package com.ejianc.business.zdsstore.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsstore.bean.FlowEntity;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.MaterialCategoryTopVO;
import com.ejianc.business.zdsstore.vo.StoreApiVO;
import com.ejianc.business.zdsstore.vo.SurplusVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;

/**
 * 仓库流水表
 *
 * @author generator
 */
@Mapper
public interface FlowMapper extends BaseCrudMapper<FlowEntity> {

    List<FlowVO> queryInstoreFlowData(IPage<FlowVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    List<SurplusVO> computeStore(@Param(value = "storeId") Long storeId, @Param(value = "materialIds") List<Long> materialIds, @Param(value = "brandIds") List<Long> brandIds);

    List<StoreApiVO> queryStoreInstoreData(Page<StoreApiVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    List<FlowVO> queryTurnInstoreFlowData(Page<FlowVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    Integer settleCount(HashMap<String, Object> map);

    void changeSettleFlag(HashMap<String, Object> map);

    List<SurplusVO> computeStoreList(Page<SurplusVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    List<MaterialCategoryTopVO> queryMaterialCategoryTopN(@Param("topN") Integer topN,@Param("startDate") String startDate,@Param("orgIds") List<Long> orgIds);

    List<MaterialCategoryTopVO> getSumMaterialCategory(@Param("startDate") String startDate, @Param("orgIds") List<Long> orgIds);

    List<FlowVO> getSendReceiveList(Page<FlowVO> page,@Param(Constants.WRAPPER) QueryWrapper wrapper);
}
