/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsstore.bean.ReturnGoodsEntity;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.service.ICheckService;
import com.ejianc.business.zdsstore.service.IReturnGoodsService;
import com.ejianc.business.zdsstore.service.StoreManageService;
import com.ejianc.business.zdsstore.vo.ReturnGoodsVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import java.security.MessageDigest;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="returnGoods")
public class ReturnGoodsBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IReturnGoodsService returnGoodsService;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private StoreManageService storeManageService;
    @Autowired
    private ICheckService checkService;
    private final String OPERATE = "returnGoodsBill";
    private final String PUSH_BILL_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/supReturnGoods/syncReturnGoods";
    private final String DELETE_BILL_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/supReturnGoods/deleteById";
    @Autowired
    private IProSupplierApi proSupplierApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        ReturnGoodsEntity entity = (ReturnGoodsEntity)((Object)this.returnGoodsService.selectById(billId));
        if (CollectionUtils.isEmpty(entity.getReturnGoodsDetailList())) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u7269\u8d44\u660e\u7ec6\u4e3a\u7a7a\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ReturnGoodsEntity entity = (ReturnGoodsEntity)((Object)this.returnGoodsService.selectById(billId));
        ReturnGoodsVO vo = (ReturnGoodsVO)BeanMapper.map((Object)((Object)entity), ReturnGoodsVO.class);
        if (CollectionUtils.isEmpty(entity.getReturnGoodsDetailList())) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u7269\u8d44\u660e\u7ec6\u4e3a\u7a7a\uff01");
        }
        if (entity.getBusinessType() == 1) {
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setSourceId(entity.getId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u6750\u6599\u9000\u8d27);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            this.storeManageService.inOutStoreRollback(storeManageVO);
            CommonResponse<StoreManageVO> commonResponse = this.storeManageService.inOutStore(storeManageVO);
            if (!commonResponse.isSuccess()) {
                this.logger.error("\u6750\u6599\u9000\u8d27\u5355-{}\u5ba1\u6279\u901a\u8fc7\u66f4\u65b0\u5e93\u5b58\u5360\u7528\u6d41\u6c34\u72b6\u6001\u5931\u8d25\uff0c{}", (Object)billId, (Object)JSONObject.toJSONString(commonResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u66f4\u65b0\u5e93\u5b58\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        this.pushToSupBusiness(vo);
        return CommonResponse.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String pushToSupBusiness(ReturnGoodsVO returnGoodsVO) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = "returnGoodsBill::" + returnGoodsVO.getId().toString();
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u6750\u6599\u9000\u56de-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)returnGoodsVO.getId(), (Object)ejcCloudSystemCode.getMsg());
            return "\u63a8\u9001\u6750\u6599\u9000\u56de\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25";
        }
        returnGoodsVO.setSourceSystemId((String)ejcCloudSystemCode.getData());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("transData", JSONObject.toJSONString((Object)returnGoodsVO));
        HashMap files = new HashMap();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"returnGoodsBill", (int)600);
            CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-zdssupbusiness-web/openapi/supReturnGoods/syncReturnGoods", paramMap, returnGoodsVO.getSupplierId().toString(), files);
            if (syncReqResp.isSuccess()) {
                CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                if (billPushResp.isSuccess()) {
                } else {
                    this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u6750\u6599\u9000\u56deid-{}\u5931\u8d25, {}", new Object[]{returnGoodsVO.getSupplierId(), returnGoodsVO.getId(), billPushResp.getMsg()});
                    msg = "\u63a8\u9001\u6750\u6599\u9000\u56de\u5931\u8d25\uff0c\u4f9b\u65b9\u5904\u7406\u63a8\u9001\u6750\u6599\u9000\u56de\u5931\u8d25";
                }
            } else {
                this.logger.error("\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u7ed3\u7b97\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{}\u5931\u8d25, {}", new Object[]{returnGoodsVO.getId(), returnGoodsVO.getSupplierId(), syncReqResp.getMsg()});
                msg = "\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u6750\u6599\u9000\u56de\u5931\u8d25";
            }
        }
        catch (Exception e) {
            this.logger.error("\u6750\u6599\u9000\u56deid-{}\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c", (Object)returnGoodsVO.getId(), (Object)e);
            msg = "\u64cd\u4f5c\u5931\u8d25\uff0c\u6750\u6599\u9000\u56de\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "returnGoodsBill");
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ReturnGoodsEntity entity = (ReturnGoodsEntity)((Object)this.returnGoodsService.selectById(billId));
        if (entity.getSignStatus() == 2) {
            return CommonResponse.error((String)"\u4f9b\u65b9\u5df2\u7b7e\u5b57,\u4e0d\u80fd\u64a4\u56de");
        }
        if (entity.getSignStatus() == 1) {
            // empty if block
        }
        if (entity != null) {
            CommonResponse commonResponse = this.checkService.checkByDate(entity.getStoreId(), DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)entity.getOutDate()));
            return commonResponse;
        }
        return CommonResponse.error((String)"\u5355\u636e\u5f02\u5e38\uff0c\u5f03\u5ba1\u5931\u8d25");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ReturnGoodsEntity entity = (ReturnGoodsEntity)((Object)this.returnGoodsService.selectById(billId));
        if (entity.getBusinessType() == 1 && entity != null && entity.getReturnGoodsDetailList().size() > 0) {
            ReturnGoodsVO vo = (ReturnGoodsVO)BeanMapper.map((Object)((Object)entity), ReturnGoodsVO.class);
            StoreManageVO storeManageVO = vo.getStoreManageVO(vo);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(false));
            this.storeManageService.inOutStoreRollback(storeManageVO);
        }
        ReturnGoodsVO returnGoodsVO = (ReturnGoodsVO)BeanMapper.map((Object)((Object)entity), ReturnGoodsVO.class);
        this.deleteById(returnGoodsVO);
        return CommonResponse.success();
    }

    public static void main(String[] args) throws Exception {
        String appid2 = "859f0363d7dcc01cc4275a6cad2a0001";
        String md5Appid2 = ReturnGoodsBpmServiceImpl.toMD5(appid2);
        String nowStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date());
        String nowStrMd5 = ReturnGoodsBpmServiceImpl.toMD5(nowStr);
        String secret2 = "11658934fd26400985e1e9d83f6ac7cf";
        String sign = ReturnGoodsBpmServiceImpl.toMD5(secret2 + md5Appid2 + nowStrMd5);
        System.out.println("appid: " + md5Appid2);
        System.out.println("nowStrMd5: " + nowStrMd5);
        System.out.println("ticket: " + nowStr);
        System.out.println("sign: " + sign);
    }

    public static String toMD5(String plainText) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] hashBytes = digest.digest(plainText.getBytes());
        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString().toLowerCase();
    }

    public static String getMD5(String str) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(str.getBytes("GBK"));
        byte[] md5Bytes = md5.digest();
        String res = "";
        for (int i = 0; i < md5Bytes.length; ++i) {
            int temp = md5Bytes[i] & 0xFF;
            if (temp <= 15) {
                res = res + "0";
            }
            res = res + Integer.toHexString(temp);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String deleteById(ReturnGoodsVO returnGoodsVO) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = "returnGoodsBill::" + returnGoodsVO.getId().toString();
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u6750\u6599\u9000\u56de-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)returnGoodsVO.getId(), (Object)ejcCloudSystemCode.getMsg());
            return "\u63a8\u9001\u6750\u6599\u9000\u56de\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25";
        }
        returnGoodsVO.setSourceSystemId((String)ejcCloudSystemCode.getData());
        returnGoodsVO.setSourceId(returnGoodsVO.getId().toString());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("transData", JSONObject.toJSONString((Object)returnGoodsVO));
        HashMap files = new HashMap();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"returnGoodsBill", (int)600);
            CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-zdssupbusiness-web/openapi/supReturnGoods/deleteById", paramMap, returnGoodsVO.getSupplierId().toString(), files);
            if (syncReqResp.isSuccess()) {
                CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                if (billPushResp.isSuccess()) {
                } else {
                    this.logger.error("\u4f9b\u65b9id-{}\u5220\u9664\u63a8\u9001\u6750\u6599\u9000\u56deid-{}\u5931\u8d25, {}", new Object[]{returnGoodsVO.getSupplierId(), returnGoodsVO.getId(), billPushResp.getMsg()});
                    msg = "\u5220\u9664\u6750\u6599\u9000\u8d27\u5931\u8d25\uff0c\u4f9b\u65b9\u5904\u7406\u5220\u9664\u6750\u6599\u9000\u56de\u5931\u8d25";
                }
            } else {
                this.logger.error("\u53d1\u9001\u8bf7\u6c42\u5220\u9664\u6750\u6599\u9000\u8d27id-{}\u7ed9\u4f9b\u65b9id-{}\u5931\u8d25, {}", new Object[]{returnGoodsVO.getId(), returnGoodsVO.getSupplierId(), syncReqResp.getMsg()});
                msg = "\u53d1\u9001\u8bf7\u6c42\u5220\u9664\u6750\u6599\u9000\u8d27\u5931\u8d25";
            }
        }
        catch (Exception e) {
            this.logger.error("\u6750\u6599\u9000\u56deid-{}\u63a8\u9001\u4f9b\u65b9\u5220\u9664\u6750\u6599\u9000\u8d27\uff0c", (Object)returnGoodsVO.getId(), (Object)e);
            msg = "\u64cd\u4f5c\u5931\u8d25\uff0c\u6750\u6599\u9000\u56de\u63a8\u9001\u5220\u9664\u6750\u6599\u9000\u8d27\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "returnGoodsBill");
        }
        return msg;
    }
}

