/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsstore.bean.ReturnGoodsEntity;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.mapper.ReturnGoodsMapper;
import com.ejianc.business.zdsstore.service.IReturnGoodsService;
import com.ejianc.business.zdsstore.service.ISurplusService;
import com.ejianc.business.zdsstore.service.StoreManageService;
import com.ejianc.business.zdsstore.vo.ReturnGoodsVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="returnGoodsService")
public class ReturnGoodsServiceImpl
extends BaseServiceImpl<ReturnGoodsMapper, ReturnGoodsEntity>
implements IReturnGoodsService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ReturnGoodsMapper returnGoodsMapper;
    @Autowired
    private StoreManageService storeManageService;
    @Autowired
    private ISurplusService surplusService;
    @Autowired
    private JedisPool jedisPool;
    private final String OPERATE = "returnGoodsBill";

    @Override
    public ReturnGoodsVO queryByContractId(Long contractId) {
        ReturnGoodsVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)contractId);
        query.eq((Object)"bill_state", (Object)BillStateEnum.UNCOMMITED_STATE);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        ReturnGoodsEntity entity = (ReturnGoodsEntity)((Object)this.returnGoodsMapper.selectOne((Wrapper)query));
        if (null != entity) {
            resp = (ReturnGoodsVO)BeanMapper.map((Object)((Object)entity), ReturnGoodsVO.class);
        }
        return resp;
    }

    @Override
    public void removeByPickReturnIds(List<Long> ids) {
        this.checkRollback(ids);
        this.removeByIds(ids, true);
    }

    @Transactional(rollbackFor={Exception.class})
    public void checkRollback(List<Long> ids) {
        StoreManageVO storeManageVO = new StoreManageVO();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", ids);
        List eList = super.list((Wrapper)query);
        ArrayList<Long> SourceIds = new ArrayList<Long>();
        for (ReturnGoodsEntity e : eList) {
            SourceIds.clear();
            SourceIds.add(e.getId());
            storeManageVO.setSourceId(e.getId());
            storeManageVO.setStoreId(e.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u6750\u6599\u9000\u8d27);
            storeManageVO.setSourceIdsForRollBack(SourceIds);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(false));
            CommonResponse<StoreManageVO> rollbackCommonResponse = this.storeManageService.inOutStoreRollback(storeManageVO);
            if (rollbackCommonResponse.isSuccess()) continue;
            this.logger.error("\u6750\u6599\u9000\u8d27\u63a8\u9001\u5e93\u5b58\u6d41\u6c34\u5931\u8d25, {}", (Object)JSONObject.toJSONString(rollbackCommonResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            throw new BusinessException(StringUtils.isNotBlank((CharSequence)rollbackCommonResponse.getMsg()) ? rollbackCommonResponse.getMsg() : "\u5220\u9664\u5931\u8d25\uff0c\u66f4\u65b0\u5e93\u5b58\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    @Override
    public ReturnGoodsVO saveOrUpdateReturnGoods(ReturnGoodsVO saveOrUpdateVO) {
        if (null != saveOrUpdateVO.getId()) {
            this.checkRollback(Arrays.asList(saveOrUpdateVO.getId()));
        }
        ReturnGoodsEntity entity = (ReturnGoodsEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ReturnGoodsEntity.class));
        super.saveOrUpdate((Object)entity, false);
        this.saveStore((ReturnGoodsVO)BeanMapper.map((Object)((Object)entity), ReturnGoodsVO.class));
        return (ReturnGoodsVO)BeanMapper.map((Object)((Object)entity), ReturnGoodsVO.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syncSignStatus(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String billData = request.getParameter("billData");
        this.logger.info("\u63a5\u6536\u5230\u4f9b\u65b9\u6750\u6599\u9000\u8d27\u4fe1\u606f\uff1a{}", (Object)billData);
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        ReturnGoodsVO returnGoodsVO = (ReturnGoodsVO)JSONObject.parseObject((String)billData, ReturnGoodsVO.class);
        Long orderId = Long.valueOf(returnGoodsVO.getSourceId());
        Jedis jedis = null;
        boolean locked = false;
        String key = "returnGoodsBill::" + orderId.toString();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"returnGoodsBill", (int)600);
            Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, "EJCBT202312000016", authority, orderId.toString());
            ArrayList attchIdsList = new ArrayList();
            for (List attachIds : attachIdsMap.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
                attchIdsList.addAll(attachIds);
            }
            ReturnGoodsEntity returnGoodsEntity = (ReturnGoodsEntity)((Object)super.selectById((Serializable)orderId));
            returnGoodsEntity.setAttachIds(attchIdsList);
            returnGoodsEntity.setSignStatus(returnGoodsVO.getSignStatus());
            returnGoodsEntity.setSignTime(returnGoodsVO.getSignTime());
            returnGoodsEntity.setSignUserId(returnGoodsVO.getSignUserId());
            returnGoodsEntity.setSignUserName(returnGoodsVO.getSignUserName());
            returnGoodsEntity.setSignUserPhone(returnGoodsVO.getSignUserPhone());
            super.saveOrUpdate((Object)returnGoodsEntity, false);
        }
        catch (Exception e) {
            this.logger.error("\u6750\u6599\u9000\u8d27id-{}\u7b7e\u5b57\u72b6\u6001\u540c\u6b65\u5f02\u5e38\uff0c", (Object)orderId, (Object)e);
        }
        finally {
            this.releaseLock(jedis, locked, key, "returnGoodsBill");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    private void saveStore(ReturnGoodsVO saveOrUpdateVO) {
        if (saveOrUpdateVO != null && saveOrUpdateVO.getReturnGoodsDetailList().size() > 0 && saveOrUpdateVO.getBusinessType() == 1) {
            StoreManageVO storeManageVO = saveOrUpdateVO.getStoreManageVO(saveOrUpdateVO);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(false));
            CommonResponse<StoreManageVO> saveStoreResp = this.storeManageService.inOutStore(storeManageVO);
            if (!saveStoreResp.isSuccess()) {
                this.logger.error("\u6750\u6599\u9000\u8d27\u63a8\u9001\u5e93\u5b58\u6d41\u6c34\u5931\u8d25, {}", (Object)JSONObject.toJSONString(saveStoreResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                throw new BusinessException(StringUtils.isNotBlank((CharSequence)saveStoreResp.getMsg()) ? saveStoreResp.getMsg() : "\u4fdd\u5b58\u5931\u8d25\uff0c\u66f4\u65b0\u5e93\u5b58\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
    }
}

