package com.ejianc.business.zdsstore.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.erp.vo.OrderVO;
import com.ejianc.business.zdsstore.bean.ReturnGoodsEntity;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.service.ICheckService;
import com.ejianc.business.zdsstore.service.IReturnGoodsService;
import com.ejianc.business.zdsstore.service.StoreManageService;
import com.ejianc.business.zdsstore.vo.ReturnGoodsVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.io.InputStream;
import java.security.MessageDigest;
import java.util.*;

@Service("returnGoods") 
public class ReturnGoodsBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IReturnGoodsService returnGoodsService;
	@Autowired
	private JedisPool jedisPool;

	@Autowired
	private ISystemDataPushService systemDataPushService;


	@Autowired
	private StoreManageService storeManageService;
	@Autowired
	private ICheckService checkService;

	private final String OPERATE = "returnGoodsBill";

	private final String PUSH_BILL_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/supReturnGoods/syncReturnGoods";
	private final String DELETE_BILL_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/supReturnGoods/deleteById";

	@Autowired
	private IProSupplierApi proSupplierApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		ReturnGoodsEntity entity = returnGoodsService.selectById(billId);
		if(CollectionUtils.isEmpty(entity.getReturnGoodsDetailList())) {
			return CommonResponse.error("操作失败，物资明细为空！");
		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ReturnGoodsEntity entity = returnGoodsService.selectById(billId);
		ReturnGoodsVO vo = BeanMapper.map(entity, ReturnGoodsVO.class);
		StoreManageVO storeManageVO = vo.getStoreManageVO(vo);
        if(CollectionUtils.isEmpty(entity.getReturnGoodsDetailList())) {
            return CommonResponse.error("操作失败，物资明细为空！");
        }
		if (entity.getBusinessType() == 1){
			storeManageVO.setStoreId(entity.getStoreId());
			storeManageVO.setSourceId(entity.getId());
			storeManageVO.setInOutTypeEnum(InOutTypeEnum.材料退货);
			storeManageVO.setOutEffectiveON(true);
			CommonResponse<StoreManageVO> commonResponse = storeManageService.inOutStore(storeManageVO);
			if(!commonResponse.isSuccess()){
				logger.error("材料退货单-{}审批通过更新库存占用流水状态失败，{}", billId, JSONObject.toJSONString(commonResponse, SerializerFeature.PrettyFormat));
				return CommonResponse.error("操作失败，更新库存信息失败！");
			}
		}

		//协同供方签字
		pushToSupBusiness(vo);


		return CommonResponse.success();
	}

	private String pushToSupBusiness(ReturnGoodsVO returnGoodsVO) {
		String msg = null;
		Jedis jedis = null;
		boolean locked = false;
		String key = OPERATE + "::" + returnGoodsVO.getId().toString();

		//设置单据当前系统信息
		CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
		if (!ejcCloudSystemCode.isSuccess()) {
			logger.error("推送材料退回-{}失败，获取当前系统编码失败,{}", returnGoodsVO.getId(), ejcCloudSystemCode.getMsg());
			return "推送材料退回失败，获取当前系统编码失败";
		}

		//设置当前系统ID
		returnGoodsVO.setSourceSystemId(ejcCloudSystemCode.getData());

		Map<String, String> paramMap = new HashMap<>();
		paramMap.put("transData", JSONObject.toJSONString(returnGoodsVO));

		Map<String, Map<String, InputStream>> files = new HashMap<>();

		try {
			jedis = jedisPool.getResource();
			//对单据进行加锁
			locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

			//推送单据到指定的供方
			CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(PUSH_BILL_SERVER_URL,
					paramMap,
					returnGoodsVO.getSupplierId().toString(),
					files);
			if (syncReqResp.isSuccess()) {
				CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
				if (billPushResp.isSuccess()) {
				} else {
					logger.error("供方id-{}处理推送材料退回id-{}失败, {}", returnGoodsVO.getSupplierId(), returnGoodsVO.getId(), billPushResp.getMsg());
					msg = "推送材料退回失败，供方处理推送材料退回失败";
				}
			} else {
				logger.error("发送请求推送结算单据id-{}给供方id-{}失败, {}", returnGoodsVO.getId(), returnGoodsVO.getSupplierId(), syncReqResp.getMsg());
				msg = "发送请求推送材料退回失败";
			}
		} catch (Exception e) {
			logger.error("材料退回id-{}推送供方失败，", returnGoodsVO.getId(), e);
			msg = "操作失败，材料退回推送供方失败！";
		} finally {
			releaseLock(jedis, locked, key, OPERATE);
		}

		return msg;
	}
	public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
		try {
			if(locked) {
				RedisTool.releaseLock(jedis, key, OPERATE);
			}
		} finally {
			if(null != jedis) {
				jedis.close();
			}
		}
	}
	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 1、退货单是否被物资合同结算引用，如引用，不可弃审；
		// 2、处置时间之后有盘点单时，不可弃审
		ReturnGoodsEntity entity = returnGoodsService.selectById(billId);
		if (entity.getSignStatus() == 2){
			return CommonResponse.error("供方已签字,不能撤回");
		}
		if (entity.getSignStatus() == 1){
			//删除推送的数据

		}
		if(entity != null){
			CommonResponse commonResponse = checkService.checkByDate(entity.getStoreId(), DateFormatUtil.formatDate("yyyy-MM-dd", entity.getOutDate()));
 			return commonResponse;
		}else{
			return CommonResponse.error("单据异常，弃审失败");
		}

	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		ReturnGoodsEntity entity = returnGoodsService.selectById(billId);
		ReturnGoodsVO returnGoodsVO = BeanMapper.map(entity, ReturnGoodsVO.class);

		if (entity.getBusinessType() == 1){
			if(entity!=null && entity.getReturnGoodsDetailList().size()>0){
				StoreManageVO storeManageVO = returnGoodsVO.getStoreManageVO(returnGoodsVO);
				storeManageVO.setStoreId(entity.getStoreId());
				storeManageVO.setSourceId(entity.getId());
				storeManageVO.setInOutTypeEnum(InOutTypeEnum.材料退货);
				storeManageVO.setOutEffectiveON(false);
				storeManageService.inOutStore(storeManageVO);
			}
		}
		deleteById(returnGoodsVO);

		return CommonResponse.success();
	}

	public static void main(String[] args) throws Exception {


		String appid2 = "859f0363d7dcc01cc4275a6cad2a0001";
		String md5Appid2 = toMD5(appid2);
		String nowStr = DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date());
		String nowStrMd5 = toMD5(nowStr);
		String secret2 = "11658934fd26400985e1e9d83f6ac7cf";
		String sign = toMD5(secret2 + md5Appid2 + nowStrMd5);

		System.out.println("appid: " + md5Appid2);
		System.out.println("nowStrMd5: " + nowStrMd5);
		System.out.println("ticket: " + nowStr);
		System.out.println("sign: " + sign);
	}

	public static String toMD5(String plainText) throws Exception {
		MessageDigest digest = MessageDigest.getInstance("MD5");
		byte[] hashBytes = digest.digest(plainText.getBytes());

		StringBuilder sb = new StringBuilder();
		for (byte b : hashBytes) {
			sb.append(Integer.toString((b & 0xff) + 0x100, 16).substring(1));
		}

		return sb.toString().toLowerCase();
	}


	/**
     * 解决php与javaMD5加密不同 获取MD5加密后的字符串
     *
     * @param str
     *            明文
     * @return 加密后的字符串
     * @throws Exception
     */
     public static String getMD5(String str) throws Exception {
        /** 创建MD5加密对象 */
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        /** 进行加密 */
        md5.update(str.getBytes("GBK"));
        /** 获取加密后的字节数组 */
        byte[] md5Bytes = md5.digest();
        String res = "";
        for (int i = 0; i < md5Bytes.length; i++) {
            int temp = md5Bytes[i] & 0xFF;
            if (temp <= 0XF) { // 转化成十六进制不够两位，前面加零
                res += "0";
            }
            res += Integer.toHexString(temp);
        }
        return res;
     }
	//删除供方业务单据数据
	private String deleteById(ReturnGoodsVO returnGoodsVO) {
		String msg = null;
		Jedis jedis = null;
		boolean locked = false;
		String key = OPERATE + "::" + returnGoodsVO.getId().toString();

		//设置单据当前系统信息
		CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
		if (!ejcCloudSystemCode.isSuccess()) {
			logger.error("推送材料退回-{}失败，获取当前系统编码失败,{}", returnGoodsVO.getId(), ejcCloudSystemCode.getMsg());
			return "推送材料退回失败，获取当前系统编码失败";
		}

		//设置当前系统ID
		returnGoodsVO.setSourceSystemId(ejcCloudSystemCode.getData());
		returnGoodsVO.setSourceId(returnGoodsVO.getId().toString());
		Map<String, String> paramMap = new HashMap<>();
		paramMap.put("transData", JSONObject.toJSONString(returnGoodsVO));

		Map<String, Map<String, InputStream>> files = new HashMap<>();

		try {
			jedis = jedisPool.getResource();
			//对单据进行加锁
			locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

			//推送单据到指定的供方
			CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(DELETE_BILL_SERVER_URL,
					paramMap,
					returnGoodsVO.getSupplierId().toString(),
					files);
			if (syncReqResp.isSuccess()) {
				CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
				if (billPushResp.isSuccess()) {
				} else {
					logger.error("供方id-{}删除推送材料退回id-{}失败, {}", returnGoodsVO.getSupplierId(), returnGoodsVO.getId(), billPushResp.getMsg());
					msg = "删除材料退货失败，供方处理删除材料退回失败";
				}
			} else {
				logger.error("发送请求删除材料退货id-{}给供方id-{}失败, {}", returnGoodsVO.getId(), returnGoodsVO.getSupplierId(), syncReqResp.getMsg());
				msg = "发送请求删除材料退货失败";
			}
		} catch (Exception e) {
			logger.error("材料退回id-{}推送供方删除材料退货，", returnGoodsVO.getId(), e);
			msg = "操作失败，材料退回推送删除材料退货！";
		} finally {
			releaseLock(jedis, locked, key, OPERATE);
		}

		return msg;
	}


}
