package com.ejianc.business.zdsstore.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsstore.bean.FlowEntity;
import com.ejianc.business.zdsstore.service.IFlowService;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.ProjectStaticsVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2024/10/17 17:25
 */
@RestController
@RequestMapping(value = "/projectInstoreStatics")
public class ProjectInstoreController {

    @Autowired
    private IFlowService service;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @PostMapping(value = "queryList")
    public CommonResponse<IPage<FlowVO>> queryList(@RequestBody QueryParam param) {
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("org_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        }

        IPage<FlowEntity> page = service.queryPage(param, false);
        IPage<FlowVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FlowVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 到货流水导出
     *
     * @param queryParam
     * @param response
     */
    @PostMapping(value = "exportInStoreList")
    public void exportInStoreList(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.setPageSize(-1);
        queryParam.setPageIndex(1);
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(InvocationInfoProxy.getOrgType())) {
            queryParam.getParams().put("org_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        }

        List<FlowEntity> data = service.queryList(queryParam);
        List<FlowVO> vos = BeanMapper.mapList(data, FlowVO.class);

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("inStoreFlowExport.xlsx", beans, response);
    }

    @PostMapping(value = "querySumList")
    public CommonResponse<IPage<FlowVO>> querySumList(@RequestBody QueryParam param) {
        Map<String, Object> queryParams = new HashMap<>();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(InvocationInfoProxy.getOrgType())) {
            queryParams.put("org_id", InvocationInfoProxy.getOrgId());
        }

        Map<String, Parameter> params = param.getParams();
        for(String key : params.keySet()) {
            queryParams.put(key, params.get(key).getValue());
        }

        queryParams.put("pageSize", param.getPageSize());
        queryParams.put("startLine", param.getPageIndex() < 1 ? 0 : (param.getPageIndex() - 1) * param.getPageSize());
        int count = service.flowCount(queryParams);

        IPage<FlowVO> resp = new Page<>();
        resp.setSize(param.getPageSize());
        resp.setCurrent(param.getPageIndex());
        resp.setTotal(count);

        List<FlowVO> list = service.flowList(queryParams);
        resp.setRecords(list);

        return CommonResponse.success("查询列表数据成功！", resp);
    }

    @PostMapping(value = "querySupList")
    public CommonResponse<List<Map<String, Object>>> querySupList(@RequestBody QueryParam param) {
        return CommonResponse.success(service.querySupList(param));
    }

    @PostMapping(value = "pagePickOutFlow")
    public CommonResponse<IPage<ProjectStaticsVO>> pagePickOutFlow(@RequestBody QueryParam param) {
        Map<String, Object> queryParams = new HashMap<>();

        Map<String, Parameter> params = param.getParams();
        for(String key : params.keySet()) {
            queryParams.put(key, params.get(key).getValue());
        }

        queryParams.put("pageSize", param.getPageSize());
        queryParams.put("startLine", param.getPageIndex() < 1 ? 0 : (param.getPageIndex() - 1) * param.getPageSize());
        int count = service.pickOutCount(queryParams);

        IPage<ProjectStaticsVO> resp = new Page<>();
        resp.setSize(param.getPageSize());
        resp.setCurrent(param.getPageIndex());
        resp.setTotal(count);
        if(count == 0) {
            resp.setRecords(new ArrayList<>());
            resp.setPages(0);
            return CommonResponse.success(resp);
        }

        List<ProjectStaticsVO> list = service.pickOutList(queryParams);
        resp.setRecords(list);

        return CommonResponse.success(resp);
    }


    @PostMapping(value = "exportPickOutFlow")
    public void exportPickOutFlow(@RequestBody QueryParam param, HttpServletResponse response) {
        Map<String, Object> queryParams = new HashMap<>();

        Map<String, Parameter> params = param.getParams();
        for(String key : params.keySet()) {
            queryParams.put(key, params.get(key).getValue());
        }

        List<ProjectStaticsVO> list = service.pickOutList(queryParams);

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("inStoreFlowExport.xlsx", beans, response);
    }


    @PostMapping(value = "pagePickOutSum")
    public CommonResponse<IPage<ProjectStaticsVO>> pagePickOutSum(@RequestBody QueryParam param) {
        Map<String, Object> queryParams = new HashMap<>();

        Map<String, Parameter> params = param.getParams();
        for(String key : params.keySet()) {
            queryParams.put(key, params.get(key).getValue());
        }

        queryParams.put("pageSize", param.getPageSize());
        queryParams.put("startLine", param.getPageIndex() < 1 ? 0 : (param.getPageIndex() - 1) * param.getPageSize());
        int count = service.pickOutSumCount(queryParams);

        IPage<ProjectStaticsVO> resp = new Page<>();
        resp.setSize(param.getPageSize());
        resp.setCurrent(param.getPageIndex());
        resp.setTotal(count);
        if(count == 0) {
            resp.setRecords(new ArrayList<>());
            resp.setPages(0);
            return CommonResponse.success(resp);
        }

        List<ProjectStaticsVO> list = service.pickOutSumList(queryParams);
        resp.setRecords(list);

        return CommonResponse.success(resp);
    }


    @PostMapping(value = "exportPickOutSum")
    public void exportPickOutSum(@RequestBody QueryParam param, HttpServletResponse response) {
        Map<String, Object> queryParams = new HashMap<>();

        Map<String, Parameter> params = param.getParams();
        for(String key : params.keySet()) {
            queryParams.put(key, params.get(key).getValue());
        }
        List<ProjectStaticsVO> list = service.pickOutSumList(queryParams);

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("pickOutSumExport.xlsx", beans, response);
    }

    @PostMapping(value = "querySubSupList")
    public CommonResponse<List<Map<String, Object>>> querySubSupList(@RequestBody QueryParam param) {
        return CommonResponse.success(service.querySubSupList(param));
    }


    @PostMapping(value = "pageInOutStore")
    public CommonResponse<IPage<ProjectStaticsVO>> pageInOutStore(@RequestBody QueryParam param) {
        Map<String, Object> queryParams = new HashMap<>();

        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(InvocationInfoProxy.getOrgType())) {
            queryParams.put("org_id", InvocationInfoProxy.getOrgId());
        }

        Map<String, Parameter> params = param.getParams();
        for(String key : params.keySet()) {
            queryParams.put(key, params.get(key).getValue());
        }

        queryParams.put("pageSize", param.getPageSize());
        queryParams.put("startLine", param.getPageIndex() < 1 ? 0 : (param.getPageIndex() - 1) * param.getPageSize());
        int count = service.countInOutStore(queryParams);

        IPage<ProjectStaticsVO> resp = new Page<>();
        resp.setSize(param.getPageSize());
        resp.setCurrent(param.getPageIndex());
        resp.setTotal(count);

        List<ProjectStaticsVO> list = service.pageInOutStore(queryParams);
        resp.setRecords(list);

        return CommonResponse.success(resp);
    }

    @PostMapping(value = "exportInOutStore")
    public void exportInOutStore(@RequestBody QueryParam param, HttpServletResponse response) {
        Map<String, Object> queryParams = new HashMap<>();

        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(InvocationInfoProxy.getOrgType())) {
            queryParams.put("org_id", InvocationInfoProxy.getOrgId());
        }

        Map<String, Parameter> params = param.getParams();
        for(String key : params.keySet()) {
            queryParams.put(key, params.get(key).getValue());
        }

        List<ProjectStaticsVO> list = service.pageInOutStore(queryParams);

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("inOutStoreExport.xlsx", beans, response);
    }
}
