/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsstore.service.IFlowService;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.ProjectStaticsVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/projectInstoreStatics"})
public class ProjectInstoreController {
    @Autowired
    private IFlowService service;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @PostMapping(value={"queryList"})
    public CommonResponse<IPage<FlowVO>> queryList(@RequestBody QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("org_id", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FlowVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"exportInStoreList"})
    public void exportInStoreList(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.setPageSize(-1);
        queryParam.setPageIndex(1);
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(InvocationInfoProxy.getOrgType())) {
            queryParam.getParams().put("org_id", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        }
        queryParam.getOrderMap().put("create_time", "desc");
        List data = this.service.queryList(queryParam);
        List vos = BeanMapper.mapList((Iterable)data, FlowVO.class);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("inStoreFlowExport.xlsx", beans, response);
    }

    @PostMapping(value={"querySumList"})
    public CommonResponse<IPage<FlowVO>> querySumList(@RequestBody QueryParam param) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(InvocationInfoProxy.getOrgType())) {
            queryParams.put("org_id", InvocationInfoProxy.getOrgId());
        }
        Map params = param.getParams();
        for (String key : params.keySet()) {
            queryParams.put(key, ((Parameter)params.get(key)).getValue());
        }
        queryParams.put("pageSize", param.getPageSize());
        queryParams.put("startLine", param.getPageIndex() < 1 ? 0 : (param.getPageIndex() - 1) * param.getPageSize());
        int count = this.service.flowCount(queryParams);
        Page resp = new Page();
        resp.setSize((long)param.getPageSize());
        resp.setCurrent((long)param.getPageIndex());
        resp.setTotal((long)count);
        List<FlowVO> list = this.service.flowList(queryParams);
        resp.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)resp);
    }

    @PostMapping(value={"exportSumList"})
    public void exportSumList(@RequestBody QueryParam param, HttpServletResponse response) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageSize(-1);
        param.setPageSize(1);
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(InvocationInfoProxy.getOrgType())) {
            queryParams.put("org_id", InvocationInfoProxy.getOrgId());
        }
        Map params = param.getParams();
        for (String key : params.keySet()) {
            queryParams.put(key, ((Parameter)params.get(key)).getValue());
        }
        queryParams.put("pageSize", param.getPageSize());
        queryParams.put("startLine", param.getPageIndex() < 1 ? 0 : (param.getPageIndex() - 1) * param.getPageSize());
        int count = this.service.flowCount(queryParams);
        Page resp = new Page();
        resp.setSize((long)param.getPageSize());
        resp.setCurrent((long)param.getPageIndex());
        resp.setTotal((long)count);
        List<FlowVO> list = this.service.flowList(queryParams);
        resp.setRecords(list);
        HashMap<String, List<FlowVO>> beans = new HashMap<String, List<FlowVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("inStoreSumExport.xlsx", beans, response);
    }

    @PostMapping(value={"querySupList"})
    public CommonResponse<List<Map<String, Object>>> querySupList(@RequestBody QueryParam param) {
        return CommonResponse.success(this.service.querySupList(param));
    }

    @PostMapping(value={"pagePickOutFlow"})
    public CommonResponse<IPage<ProjectStaticsVO>> pagePickOutFlow(@RequestBody QueryParam param) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        Map params = param.getParams();
        for (String key : params.keySet()) {
            queryParams.put(key, ((Parameter)params.get(key)).getValue());
        }
        queryParams.put("pageSize", param.getPageSize());
        queryParams.put("startLine", param.getPageIndex() < 1 ? 0 : (param.getPageIndex() - 1) * param.getPageSize());
        int count = this.service.pickOutCount(queryParams);
        Page resp = new Page();
        resp.setSize((long)param.getPageSize());
        resp.setCurrent((long)param.getPageIndex());
        resp.setTotal((long)count);
        if (count == 0) {
            resp.setRecords(new ArrayList());
            resp.setPages(0L);
            return CommonResponse.success((Object)resp);
        }
        List<ProjectStaticsVO> list = this.service.pickOutList(queryParams);
        resp.setRecords(list);
        return CommonResponse.success((Object)resp);
    }

    @PostMapping(value={"exportPickOutFlow"})
    public void exportPickOutFlow(@RequestBody QueryParam param, HttpServletResponse response) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        Map params = param.getParams();
        for (String key : params.keySet()) {
            queryParams.put(key, ((Parameter)params.get(key)).getValue());
        }
        List<ProjectStaticsVO> list = this.service.pickOutList(queryParams);
        HashMap<String, List<ProjectStaticsVO>> beans = new HashMap<String, List<ProjectStaticsVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("inStoreFlowExport.xlsx", beans, response);
    }

    @PostMapping(value={"pagePickOutSum"})
    public CommonResponse<IPage<ProjectStaticsVO>> pagePickOutSum(@RequestBody QueryParam param) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        Map params = param.getParams();
        for (String key : params.keySet()) {
            queryParams.put(key, ((Parameter)params.get(key)).getValue());
        }
        queryParams.put("pageSize", param.getPageSize());
        queryParams.put("startLine", param.getPageIndex() < 1 ? 0 : (param.getPageIndex() - 1) * param.getPageSize());
        int count = this.service.pickOutSumCount(queryParams);
        Page resp = new Page();
        resp.setSize((long)param.getPageSize());
        resp.setCurrent((long)param.getPageIndex());
        resp.setTotal((long)count);
        if (count == 0) {
            resp.setRecords(new ArrayList());
            resp.setPages(0L);
            return CommonResponse.success((Object)resp);
        }
        List<ProjectStaticsVO> list = this.service.pickOutSumList(queryParams);
        resp.setRecords(list);
        return CommonResponse.success((Object)resp);
    }

    @PostMapping(value={"exportPickOutSum"})
    public void exportPickOutSum(@RequestBody QueryParam param, HttpServletResponse response) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        Map params = param.getParams();
        for (String key : params.keySet()) {
            queryParams.put(key, ((Parameter)params.get(key)).getValue());
        }
        List<ProjectStaticsVO> list = this.service.pickOutSumList(queryParams);
        HashMap<String, List<ProjectStaticsVO>> beans = new HashMap<String, List<ProjectStaticsVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("pickOutSumExport.xlsx", beans, response);
    }

    @PostMapping(value={"querySubSupList"})
    public CommonResponse<List<Map<String, Object>>> querySubSupList(@RequestBody QueryParam param) {
        return CommonResponse.success(this.service.querySubSupList(param));
    }

    @PostMapping(value={"pageInOutStore"})
    public CommonResponse<IPage<ProjectStaticsVO>> pageInOutStore(@RequestBody QueryParam param) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(InvocationInfoProxy.getOrgType())) {
            queryParams.put("org_id", InvocationInfoProxy.getOrgId());
        }
        Map params = param.getParams();
        for (String key : params.keySet()) {
            queryParams.put(key, ((Parameter)params.get(key)).getValue());
        }
        queryParams.put("pageSize", param.getPageSize());
        queryParams.put("startLine", param.getPageIndex() < 1 ? 0 : (param.getPageIndex() - 1) * param.getPageSize());
        int count = this.service.countInOutStore(queryParams);
        Page resp = new Page();
        resp.setSize((long)param.getPageSize());
        resp.setCurrent((long)param.getPageIndex());
        resp.setTotal((long)count);
        List<ProjectStaticsVO> list = this.service.pageInOutStore(queryParams);
        resp.setRecords(list);
        return CommonResponse.success((Object)resp);
    }

    @PostMapping(value={"exportInOutStore"})
    public void exportInOutStore(@RequestBody QueryParam param, HttpServletResponse response) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(InvocationInfoProxy.getOrgType())) {
            queryParams.put("org_id", InvocationInfoProxy.getOrgId());
        }
        Map params = param.getParams();
        for (String key : params.keySet()) {
            queryParams.put(key, ((Parameter)params.get(key)).getValue());
        }
        List<ProjectStaticsVO> list = this.service.pageInOutStore(queryParams);
        HashMap<String, List<ProjectStaticsVO>> beans = new HashMap<String, List<ProjectStaticsVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("inOutStoreExport.xlsx", beans, response);
    }
}

