package com.ejianc.business.zdsstore.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.zdsstore.bean.*;
import com.ejianc.business.zdsstore.consts.AllocationState;
import com.ejianc.business.zdsstore.service.*;
import com.ejianc.business.zdsstore.utils.MsgSendUtil;
import com.ejianc.business.zdsstore.vo.AllotInVO;
import com.ejianc.business.zdsstore.vo.AllotOutVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@Service("allotOut") 
public class AllotOutBpmServiceImpl implements ICommonBusinessService {

	@Value("${common.env.base-host}")
	private String BASE_HOST;

	@Autowired
	private IPushMessageApi pushMessageApi;

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IAllotOutService service;
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IAllotInService allotInService;
	@Autowired
	private AllotInMessageService allotInMessageService;
	private static final String BILL_CODE = "zds-all-in";//此处需要根据实际修改
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private JedisPool jedisPool;
	@Autowired
	StoreManageService storeManageService;
	@Autowired
	private MsgSendUtil msgSendUtil;

	@Autowired
	private SessionManager sessionManager;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		AllotOutEntity allotOutEntity = service.selectById(billId);
		if (CollectionUtils.isEmpty(allotOutEntity.getAllotOutDetailList())){
			return CommonResponse.error("物资明细为空时，不允许提交调拨单!");
		}
		//TODO
		//加锁防止生成多个调拨入库 提交前进行
		Jedis jedis = jedisPool.getResource();
		boolean locked = false;
		locked = RedisTool.tryLock(jedis, String.valueOf(billId), "generateAllotIn", 1000);
		logger.info("判断单据单据锁结果------"+locked);
		try{
			if (locked){

			}
			else{
				return CommonResponse.success("出现并发操作,请稍后重试！");
			}
		}catch (Exception e){
			e.printStackTrace();
		} finally {
			if(locked) {
				RedisTool.releaseLock(jedis, String.valueOf(billId), "generateAllotIn");
			}
			jedis.close();
		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO

		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.error("该单据不支持弃审和撤回");
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}
	@Autowired
	private IStoreService storeService;
	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
				//更新流水
				AllotOutEntity allotOutEntity = service.selectById(billId);
				if (CollectionUtils.isNotEmpty(allotOutEntity.getAllotOutDetailList())){
					AllotOutVO saveOrUpdateVO = BeanMapper.map(allotOutEntity, AllotOutVO.class);
					saveOrUpdateVO.setId(allotOutEntity.getId());
					saveOrUpdateVO.setBillCode(allotOutEntity.getBillCode());
					List<StoreManageVO> storeManageVOList = saveOrUpdateVO.getStoreManageVOList(saveOrUpdateVO);
					for (StoreManageVO storeManageVO : storeManageVOList) {
						logger.info("调用库存参数：————" + JSONObject.toJSONString(storeManageVO));
						storeManageService.inOutStore(storeManageVO);
					}
				}else {
					return CommonResponse.error("物资明细为空时，不允许提交调拨单!");
				}
				if (!Objects.isNull(allotOutEntity)){
					//再次提交 收料状态设置带收清空退回原因
					if (allotOutEntity.getReceiveState().equals(Integer.parseInt(AllocationState.REJECT.getCode()))){
						LambdaUpdateWrapper<AllotOutEntity> allotOutWrapper = new LambdaUpdateWrapper<>();
						allotOutWrapper.eq(AllotOutEntity::getId, billId);
						allotOutWrapper.set(AllotOutEntity::getReceiveState, Integer.parseInt(AllocationState.TO_RECEIVING.getCode()));
						allotOutWrapper.set(AllotOutEntity::getReturnReason,null);
						allotOutWrapper.set(AllotOutEntity::getReceiverPersonId,null);
						allotOutWrapper.set(AllotOutEntity::getReceiverPerson,null);
						service.update(allotOutWrapper);
					}
					//生成调拨入库
					AllotInEntity allotInEntity = new AllotInEntity();
					allotInEntity.setAllocatType(allotOutEntity.getAllocatType());
					//区分大区 和项目

					Integer allocatType = allotOutEntity.getAllocatType();

					Integer allocatOutType = allotOutEntity.getAllocatOutType();
					if (allocatOutType==1){
						allotInEntity.setOutProjectId(allotOutEntity.getProjectId());
						allotInEntity.setOutProjectName(allotOutEntity.getProjectName());
						allotInEntity.setOutProjectCode(allotOutEntity.getProjectCode());
					}else {
						allotInEntity.setOutStoreOrgId(allotOutEntity.getOutStoreOrgId());
						allotInEntity.setOutStoreOrgName(allotOutEntity.getOutStoreOrgName());
						allotInEntity.setOutStoreOrgCode(allotOutEntity.getOutStoreOrgCode());
					}

					allotInEntity.setOutOrgId(allotOutEntity.getOrgId());
					allotInEntity.setOutOrgName(allotOutEntity.getOrgName());
					//入库信息
					allotInEntity.setAllocatInType(allotOutEntity.getAllocatOutType());
					allotInEntity.setOutTaxMny(allotOutEntity.getOutTaxMny());
					allotInEntity.setProjectId(allotOutEntity.getInProjectId());
					allotInEntity.setProjectName(allotOutEntity.getInProjectName());
					allotInEntity.setParentOrgId(allotOutEntity.getInParentOrgId());
					allotInEntity.setParentOrgName(allotOutEntity.getInParentOrgName());
					allotInEntity.setParentOrgCode(allotOutEntity.getInParentOrgCode());
					allotInEntity.setOrgId(allotOutEntity.getInOrgId());
					allotInEntity.setOrgCode(allotOutEntity.getInOrgCode());
					allotInEntity.setOrgName(allotOutEntity.getInOrgName());
					allotInEntity.setAllotOutId(allotOutEntity.getId());
					allotInEntity.setOutMny(allotOutEntity.getOutMny());
					allotInEntity.setOutDate(allotOutEntity.getOutDate());
					allotInEntity.setEmployeeId(allotOutEntity.getEmployeeId());
					allotInEntity.setEmployeeName(allotOutEntity.getEmployeeName());
					allotInEntity.setDepartmentId(allotOutEntity.getDepartmentId());
					allotInEntity.setDepartmentName(allotOutEntity.getDepartmentName());
					allotInEntity.setNotifyReceiverId(allotOutEntity.getReceiverId());
					allotInEntity.setReceiverName(allotOutEntity.getReceiverName());
					allotInEntity.setMemo(allotOutEntity.getMemo());
					allotInEntity.setCompanyName(allotOutEntity.getCompanyName());
					allotInEntity.setInCompanyName(allotOutEntity.getInCompanyName());
					allotInEntity.setMaterialNames(allotOutEntity.getMaterialNames());
					allotInEntity.setReceiveState(Integer.valueOf(AllocationState.TO_RECEIVING.getCode()));

					long id = IdWorker.getId();
					if (CollectionUtils.isNotEmpty(allotOutEntity.getAllotOutDetailList())){



						List<AllotInDetailEntity> allotInDetailEntitys = BeanMapper.mapList(allotOutEntity.getAllotOutDetailList(), AllotInDetailEntity.class);
						allotInDetailEntitys.forEach(item->{
							item.setId(null);
							item.setAllocatId(id);
							item.setDetailStoreId(null);
							item.setDetailStoreName(null);
						});
						if (allocatType==2){
						//查询当前大区下是否只有一个实际仓库
							StoreEntity storeEntity = storeService.queryOrgStoreByOrg(allotOutEntity.getInOrgId());
							if (storeEntity!=null){
								allotInDetailEntitys.forEach(item->{
									item.setId(null);
									item.setAllocatId(id);
									item.setDetailStoreId(storeEntity.getId());
									item.setDetailStoreName(storeEntity.getName());
								});
							}
						}
						allotInEntity.setAllotInDetailList(allotInDetailEntitys);
						logger.info("子表信息："+allotInDetailEntitys.toString());
					}
					AllotInVO vo = BeanMapper.map(allotInEntity, AllotInVO.class);
					BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),vo);
					CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
					if(billCode.isSuccess()) {
						allotInEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
					}else{
						throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
					}
					allotInEntity.setId(id);
					boolean b = allotInService.saveOrUpdate(allotInEntity,false);




					if (b){
						AllotInEntity allot = allotInService.selectById(id);
						if ((allot!=null) && (allot.getNotifyReceiverId()!=null)){

							logger.info("项目调拨出库 通知收料人id-{}发送消息", allot.getNotifyReceiverId().toString());
							PushMsgParameter parameter = new PushMsgParameter();
							parameter.setSubject("【项目调拨】：【"+allot.getBillCode()+"】，【"+ DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date()) +"】请悉知！");
							StringBuilder content = new StringBuilder();
							content.append("【").append(allot.getBillCode()).append("】，【")
									.append(allot.getOutProjectName()).append("】，调出的物资【")
									.append(allot.getMaterialNames()).append("】").append("请准备接收入库！");
							parameter.setContent(content.toString());
							parameter.setPcUrl(BASE_HOST + "ejc-zdsmaterial-frontend/#/subCostApply?id=" + allot.getId().toString());

							String[] recIds = new String[]{allot.getNotifyReceiverId().toString()}; //验收人Id
							parameter.setReceivers(recIds);
							sendMsg(parameter, allot.getId(), "项目调拨出库向收料人发送信息");

						}
					}
				}
		AllotOutEntity entity = service.selectById(billId);
		List<AllotOutDetailEntity> allotOutDetailList = entity.getAllotOutDetailList();
		BigDecimal sumAllotDiffMny = null;
		BigDecimal sumAllotDiffTaxMny = null;
		if (CollectionUtils.isNotEmpty(allotOutDetailList)){
			sumAllotDiffMny = allotOutDetailList.stream().filter(item -> null != item.getAllotDiffMny()).map(AllotOutDetailEntity::getAllotDiffMny).reduce(BigDecimal.ZERO, BigDecimal::add);
			sumAllotDiffTaxMny = allotOutDetailList.stream().filter(item -> null != item.getAllotDiffTaxMny()).map(AllotOutDetailEntity::getAllotDiffTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
		}
		LambdaUpdateWrapper<AllotOutEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.in(AllotOutEntity::getId, entity.getId());
		updateWrapper.set(AllotOutEntity::getSumAllotDiffMny, sumAllotDiffMny);
		updateWrapper.set(AllotOutEntity::getSumAllotDiffTaxMny, sumAllotDiffTaxMny);
		// 生效
		updateWrapper.set(AllotOutEntity::getEffectDate, new Date());
		updateWrapper.set(AllotOutEntity::getApproveUserId, sessionManager.getUserContext().getUserId());
		updateWrapper.set(AllotOutEntity::getApproveUserName, sessionManager.getUserContext().getUserName());
		service.update(updateWrapper);
		logger.info("sumAllotDiffMny---"+sumAllotDiffMny);
		logger.info("sumAllotDiffTaxMny---"+sumAllotDiffTaxMny);
		return CommonResponse.success();
	}
	public void sendMsg(PushMsgParameter parameter, Long billId, String oprMsg) {
		parameter.setSaveFlag(true);
		parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
		parameter.setMsgType("notice");
		parameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS, PushMsgParameter.CHANNEL_TYPE_EMAIL});

		CommonResponse<String> sendResp = pushMessageApi.pushMessage(parameter);
		if (!sendResp.isSuccess()) {
			logger.error("{}-发送消息失败，单据Id-{}，发送消息结果-{}", oprMsg, billId, JSONObject.toJSONString(sendResp, SerializerFeature.PrettyFormat,
					SerializerFeature.WriteMapNullValue));
		} else {
			logger.info("{}-发送消息成功！", oprMsg);
		}
	}
	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("该单据不支持弃审和撤回");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
