package com.ejianc.business.zdsstore.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.zdsstore.bean.FlowEntity;
import com.ejianc.business.zdsstore.consts.StoreCommonConsts;
import com.ejianc.business.zdsstore.service.IFlowService;
import com.ejianc.business.zdsstore.service.ISurplusService;
import com.ejianc.business.zdsstore.service.StoreManageService;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.OutFlowVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.business.zdsstore.vo.SurplusVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/api/storeManage/")
@Api(value = "仓库管理公共API接口", tags = {"仓库管理公共API接口"})
public class StoreManageApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    StoreManageService storeManageService;
    @Autowired
    IFlowService flowService;
    @Autowired
    private ISurplusService surplusService;

    /**
     * @param storeManageVO 数据
     * @description: 入库
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author songlx
     * @date: 2022/1/18
     */
    @ApiOperation("出入库正向操作")
    @RequestMapping(value = "/inOutStore", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<StoreManageVO> inOutStore(@RequestBody StoreManageVO storeManageVO) {
        return storeManageService.inOutStore(storeManageVO);
    }


    /**
     * @param storeManageVO 数据
     * @description: 出入库逆向操作
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author songlx
     * @date: 2022/1/17
     */
    @ApiOperation("出入库逆向操作")
    @RequestMapping(value = "/inOutStoreRollback", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<StoreManageVO> inOutStoreRollback(@RequestBody StoreManageVO storeManageVO) {
        return storeManageService.inOutStoreRollback(storeManageVO);
    }

    /**
     * @param storeManageVO
     * @description: 查询物资库存现存量库存均价
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.store.vo.StoreManageVO>
     * @author songlx
     * @date: 2022/2/9
     */
    @ApiOperation("现存量库存均价")
    @RequestMapping(value = "/surplusMaterialPrice", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<StoreManageVO> surplusMaterialPrice(@RequestBody StoreManageVO storeManageVO) {
        return storeManageService.surplusMaterialPrice(storeManageVO);
    }


    /**
     * @param storeManageVO
     * @description: 更新摊销金额
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.store.vo.StoreManageVO>
     * @author songlx
     * @date: 2022/3/2
     */
    @ApiOperation("更新摊销金额")
    @RequestMapping(value = "/updateShareMny", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<StoreManageVO> updateShareMny(@RequestBody StoreManageVO storeManageVO) {
        return storeManageService.updateShareMny(storeManageVO);
    }

    /**
     * @description:  周转材库存现存量库存均价
     *
     * @param storeManageVO
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.store.vo.StoreManageVO>
     * @author songlx
     * @date: 2022/3/3
     */
    @ApiOperation("周转材库存现存量库存均价")
    @RequestMapping(value = "/turnSurplusMaterialPrice", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<StoreManageVO> turnSurplusMaterialPrice(@RequestBody StoreManageVO storeManageVO) {
        return storeManageService.turnSurplusMaterialPrice(storeManageVO);
    }
    /**
     * @param
     * @description: 根据合同id 出入库类型 查询明细
     * @author 姜轶凯
     * @date: 2022/3/4
     */
    @PostMapping(value = "getFlowListByContractId")
    @ResponseBody
    CommonResponse<List<FlowVO>> getFlowListByContractId(@RequestBody OutFlowVO outFlowVO){
        QueryParam param = new QueryParam();
        param.getParams().put("inOutType", new Parameter(QueryParam.IN, outFlowVO.getInOutTypeList()));
        param.getParams().put("pickContractId", new Parameter(QueryParam.EQ, outFlowVO.getContractId()));
        param.getParams().put("effectiveState", new Parameter(QueryParam.EQ, StoreCommonConsts.YES));
        param.getParams().put("settleFlag", new Parameter(QueryParam.EQ, StoreCommonConsts.NO));
        List<FlowEntity> flowEntities = flowService.queryList(param, false);
        List<FlowVO> list = BeanMapper.mapList(flowEntities, FlowVO.class);
        return CommonResponse.success("查询成功",list);
    }
    /**
     * @param
     * @description: 根据采购合同id 出入库类型 查询 入库金额
     * @author 姜轶凯
     * @date: 2022/5/28
     */
    @PostMapping(value = "/queryInstoreTaxMnyByPurchaseContractId")
    @ResponseBody
    CommonResponse<BigDecimal> queryInstoreTaxMnyByPurchaseContractId(@RequestBody OutFlowVO outFlowVO){
        QueryWrapper<FlowEntity> queryWrapper= new QueryWrapper<>();
        queryWrapper.select("IFNULL(SUM(tax_mny),0) as taxMny");
        queryWrapper.eq("purchase_contract_id",outFlowVO.getContractId());
        queryWrapper.eq("in_out_flag",1);
        if(null != outFlowVO.getPartyaFlag()) {
            queryWrapper.eq("partya_flag", outFlowVO.getPartyaFlag());
        }
        if(CollectionUtils.isNotEmpty(outFlowVO.getInOutTypeList())) {
            queryWrapper.in(CollectionUtils.isNotEmpty(outFlowVO.getInOutTypeList()),"in_out_type",outFlowVO.getInOutTypeList());
        }
        FlowEntity entity = flowService.getOne(queryWrapper);
        BigDecimal taxMny = entity.getTaxMny();
        return CommonResponse.success("查询成功",taxMny);
    }

    @ApiOperation("查询仓库余量")
    @RequestMapping(value = "/querySurplusBatch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SurplusVO>> querySurplusBatch(@RequestBody List<SurplusVO> vos) {
        return CommonResponse.success("查询仓库余量成功！", surplusService.querySurplusBatch(vos));
    }

    @ApiOperation("查询指定组织列表下仓库余量")
    @RequestMapping(value = "/queryOrgSurplusBatch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SurplusVO>> queryOrgSurplusBatch(@RequestBody QueryParam queryParam) {
        return CommonResponse.success("查询仓库余量成功！", surplusService.queryOrgSurplusBatch(queryParam));
    }

    @ApiOperation("查询流水")
    @RequestMapping(value = "/queryFlowBatch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<FlowVO>> queryFlowBatch(@RequestBody List<FlowVO> vos) {
        return CommonResponse.success("查询流水成功！", flowService.queryFlowBatch(vos));
    }

    /**
     * @param storeManageVOList 数据
     * @description: 入库
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author songlx
     * @date: 2022/1/18
     */
    @ApiOperation("出入库正向操作")
    @RequestMapping(value = "/inOutStoreBatch", method = RequestMethod.POST)
    @ResponseBody
    @Transactional
    CommonResponse<List<StoreManageVO>> inOutStoreBatch(@RequestBody List<StoreManageVO> storeManageVOList) {
        List<StoreManageVO> result = new ArrayList<>();
        for(StoreManageVO storeManageVO : storeManageVOList){
            logger.info("入库信息：{}", JSONObject.toJSONString(storeManageVO), SerializerFeature.PrettyFormat);
            CommonResponse<StoreManageVO> response = storeManageService.inOutStore(storeManageVO);
            logger.info("入库处理结果：{}", JSONObject.toJSONString(response.getData()), SerializerFeature.PrettyFormat);
            if (response.isSuccess()) {
                result.add(response.getData());
            }else {
                throw new BusinessException("批量出入库正向操作失败：" + response.getMsg());
            }
        }
        return CommonResponse.success("批量出入库正向操作成功", result);
    }


    /**
     * @param storeManageVOList 数据
     * @description: 出入库逆向操作
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author songlx
     * @date: 2022/1/17
     */
    @ApiOperation("出入库逆向操作")
    @RequestMapping(value = "/inOutStoreRollbackBatch", method = RequestMethod.POST)
    @ResponseBody
    @Transactional
    CommonResponse<List<StoreManageVO>> inOutStoreRollbackBatch(@RequestBody List<StoreManageVO> storeManageVOList) {
        List<StoreManageVO> result = new ArrayList<>();
        logger.info("storeManageVOList: {}", JSONObject.toJSONString(storeManageVOList, SerializerFeature.PrettyFormat));
        for(StoreManageVO storeManageVO : storeManageVOList){
            CommonResponse<StoreManageVO> response = storeManageService.inOutStoreRollback(storeManageVO);
            if (response.isSuccess()) {
                result.add(response.getData());
            }else {
                throw new BusinessException("批量出入库逆向操作失败：" + response.getMsg());
            }
        }
        return CommonResponse.success("批量出入库逆向操作成功", result);
    }
}
