/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsstore.service.IAllotInService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"projectAllot"})
public class ProjectAllotController {
    @Autowired
    private IAllotInService service;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<JSONObject>> pageList(@RequestBody QueryParam param) {
        CommonResponse orgResp;
        CommonResponse projectResp;
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        Map params = param.getParams();
        for (String key : params.keySet()) {
            queryParams.put(key, ((Parameter)params.get(key)).getValue());
        }
        queryParams.put("pageSize", param.getPageSize());
        queryParams.put("startLine", param.getPageIndex() < 1 ? 0 : (param.getPageIndex() - 1) * param.getPageSize());
        int count = this.service.countProjectAllot(queryParams);
        Page resp = new Page();
        resp.setSize((long)param.getPageSize());
        resp.setCurrent((long)param.getPageIndex());
        resp.setTotal((long)count);
        if (count == 0) {
            resp.setRecords(new ArrayList());
            resp.setPages(0L);
            return CommonResponse.success((Object)resp);
        }
        List<JSONObject> list = this.service.pageProjectAllot(queryParams);
        HashSet projectIds = new HashSet();
        HashSet orgIds = new HashSet();
        HashMap<Long, ProjectPoolSetVO> projectIdMap = new HashMap<Long, ProjectPoolSetVO>();
        HashMap<Long, OrgVO> secOrgIdMap = new HashMap<Long, OrgVO>();
        HashMap<Long, Long> orgSecOrgIdMap = new HashMap<Long, Long>();
        list.stream().forEach(item -> {
            if (null != item.getLong("inProjectId")) {
                projectIds.add(item.getLong("inProjectId"));
            }
            if (null != item.getLong("outProjectId")) {
                projectIds.add(item.getLong("outProjectId"));
            }
            if (null != item.getLong("inOrgId")) {
                orgIds.add(item.getLong("inOrgId"));
            }
            if (null != item.getLong("outOrgId")) {
                orgIds.add(item.getLong("outOrgId"));
            }
        });
        if (CollectionUtils.isNotEmpty(projectIds) && (projectResp = this.projectPoolApi.queryProjectsByIds(new ArrayList(projectIds))).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)projectResp.getData()))) {
            projectIdMap.putAll(((List)projectResp.getData()).stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
        }
        if (CollectionUtils.isNotEmpty(orgIds) && (orgResp = this.orgApi.findAllByIds(new ArrayList(orgIds))).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)orgResp.getData()))) {
            String[] orgId = null;
            HashSet<Long> secOrgIds = new HashSet<Long>();
            for (OrgVO org : (List)orgResp.getData()) {
                orgId = org.getInnerCode().split("\\|");
                orgSecOrgIdMap.put(org.getId(), orgId.length > 2 ? Long.valueOf(orgId[1]) : Long.valueOf(orgId[orgId.length - 1]));
                secOrgIds.add(orgId.length > 2 ? Long.valueOf(orgId[1]) : Long.valueOf(orgId[orgId.length - 1]));
            }
            orgResp = this.orgApi.findAllByIds(new ArrayList(secOrgIds));
            if (orgResp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)orgResp.getData()))) {
                for (OrgVO org : (List)orgResp.getData()) {
                    secOrgIdMap.put(org.getId(), org);
                }
            }
        }
        for (JSONObject json : list) {
            if (null != json.getLong("inProjectId") && projectIdMap.containsKey(json.getLong("inProjectId"))) {
                json.put("inProjectCode", (Object)((ProjectPoolSetVO)projectIdMap.get(json.getLong("inProjectId"))).getCode());
            }
            if (null != json.getLong("outProjectId") && projectIdMap.containsKey(json.getLong("outProjectId"))) {
                json.put("outProjectCode", (Object)((ProjectPoolSetVO)projectIdMap.get(json.getLong("outProjectId"))).getCode());
            }
            if (null != json.getLong("inOrgId") && secOrgIdMap.containsKey(orgSecOrgIdMap.get(json.getLong("inOrgId")))) {
                json.put("inSecOrgName", (Object)((OrgVO)secOrgIdMap.get(orgSecOrgIdMap.get(json.getLong("inOrgId")))).getName());
            }
            if (null == json.getLong("outOrgId") || !secOrgIdMap.containsKey(orgSecOrgIdMap.get(json.getLong("outOrgId")))) continue;
            json.put("outSecOrgName", (Object)((OrgVO)secOrgIdMap.get(orgSecOrgIdMap.get(json.getLong("outOrgId")))).getName());
        }
        resp.setRecords(list);
        return CommonResponse.success((Object)resp);
    }

    @PostMapping(value={"export"})
    public void exportPickOutFlow(@RequestBody QueryParam param, HttpServletResponse response) {
        CommonResponse orgResp;
        CommonResponse projectResp;
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        Map params = param.getParams();
        for (String key : params.keySet()) {
            queryParams.put(key, ((Parameter)params.get(key)).getValue());
        }
        List<JSONObject> list = this.service.pageProjectAllot(queryParams);
        HashSet projectIds = new HashSet();
        HashSet orgIds = new HashSet();
        HashMap<Long, ProjectPoolSetVO> projectIdMap = new HashMap<Long, ProjectPoolSetVO>();
        HashMap<Long, OrgVO> secOrgIdMap = new HashMap<Long, OrgVO>();
        HashMap<Long, Long> orgSecOrgIdMap = new HashMap<Long, Long>();
        list.stream().forEach(item -> {
            if (null != item.getLong("inProjectId")) {
                projectIds.add(item.getLong("inProjectId"));
            }
            if (null != item.getLong("outProjectId")) {
                projectIds.add(item.getLong("outProjectId"));
            }
            if (null != item.getLong("inOrgId")) {
                orgIds.add(item.getLong("inOrgId"));
            }
            if (null != item.getLong("outOrgId")) {
                orgIds.add(item.getLong("outOrgId"));
            }
        });
        if (CollectionUtils.isNotEmpty(projectIds) && (projectResp = this.projectPoolApi.queryProjectsByIds(new ArrayList(projectIds))).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)projectResp.getData()))) {
            projectIdMap.putAll(((List)projectResp.getData()).stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
        }
        if (CollectionUtils.isNotEmpty(orgIds) && (orgResp = this.orgApi.findAllByIds(new ArrayList(orgIds))).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)orgResp.getData()))) {
            String[] orgId = null;
            HashSet<Long> secOrgIds = new HashSet<Long>();
            for (OrgVO org : (List)orgResp.getData()) {
                orgId = org.getInnerCode().split("\\|");
                orgSecOrgIdMap.put(org.getId(), orgId.length > 2 ? Long.valueOf(orgId[1]) : Long.valueOf(orgId[orgId.length - 1]));
                secOrgIds.add(orgId.length > 2 ? Long.valueOf(orgId[1]) : Long.valueOf(orgId[orgId.length - 1]));
            }
            orgResp = this.orgApi.findAllByIds(new ArrayList(secOrgIds));
            if (orgResp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)orgResp.getData()))) {
                for (OrgVO org : (List)orgResp.getData()) {
                    secOrgIdMap.put(org.getId(), org);
                }
            }
        }
        for (JSONObject json : list) {
            if (null != json.getLong("inProjectId") && projectIdMap.containsKey(json.getLong("inProjectId"))) {
                json.put("inProjectCode", (Object)((ProjectPoolSetVO)projectIdMap.get(json.getLong("inProjectId"))).getCode());
            }
            if (null != json.getLong("outProjectId") && projectIdMap.containsKey(json.getLong("outProjectId"))) {
                json.put("outProjectCode", (Object)((ProjectPoolSetVO)projectIdMap.get(json.getLong("outProjectId"))).getCode());
            }
            if (null != json.getLong("inOrgId") && secOrgIdMap.containsKey(orgSecOrgIdMap.get(json.getLong("inOrgId")))) {
                json.put("inSecOrgName", (Object)((OrgVO)secOrgIdMap.get(orgSecOrgIdMap.get(json.getLong("inOrgId")))).getName());
            }
            if (null == json.getLong("outOrgId") || !secOrgIdMap.containsKey(orgSecOrgIdMap.get(json.getLong("outOrgId")))) continue;
            json.put("outSecOrgName", (Object)((OrgVO)secOrgIdMap.get(orgSecOrgIdMap.get(json.getLong("outOrgId")))).getName());
        }
        HashMap<String, List<JSONObject>> beans = new HashMap<String, List<JSONObject>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProjectAllotexport.xlsx", beans, response);
    }
}

