/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsstore.bean.InOutEntity;
import com.ejianc.business.zdsstore.bean.PickReturnDetailEntity;
import com.ejianc.business.zdsstore.bean.PickReturnEntity;
import com.ejianc.business.zdsstore.enums.ProsubSignStatusEnum;
import com.ejianc.business.zdsstore.mapper.PickReturnMapper;
import com.ejianc.business.zdsstore.service.IInOutService;
import com.ejianc.business.zdsstore.service.IPickReturnDetailService;
import com.ejianc.business.zdsstore.service.IPickReturnService;
import com.ejianc.business.zdsstore.service.StoreManageService;
import com.ejianc.business.zdsstore.vo.PickReturnDetailVO;
import com.ejianc.business.zdsstore.vo.PickReturnVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="pickReturnService")
public class PickReturnServiceImpl
extends BaseServiceImpl<PickReturnMapper, PickReturnEntity>
implements IPickReturnService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_TYPE_CODE = "EJCBT202312000017";
    private static final String BILL_CODE = "zds_PICK_RETURN_CODE";
    private final String OPERATE = "pickReturnBill";
    private final String BILL_DEL_PM_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/pickReturn/billDel";
    private final String BILL_PUSH_PM_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/pickReturn/syncPickReturnBill";
    @Autowired
    private PickReturnMapper pickReturnMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPickReturnService service;
    @Autowired
    private IPickReturnDetailService detailService;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private PickReturnMapper mapper;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private StoreManageService storeManageService;
    @Autowired
    private IInOutService iInOutService;

    @Override
    public PickReturnVO queryByContractId(Long contractId) {
        PickReturnVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)contractId);
        query.eq((Object)"bill_state", (Object)BillStateEnum.UNCOMMITED_STATE);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        PickReturnEntity entity = (PickReturnEntity)((Object)this.pickReturnMapper.selectOne((Wrapper)query));
        if (null != entity) {
            resp = (PickReturnVO)BeanMapper.map((Object)((Object)entity), PickReturnVO.class);
        }
        return resp;
    }

    @Override
    public void removeByPickReturnIds(List<Long> ids) {
        this.removeByIds(ids, true);
    }

    @Override
    public PickReturnVO saveOrUpdate(PickReturnVO saveOrUpdateVO) {
        PickReturnVO voByContract;
        PickReturnEntity entity = (PickReturnEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PickReturnEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
                entity.setProportionFlag("0");
                entity.setRelationFlag("0");
                entity.setConfirmStatus(ProsubSignStatusEnum.\u5f85\u786e\u8ba4.getCode());
                entity.setSourceType(ProsubSignStatusEnum.\u81ea\u5236.getCode());
                entity.setSignStatus(ProsubSignStatusEnum.\u672a\u7b7e\u5b57.getCode());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (!(null == (voByContract = this.service.queryByContractId(saveOrUpdateVO.getContractId())) || null != saveOrUpdateVO.getId() && voByContract.getId().equals(saveOrUpdateVO.getId()))) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u5408\u540c\u4e0b\u5b58\u5728\u672a\u751f\u6548\u5355\u636e\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01");
        }
        entity.getPickReturnDetailList().stream().forEach(e -> e.setSourType(ProsubSignStatusEnum.\u81ea\u5236.getCode()));
        this.service.saveOrUpdate((Object)entity, false);
        PickReturnVO vo = (PickReturnVO)BeanMapper.map((Object)((Object)entity), PickReturnVO.class);
        return vo;
    }

    @Override
    public PickReturnEntity getBySourceId(String sourceId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"source_id", (Object)sourceId);
        PickReturnEntity e = (PickReturnEntity)((Object)super.getOne((Wrapper)query));
        if (null != e) {
            List<PickReturnDetailEntity> detailList = this.detailService.getAllByDeliveryId(e.getId());
            e.setPickReturnDetailList(detailList);
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String pushPickReturnBill(PickReturnEntity entity) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = "pickReturnBill::" + entity.getId().toString() + "::sup";
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"pickReturnBill", (int)600);
            if (!locked) {
                this.releaseLock(jedis, false, key, "pickReturnBill");
                String string = "\u6750\u6599\u9000\u5e93\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25\uff0c\u52a0\u9501\u5931\u8d25\uff01";
                return string;
            }
            CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                this.logger.error("\u63a8\u9001\u9000\u5e93-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)entity.getId(), (Object)ejcCloudSystemCode.getMsg());
                String string = "\u63a8\u9001\u9000\u5e93\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25";
                return string;
            }
            entity.setSourceSystemId((String)ejcCloudSystemCode.getData());
            HashMap<String, String> params = new HashMap<String, String>();
            if (ProsubSignStatusEnum.\u5f85\u786e\u8ba4.getCode().equals(entity.getConfirmStatus())) {
                CommonResponse fileResp = this.attachmentApi.queryListBySourceId(entity.getId(), null, null, null);
                if (fileResp.isSuccess()) {
                    HashMap files = new HashMap();
                    List fileList = (List)fileResp.getData();
                    HashMap<String, String> fileSourceTypeMap = new HashMap<String, String>();
                    ArrayList<Long> fileIds = new ArrayList<Long>();
                    for (Object attach : fileList) {
                        fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                        fileIds.add(attach.getId());
                    }
                    params.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
                    if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                        Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                        fileMap.keySet().stream().forEach(fileKey -> {
                            HashMap file = new HashMap(1);
                            file.put((String)fileKey, fileMap.get(fileKey));
                            files.put(fileKey, file);
                        });
                    }
                    params.put("transData", JSONObject.toJSONString((Object)((Object)entity)));
                    this.logger.info("\u6750\u6599\u9000\u5e93\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0: url-{}, \u9000\u5e93\u5355\uff1a{}", (Object)"/ejc-zdssupbusiness-web/openapi/pickReturn/syncPickReturnBill", (Object)JSONObject.toJSONString((Object)((Object)entity)));
                    CommonResponse writeBackResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-zdssupbusiness-web/openapi/pickReturn/syncPickReturnBill", params, entity.getSubOrgId().toString(), files);
                    this.logger.error("\u6750\u6599\u9000\u5e93\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u8bf7\u6c42\u7ed3\u679c\uff0c{}", (Object)JSONObject.toJSONString((Object)writeBackResp));
                    if (!writeBackResp.isSuccess()) {
                        Object attach;
                        this.releaseLock(jedis, true, key, "pickReturnBill");
                        this.logger.error("\u6750\u6599\u9000\u5e93id-{}\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff0c{}", (Object)entity.getId(), (Object)writeBackResp.getMsg());
                        attach = "\u6750\u6599\u9000\u5e93\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25";
                        return attach;
                    }
                    String operateRespStr = (String)writeBackResp.getData();
                    CommonResponse operateResp = (CommonResponse)JSONObject.parseObject((String)operateRespStr, CommonResponse.class);
                    if (!operateResp.isSuccess()) {
                        this.logger.error("\u6750\u6599\u9000\u5e93id-{}\u63a8\u9001\u4f9b\u5e94\u94fe\uff0c\u5e73\u53f0\u5904\u7406\u5931\u8d25\uff0c{}", (Object)entity.getId(), (Object)operateResp.getMsg());
                        this.releaseLock(jedis, true, key, "pickReturnBill");
                        String string = "\u6750\u6599\u9000\u5e93\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25";
                        return string;
                    }
                }
            } else {
                params.put("transData", JSONObject.toJSONString((Object)((Object)entity)));
                this.logger.info("\u6750\u6599\u9000\u5e93\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0: url-{}, \u53d1\u8d27\u5355\uff1a{}", (Object)"/ejc-zdssupbusiness-web/openapi/pickReturn/syncPickReturnBill", (Object)JSONObject.toJSONString((Object)((Object)entity)));
                CommonResponse writeBackResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-zdssupbusiness-web/openapi/pickReturn/syncPickReturnBill", params, entity.getSubOrgId().toString(), null);
                this.logger.info("\u6750\u6599\u9000\u5e93\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u8bf7\u6c42\u7ed3\u679c\uff0c{}", (Object)JSONObject.toJSONString((Object)writeBackResp));
                if (!writeBackResp.isSuccess()) {
                    this.releaseLock(jedis, true, key, "pickReturnBill");
                    this.logger.error("\u6750\u6599\u9000\u5e93id-{}\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff0c{}", (Object)entity.getId(), (Object)writeBackResp.getMsg());
                    String files = "\u6750\u6599\u9000\u5e93\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25";
                    return files;
                }
                String operateRespStr = (String)writeBackResp.getData();
                CommonResponse operateResp = (CommonResponse)JSONObject.parseObject((String)operateRespStr, CommonResponse.class);
                if (!operateResp.isSuccess()) {
                    this.logger.error("\u6750\u6599\u9000\u5e93id-{}\u63a8\u9001\u4f9b\u5e94\u94fe\uff0c\u5e73\u53f0\u5904\u7406\u5931\u8d25\uff0c{}", (Object)entity.getId(), (Object)operateResp.getMsg());
                    this.releaseLock(jedis, true, key, "pickReturnBill");
                    String string = "\u6750\u6599\u9000\u5e93\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25";
                    return string;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u6750\u6599\u9000\u5e93id-{}\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25\uff0c", (Object)entity.getId(), (Object)e);
            msg = "\u64cd\u4f5c\u5931\u8d25\uff0c\u6750\u6599\u9000\u5e93\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "pickReturnBill");
        }
        return msg;
    }

    @Override
    public CommonResponse<String> syncPickReturn(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String transData = request.getParameter("transData");
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        this.logger.info("\u63a5\u6536\u5230\u63a8\u9001\u9000\u5e93\u5355\u636e: {}, \u5f53\u524d\u4e0a\u4e0b\u6587: {}", (Object)transData, (Object)authority);
        if (StringUtils.isBlank((CharSequence)transData)) {
            return CommonResponse.error((String)"\u5355\u636e\u540c\u6b65\u5931\u8d25\uff0c\u5355\u636e\u5185\u5bb9\u4e3a\u7a7a\uff01");
        }
        PickReturnEntity entity = (PickReturnEntity)((Object)JSONObject.parseObject((String)transData, PickReturnEntity.class));
        this.logger.info("\u63a5\u6536\u5230\u63a8\u9001\u9000\u5e93\u8f6c\u6362\u5355\u636e: {}", (Object)entity);
        if (ProsubSignStatusEnum.\u5f85\u786e\u8ba4.getCode().equals(entity.getConfirmStatus()) || ProsubSignStatusEnum.\u5df2\u9a73\u56de.getCode().equals(entity.getConfirmStatus())) {
            entity.setSourceId(entity.getId());
            Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, BILL_TYPE_CODE, authority, null);
            ArrayList attchIdsList = new ArrayList();
            for (List attachIds : attachIdsMap.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
                attchIdsList.addAll(attachIds);
            }
            entity.setAttachIds(attchIdsList);
            entity.setTenantId(InvocationInfoProxy.getTenantid());
            entity.setSourceType(ProsubSignStatusEnum.\u4f9b\u65b9\u7533\u8bf7.getCode());
            entity.getPickReturnDetailList().forEach(e -> e.setSourType(ProsubSignStatusEnum.\u4f9b\u65b9\u7533\u8bf7.getCode()));
            entity.setVersion(null);
            entity.setCreateUserCode(null);
            entity.setUpdateUserCode(null);
            entity.getPickReturnDetailList().stream().forEach(detail -> {
                detail.setInstoreId(entity.getStoreId());
                detail.setSourType(ProsubSignStatusEnum.\u4f9b\u65b9\u7533\u8bf7.getCode());
                detail.setSourceId(detail.getId());
                detail.setCreateTime(null);
                detail.setUpdateTime(null);
                detail.setTenantId(InvocationInfoProxy.getTenantid());
                detail.setUpdateUserCode(null);
                detail.setCreateUserCode(null);
                detail.setVersion(null);
            });
            this.logger.info("\u63a5\u6536\u5230\u63a8\u9001\u9000\u5e93\u8f6c\u6362\u4fdd\u5b58\u5355\u636e: {}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
            this.service.saveOrUpdate((Object)entity, false);
            return CommonResponse.success((String)"\u5355\u636e\u540c\u6b65\u6210\u529f\uff01");
        }
        if (ProsubSignStatusEnum.\u5df2\u786e\u8ba4.getCode().equals(entity.getConfirmStatus())) {
            PickReturnEntity pickReturn = (PickReturnEntity)((Object)this.service.selectById(entity.getSourceId()));
            PickReturnVO pickReturnVO = (PickReturnVO)BeanMapper.map((Object)((Object)entity), PickReturnVO.class);
            entity.setSourceId(entity.getId());
            Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, BILL_TYPE_CODE, authority, null);
            ArrayList attachIdsList = new ArrayList();
            for (List attachIds : attachIdsMap.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
                attachIdsList.addAll(attachIds);
            }
            pickReturn.setAttachIds(attachIdsList);
            if (pickReturnVO != null && pickReturnVO.getPickReturnDetailList().size() > 0) {
                Map<Long, List<PickReturnDetailVO>> detailMap = pickReturnVO.getPickReturnDetailList().stream().collect(Collectors.groupingBy(PickReturnDetailVO::getStoreId));
                detailMap.forEach((storeId, value) -> {
                    List detailVOS = (List)detailMap.get(storeId);
                    pickReturnVO.setPickReturnDetailList(detailVOS);
                    StoreManageVO storeManageVO = pickReturnVO.getStoreManageVO(pickReturnVO, storeId);
                    storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
                    this.storeManageService.inOutStore(storeManageVO);
                });
            }
            pickReturn.setSignStatus(entity.getSignStatus());
            this.logger.info("\u9000\u5e93\u5355\u66f4\u65b0\u786e\u8ba4\u72b6\u6001\uff1aid-{}", (Object)pickReturn.getId());
            this.service.saveOrUpdate((Object)pickReturn);
            return CommonResponse.success((String)"\u5355\u636e\u540c\u6b65\u6210\u529f\uff01");
        }
        this.logger.info("\u786e\u8ba4\u72b6\u6001\u4e3a\u7a7a\uff1aid-{}", (Object)entity.getId());
        return CommonResponse.success((String)"\u5355\u636e\u540c\u6b65\u6210\u529f\uff01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String billDel(PickReturnEntity entity) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = "pickReturnBill::" + entity.getId().toString();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"pickReturnBill", (int)600);
            if (!locked) {
                this.releaseLock(jedis, false, key, "pickReturnBill");
                String string = "\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u6570\u636e\u5df2\u88ab\u4fee\u6539\uff01";
                return string;
            }
            boolean delResult = this.deleteByPickReturnId(entity.getId());
            if (!delResult) {
                this.releaseLock(jedis, true, key, "pickReturnBill");
                String string = "\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636e\u5220\u9664\u5931\u8d25\uff01";
                return string;
            }
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u8d27\u5355id-{}\u4f5c\u5e9f\u5f02\u5e38\uff0c", (Object)entity.getId(), (Object)e);
            msg = "\u64cd\u4f5c\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "pickReturnBill");
        }
        return msg;
    }

    @Override
    public PickReturnVO pushStatus(PickReturnVO saveOrUpdateVO) {
        String s;
        PickReturnEntity entity = (PickReturnEntity)((Object)this.service.selectById(saveOrUpdateVO.getId()));
        entity.setConfirmStatus(saveOrUpdateVO.getConfirmStatus());
        entity.setSignStatus(saveOrUpdateVO.getSignStatus());
        if (ProsubSignStatusEnum.\u5df2\u786e\u8ba4.getCode().equals(saveOrUpdateVO.getConfirmStatus())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"instore_id", (Object)saveOrUpdateVO.getId());
            List list = this.detailService.list((Wrapper)queryWrapper);
            List<PickReturnDetailEntity> pickReturnDetailEntities = this.splitReturnList(list);
            entity.getPickReturnDetailList().addAll(pickReturnDetailEntities);
            PickReturnVO pickReturnVO = (PickReturnVO)BeanMapper.map((Object)((Object)entity), PickReturnVO.class);
            if (pickReturnVO != null && pickReturnVO.getPickReturnDetailList().size() > 0) {
                Map<Long, List<PickReturnDetailVO>> detailMap = pickReturnVO.getPickReturnDetailList().stream().filter(e -> ProsubSignStatusEnum.\u4f9b\u65b9\u63a8\u9001\u751f\u6210.getCode().equals(e.getSourType())).collect(Collectors.groupingBy(PickReturnDetailVO::getStoreId));
                detailMap.forEach((storeId, value) -> {
                    List detailVOS = (List)detailMap.get(storeId);
                    pickReturnVO.setPickReturnDetailList(detailVOS);
                    StoreManageVO storeManageVO = pickReturnVO.getStoreManageVO(pickReturnVO, storeId);
                    storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
                    CommonResponse<StoreManageVO> storeManageVOCommonResponse = this.storeManageService.inOutStore(storeManageVO);
                    if (!storeManageVOCommonResponse.isSuccess()) {
                        throw new BusinessException(storeManageVOCommonResponse.getMsg());
                    }
                });
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(s = this.pushPickReturnBill(entity)))) {
            throw new BusinessException(s);
        }
        super.saveOrUpdate((Object)entity, false);
        return (PickReturnVO)BeanMapper.map((Object)((Object)entity), PickReturnVO.class);
    }

    List<PickReturnDetailEntity> splitReturnList(List<PickReturnDetailEntity> list) {
        ArrayList<PickReturnDetailEntity> addList = new ArrayList<PickReturnDetailEntity>();
        Map<Long, PickReturnDetailEntity> returnMap = list.stream().collect(Collectors.toMap(e -> e.getInOutId(), e -> e));
        List<Long> collect = list.stream().map(e -> e.getInOutId()).collect(Collectors.toList());
        List<InOutEntity> inOutEntities = this.iInOutService.queryInOutList(collect);
        if (CollectionUtils.isNotEmpty(inOutEntities)) {
            Map<Long, List<InOutEntity>> inOutMap = inOutEntities.stream().collect(Collectors.groupingBy(InOutEntity::getOutBillDetailId));
            for (Map.Entry<Long, PickReturnDetailEntity> entity : returnMap.entrySet()) {
                List<InOutEntity> inOutEntities1 = inOutMap.get(entity.getKey());
                if (!CollectionUtils.isNotEmpty(inOutEntities1)) continue;
                PickReturnDetailEntity value = entity.getValue();
                BigDecimal returnNum = value.getReturnNum();
                for (InOutEntity item : inOutEntities1) {
                    if (!ComputeUtil.isGreaterThan((BigDecimal)returnNum, (BigDecimal)BigDecimal.ZERO)) continue;
                    BigDecimal surplusNum = ComputeUtil.safeSub((BigDecimal)item.getOutNum(), (BigDecimal)item.getReturnStoreNum());
                    PickReturnDetailEntity add = new PickReturnDetailEntity();
                    add.setSurplusNum(surplusNum);
                    if (ComputeUtil.isLessThan((BigDecimal)surplusNum, (BigDecimal)returnNum)) {
                        add.setReturnNum(surplusNum);
                        returnNum = ComputeUtil.safeSub((BigDecimal)returnNum, (BigDecimal)surplusNum);
                    } else {
                        add.setReturnNum(returnNum);
                        returnNum = BigDecimal.ZERO;
                    }
                    add.setCreateTime(null);
                    add.setUpdateTime(null);
                    add.setRowState("add");
                    add.setId(IdWorker.getId());
                    add.setSourType(ProsubSignStatusEnum.\u4f9b\u65b9\u63a8\u9001\u751f\u6210.getCode());
                    add.setInstoreId(item.getId());
                    add.setInstoreBillId(item.getInBillId());
                    add.setInstoreCode(item.getInBillCode());
                    add.setOutstoreBillId(item.getOutBillId());
                    add.setOutstoreCode(item.getOutBillCode());
                    add.setOutstoreDate(item.getOutDate());
                    add.setMaterialCategoryName(item.getMaterialCategoryName());
                    add.setMaterialCategoryCode(item.getMaterialCategoryCode());
                    add.setMaterialCategoryId(item.getMaterialCategoryId());
                    add.setMaterialName(item.getMaterialName());
                    add.setMaterialSpec(item.getMaterialSpec());
                    add.setMaterialUnitId(item.getMaterialUnitId());
                    add.setMaterialUnitName(item.getMaterialUnitName());
                    add.setMaterialId(item.getMaterialId());
                    add.setMaterialCode(item.getMaterialCode());
                    add.setStoreId(item.getOutStoreId());
                    add.setStoreName(item.getOutStoreName());
                    add.setBrandId(item.getBrandId());
                    add.setBrandName(item.getBrandName());
                    add.setProductCode(item.getProductCode());
                    add.setPrice(item.getPrice());
                    add.setTaxPrice(item.getTaxPrice());
                    add.setTaxRate(item.getTaxRate());
                    add.setInOutId(item.getId());
                    add.setAttrFlag(Integer.valueOf(item.getStoreType()));
                    add.setAttrFlagName(item.getStoreTypeName());
                    BigDecimal mny = ComputeUtil.safeMultiply((BigDecimal)item.getPrice(), (BigDecimal)add.getReturnNum());
                    BigDecimal taxMny = ComputeUtil.safeMultiply((BigDecimal)item.getTaxPrice(), (BigDecimal)add.getReturnNum());
                    add.setMny(mny);
                    add.setTaxMny(taxMny);
                    addList.add(add);
                }
            }
        }
        return addList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String deletePickReturnBill(PickReturnEntity entity) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = "pickReturnBill::" + entity.getId().toString() + "::sup";
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"pickReturnBill", (int)600);
            if (!locked) {
                this.releaseLock(jedis, false, key, "pickReturnBill");
                String string = "\u6750\u6599\u9000\u5e93\u4f5c\u5e9f\u5931\u8d25\uff0c\u52a0\u9501\u5931\u8d25\uff01";
                return string;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("sourceId", entity.getId().toString());
            CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                this.logger.error("\u63a8\u9001\u9a8c\u6536-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)entity.getId(), (Object)ejcCloudSystemCode.getMsg());
                String string = "\u63a8\u9001\u9a8c\u6536\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25";
                return string;
            }
            this.logger.info("\u6750\u6599\u9000\u5e93\u4f5c\u5e9f\u901a\u77e5\u4f9b\u65b9\u5e73\u53f0: url-{}, \u6750\u6599\u9000\u5e93\uff1a{}", (Object)"/ejc-zdssupbusiness-web/openapi/pickReturn/billDel", (Object)JSONObject.toJSONString((Object)((Object)entity)));
            CommonResponse writeBackResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-zdssupbusiness-web/openapi/pickReturn/billDel", params, entity.getSubOrgId().toString(), null);
            this.logger.error("\u6750\u6599\u9000\u5e93\u4f5c\u5e9f\u901a\u77e5\u4f9b\u65b9\u5e73\u53f0\u8bf7\u6c42\u7ed3\u679c\uff0c{}", (Object)JSONObject.toJSONString((Object)writeBackResp));
            if (!writeBackResp.isSuccess()) {
                this.releaseLock(jedis, true, key, "pickReturnBill");
                this.logger.error("\u6750\u6599\u9000\u5e93id-{}\u4f5c\u5e9f\u901a\u77e5\u4f9b\u65b9\u5e73\u53f0\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff0c{}", (Object)entity.getId(), (Object)writeBackResp.getMsg());
                String string = "\u9000\u5e93\u4f5c\u5e9f\u901a\u77e5\u4f9b\u65b9\u5e73\u53f0\u5931\u8d25";
                return string;
            }
            String operateRespStr = (String)writeBackResp.getData();
            CommonResponse operateResp = (CommonResponse)JSONObject.parseObject((String)operateRespStr, CommonResponse.class);
            if (!operateResp.isSuccess()) {
                this.logger.error("\u6750\u6599\u9000\u5e93id-{}\u63a8\u9001\u4f9b\u65b9\uff0c\u5e73\u53f0\u5904\u7406\u5931\u8d25\uff0c{}", (Object)entity.getId(), (Object)operateResp.getMsg());
                this.releaseLock(jedis, true, key, "pickReturnBill");
                String string = "\u6750\u6599\u9000\u5e93\u4f5c\u5e9f\u901a\u77e5\u4f9b\u65b9\u5e73\u53f0\u5931\u8d25";
                return string;
            }
        }
        catch (Exception e) {
            this.logger.error("\u6750\u6599\u9000\u5e93id-{}\u4f5c\u5e9f\u901a\u77e5\u4f9b\u65b9\u5e73\u53f0\u5931\u8d25\uff0c", (Object)entity.getId(), (Object)e);
            msg = "\u64cd\u4f5c\u5931\u8d25\uff0c\u6750\u6599\u9000\u5e93\u4f5c\u5e9f\u901a\u77e5\u4f9b\u65b9\u5e73\u53f0\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "pickReturnBill");
        }
        return msg;
    }

    private boolean deleteByPickReturnId(Long deliveryId) {
        this.mapper.deleteByPickReturnId(deliveryId);
        this.detailService.deleteByPickReturnId(deliveryId);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}

