package com.ejianc.business.zdsstore.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsstore.bean.FlowEntity;
import com.ejianc.business.zdsstore.service.IFlowService;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.ProjectStaticsVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2024/10/17 17:25
 */
@RestController
@RequestMapping(value = "/projectInstoreStatics")
public class ProjectInstoreController {

    @Autowired
    private IFlowService service;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @PostMapping(value = "queryList")
    public CommonResponse<IPage<FlowVO>> queryList(@RequestBody QueryParam param) {
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("org_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            CommonResponse<List<OrgVO>> orgResp = orgApi.findOrgByTypesAndOrgId(InvocationInfoProxy.getTenantid(),
                    Arrays.asList(new Integer[]{5}),null, InvocationInfoProxy.getOrgId());
            if(!orgResp.isSuccess()) {
                logger.error("根据组织id-{}查询本下项目部信息失败", InvocationInfoProxy.getOrgId(), JSONObject.toJSONString(orgResp));
                return CommonResponse.error("查询组织信息失败！");
            }
            if(CollectionUtils.isEmpty(orgResp.getData())) {
                logger.info("根据组织id-{}查询本下项目部信息为空!", InvocationInfoProxy.getOrgId());
                param.getParams().put("org_id", new Parameter(QueryParam.EQ, -99L));
            } else {
                param.getParams().put("org_id", new Parameter(QueryParam.IN, orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }

        IPage<FlowEntity> page = service.queryPage(param, false);
        IPage<FlowVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FlowVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 到货流水导出
     *
     * @param queryParam
     * @param response
     */
    @PostMapping(value = "exportInStoreList")
    public void exportInStoreList(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.setPageSize(-1);
        queryParam.setPageIndex(1);
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        CommonResponse<List<OrgVO>> orgResp = orgApi.findOrgByTypesAndOrgId(InvocationInfoProxy.getTenantid(),
                Arrays.asList(new Integer[]{5}),null, InvocationInfoProxy.getOrgId());
        if(!orgResp.isSuccess()) {
            logger.error("根据组织id-{}查询本下项目部信息失败", InvocationInfoProxy.getOrgId(), JSONObject.toJSONString(orgResp));
            throw new BusinessException("查询组织信息失败！");
        }
        if(CollectionUtils.isEmpty(orgResp.getData())) {
            logger.info("根据组织id-{}查询本下项目部信息为空!", InvocationInfoProxy.getOrgId());
            queryParam.getParams().put("orgId", new Parameter(QueryParam.EQ, -99L));
        } else {
            queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        queryParam.getOrderMap().put("create_time", "desc");
        List<FlowEntity> data = service.queryList(queryParam);
        List<FlowVO> vos = BeanMapper.mapList(data, FlowVO.class);

        List<Long> projectIds = new ArrayList<>(vos.stream().map(FlowVO::getProjectId).collect(Collectors.toSet()));
        Map<Long, ProjectPoolSetVO> prjIdMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(projectIds)) {
            CommonResponse<List<ProjectPoolSetVO>> prjResp =projectPoolApi.queryProjectsByIds(projectIds);
            if(prjResp.isSuccess() || CollectionUtils.isNotEmpty(prjResp.getData())) {
                prjIdMap.putAll(prjResp.getData().stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
            }
        }

        vos.stream().forEach(item -> {
            if(StringUtils.isBlank(item.getSupplierName())) {
                if("2".equals(item.getStoreType())) {
                    item.setSupplierName("临建入库");
                } else {
                    item.setSupplierName("甲供材入库");
                }
            }
            if(prjIdMap.containsKey(item.getProjectId())) {
                item.setProjectCode(prjIdMap.get(item.getProjectId()).getCode());
            }
        });

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("inStoreFlowExport.xlsx", beans, response);
    }

    @PostMapping(value = "querySumList")
    public CommonResponse<IPage<FlowVO>> querySumList(@RequestBody QueryParam param) {
        Map<String, Object> queryParams = new HashMap<>();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        CommonResponse<List<OrgVO>> orgResp = orgApi.findOrgByTypesAndOrgId(InvocationInfoProxy.getTenantid(),
                Arrays.asList(new Integer[]{5}),null, InvocationInfoProxy.getOrgId());
        if(!orgResp.isSuccess()) {
            logger.error("根据组织id-{}查询本下项目部信息失败", InvocationInfoProxy.getOrgId(), JSONObject.toJSONString(orgResp));
            throw new BusinessException("查询组织信息失败！");
        }
        if(CollectionUtils.isEmpty(orgResp.getData())) {
            logger.info("根据组织id-{}查询本下项目部信息为空!", InvocationInfoProxy.getOrgId());
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, -99L));
        } else {
            param.getParams().put("orgIds", new Parameter(QueryParam.IN, orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        Map<String, Parameter> params = param.getParams();
        for(String key : params.keySet()) {
            queryParams.put(key, params.get(key).getValue());
        }

        queryParams.put("pageSize", param.getPageSize());
        queryParams.put("startLine", param.getPageIndex() < 1 ? 0 : (param.getPageIndex() - 1) * param.getPageSize());
        int count = service.flowCount(queryParams);

        IPage<FlowVO> resp = new Page<>();
        resp.setSize(param.getPageSize());
        resp.setCurrent(param.getPageIndex());
        resp.setTotal(count);

        List<FlowVO> list = service.flowList(queryParams);
        list.stream().forEach(item -> {
            if(StringUtils.isBlank(item.getSupplierName())) {
                if("2".equals(item.getStoreType())) {
                    item.setSupplierName("临建入库");
                } else {
                    item.setSupplierName("甲供材入库");
                }
            }
        });
        resp.setRecords(list);

        return CommonResponse.success("查询列表数据成功！", resp);
    }

    @PostMapping(value = "exportSumList")
    public void exportSumList(@RequestBody QueryParam param, HttpServletResponse response) {
        Map<String, Object> queryParams = new HashMap<>();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageSize(-1);
        param.setPageSize(1);

        CommonResponse<List<OrgVO>> orgResp = orgApi.findOrgByTypesAndOrgId(InvocationInfoProxy.getTenantid(),
                Arrays.asList(new Integer[]{5}),null, InvocationInfoProxy.getOrgId());
        if(!orgResp.isSuccess()) {
            logger.error("根据组织id-{}查询本下项目部信息失败", InvocationInfoProxy.getOrgId(), JSONObject.toJSONString(orgResp));
            throw new BusinessException("查询组织信息失败！");
        }
        if(CollectionUtils.isEmpty(orgResp.getData())) {
            logger.info("根据组织id-{}查询本下项目部信息为空!", InvocationInfoProxy.getOrgId());
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, -99L));
        } else {
            param.getParams().put("orgIds", new Parameter(QueryParam.IN, orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        Map<String, Parameter> params = param.getParams();
        for(String key : params.keySet()) {
            queryParams.put(key, params.get(key).getValue());
        }

        List<FlowVO> list = service.flowList(queryParams);
        list.stream().forEach(item -> {
            if(StringUtils.isBlank(item.getSupplierName())) {
                if("2".equals(item.getStoreType())) {
                    item.setSupplierName("临建入库");
                } else {
                    item.setSupplierName("甲供材入库");
                }
            }
        });

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("inStoreSumExport.xlsx", beans, response);
    }

    @PostMapping(value = "querySupList")
    public CommonResponse<List<Map<String, Object>>> querySupList(@RequestBody QueryParam param) {

        CommonResponse<List<OrgVO>> orgResp = orgApi.findOrgByTypesAndOrgId(InvocationInfoProxy.getTenantid(),
                Arrays.asList(new Integer[]{5}),null, InvocationInfoProxy.getOrgId());
        if(!orgResp.isSuccess()) {
            logger.error("根据组织id-{}查询本下项目部信息失败", InvocationInfoProxy.getOrgId(), JSONObject.toJSONString(orgResp));
            throw new BusinessException("查询组织信息失败！");
        }
        if(CollectionUtils.isEmpty(orgResp.getData())) {
            logger.info("根据组织id-{}查询本下项目部信息为空!", InvocationInfoProxy.getOrgId());
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, -99L));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        return CommonResponse.success(service.querySupList(param));
    }

    @PostMapping(value = "pagePickOutFlow")
    public CommonResponse<IPage<ProjectStaticsVO>> pagePickOutFlow(@RequestBody QueryParam param) {
        Map<String, Object> queryParams = new HashMap<>();

        CommonResponse<List<OrgVO>> orgResp = orgApi.findOrgByTypesAndOrgId(InvocationInfoProxy.getTenantid(),
                Arrays.asList(new Integer[]{5}),null, InvocationInfoProxy.getOrgId());
        if(!orgResp.isSuccess()) {
            logger.error("根据组织id-{}查询本下项目部信息失败", InvocationInfoProxy.getOrgId(), JSONObject.toJSONString(orgResp));
            throw new BusinessException("查询组织信息失败！");
        }
        if(CollectionUtils.isEmpty(orgResp.getData())) {
            logger.info("根据组织id-{}查询本下项目部信息为空!", InvocationInfoProxy.getOrgId());
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, -99L));
        } else {
            param.getParams().put("orgIds", new Parameter(QueryParam.IN, orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        Map<String, Parameter> params = param.getParams();
        for(String key : params.keySet()) {
            queryParams.put(key, params.get(key).getValue());
        }

        queryParams.put("pageSize", param.getPageSize());
        queryParams.put("startLine", param.getPageIndex() < 1 ? 0 : (param.getPageIndex() - 1) * param.getPageSize());
        int count = service.pickOutCount(queryParams);

        IPage<ProjectStaticsVO> resp = new Page<>();
        resp.setSize(param.getPageSize());
        resp.setCurrent(param.getPageIndex());
        resp.setTotal(count);
        if(count == 0) {
            resp.setRecords(new ArrayList<>());
            resp.setPages(0);
            return CommonResponse.success(resp);
        }

        List<ProjectStaticsVO> list = service.pickOutList(queryParams);
        resp.setRecords(list);

        return CommonResponse.success(resp);
    }


    @PostMapping(value = "exportPickOutFlow")
    public void exportPickOutFlow(@RequestBody QueryParam param, HttpServletResponse response) {
        Map<String, Object> queryParams = new HashMap<>();

        CommonResponse<List<OrgVO>> orgResp = orgApi.findOrgByTypesAndOrgId(InvocationInfoProxy.getTenantid(),
                Arrays.asList(new Integer[]{5}),null, InvocationInfoProxy.getOrgId());
        if(!orgResp.isSuccess()) {
            logger.error("根据组织id-{}查询本下项目部信息失败", InvocationInfoProxy.getOrgId(), JSONObject.toJSONString(orgResp));
            throw new BusinessException("查询组织信息失败！");
        }
        if(CollectionUtils.isEmpty(orgResp.getData())) {
            logger.info("根据组织id-{}查询本下项目部信息为空!", InvocationInfoProxy.getOrgId());
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, -99L));
        } else {
            param.getParams().put("orgIds", new Parameter(QueryParam.IN, orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        Map<String, Parameter> params = param.getParams();
        for(String key : params.keySet()) {
            queryParams.put(key, params.get(key).getValue());
        }

        List<ProjectStaticsVO> list = service.pickOutList(queryParams);

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("inStoreFlowExport.xlsx", beans, response);
    }


    @PostMapping(value = "pagePickOutSum")
    public CommonResponse<IPage<ProjectStaticsVO>> pagePickOutSum(@RequestBody QueryParam param) {
        Map<String, Object> queryParams = new HashMap<>();

        CommonResponse<List<OrgVO>> orgResp = orgApi.findOrgByTypesAndOrgId(InvocationInfoProxy.getTenantid(),
                Arrays.asList(new Integer[]{5}),null, InvocationInfoProxy.getOrgId());
        if(!orgResp.isSuccess()) {
            logger.error("根据组织id-{}查询本下项目部信息失败", InvocationInfoProxy.getOrgId(), JSONObject.toJSONString(orgResp));
            throw new BusinessException("查询组织信息失败！");
        }
        if(CollectionUtils.isEmpty(orgResp.getData())) {
            logger.info("根据组织id-{}查询本下项目部信息为空!", InvocationInfoProxy.getOrgId());
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, -99L));
        } else {
            param.getParams().put("orgIds", new Parameter(QueryParam.IN, orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        Map<String, Parameter> params = param.getParams();
        for(String key : params.keySet()) {
            queryParams.put(key, params.get(key).getValue());
        }

        queryParams.put("pageSize", param.getPageSize());
        queryParams.put("startLine", param.getPageIndex() < 1 ? 0 : (param.getPageIndex() - 1) * param.getPageSize());
        int count = service.pickOutSumCount(queryParams);

        IPage<ProjectStaticsVO> resp = new Page<>();
        resp.setSize(param.getPageSize());
        resp.setCurrent(param.getPageIndex());
        resp.setTotal(count);
        if(count == 0) {
            resp.setRecords(new ArrayList<>());
            resp.setPages(0);
            return CommonResponse.success(resp);
        }

        List<ProjectStaticsVO> list = service.pickOutSumList(queryParams);
        resp.setRecords(list);

        return CommonResponse.success(resp);
    }


    @PostMapping(value = "exportPickOutSum")
    public void exportPickOutSum(@RequestBody QueryParam param, HttpServletResponse response) {
        Map<String, Object> queryParams = new HashMap<>();

        CommonResponse<List<OrgVO>> orgResp = orgApi.findOrgByTypesAndOrgId(InvocationInfoProxy.getTenantid(),
                Arrays.asList(new Integer[]{5}),null, InvocationInfoProxy.getOrgId());
        if(!orgResp.isSuccess()) {
            logger.error("根据组织id-{}查询本下项目部信息失败", InvocationInfoProxy.getOrgId(), JSONObject.toJSONString(orgResp));
            throw new BusinessException("查询组织信息失败！");
        }
        if(CollectionUtils.isEmpty(orgResp.getData())) {
            logger.info("根据组织id-{}查询本下项目部信息为空!", InvocationInfoProxy.getOrgId());
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, -99L));
        } else {
            param.getParams().put("orgIds", new Parameter(QueryParam.IN, orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        Map<String, Parameter> params = param.getParams();
        for(String key : params.keySet()) {
            queryParams.put(key, params.get(key).getValue());
        }
        List<ProjectStaticsVO> list = service.pickOutSumList(queryParams);

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("pickOutSumExport.xlsx", beans, response);
    }

    @PostMapping(value = "querySubSupList")
    public CommonResponse<List<Map<String, Object>>> querySubSupList(@RequestBody QueryParam param) {
        CommonResponse<List<OrgVO>> orgResp = orgApi.findOrgByTypesAndOrgId(InvocationInfoProxy.getTenantid(),
                Arrays.asList(new Integer[]{5}),null, InvocationInfoProxy.getOrgId());
        if(!orgResp.isSuccess()) {
            logger.error("根据组织id-{}查询本下项目部信息失败", InvocationInfoProxy.getOrgId(), JSONObject.toJSONString(orgResp));
            throw new BusinessException("查询组织信息失败！");
        }
        if(CollectionUtils.isEmpty(orgResp.getData())) {
            logger.info("根据组织id-{}查询本下项目部信息为空!", InvocationInfoProxy.getOrgId());
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, -99L));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        return CommonResponse.success(service.querySubSupList(param));
    }


    @PostMapping(value = "pageInOutStore")
    public CommonResponse<IPage<ProjectStaticsVO>> pageInOutStore(@RequestBody QueryParam param) {
        Map<String, Object> queryParams = new HashMap<>();

        CommonResponse<List<OrgVO>> orgResp = orgApi.findOrgByTypesAndOrgId(InvocationInfoProxy.getTenantid(),
                Arrays.asList(new Integer[]{5}),null, InvocationInfoProxy.getOrgId());
        if(!orgResp.isSuccess()) {
            logger.error("根据组织id-{}查询本下项目部信息失败", InvocationInfoProxy.getOrgId(), JSONObject.toJSONString(orgResp));
            throw new BusinessException("查询组织信息失败！");
        }
        if(CollectionUtils.isEmpty(orgResp.getData())) {
            logger.info("根据组织id-{}查询本下项目部信息为空!", InvocationInfoProxy.getOrgId());
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, -99L));
        } else {
            param.getParams().put("orgIds", new Parameter(QueryParam.IN, orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(InvocationInfoProxy.getOrgType())) {
            queryParams.put("org_id", InvocationInfoProxy.getOrgId());
        }

        Map<String, Parameter> params = param.getParams();
        for(String key : params.keySet()) {
            queryParams.put(key, params.get(key).getValue());
        }

        queryParams.put("pageSize", param.getPageSize());
        queryParams.put("startLine", param.getPageIndex() < 1 ? 0 : (param.getPageIndex() - 1) * param.getPageSize());
        int count = service.countInOutStore(queryParams);

        IPage<ProjectStaticsVO> resp = new Page<>();
        resp.setSize(param.getPageSize());
        resp.setCurrent(param.getPageIndex());
        resp.setTotal(count);

        List<ProjectStaticsVO> list = service.pageInOutStore(queryParams);
        resp.setRecords(list);

        return CommonResponse.success(resp);
    }

    @PostMapping(value = "exportInOutStore")
    public void exportInOutStore(@RequestBody QueryParam param, HttpServletResponse response) {
        Map<String, Object> queryParams = new HashMap<>();

        CommonResponse<List<OrgVO>> orgResp = orgApi.findOrgByTypesAndOrgId(InvocationInfoProxy.getTenantid(),
                Arrays.asList(new Integer[]{5}),null, InvocationInfoProxy.getOrgId());
        if(!orgResp.isSuccess()) {
            logger.error("根据组织id-{}查询本下项目部信息失败", InvocationInfoProxy.getOrgId(), JSONObject.toJSONString(orgResp));
            throw new BusinessException("查询组织信息失败！");
        }
        if(CollectionUtils.isEmpty(orgResp.getData())) {
            logger.info("根据组织id-{}查询本下项目部信息为空!", InvocationInfoProxy.getOrgId());
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, -99L));
        } else {
            param.getParams().put("orgIds", new Parameter(QueryParam.IN, orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        Map<String, Parameter> params = param.getParams();
        for(String key : params.keySet()) {
            queryParams.put(key, params.get(key).getValue());
        }

        List<ProjectStaticsVO> list = service.pageInOutStore(queryParams);

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("inOutStoreExport.xlsx", beans, response);
    }
}
