package com.ejianc.business.zdsstore.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsstore.service.IAllotInService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2024/11/21 21:03
 */
@RestController
@RequestMapping(value = "projectAllot")
public class ProjectAllotController {

    @Autowired
    private IAllotInService service;

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Autowired
    private IOrgApi orgApi;


    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<JSONObject>> pageList(@RequestBody QueryParam param) {
        Map<String, Object> queryParams = new HashMap<>();

        Map<String, Parameter> params = param.getParams();
        for(String key : params.keySet()) {
            queryParams.put(key, params.get(key).getValue());
        }
        if(StringUtils.isNotBlank(param.getSearchText())) {
            queryParams.put("searchText", param.getSearchText());
        }

        queryParams.put("pageSize", param.getPageSize());
        queryParams.put("startLine", param.getPageIndex() < 1 ? 0 : (param.getPageIndex() - 1) * param.getPageSize());

        int count = service.countProjectAllot(queryParams);

        IPage<JSONObject> resp = new Page<>();
        resp.setSize(param.getPageSize());
        resp.setCurrent(param.getPageIndex());
        resp.setTotal(count);
        if(count == 0) {
            resp.setRecords(new ArrayList<>());
            resp.setPages(0);
            return CommonResponse.success(resp);
        }

        List<JSONObject> list = service.pageProjectAllot(queryParams);

        //查询所有项目
        Set<Long> projectIds = new HashSet<>();
        Set<Long> orgIds = new HashSet<>();
        Map<Long, ProjectPoolSetVO> projectIdMap = new HashMap<>();
        Map<Long, OrgVO> secOrgIdMap = new HashMap<>();
        Map<Long, Long> orgSecOrgIdMap = new HashMap<>();
        list.stream().forEach(item -> {
            if(null != item.getLong("inProjectId")) {
                projectIds.add(item.getLong("inProjectId"));
            }
            if(null != item.getLong("outProjectId")) {
                projectIds.add(item.getLong("outProjectId"));
            }
            if(null != item.getLong("inOrgId")) {
                orgIds.add(item.getLong("inOrgId"));
            }
            if(null != item.getLong("outOrgId")) {
                orgIds.add(item.getLong("outOrgId"));
            }
        });

        if(CollectionUtils.isNotEmpty(projectIds)) {
            CommonResponse<List<ProjectPoolSetVO>> projectResp = projectPoolApi.queryProjectsByIds(new ArrayList<>(projectIds));
            if(projectResp.isSuccess() && CollectionUtils.isNotEmpty(projectResp.getData())) {
                projectIdMap.putAll(projectResp.getData().stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
            }
        }

        //查询二级单位
        if(CollectionUtils.isNotEmpty(orgIds)) {
            CommonResponse<List<OrgVO>> orgResp = orgApi.findAllByIds(new ArrayList<>(orgIds));
            if(orgResp.isSuccess() && CollectionUtils.isNotEmpty(orgResp.getData())) {

                String[] orgId = null;
                Set<Long> secOrgIds = new HashSet<>();
                for(OrgVO org : orgResp.getData()) {
                    orgId =  org.getInnerCode().split("\\|");
                    orgSecOrgIdMap.put(org.getId(), orgId.length > 2 ? Long.valueOf(orgId[1]) : Long.valueOf(orgId[orgId.length-1]));
                    secOrgIds.add(orgId.length > 2 ? Long.valueOf(orgId[1]) : Long.valueOf(orgId[orgId.length-1]) );
                }

                //根据Id查询二级单位
                orgResp = orgApi.findAllByIds(new ArrayList<>(secOrgIds));
                if(orgResp.isSuccess() && CollectionUtils.isNotEmpty(orgResp.getData())) {
                   for(OrgVO org : orgResp.getData()) {
                       secOrgIdMap.put(org.getId(), org);
                   }
                }
           }
        }

        for(JSONObject json : list) {
            if(null != json.getLong("inProjectId") && projectIdMap.containsKey(json.getLong("inProjectId"))) {
                json.put("inProjectCode", projectIdMap.get(json.getLong("inProjectId")).getCode());
            }
            if(null != json.getLong("outProjectId") && projectIdMap.containsKey(json.getLong("outProjectId"))) {
                json.put("outProjectCode", projectIdMap.get(json.getLong("outProjectId")).getCode());
            }
            if(null != json.getLong("inOrgId") && secOrgIdMap.containsKey(orgSecOrgIdMap.get(json.getLong("inOrgId")))) {
                json.put("inSecOrgName", secOrgIdMap.get(orgSecOrgIdMap.get(json.getLong("inOrgId"))).getName());
            }
            if(null != json.getLong("outOrgId") && secOrgIdMap.containsKey(orgSecOrgIdMap.get(json.getLong("outOrgId")))) {
                json.put("outSecOrgName", secOrgIdMap.get(orgSecOrgIdMap.get(json.getLong("outOrgId"))).getName());
            }
        }

        resp.setRecords(list);

        return CommonResponse.success(resp);
    }

    @PostMapping(value = "export")
    public void exportPickOutFlow(@RequestBody QueryParam param, HttpServletResponse response) {
        Map<String, Object> queryParams = new HashMap<>();

        Map<String, Parameter> params = param.getParams();
        for(String key : params.keySet()) {
            queryParams.put(key, params.get(key).getValue());
        }

        List<JSONObject> list = service.pageProjectAllot(queryParams);

        //查询所有项目
        Set<Long> projectIds = new HashSet<>();
        Set<Long> orgIds = new HashSet<>();
        Map<Long, ProjectPoolSetVO> projectIdMap = new HashMap<>();
        Map<Long, OrgVO> secOrgIdMap = new HashMap<>();
        Map<Long, Long> orgSecOrgIdMap = new HashMap<>();
        list.stream().forEach(item -> {
            if(null != item.getLong("inProjectId")) {
                projectIds.add(item.getLong("inProjectId"));
            }
            if(null != item.getLong("outProjectId")) {
                projectIds.add(item.getLong("outProjectId"));
            }
            if(null != item.getLong("inOrgId")) {
                orgIds.add(item.getLong("inOrgId"));
            }
            if(null != item.getLong("outOrgId")) {
                orgIds.add(item.getLong("outOrgId"));
            }
        });

        if(CollectionUtils.isNotEmpty(projectIds)) {
            CommonResponse<List<ProjectPoolSetVO>> projectResp = projectPoolApi.queryProjectsByIds(new ArrayList<>(projectIds));
            if(projectResp.isSuccess() && CollectionUtils.isNotEmpty(projectResp.getData())) {
                projectIdMap.putAll(projectResp.getData().stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
            }
        }

        //查询二级单位
        if(CollectionUtils.isNotEmpty(orgIds)) {
            CommonResponse<List<OrgVO>> orgResp = orgApi.findAllByIds(new ArrayList<>(orgIds));
            if(orgResp.isSuccess() && CollectionUtils.isNotEmpty(orgResp.getData())) {

                String[] orgId = null;
                Set<Long> secOrgIds = new HashSet<>();
                for(OrgVO org : orgResp.getData()) {
                    orgId =  org.getInnerCode().split("\\|");
                    orgSecOrgIdMap.put(org.getId(), orgId.length > 2 ? Long.valueOf(orgId[1]) : Long.valueOf(orgId[orgId.length-1]));
                    secOrgIds.add(orgId.length > 2 ? Long.valueOf(orgId[1]) : Long.valueOf(orgId[orgId.length-1]) );
                }

                //根据Id查询二级单位
                orgResp = orgApi.findAllByIds(new ArrayList<>(secOrgIds));
                if(orgResp.isSuccess() && CollectionUtils.isNotEmpty(orgResp.getData())) {
                    for(OrgVO org : orgResp.getData()) {
                        secOrgIdMap.put(org.getId(), org);
                    }
                }
            }
        }

        for(JSONObject json : list) {
            if(null != json.getLong("inProjectId") && projectIdMap.containsKey(json.getLong("inProjectId"))) {
                json.put("inProjectCode", projectIdMap.get(json.getLong("inProjectId")).getCode());
            }
            if(null != json.getLong("outProjectId") && projectIdMap.containsKey(json.getLong("outProjectId"))) {
                json.put("outProjectCode", projectIdMap.get(json.getLong("outProjectId")).getCode());
            }
            if(null != json.getLong("inOrgId") && secOrgIdMap.containsKey(orgSecOrgIdMap.get(json.getLong("inOrgId")))) {
                json.put("inSecOrgName", secOrgIdMap.get(orgSecOrgIdMap.get(json.getLong("inOrgId"))).getName());
            }
            if(null != json.getLong("outOrgId") && secOrgIdMap.containsKey(orgSecOrgIdMap.get(json.getLong("outOrgId")))) {
                json.put("outSecOrgName", secOrgIdMap.get(orgSecOrgIdMap.get(json.getLong("outOrgId"))).getName());
            }
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProjectAllotexport.xlsx", beans, response);
    }

}
