/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsstore.bean.AllotOutEntity;
import com.ejianc.business.zdsstore.service.IAllotOutService;
import com.ejianc.business.zdsstore.service.IStoreService;
import com.ejianc.business.zdsstore.service.StoreManageService;
import com.ejianc.business.zdsstore.vo.AllotOutVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"allotOut"})
public class AllotOutController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAllotOutService service;
    @Autowired
    StoreManageService storeManageService;
    @Autowired
    IStoreService storeService;
    @Autowired
    private ICommonBusinessService allotOut;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AllotOutVO> saveOrUpdate(@RequestBody AllotOutVO saveOrUpdateVO) {
        CommonResponse<AllotOutVO> vo = this.service.allotOutSaveOrUpdate(saveOrUpdateVO);
        return vo;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AllotOutVO> queryDetail(Long id) {
        AllotOutEntity entity = (AllotOutEntity)((Object)this.service.selectById(id));
        AllotOutVO vo = (AllotOutVO)BeanMapper.map((Object)((Object)entity), AllotOutVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AllotOutVO> vos) {
        CommonResponse<String> commonResponse = this.service.allotOutDelete(vos);
        return commonResponse;
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AllotOutVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("materialNames");
        fuzzyFields.add("inProjectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("receiverPerson");
        fuzzyFields.add("billCode");
        fuzzyFields.add("companyName");
        fuzzyFields.add("inCompanyName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AllotOutVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        this.service.excelExport(param, response);
    }

    @RequestMapping(value={"/refAllotOutData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<AllotOutVO>> refAllotOutData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AllotOutVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/surplusMaterialPrice"}, method={RequestMethod.POST})
    @ResponseBody
    CommonResponse<List<StoreManageVO>> surplusMaterialPrice(@RequestBody AllotOutVO saveOrUpdateVO) {
        CommonResponse<List<StoreManageVO>> listCommonResponse = this.service.surplusListMaterialPrice(saveOrUpdateVO);
        return listCommonResponse;
    }

    @RequestMapping(value={"/querytestDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AllotOutVO> querytestDetail(Long id) {
        this.allotOut.afterApprovalProcessor(id, Integer.valueOf(0), "BT220209000000004");
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/getOrgTwoById"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrgVO> getOrgTwoById(Long orgId) {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(orgId);
        Map<Long, OrgVO> corpMapByIds = this.getCorpMapByIds(orgIds);
        OrgVO orgVO = corpMapByIds.get(orgId);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)orgVO);
    }

    public Map<Long, OrgVO> getCorpMapByIds(List<Long> orgIds) {
        HashMap<Long, OrgVO> corp = new HashMap<Long, OrgVO>();
        CommonResponse rootResp = this.iOrgApi.findOrgByType(InvocationInfoProxy.getTenantid(), Arrays.asList(1), null);
        HashMap orgMap = new HashMap();
        HashMap corpMap = new HashMap();
        HashMap rootMap = new HashMap();
        if (rootResp.isSuccess() && null != rootResp.getData()) {
            for (OrgVO root : (List)rootResp.getData()) {
                CommonResponse orgResp = this.iOrgApi.findChildrenByParentId(root.getId());
                if (!orgResp.isSuccess() || null == orgResp.getData()) continue;
                List orgList = (List)orgResp.getData();
                orgMap.putAll(orgList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity())));
                corpMap.putAll(orgList.stream().filter(e -> e.getOrgType() == 2 && 1 == StringUtils.countMatches((CharSequence)e.getInnerCode(), (CharSequence)"|")).collect(Collectors.toMap(BaseVO::getId, Function.identity())));
                rootMap.putAll(orgList.stream().filter(e -> e.getOrgType() == 1).collect(Collectors.toMap(BaseVO::getId, Function.identity())));
            }
        }
        for (Long orgId : orgIds) {
            if (!orgMap.containsKey(orgId)) continue;
            String innerCode = ((OrgVO)orgMap.get(orgId)).getInnerCode();
            for (Long key : corpMap.keySet()) {
                if (!innerCode.contains(String.valueOf(key))) continue;
                corp.put(orgId, (OrgVO)corpMap.get(key));
            }
            if (corp.containsKey(orgId)) continue;
            for (Long key : rootMap.keySet()) {
                if (!innerCode.contains(String.valueOf(key))) continue;
                corp.put(orgId, (OrgVO)rootMap.get(key));
            }
        }
        return corp;
    }
}

