package com.ejianc.business.zdsstore.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsstore.bean.FlowEntity;
import com.ejianc.business.zdsstore.vo.*;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 仓库流水表
 *
 * @author generator
 */
@Mapper
public interface FlowMapper extends BaseCrudMapper<FlowEntity> {

    List<FlowVO> queryInstoreFlowData(IPage<FlowVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    List<SurplusVO> computeStore(@Param(value = "storeId") Long storeId, @Param(value = "materialIds") List<Long> materialIds, @Param(value = "brandIds") List<Long> brandIds);

    List<StoreApiVO> queryStoreInstoreData(Page<StoreApiVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    List<FlowVO> queryTurnInstoreFlowData(Page<FlowVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    Integer settleCount(HashMap<String, Object> map);

    void changeSettleFlag(HashMap<String, Object> map);

    List<SurplusVO> computeStoreList(Page<SurplusVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    List<MaterialCategoryTopVO> queryMaterialCategoryTopN(@Param("topN") Integer topN,@Param("startDate") String startDate,@Param("orgIds") List<Long> orgIds);

    List<MaterialCategoryTopVO> getSumMaterialCategory(@Param("startDate") String startDate, @Param("orgIds") List<Long> orgIds);

    List<FlowVO> getSendReceiveList(Page<FlowVO> page,@Param(Constants.WRAPPER) QueryWrapper wrapper);

    int pickOutCount(Map<String, Object> queryParams);

    List<ProjectStaticsVO> pickOutList(Map<String, Object> queryParams);

    int flowCount(Map<String, Object> queryParams);

    List<FlowVO> flowList(Map<String, Object> queryParams);

    int pickOutSumCount(Map<String, Object> queryParams);

    List<ProjectStaticsVO> pickOutSumList(Map<String, Object> queryParams);

    int countInOutStore(Map<String, Object> queryParams);

    List<ProjectStaticsVO> pageInOutStore(Map<String, Object> queryParams);
}
