package com.ejianc.business.zdsstore.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsstore.bean.IdleFlowEntity;
import com.ejianc.business.zdsstore.bean.SurplusEntity;
import com.ejianc.business.zdsstore.mapper.IdleFlowMapper;
import com.ejianc.business.zdsstore.service.IIdleFlowService;
import com.ejianc.business.zdsstore.service.ISurplusService;
import com.ejianc.business.zdsstore.vo.IdleFlowVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 盘活闲置流水表
 *
 * @author generator
 *
 */
@Service("idleFlowService")
public class IdleFlowServiceImpl extends BaseServiceImpl<IdleFlowMapper, IdleFlowEntity> implements IIdleFlowService{

    @Autowired
    private ISurplusService surplusService;

    @Override
    public CommonResponse<String> inOutStore(List<IdleFlowVO> flowVOS) {
        List<IdleFlowEntity> flowEntities = BeanMapper.mapList(flowVOS, IdleFlowEntity.class);
        QueryWrapper<IdleFlowEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.and(q -> {
            for(IdleFlowEntity f : flowEntities) {
                q.or(iq -> iq.eq("store_id", f.getStoreId()).eq("brand_id", f.getBrandId()).eq("material_id", f.getMaterialId()));
            }
            return q;
        });
        List<IdleFlowEntity> list = list(queryWrapper);
        if (CollectionUtils.isEmpty(list)) {
            list = new ArrayList<>();
        }
        list.addAll(flowEntities);
        Map<String, BigDecimal> resultMap = list.stream()
                .collect(Collectors.groupingBy(
                        x -> x.getStoreId() + "@" + x.getMaterialId() + "@" + x.getBrandId(),
                        Collectors.reducing(BigDecimal.ZERO, IdleFlowEntity::getNum, BigDecimal::add)
                ));
        QueryWrapper<SurplusEntity> wrapper = new QueryWrapper<>();
        wrapper.and(q -> {
            for(IdleFlowEntity f : flowEntities) {
                q.or(iq -> iq.eq("store_id", f.getStoreId()).eq("brand_id", f.getBrandId()).eq("material_id", f.getMaterialId()));
            }
            return q;
        });
        List<SurplusEntity> surplusEntities = surplusService.list(wrapper);
        List<SurplusEntity> updateList = new ArrayList<>();
        for(SurplusEntity surplusEntity : surplusEntities){
            String key = surplusEntity.getStoreId() + "@" + surplusEntity.getMaterialId() + "@" + surplusEntity.getBrandId();
            if (!resultMap.containsKey(key) || ComputeUtil.isLessThan(surplusEntity.getSurplusNum(), resultMap.get(key))) {
                return CommonResponse.error("物资[名称：" + surplusEntity.getMaterialName() + "，规格：" + StrUtil.emptyToDefault(surplusEntity.getMaterialSpec(), "无") + "，品牌：" + StrUtil.emptyToDefault(surplusEntity.getBrandName(), "无") + "]，库存余量：" + ComputeUtil.scaleTwo(ComputeUtil.safeSub(surplusEntity.getSurplusNum(), resultMap.get(key))) + "，库存不足!");
            }else {
                surplusEntity.setIdleNum(resultMap.get(key));
                updateList.add(surplusEntity);
            }
        }

        boolean b = saveOrUpdateBatch(flowEntities);
        //入库成功后更新库存
        if (b && CollectionUtils.isNotEmpty(updateList)) {
            surplusService.saveOrUpdateBatch(updateList);
        }
        return CommonResponse.success("推送盘活闲置流水成功！");
    }

    @Override
    public CommonResponse<String> inOutStoreRollback(Long sourceId) {
        //先查询数据库的数据并删除
        QueryWrapper<IdleFlowEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("source_id", sourceId);
        List<IdleFlowEntity> dblist = list(queryWrapper);
        if(remove(queryWrapper)){
            //查询剩余流水重新算汇总闲置量
            QueryWrapper<IdleFlowEntity > wrapper = new QueryWrapper<>();
            wrapper.and(q -> {
                for(IdleFlowEntity f : dblist) {
                    q.or(iq -> iq.eq("store_id", f.getStoreId()).eq("brand_id", f.getBrandId()).eq("material_id", f.getMaterialId()));
                }
                return q;
            });
            List<IdleFlowEntity> list = list(wrapper);
            Map<String, BigDecimal> resultMap = CollectionUtils.isNotEmpty(list) ? list.stream()
                    .collect(Collectors.groupingBy(
                            x -> x.getStoreId() + "@" + x.getMaterialId() + "@" + x.getBrandId(),
                            Collectors.reducing(BigDecimal.ZERO, IdleFlowEntity::getNum, BigDecimal::add)
                    )) : new HashMap<>();
            //查询相关的余量表
            QueryWrapper<SurplusEntity> query = new QueryWrapper<>();
            query.and(q -> {
                for(IdleFlowEntity f : dblist) {
                    q.or(iq -> iq.eq("store_id", f.getStoreId()).eq("brand_id", f.getBrandId()).eq("material_id", f.getMaterialId()));
                }
                return q;
            });
            List<SurplusEntity> surplusEntities = surplusService.list(query);
            List<SurplusEntity> updateList = new ArrayList<>();
            for(SurplusEntity surplusEntity : surplusEntities){
                String key = surplusEntity.getStoreId() + "@" + surplusEntity.getMaterialId() + "@" + surplusEntity.getBrandId();
                surplusEntity.setIdleNum(resultMap.containsKey(key) ? resultMap.get(key) : BigDecimal.ZERO);
                updateList.add(surplusEntity);
            }

            if (CollectionUtils.isNotEmpty(updateList)) {
                surplusService.saveOrUpdateBatch(updateList);
            }
        }

        return CommonResponse.success("删除盘活闲置流水成功！");
    }
}
