package com.ejianc.business.zdssupplier.common.consumer;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdssupplier.material.vo.SupplierSyncParam;
import com.ejianc.business.zdssupplier.utils.enterprise.dispatch.SupplierSyncFactory;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.mq.consumer.BaseConsumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * @author CJ
 * @Description:
 * @date 2024/4/24 11:31
 */
@Component
public class MatSupplierListener extends BaseConsumer {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${spring.cloud.config.profile}")
    private String profile;

    @Override
    protected void doConsumeMsg(MqMessage mqMessage) {
        logger.info("接收到待同步ERP物资供应商信息信息：{}", mqMessage.getBody());
        try {
            SupplierSyncParam param = JSONObject.parseObject(mqMessage.getBody().toString(), SupplierSyncParam.class);
            if(StringUtils.isBlank(param.getHandleServiceName())) {
                logger.error("供应商id-{},syncType-{}同步失败，处理服务名称为空！", param.getSupplierId(), param.getSyncType());
                return;
            }

            SupplierSyncFactory.getInstance(param.getHandleServiceName()).supplierSync(param);
        } catch (Exception e) {
            logger.error("供应商同步ERP异常: ", e);
        }
    }

    @Override
    protected String[] getQueueNames() {
        return new String[]{SupplierSyncParam.SUPPLIER_SYNC_ERP_QUEUE+"_"+profile};
    }
}
