package com.ejianc.business.zdssupplier.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.material.api.IZDSMatSupManagerApi;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierChangeEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierEntity;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierChangeMaterialInfoService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierChangeService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierService;
import com.ejianc.business.zdssupplier.material.service.impl.MatSupplierChangeBpmServiceImpl;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierChangeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import jdk.nashorn.internal.ir.annotations.Ignore;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 物资供应商变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("matSupplierChange")
public class MatSupplierChangeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZDS_MAT_SUPPLIER_CHANGE";//此处需要根据实际修改

    @Autowired
    private IMatSupplierChangeService service;

    @Autowired
    private IZDSMatSupManagerApi izdsMatSupManagerApi;

    @Autowired
    private IMatSupplierChangeMaterialInfoService changeMaterialInfoService;

    @Autowired
    private IMatSupplierService supplierService;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MatSupplierChangeVO> saveOrUpdate(@RequestBody MatSupplierChangeVO saveOrUpdateVO) {
        MatSupplierChangeVO vo = service.saveOrUpdate(saveOrUpdateVO);

        MatSupplierEntity supplier = supplierService.selectById(vo.getSupplierId());
        vo.setCorpSid(supplier.getCorpSid());
        vo.setCorpErpName(supplier.getCorpErpName());
        vo.setErpType(supplier.getErpType());

    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MatSupplierChangeVO> queryDetail(Long id) {
    	MatSupplierChangeEntity entity = service.selectById(id);
    	MatSupplierChangeVO vo = BeanMapper.map(entity, MatSupplierChangeVO.class);

        MatSupplierEntity supplier = supplierService.selectById(entity.getSupplierId());
        vo.setCorpSid(supplier.getCorpSid());
        vo.setCorpErpName(supplier.getCorpErpName());
        vo.setErpType(supplier.getErpType());

        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MatSupplierChangeVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (MatSupplierChangeVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(MatSupplierChangeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MatSupplierChangeVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("socialCreditCode");
        fuzzyFields.add("legalPerson");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("sourceType", new Parameter(QueryParam.EQ, PlanConstant.SOURCE_TYPE_EL));// 自制
        param.getParams().put("createUserCode", new Parameter("eq", InvocationInfoProxy.getUsercode()));
        IPage<MatSupplierChangeEntity> page = service.queryPage(param,false);
        IPage<MatSupplierChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MatSupplierChangeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryListBySupplier 查询供方列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryListBySupplier", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MatSupplierChangeVO>> queryListBySupplier(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("socialCreditCode");
        fuzzyFields.add("legalPerson");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("sourceType", new Parameter(QueryParam.EQ, PlanConstant.SOURCE_TYPE_SUPPLIER));// 供方发起
        // TODO 负责人过滤
        //查询当前登录人负责的物料分类
        CommonResponse<List<Long>> categoryIdsResp = izdsMatSupManagerApi.getCategoryIdsByUseId(InvocationInfoProxy.getUserid());
        if(!categoryIdsResp.isSuccess()) {
            logger.error("获取人员-{}审核物资分类列表失败, {}",InvocationInfoProxy.getUserid(), JSONObject.toJSONString(categoryIdsResp, SerializerFeature.PrettyFormat));
            return CommonResponse.error("获取物资分类审核人信息失败！");
        }
        List<Long> categoryIds = categoryIdsResp.getData();
        if(CollectionUtils.isEmpty(categoryIds)) {
            IPage<MatSupplierChangeVO> pageData = new Page<>(param.getPageIndex(), param.getPageSize(), 0);
            return CommonResponse.success("查询列表数据成功！", pageData);
        }

        //查询供货内容中分类归属于设置审核分类的供应商
        List<Long> changeIds = changeMaterialInfoService.getAllSupIdsByCategoryIds(categoryIds);
        if(CollectionUtils.isEmpty(changeIds)) {
            IPage<MatSupplierChangeVO> pageData = new Page<>(param.getPageIndex(), param.getPageSize(), 0);
            return CommonResponse.success("查询列表数据成功！", pageData);
        }

        param.getParams().put("id", new Parameter(QueryParam.IN, changeIds));

        IPage<MatSupplierChangeEntity> page = service.queryPage(param,false);
        IPage<MatSupplierChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MatSupplierChangeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MatSupplierChangeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MatSupplierChange-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refMatSupplierChangeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MatSupplierChangeVO>> refMatSupplierChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MatSupplierChangeEntity> page = service.queryPage(param,false);
        IPage<MatSupplierChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MatSupplierChangeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 根据主键ID查询原始单据详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/saveChangeBySupplierId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MatSupplierChangeVO> saveChangeBySupplierId(@RequestParam Long id) {
        MatSupplierChangeVO vo = service.saveChangeBySupplierId(id);
        return CommonResponse.success(vo);
    }

    /**
     * 供应商名称调用天眼查
     * @param supplierName
     * @param id
     * @return
     */
    @RequestMapping(value = "/TYCDetail", method = RequestMethod.GET)
    @ResponseBody
    @Ignore
    public CommonResponse<MatSupplierChangeVO> TYCDetail(@RequestParam("supplierName") String supplierName,
            @RequestParam("supplierId") Long supplierId, @RequestParam(value = "id", required = false) Long id) {
        MatSupplierChangeVO vo = service.TYCDetail(supplierName, supplierId, id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 保存同步单据
     * @param request
     * @return
     */
    @RequestMapping(value = "/saveSyncBill", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Long> saveSyncBill(HttpServletRequest request) {
        return CommonResponse.success("接收成功！", service.saveSyncBill(request));
    }

    /**
     * 更新单据状态
     *
     * @param vo
     * @return
     */
    @PostMapping(value = "/updateBillStatus")
    @ResponseBody
    public CommonResponse<String> updateBillStatus(@RequestBody MatSupplierChangeVO vo) {
        String msg = service.updateBillStatus(vo);
        if(StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("操作成功！");
    }

    /**
     * 查询对比数据
     * @param changeId
     * @return
     */
    @RequestMapping(value = "/contrast", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> contrast(Long changeId) {
        JSONObject contrast = service.contrast(changeId);
        return CommonResponse.success("新增转换数据成功！",contrast);
    }

    @Autowired
    private MatSupplierChangeBpmServiceImpl bpmService;

    /**
     * 审批后事件
     * @param id
     * @return
     */
    @RequestMapping(value = "/test", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String > test(@RequestParam Long id) {
        CommonResponse<String> response = bpmService.afterApprovalProcessor(id, null, null);
        MatSupplierChangeEntity entity = service.selectById(id);
        entity.setBillState(1);
        service.updateById(entity);
        return response;
    }
}
