package com.ejianc.business.zdssupplier.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdssupplier.common.utils.CoordinationUtil;
import com.ejianc.business.zdssupplier.common.utils.PushSupUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.cons.enums.SupLinkerEnum;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerChangeEntity;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierEntity;
import com.ejianc.business.zdssupplier.material.mapper.MatLinkerMapper;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierService;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerVO;
import com.ejianc.business.zdssupplier.sub.bean.LinkerEntity;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 物资联系人档案
 *
 * @author generator
 */
@Service("matLinkerService")
public class MatLinkerServiceImpl extends BaseServiceImpl<MatLinkerMapper, MatLinkerEntity> implements IMatLinkerService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String CHANGE_BILL_TYPE = "EJCBT202403000022";//此处需要根据实际修改
    private static final String SOURCE_TYPE_ONE = "legalPersonFile";//此处需要根据实际修改
    private static final String SOURCE_TYPE_TWO = "agentFile";//此处需要根据实际修改
    private static final String LINKER_BILL_TYPE = "EJCBT202403000021";//此处需要根据实际修改
    private static final String BILL_CODE = "ZDS_MAT_LINKER";//此处需要根据实际修改
    @Value("${file.openDownUrl}")
    private String openDownUrl;// 项目方下载附件地址
    @Autowired
    private CoordinationUtil coordinationUtil;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IMatSupplierService supplierService;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private MatLinkerMapper mapper;

    @Autowired
    private PushSupUtil pushSupUtil;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Override
    public MatLinkerVO saveOrUpdate(MatLinkerVO saveOrUpdateVO) {
        return saveOrUpdate(saveOrUpdateVO, "true", true);
    }

    @Override
    public MatLinkerVO saveOrUpdate(MatLinkerVO saveOrUpdateVO, String checkFlag, boolean cooFlag) {
        MatLinkerEntity entity = BeanMapper.map(saveOrUpdateVO, MatLinkerEntity.class);

        MatSupplierEntity supplier = supplierService.selectById(entity.getSupplierId());
        // 联系人校验
        supplier.getLinkerList().add(entity);
        if(!"false".equals(checkFlag)) {
            this.validateUnique(supplier.getLinkerList());
        }

        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
//        MatSupplierEntity supplier = supplierService.selectById(entity.getSupplierId());
        if(cooFlag) {
            if (!PlanConstant.STRING_YES.equals(supplier.getCoordination())) {
                // 供应商未生成协同租户，则先创建协同租户
                supplierService.createSupTenant(supplier);
            }
            if (!PlanConstant.STRING_YES.equals(entity.getCoordination())) {
                // 联系人未生成协同账号，则先创建协同账号
                this.createSupAccount(entity, supplier.getTenant());
            }
        }

        return BeanMapper.map(entity, MatLinkerVO.class);
    }

    @Override
    public List<MatLinkerVO> getBySourceIds(List<String> sourceIds) {
        List<MatLinkerVO> resp = new ArrayList<>();
        QueryWrapper<MatLinkerEntity> query = new QueryWrapper<>();
        query.in("third_source_id", sourceIds);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("date_type", BaseVO.DR_UNDELETE);

        List<MatLinkerEntity> list = super.list(query);
        if (CollectionUtils.isNotEmpty(list)) {
            resp = BeanMapper.mapList(list, MatLinkerVO.class);
        }
        return resp;
    }

    @Override
    public CommonResponse<MatLinkerVO> queryDetailBill(HttpServletRequest request) {
        String transData = request.getParameter("transData");
        JSONObject jsonObject = JSONObject.parseObject(transData, JSONObject.class);
        String supUserId = jsonObject.getString("supUserId");
        Long supTenant =jsonObject.getLong("supTenant");
        QueryWrapper<MatLinkerEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("sup_user_id", supUserId);
        queryWrapper.eq("date_type", 0);
        if(null != supTenant) {
            queryWrapper.eq("tenant", supTenant);
        }
        if (jsonObject.containsKey("changeVersion")) {
            Integer changeVersion = jsonObject.getInteger("changeVersion");
            if (changeVersion > 1) {
                queryWrapper.eq("change_version", changeVersion - 1);
                List<MatLinkerEntity> list = super.list(queryWrapper);
                if (list.size() == 0) {
                    return CommonResponse.error("未查询到单据！");
                }
                MatLinkerEntity supplierEntity = list.get(0);
                MatLinkerVO vo = BeanMapper.map(supplierEntity, MatLinkerVO.class);
                return CommonResponse.success("查询详情数据成功！", vo);
            }
        }
        List<MatLinkerEntity> list = super.list(queryWrapper);
        if (list.size() == 0) {
            return CommonResponse.error("未查询到单据！");
        }
        MatLinkerEntity supplierEntity = list.get(0);
        MatLinkerVO vo = BeanMapper.map(supplierEntity, MatLinkerVO.class);
        List<Long> fileIds = new ArrayList<>();
        if(vo.getUserType()==1) {
            if(StringUtils.isNotBlank(vo.getLegalPersonFileId())) {
                fileIds.add(Long.valueOf(vo.getLegalPersonFileId()));
            }
        } else {
            if(StringUtils.isNotBlank(vo.getAgencyFileId())) {
                fileIds.add(Long.valueOf(vo.getAgencyFileId()));
            }
            if(StringUtils.isNotBlank(vo.getCertifyFileId())) {
                fileIds.add(Long.valueOf(vo.getCertifyFileId()));
            }
        }
        if (CollectionUtils.isNotEmpty(fileIds)) {
            CommonResponse<List<AttachmentVO>> attachmentVOCommonResponse = attachmentApi.queryAllByIds(fileIds);
            if (!attachmentVOCommonResponse.isSuccess()){
                throw new BusinessException("网络异常， 附件查询失败， 请稍后再试");
            }
            if (attachmentVOCommonResponse.getData()==null){
                throw new BusinessException("网络异常， 附件查询为空， 请稍后再试");
            }
            List<AttachmentVO> attachmentVos =  attachmentVOCommonResponse.getData();
            List<String> filePathList = new ArrayList<>();
            List<Long> newFileIds = new ArrayList<>();
            for(AttachmentVO attachmentVo : attachmentVos) {
                filePathList.add(openDownUrl+attachmentVo.getFilePath());
                newFileIds.add(attachmentVo.getId());
            }
            vo.setFilePathList(filePathList);
            vo.setNewFileIds(newFileIds);
        }

//        String fileId = vo.getUserType() == 1 ? vo.getLegalPersonFileId() : vo.getAgencyFileId();
//        if (StringUtils.isNotBlank(fileId)) {
//            CommonResponse<AttachmentVO> attachmentVOCommonResponse = attachmentApi.queryDetail(fileId);
//            if (!attachmentVOCommonResponse.isSuccess()) {
//                throw new BusinessException("网络异常， 附件查询失败， 请稍后再试");
//            }
//            if (attachmentVOCommonResponse.getData() == null) {
//                throw new BusinessException("网络异常， 附件查询为空， 请稍后再试");
//            }
//            AttachmentVO attachmentVo = attachmentVOCommonResponse.getData();
//            List<String> filePathList = new ArrayList<>();
//            List<Long> newFileIds = new ArrayList<>();
//            filePathList.add(openDownUrl + attachmentVo.getFilePath());
//            newFileIds.add(Long.valueOf(fileId));
//            vo.setFilePathList(filePathList);
//            vo.setNewFileIds(newFileIds);
//        }
        CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryNoAuthListBySourceId(vo.getId(), null, null, null);
        if (fileResp.isSuccess()) {
            vo.setFileList(fileResp.getData());
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    @Override
    public MatLinkerVO createSupAccount(MatLinkerEntity linker, Long supTenantId) {
        if (StringUtils.isBlank(linker.getMobileLinkPhone())) {
            throw new BusinessException("联系人电话为空");
        }
        Map<String, String> reqParam = new HashMap<>();
        reqParam.put("linkMobile", linker.getMobileLinkPhone());
        reqParam.put("linkName", linker.getName());
        reqParam.put("linkSupType", PlanConstant.MAT_SUPPLIER);
        reqParam.put("supplierAccRole", PlanConstant.物资联系人);
        reqParam.put("supplierTenantId", supTenantId.toString());
        reqParam.put("accRoleCheck", Boolean.TRUE.toString());
        reqParam.put("supplierId", linker.getSupplierId().toString());
        reqParam.put("billId", linker.getId().toString());

        // 联系人生成协同账号
        JSONObject resp = coordinationUtil.createSupAccount(reqParam);

        // 发送邮件和短信
        JSONObject entity = new JSONObject();
        entity.put("linkPhone", linker.getMobileLinkPhone());
        entity.put("linkerName", linker.getName());
        entity.put("linkEmail", linker.getElectronicMail());
        entity.put("supplierName", linker.getSupplierName());
        coordinationUtil.sendApproveSms(entity);
        coordinationUtil.sendApproveEmail(entity);

        linker.setEnableStatus(PlanConstant.INTEGER_YES);
        linker.setCoordination(PlanConstant.STRING_YES);
        linker.setTenant(resp.getLong("tenantId"));
        linker.setSupUserId(resp.getLong("userId"));
        super.saveOrUpdate(linker, false);
        return BeanMapper.map(linker, MatLinkerVO.class);
    }

    @Override
    public MatLinkerVO getBySupUserId(Long linkerSupUserId, Long supplierId) {
        MatLinkerVO resp = null;

        QueryWrapper<MatLinkerEntity> query = new QueryWrapper<>();
        query.eq("sup_user_id", linkerSupUserId);
        query.eq("supplier_id", supplierId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("date_type", BaseVO.DR_UNDELETE);
        MatLinkerEntity e = super.getOne(query);

        if (null != e) {
            resp = BeanMapper.map(e, MatLinkerVO.class);
        }

        return resp;
    }

    @Override
    public boolean linkerChangeStatus(Long linkerId, Long changeId) {
        MatLinkerEntity linker = super.selectById(linkerId);
        if (null != linker.getChangeStatus() && linker.getChangeStatus().equals(SupLinkerEnum.变更中.getCode())) {
            return true;
        }
        linker.setChangeId(changeId);
        linker.setChangeStatus(Integer.valueOf(SupLinkerEnum.变更中.getCode()));
        super.saveOrUpdate(linker, false);
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void upLinkerChangeStatus(Long linkerId, Integer changeStatus, MatLinkerChangeEntity entity) {
        logger.info("修改联系人：linkerId{}，changeStatus{}，MatLinkerChangeEntity{}",linkerId,changeStatus,JSONObject.toJSONString(entity));
        MatLinkerEntity linkerEntity = super.selectById(linkerId);
        Integer userType = linkerEntity.getUserType();
        linkerEntity.setChangeStatus(changeStatus);
        MatLinkerEntity oldEntity= null;
        if (null != entity) {
            oldEntity = BeanMapper.map(linkerEntity, MatLinkerEntity.class);
            oldEntity.setId(null);
            oldEntity.setDateType(1);
            oldEntity.setMainLinkerId(linkerId);
            oldEntity.setVersion(null);
            oldEntity.setCreateTime(null);
            oldEntity.setChangeVersion(entity.getChangeVersion());
            oldEntity.setAccessId(null);
            oldEntity.setSupplierId(null);
            oldEntity.setDateType(1); //纪录

            //查询当前供应商下是否存在 法人的单据
            if ("1".equals(entity.getUserType())) {
                QueryWrapper<MatLinkerEntity> query = new QueryWrapper<>();
                query.eq("user_type", 0);
                query.ne("id", linkerId);
                query.eq("supplier_id", linkerEntity.getSupplierId());
                query.eq("date_type", PlanConstant.INTEGER_NO);

                int count = super.count(query);
                if (count > 0) {
                    throw new BusinessException("该供应商下已存在法定代表人，无法变更！");
                }
            }
            if (!entity.getMobileLinkPhone().equals(linkerEntity.getMobileLinkPhone())) {
                QueryWrapper<MatLinkerEntity> queryWrapper = new QueryWrapper<>();
                queryWrapper.eq("mobile_link_phone", entity.getMobileLinkPhone());
                queryWrapper.eq("enable_status", 1);
                queryWrapper.eq("date_type", PlanConstant.INTEGER_NO);
                queryWrapper.ne("id", linkerId);
                List<MatLinkerEntity> list = super.list(queryWrapper);
                if (CollectionUtils.isNotEmpty(list)) {
                    MatLinkerEntity matLinkerEntity = list.get(0);
                    if (!entity.getIdCardId().equals(matLinkerEntity.getIdCardId())) {
                        throw new BusinessException("该手机号已被使用，无法变更！");
                    }
                }
            }

            linkerEntity.setMobileLinkPhone(entity.getMobileLinkPhone());
            linkerEntity.setElectronicMail(entity.getElectronicMail());
            linkerEntity.setAddress(entity.getAddress());
            boolean fileChange = false;
            if (String.valueOf(linkerEntity.getUserType()).equals(String.valueOf(entity.getUserType()))){
                if (userType == 1) {
                    if (StringUtils.isNotBlank(entity.getLegalPersonFileId()) && StringUtils.isNotBlank(linkerEntity.getLegalPersonFileId())
                            && !StringUtils.equals(entity.getLegalPersonFileId(), linkerEntity.getLegalPersonFileId())) {
                        fileChange = true;
                    }
                } else {
                    if (StringUtils.isNotBlank(entity.getAgencyFileId()) && StringUtils.isNotBlank(linkerEntity.getAgencyFileId()) &&
                            !StringUtils.equals(entity.getAgencyFileId(), linkerEntity.getAgencyFileId())) {
                        fileChange = true;
                    }
                }
            } else {
                fileChange = true;
            }

            if (fileChange) {
                List<Long> delFileIds = new ArrayList<>();
                if(Integer.valueOf(1).equals(entity.getUserType())) {
                    //删除掉变更的资质源文件
                    if(StringUtils.isNotBlank(linkerEntity.getLegalPersonFileId())) {
                        delFileIds.add(Long.valueOf(linkerEntity.getLegalPersonFileId()));
                    }
                    if (!String.valueOf(linkerEntity.getUserType()).equals(String.valueOf(entity.getUserType()))){
                        if(StringUtils.isNotBlank(linkerEntity.getAgencyFileId())) {
                            delFileIds.add(Long.valueOf(linkerEntity.getAgencyFileId()));
                        }
                        if(StringUtils.isNotBlank(linkerEntity.getCertifyFileId())) {
                            delFileIds.add(Long.valueOf(linkerEntity.getCertifyFileId()));
                        }
                    }
                    if(StringUtils.isNotBlank(entity.getLegalPersonFileId())) {
                        Long fileId = pushSupUtil.uploadFileFormNet(BillTypeEnum.物资联系人档案.getCode(), linkerEntity.getId(),
                                PlanConstant.LEGAL_PERSON_SOURCE_TYPE, Long.valueOf(entity.getLegalPersonFileId()), baseHost);
                        linkerEntity.setLegalPersonFileId(fileId.toString());
                    }
                    linkerEntity.setLegalPersonFileName(linkerEntity.getLegalPersonFileName());
                } else {
                    if(StringUtils.isNotBlank(entity.getAgencyFileId())) {
                        if(StringUtils.isNotBlank(linkerEntity.getAgencyFileId())) {
                            delFileIds.add(Long.valueOf(linkerEntity.getAgencyFileId()));
                        }
                        Long fileId = pushSupUtil.uploadFileFormNet(BillTypeEnum.物资联系人档案.getCode(), linkerEntity.getId(),
                                PlanConstant.AGENT_SOURCE_TYPE, Long.valueOf(entity.getAgencyFileId()), baseHost);
                        linkerEntity.setAgencyFileId(fileId.toString());
                        linkerEntity.setAgencyFileName(linkerEntity.getAgencyFileName());
                    }
                    if(StringUtils.isNotBlank(entity.getCertifyFileId())) {
                        if(StringUtils.isNotBlank(linkerEntity.getCertifyFileId())) {
                            delFileIds.add(Long.valueOf(linkerEntity.getCertifyFileId()));
                        }
                        Long fileId = pushSupUtil.uploadFileFormNet(BillTypeEnum.物资联系人档案.getCode(), linkerEntity.getId(),
                                PlanConstant.CERTIFY_SOURCE_TYPE, Long.valueOf(entity.getCertifyFileId()), baseHost);
                        linkerEntity.setCertifyFileId(fileId.toString());
                        linkerEntity.setCertifyFileName(linkerEntity.getAgencyFileName());
                    }
                    if (!String.valueOf(linkerEntity.getUserType()).equals(String.valueOf(entity.getUserType()))){
                        if(StringUtils.isNotBlank(linkerEntity.getLegalPersonFileId())) {
                            delFileIds.add(Long.valueOf(linkerEntity.getLegalPersonFileId()));
                        }
                    }
                }

                if(CollectionUtils.isNotEmpty(delFileIds)) {
                    //联系人文件改为记录的文件
                    oldEntity.setAttachIds(delFileIds);
                }
            }
            linkerEntity.setUserType(entity.getUserType());
            if(StringUtils.isNotBlank(entity.getUserName())) {
                linkerEntity.setName(entity.getUserName());
                linkerEntity.setUserName(entity.getUserName());
            }
            if(null != entity.getLinkerStatus()) {
                linkerEntity.setLinkerStatus(entity.getLinkerStatus());
            }
        }

        if(null != oldEntity) {
            logger.info("联系人记录:{}", JSONObject.toJSONString(oldEntity, SerializerFeature.PrettyFormat));
            super.saveOrUpdate(oldEntity);
        }
        logger.info("变更后联系人档案：{}", JSONObject.toJSONString(linkerEntity, SerializerFeature.PrettyFormat));
        super.saveOrUpdate(linkerEntity, false);
    }


    @Override
    public void deleteChange(List<Long> linkerId) {
        UpdateWrapper<MatLinkerEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.in("id", linkerId);
        updateWrapper.set("change_status", SupLinkerEnum.未变更.getCode());
        updateWrapper.set("change_id", null);
        super.update(updateWrapper);
    }

    @Override
    public Boolean validateUnique(MatLinkerEntity linker, Long id) {
        // 同一供应商下联系人不能重复
        QueryParam param = new QueryParam();
        param.getParams().put("mobileLinkPhone", new Parameter(QueryParam.EQ, linker.getMobileLinkPhone()));
//        if(null != linker.getSupplierId()) {
//            param.getParams().put("supplierId", new Parameter(QueryParam.EQ, linker.getSupplierId()));
//        } else if(null != linker.getAccessId()) {
//            param.getParams().put("accessId", new Parameter(QueryParam.EQ, linker.getAccessId()));
//        }
        param.getParams().put("enableStatus", new Parameter(QueryParam.EQ, PlanConstant.INTEGER_YES));
        param.getParams().put("dateType", new Parameter(QueryParam.EQ, PlanConstant.INTEGER_NO));
        if(id != null){
            param.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        List<MatLinkerEntity> linkerList = super.queryList(param);
        if(CollectionUtils.isNotEmpty(linkerList)){
            logger.error("该联系人的手机号{}已生成档案【{}】，不允许重复生成！", linker.getMobileLinkPhone(), linkerList.get(0).getId());
            throw new BusinessException("联系人[名称："+linker.getName()+"，手机号："+linker.getMobileLinkPhone()+"]已生成档案，不允许重复生成！");
        }
        return true;
    }

    @Override
    public Boolean validateUnique(List<MatLinkerEntity> linkerList) {
        linkerList = linkerList.stream().filter(x->!"del".equals(x.getRowState())).collect(Collectors.toList());
        Integer legalNum = (int) linkerList.stream().filter(x->PlanConstant.INTEGER_YES.equals(x.getUserType())).count();
        if(legalNum > 1){
            throw new BusinessException("联系人类型为法定代表人最多只能有一条！");
        }
        for(MatLinkerEntity linker : linkerList){
            // 校验手机号唯一性
            this.validateUnique(linker, linker.getId());
        }
        return true;
    }

    @Override
    public List<MatLinkerEntity> getAllBySupplierIds(List<Long> supplierIds, Integer enableStatus) {
        QueryWrapper<MatLinkerEntity> query  = new QueryWrapper<>();
        query.eq("date_type", 0);
        query.eq("dr", BaseVO.DR_UNDELETE);
        if(null != enableStatus) {
            query.eq("enable_status", enableStatus);
        }
        query.in("supplier_id", supplierIds);

        return super.list(query);
    }

    @Override
    public List<Map<String, Object>> getLinkerCreatorInf(List<Long> linkerIds) {
        return mapper.getLinkerCreatorInf(linkerIds);
    }

    @Override
    public void validateUnique(String name, String mobileLinkPhone) {
        // 同一供应商下联系人不能重复
        QueryParam param = new QueryParam();
        param.getParams().put("mobileLinkPhone", new Parameter(QueryParam.EQ, mobileLinkPhone));
        param.getParams().put("enableStatus", new Parameter(QueryParam.EQ, PlanConstant.INTEGER_YES));
        param.getParams().put("dateType", new Parameter(QueryParam.EQ, PlanConstant.INTEGER_NO));
        List<MatLinkerEntity> linkerList = super.queryList(param);
        if(CollectionUtils.isNotEmpty(linkerList)){
            logger.error("该联系人的手机号{}已生成档案【{}】，不允许重复生成！", mobileLinkPhone, linkerList.get(0).getId());
            throw new BusinessException("联系人[名称："+name+"，手机号："+mobileLinkPhone+"]已生成档案，不允许重复生成！");
        }
    }

    @Override
    public void createSupAccount(Long linkerId) {
        MatLinkerEntity linker = super.selectById(linkerId);
        MatSupplierEntity supplier = supplierService.selectById(linker.getSupplierId());

        if(!PlanConstant.STRING_YES.equals(supplier.getCoordination())) {
            supplierService.createSupTenant(supplier);
        }

        if(!PlanConstant.STRING_YES.equals(linker.getCoordination())) {
            if (StringUtils.isBlank(linker.getMobileLinkPhone())) {
                throw new BusinessException("联系人电话为空");
            }
            Map<String, String> reqParam = new HashMap<>();
            reqParam.put("linkMobile", linker.getMobileLinkPhone());
            reqParam.put("linkName", linker.getName());
            reqParam.put("linkSupType", PlanConstant.MAT_SUPPLIER);
            reqParam.put("supplierAccRole", PlanConstant.物资联系人);
            reqParam.put("supplierTenantId", supplier.getTenant().toString());
            reqParam.put("accRoleCheck", Boolean.TRUE.toString());
            reqParam.put("supplierId", linker.getSupplierId().toString());
            reqParam.put("billId", linker.getId().toString());

            // 联系人生成协同账号
            JSONObject resp = coordinationUtil.createSupAccount(reqParam);

            // 发送邮件和短信
            JSONObject entity = new JSONObject();
            entity.put("linkPhone", linker.getMobileLinkPhone());
            entity.put("linkerName", linker.getName());
            entity.put("linkEmail", linker.getElectronicMail());
            entity.put("supplierName", linker.getSupplierName());
            coordinationUtil.sendApproveSms(entity);
            coordinationUtil.sendApproveEmail(entity);

            linker.setEnableStatus(PlanConstant.INTEGER_YES);
            linker.setCoordination(PlanConstant.STRING_YES);
            linker.setTenant(resp.getLong("tenantId"));
            linker.setSupUserId(resp.getLong("userId"));
            super.saveOrUpdate(linker, false);
        }
    }
}
