package com.ejianc.business.zdssupplier.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zdssupplier.material.mapper.MatSupplierAccessMaterialInfoMapper;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierAccessMaterialInfoEntity;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierAccessMaterialInfoService;

import java.util.List;

/**
 * 物资供应商准入-供货信息
 * 
 * @author generator
 * 
 */
@Service("matSupplierAccessMaterialInfoService")
public class MatSupplierAccessMaterialInfoServiceImpl extends BaseServiceImpl<MatSupplierAccessMaterialInfoMapper, MatSupplierAccessMaterialInfoEntity> implements IMatSupplierAccessMaterialInfoService{

    @Override
    public List<MatSupplierAccessMaterialInfoEntity> getAllByAccessId(Long accessId) {
        QueryWrapper<MatSupplierAccessMaterialInfoEntity> query = new QueryWrapper<>();
        query.eq("access_id", accessId);
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.list(query);
    }
}
