package com.ejianc.business.zdssupplier.sub.controller;

import java.io.Serializable;

import com.ejianc.business.zdssupplier.common.utils.InviteCodeGenerator;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.sub.bean.SupplierAccessEntity;
import com.ejianc.business.zdssupplier.sub.service.ISupplierAccessService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.zdssupplier.sub.bean.SupplierInviteEntity;
import com.ejianc.business.zdssupplier.sub.service.ISupplierInviteService;
import com.ejianc.business.zdssupplier.sub.vo.SupplierInviteVO;

/**
 * 分包供应商邀请链接
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("supplierInvite")
public class SupplierInviteController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZDS_SUB_SUPPLIER_INVITE";//此处需要根据实际修改

    @Autowired
    private ISupplierInviteService service;

    @Autowired
    private ISupplierAccessService accessService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SupplierInviteVO> saveOrUpdate(@RequestBody SupplierInviteVO saveOrUpdateVO) {
    	SupplierInviteVO vo = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SupplierInviteVO> queryDetail(Long id) {
    	SupplierInviteEntity entity = service.selectById(id);
    	SupplierInviteVO vo = BeanMapper.map(entity, SupplierInviteVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SupplierInviteVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SupplierInviteVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SupplierInviteVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SupplierInviteVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("inviterName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 根据邀请人过滤
        param.getParams().put("inviterId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        if(!param.getParams().containsKey("status")){
            param.getParams().put("status", new Parameter(QueryParam.NE, PlanConstant.INVITE_STATUS_APPROVE));
        }

//        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
//        UserContext userContextCache =sessionManager.getUserContext();
//        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
//        String authOrgIds = userContextCache.getAuthOrgIds();
//        List<OrgVO> orgVOList = null;
//        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
//        }else {//pc端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
//        }
//        //普通组织 id
//        List<Long> commonOrgIds = new ArrayList<>();
//        //项目部 id
//        List<Long> departmentIds = new ArrayList<>();
//        orgVOList.stream().forEach(org -> {
//            if(5 == org.getOrgType()) {
//                //项目部
//                departmentIds.add(org.getId());
//            } else {
//                //普通组织
//                commonOrgIds.add(org.getId());
//            }
//        });
//        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
//        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
//            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
//        }
//        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<SupplierInviteEntity> page = service.queryPage(param,false);
        IPage<SupplierInviteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<SupplierInviteVO> records = BeanMapper.mapList(page.getRecords(), SupplierInviteVO.class);
        if(CollectionUtils.isNotEmpty(records)){
            List<Long> ids = records.stream().map(SupplierInviteVO::getId).collect(Collectors.toList());
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("inviteId", new Parameter(QueryParam.IN, ids));
            List<SupplierAccessEntity> list = accessService.queryList(queryParam);
            Map<Long, SupplierAccessEntity> map = list.stream().collect(Collectors.toMap(x->x.getInviteId(), x->x, (v1, v2)->v2));
            for(SupplierInviteVO vo : records){
                if(map.containsKey(vo.getId())){
                    SupplierAccessEntity access = map.get(vo.getId());
                    vo.setSocialCreditCode(access.getSocialCreditCode());
                    vo.setLegalPerson(access.getLegalPerson());
                    vo.setAccessId(access.getId());
                }
            }
        }
  		pageData.setRecords(records);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryApproveList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SupplierInviteVO>> queryApproveList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("inviterName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 根据邀请人过滤
        param.getParams().put("inviterId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        param.getParams().put("status", new Parameter(QueryParam.EQ, PlanConstant.INVITE_STATUS_APPROVE));
        IPage<SupplierInviteEntity> page = service.queryPage(param,false);
        IPage<SupplierInviteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<SupplierInviteVO> records = BeanMapper.mapList(page.getRecords(), SupplierInviteVO.class);
        if(CollectionUtils.isNotEmpty(records)){
            List<Long> ids = records.stream().map(SupplierInviteVO::getId).collect(Collectors.toList());
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("inviteId", new Parameter(QueryParam.IN, ids));
            List<SupplierAccessEntity> list = accessService.queryList(queryParam);
            Map<Long, SupplierAccessEntity> map = list.stream().collect(Collectors.toMap(x->x.getInviteId(), x->x, (v1, v2)->v2));
            for(SupplierInviteVO vo : records){
                if(map.containsKey(vo.getId())){
                    SupplierAccessEntity access = map.get(vo.getId());
                    vo.setSocialCreditCode(access.getSocialCreditCode());
                    vo.setLegalPerson(access.getLegalPerson());
                    vo.setAccessId(access.getId());
                }
            }
        }
        pageData.setRecords(records);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SupplierInviteEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SupplierInvite-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refSupplierInviteData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SupplierInviteVO>> refSupplierInviteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SupplierInviteEntity> page = service.queryPage(param,false);
        IPage<SupplierInviteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplierInviteVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 更新单据状态
     *
     * @param vo
     * @return
     */
    @PostMapping(value = "/updateBillStatus")
    @ResponseBody
    public CommonResponse<String> updateBillStatus(@RequestBody SupplierInviteVO vo) {
        String msg = service.updateBillStatus(vo);
        if(StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("操作成功！");
    }

    /**
     * 生成8位唯一标识
     *
     * @return
     */
    @GetMapping(value = "/createInviteCode")
    @ResponseBody
    public CommonResponse<String> createInviteCode(@RequestParam("code") String code) {
        StringBuffer inviteCode = new StringBuffer();
        switch (code) {
            case "ZDS_SUB_SUPPLIER_INVITE_SIGN":
                inviteCode.append("xq");
                break;
            case "ZDS_MAT_SUPPLIER_INVITE_SIGN":
                inviteCode.append("xz");
                break;
            case "ZDS_SUB_LINKER_INVITE_SIGN":
                inviteCode.append("xa");
                break;
            case "ZDS_MAT_LINKER_INVITE_SIGN":
                inviteCode.append("xc");
                break;
        }
        inviteCode.append(InviteCodeGenerator.generateInviteCode());
        return CommonResponse.success("操作成功！", inviteCode.toString());
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/test", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> test(Long id) {
        SupplierInviteEntity entity = service.selectById(id);
        return CommonResponse.success("查询详情数据成功！", service.pushBillToSupCenter(entity));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/testMsg", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> testMsg(Long id) {
        SupplierInviteEntity entity = service.selectById(id);
        service.saveOrUpdate(BeanMapper.map(entity, SupplierInviteVO.class));
        return CommonResponse.success("查询详情数据成功！", true);
    }
}
