package com.ejianc.business.zdssupplier.sub.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierEntity;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierService;
import com.ejianc.business.zdssupplier.sub.bean.SupplierEntity;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.business.zdssupplier.sub.vo.SupplierVO;
import com.ejianc.foundation.tenant.vo.TenantVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;


@RestController
@RequestMapping("/api/subSupplierApi/")
public class SubSupplierApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISupplierService supplierService;

    @Autowired
    private IMatSupplierService matSupplierService;

    /**
     * 根据供应商来源Id，获取供应商信息
     */
    @GetMapping(value = "getOneBySourceId")
    CommonResponse<SupplierVO> getOneBySourceId(@RequestParam("sourceId") String sourceId, @RequestParam(required = false) String supplierType) {
        SupplierVO resp = null;
        QueryWrapper<SupplierEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("third_source_id", sourceId);
        SupplierEntity e = supplierService.getOne(query);

        if(null != e) {
            resp = BeanMapper.map(e, SupplierVO.class);
        }

        return CommonResponse.success(resp);
    }
    @GetMapping(value = "getOneById")
    CommonResponse<SupplierVO> getOneById(@RequestParam("id") Long id) {
        SupplierVO resp = null;
        QueryWrapper<SupplierEntity> query = new QueryWrapper<>();
        query.eq("id", id);
        SupplierEntity e = supplierService.getOne(query);
        if(null != e) {
            resp = BeanMapper.map(e, SupplierVO.class);
        }
        return CommonResponse.success(resp);
    }

    @PostMapping(value = "getAllByIds")
    CommonResponse<List<SupplierVO>> getAllByIds(@RequestBody List<Long> ids) {
        List<SupplierVO> resp = new ArrayList<>();
        QueryWrapper<SupplierEntity> query = new QueryWrapper<>();
        query.in("id", ids);
        List<SupplierEntity> dbList = supplierService.list(query);

        if(CollectionUtils.isNotEmpty(dbList)) {
            resp = BeanMapper.mapList(dbList, SupplierVO.class);
        }
        return CommonResponse.success(resp);
    }

    /**
     * 根据供应商来源Id，获取供应商信息
     * @param params sourceIds-List<String>  supplierType-String
     * @return
     */
    @PostMapping(value = "getAllBySourceIds")
    CommonResponse<List<SupplierVO>> getAllBySourceIds(@RequestBody JSONObject params) {
        List<SupplierVO> resp = new ArrayList<>();
        QueryWrapper<SupplierEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.in("third_source_id", params.getJSONArray("sourceIds"));
        List<SupplierEntity> eList = supplierService.list(query);

        if(CollectionUtils.isNotEmpty(eList)) {
            resp = BeanMapper.mapList(eList, SupplierVO.class);
        }

        return CommonResponse.success(resp);
    }

    /**
     * 根据供应商编码，获取供应商信息
     */
    @GetMapping(value = "getOneByCode")
    CommonResponse<SupplierVO> getOneByCode(@RequestParam("code") String code) {
        SupplierVO resp = null;
        QueryWrapper<SupplierEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("code", code);
        SupplierEntity e = supplierService.getOne(query);

        if(null != e) {
            resp = BeanMapper.map(e, SupplierVO.class);
        }

        return CommonResponse.success(resp);
    }

    /**
     * 根据供应商编码，获取供应商信息
     * @return
     */
    @PostMapping(value = "getAllByCodes")
    CommonResponse<List<SupplierVO>> getAllByCodes(@RequestBody List<String> code) {
        List<SupplierVO> resp = new ArrayList<>();
        QueryWrapper<SupplierEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.in("code", code);
        List<SupplierEntity> eList = supplierService.list(query);

        if(CollectionUtils.isNotEmpty(eList)) {
            resp = BeanMapper.mapList(eList, SupplierVO.class);
        }

        return CommonResponse.success(resp);
    }


    /**
     * 根据租户Id获取对应供应商信息
     *
     * @param tenantId
     * @return
     */
    @GetMapping(value = "getByTenantId")
    CommonResponse<SupplierVO> getByTenantId(@RequestParam Long tenantId) {
        SupplierVO resp = null;
        QueryWrapper<SupplierEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("tenant", tenantId);
        SupplierEntity e = supplierService.getOne(query);

        if(null != e) {
            resp = BeanMapper.map(e, SupplierVO.class);
        }

        return CommonResponse.success(resp);
    }

    /**
     * 根据租户Ids获取对应供应商信息列表
     *
     * @param tenantIds
     * @return
     */
    @PostMapping(value = "getByTenantIds")
    CommonResponse<List<SupplierVO>> getByTenantIds(@RequestParam List<Long> tenantIds) {
        List<SupplierVO> resp = new ArrayList<>();
        QueryWrapper<SupplierEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.in("tenant", tenantIds);
        List<SupplierEntity> eList = supplierService.list(query);

        if(CollectionUtils.isNotEmpty(eList)) {
            resp = BeanMapper.mapList(eList, SupplierVO.class);
        }

        return CommonResponse.success(resp);
    }

    /**
     * 供应商生成协同租户
     * @param supplierVO
     * @return
     */
    @PostMapping(value = "accCoordination")
    public CommonResponse<SupplierVO> accCoordination(@RequestBody SupplierVO supplierVO) {
        // 查询供应商是否协同
        SupplierEntity supplier = supplierService.selectById(supplierVO.getId());
        if(!PlanConstant.STRING_YES.equals(supplier.getCoordination())) {
            // 供应商为生成协同租户，则先创建协同租户
            TenantVO tenant = supplierService.createSupTenant(supplier);
            if(null == tenant) {
                return CommonResponse.error("生成供应商协同信息失败！");
            }
        }
        supplier = supplierService.selectById(supplierVO.getId());
        return CommonResponse.success("查询成功", BeanMapper.map(supplier, SupplierVO.class));
    }

    @GetMapping(value = "getSystemById")
    CommonResponse<String> getSystemById(@RequestParam("id") Long id) {
        String systemId = null;
        SupplierEntity sub = supplierService.selectById(id);
        if(sub != null){
            systemId = sub.getSystemId();
        }
        MatSupplierEntity mat = matSupplierService.selectById(id);
        if(mat != null){
            systemId = mat.getSystemId();
        }
        return CommonResponse.success("查询成功！", systemId);
    }

}
