package com.ejianc.business.zdssupplier.sub.service;

import com.ejianc.business.zdssupplier.sub.bean.LinkerChangeEntity;
import com.ejianc.business.zdssupplier.sub.bean.LinkerEntity;
import com.ejianc.business.zdssupplier.sub.vo.LinkerVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * 分包联系人档案
 * 
 * @author generator
 * 
 */
public interface ILinkerService extends IBaseService<LinkerEntity> {

    LinkerVO saveOrUpdate(LinkerVO saveOrUpdateVO);

    List<LinkerVO> getBySourceIds(List<String> sourceIds);

    /**
     * 根据移动电话查询人员
     * @param mobileLinkPhone
     * @return
     */
    LinkerVO getByMobileLinkPhone(String mobileLinkPhone);

    /**
     * 供方查询详情
     * @param request
     * @return
     */
    CommonResponse<LinkerVO> queryDetailBill(HttpServletRequest request);

//    /**
//     * 分包联系人新增
//     * @param linker
//     * @return
//     */
//    LinkerVO addLinker(LinkerVO linker);

    /**
     * 联系人生成协同账号
     * @param linker
     * @param supTenantId
     * @return
     */
    LinkerVO createSupAccount(LinkerEntity linker, Long supTenantId);

    LinkerVO getBySupUserId(Long linkerSupUserId, Long supplierId);

    LinkerVO getSupUserIdAndTenant(Long supUserId, Long tenantId);



    /**
     * 查询当前联系人变更状态 并修改
     * @param linkerId 联系人id
     * @param changeId 变更单id
     */
    boolean linkerChangeStatus(Long linkerId, Long changeId);

    /**
     * 修改对应联系人状态
     * @param linkerId
     * @param changeStatus
     */
    void upLinkerChangeStatus(Long linkerId, Integer changeStatus, LinkerChangeEntity entity);

    void deleteChange(List<Long> linkerId);

    /**
     * 校验手机号唯一性
     * @param linker
     * @return
     */
    Boolean validateUnique(LinkerEntity linker, Long id);

    /**
     * 校验手机号唯一性
     * @return
     */
    Boolean validateUnique(List<LinkerEntity> linkerList);

    List<LinkerEntity> getAllBySupplierIds(List<Long> supplierIds);

    List<Map<String, Object>> getLinkerCreatorInf(List<Long> linkerIds);

    void validateUnique(String name, String mobileLinkPhone);

    public LinkerVO saveOrUpdate(LinkerVO saveOrUpdateVO, String checkFlag, boolean cooFlag);

    void generateAccount(Long linkerId);
}
