package com.ejianc.business.zdssupplier.sub.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.SupLinkerEnum;
import com.ejianc.business.zdssupplier.sub.bean.LinkerChangeEntity;
import com.ejianc.business.zdssupplier.sub.service.ILinkerChangeService;
import com.ejianc.business.zdssupplier.sub.service.ILinkerService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.business.zdssupplier.sub.vo.SupplierSyncErpParamVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Map;

@Service("linkerChange") 
public class LinkerChangeBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private ILinkerChangeService service;
	@Autowired
	private ILinkerService linkerService;
	@Autowired
	private ISupplierService supplierService;
	@Autowired
	private IUserApi userApi;
	@Autowired
	private SessionManager sessionManager;


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		LinkerChangeEntity entity = service.selectById(billId);
		JSONArray resp = supplierService.getSupplierApprList(entity.getSupplierId());
		if(resp.size() == 0) {
			return CommonResponse.error("操作失败，该分包商的发展专业或主导专业未设置审核人！");
		}

		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		LinkerChangeEntity entity = service.selectById(billId);
		entity.setReceiveStatus(SupLinkerEnum.审批中.getCode());
		service.saveOrUpdate(entity,false);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		LinkerChangeEntity entity = service.selectById(billId);
		entity.setReceiveStatus(SupLinkerEnum.审批通过.getCode());
		if (entity.getSourceType().equals("2")){
			String s = service.pushBill(entity);
			if (StringUtils.isNotBlank(s)) {
				throw new BusinessException(s);
			}
		}
		service.saveOrUpdate(entity,false);
		linkerService.upLinkerChangeStatus(entity.getLinkerId(),SupLinkerEnum.已变更.getCode(),entity);

		UserContext user = sessionManager.getUserContext();
		//推送ERP
		String msg = supplierService.syncSupplierChangeToErp(new SupplierSyncErpParamVO(entity.getSupplierId(), entity.getLinkerId(),
				PlanConstant.联系人变更同步ERP, billId, true, user.getUserId(), user.getUserName()));
		if(StringUtils.isNotBlank(msg)) {
			throw new BusinessException(msg);
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("无法撤回!");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.error("无法撤回!");
	}

	@Override
	public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other){
		LinkerChangeEntity entity = service.selectById(billId);
		JSONArray resp = supplierService.getSupplierApprList(entity.getSupplierId());
		if(resp.size() == 0) {
			return CommonResponse.error("操作失败，该分包商的发展专业或主导专业未设置审核人！");
		}
		return CommonResponse.success(resp);
	}
}
