package com.ejianc.business.zdssupplier.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdssupplier.common.utils.PushSupUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.BillPushStatusEnum;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.sub.bean.*;
import com.ejianc.business.zdssupplier.sub.service.ILinkerAccessService;
import com.ejianc.business.zdssupplier.sub.service.ILinkerInviteFlowService;
import com.ejianc.business.zdssupplier.sub.service.ILinkerService;
import com.ejianc.business.zdssupplier.sub.vo.LinkerInviteFlowVO;
import com.ejianc.business.zdssupplier.sub.vo.LinkerInviteVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zdssupplier.sub.mapper.LinkerInviteMapper;
import com.ejianc.business.zdssupplier.sub.bean.LinkerInviteEntity;
import com.ejianc.business.zdssupplier.sub.service.ILinkerInviteService;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 分包联系人邀请链接
 * 
 * @author generator
 * 
 */
@Service("linkerInviteService")
public class LinkerInviteServiceImpl extends BaseServiceImpl<LinkerInviteMapper, LinkerInviteEntity> implements ILinkerInviteService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "ZDS_SUB_LINKER_INVITE";//此处需要根据实际修改
    private static final String SYSTEM_ID = "systemId";
    private static final String BILL_TYPE = BillTypeEnum.分包联系人邀请.getCode();
    private static final String BILL_NAME = BillTypeEnum.分包联系人邀请.getName();

    private static final String PUSH_BILL_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/linkerInvite/syncBill";
    private static final String BILL_WITER_BACK_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/linkerInvite/syncBill";

    @Autowired
    private PushSupUtil pushSupUtil;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private ILinkerInviteFlowService flowService;

    @Autowired
    private ILinkerAccessService accessService;

    @Autowired
    private ILinkerService linkerService;

    @Override
    public LinkerInviteVO saveOrUpdate(LinkerInviteVO saveOrUpdateVO) {
        LinkerInviteEntity entity = BeanMapper.map(saveOrUpdateVO, LinkerInviteEntity.class);

        // 当前供应商下已存在此手机号，不允许邀请
        this.validateMobile(entity.getSupplierId(), entity.getLinkPhone(), entity.getId());

        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setInviterPhone(sessionManager.getUserContext().getUserMobile());
        }
        super.saveOrUpdate(entity, false);

        // 单据协同推送
        this.pushBillToSupCenter(entity);

        return BeanMapper.map(entity, LinkerInviteVO.class);
    }

    /**
     * 当前供应商下已存在此手机号，不允许邀请
     * @param supplierId
     * @param linkPhone
     * @param id
     * @return
     */
    private Boolean validateMobile(Long supplierId, String linkPhone, Long id) {
        QueryParam param = new QueryParam();
        param.getParams().put("supplierId", new Parameter(QueryParam.EQ, supplierId));
        param.getParams().put("linkPhone", new Parameter(QueryParam.EQ, linkPhone));
        // 排除已作废
        param.getParams().put("status", new Parameter(QueryParam.NE, PlanConstant.INVITE_STATUS_INVALID));
        if(id != null){
            param.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        List<LinkerInviteEntity> inviteList = super.queryList(param);
        if(CollectionUtils.isNotEmpty(inviteList)){
            throw new BusinessException("该手机号已生成邀请中链接【" + inviteList.get(0).getBillCode() + "】，不允许重复邀请！");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("supplierId", new Parameter(QueryParam.EQ, supplierId));
        queryParam.getParams().put("mobileLinkPhone", new Parameter(QueryParam.EQ, linkPhone));
        List<LinkerEntity> linkerList = linkerService.queryList(queryParam);
        if(CollectionUtils.isNotEmpty(linkerList)){
            throw new BusinessException("该手机号已生成档案【" + linkerList.get(0).getCode() + "】，不允许重复邀请！");
        }
        return true;
    }

    @Override
    public boolean pushBillToSupCenter(LinkerInviteEntity entity) {
        Long sourceId = pushSupUtil.pushBillToSupCenter((JSONObject)JSONObject.toJSON(entity), SYSTEM_ID,
                BILL_TYPE, BILL_NAME, PUSH_BILL_SERVER_URL);
        if(sourceId != null){
            entity.setSourceId(sourceId);
            entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());

            // 向邀请邮箱发送邮件
            this.sendEmail(entity);
            // 向邀请电话发送短信
            this.sendSms(entity);

            // 生成流水
            LinkerInviteFlowVO flow = new LinkerInviteFlowVO();
            flow.setInviteId(entity.getId());
            flow.setFlowType(PlanConstant.FLOW_TYPE_INVITE.toString());
            flowService.saveOrUpdate(flow);
        } else {
            logger.error("单据-{}id-{}推送供方服务失败", BILL_NAME, entity.getId());
            entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
        }
        super.saveOrUpdate(entity, false);
        return true;
    }

    @Override
    public String updateBillStatus(LinkerInviteVO vo) {
        return this.updateBillStatus(vo, false);
    }

    @Override
    public String updateBillStatus(LinkerInviteVO vo, Boolean saveFlag) {
        // 代注册无需更新状态及生成流水
        if(vo.getId() == null){
            return null;
        }
        // 查询当前用户信息
        LinkerInviteEntity entity = super.selectById(vo.getId());
        // 校验业务状态
        pushSupUtil.validateStatus(vo.getStatus(), entity.getStatus());
        entity.setStatus(vo.getStatus());
        // 供方推送无需推送供方
        if(!saveFlag) {
            pushSupUtil.updateBillStatus((JSONObject) JSONObject.toJSON(entity),
                    "status", SYSTEM_ID, BILL_TYPE, BILL_NAME, BILL_WITER_BACK_SERVER_URL, null);
        }
        // 已准入
        if(PlanConstant.INVITE_STATUS_APPROVE.equals(vo.getStatus())){
            // 向邀请邮箱发送注册成功邮件
            this.sendApproveEmail(entity);
            // 向邀请电话发送注册成功短信
            this.sendApproveSms(entity);
        }
        // 已驳回
        if(PlanConstant.INVITE_STATUS_BACK.equals(vo.getStatus())){
            // 向邀请邮箱发送注册驳回邮件
            this.sendBackEmail(entity);
        }
        super.saveOrUpdate(entity);
        if(saveFlag){
            // 供方推送过来的数据操作人为供方登录人，生成流水
            LinkerInviteFlowEntity flow = new LinkerInviteFlowEntity();
            flow.setInviteId(entity.getId());
            flow.setFlowType(vo.getStatus());
            flow.setOperatorId(vo.getInviterId());
            flow.setOperatorName(vo.getInviterName());
            flow.setOperateTime(new Date());
            flowService.saveOrUpdate(flow, false);
        } else {
            // 生成流水
            LinkerInviteFlowVO flow = new LinkerInviteFlowVO();
            flow.setInviteId(entity.getId());
            // 更新状态flowType必传，否则流转状态有可能不对应
            flow.setFlowType(StringUtils.isNotEmpty(vo.getFlowType()) ? vo.getFlowType() : vo.getStatus());
            flowService.saveOrUpdate(flow);
        }
        // 驳回删除准入
        if(PlanConstant.INVITE_STATUS_BACK.equals(vo.getStatus())){
            QueryParam param = new QueryParam();
            param.getParams().put("inviteId", new Parameter(QueryParam.EQ, entity.getId()));
            List<LinkerAccessEntity> list = accessService.queryList(param);
            if(CollectionUtils.isNotEmpty(list)){
                List<Long> ids = list.stream().map(x->x.getId()).collect(Collectors.toList());
                accessService.removeByIds(ids, true);
            }
        }
        return null;
    }

    /**
     * 向邀请电话发送短信
     * @param entity
     */
    private void sendSms(LinkerInviteEntity entity) {
        Map<String, String> params = new HashMap<>();
        params.put("path", entity.getInviteCode());
        params.put("name", entity.getInviterName());
        params.put("phone", entity.getInviterPhone());
        pushSupUtil.sendSmsNoAuth(entity.getLinkPhone(), PlanConstant.联系人邀请短信模板编码, PlanConstant.SIGN_NAME, params);
    }

    /**
     * 向邀请邮箱发送邮件
     * @param entity
     */
    private void sendEmail(LinkerInviteEntity entity) {
        StringBuilder content = new StringBuilder();
        content.append("中电四公司提醒您办理联系人入库，请点击下方链接完成注册");
        content.append(entity.getInviteUrl());
        content.append("，该链接请勿外传，如有疑问，请联系:");
        content.append(entity.getInviterName());
        content.append("，手机号:");
        content.append(entity.getInviterPhone());
        JSONObject params = new JSONObject();
        params.put("userEmails", entity.getLinkEmail());
        params.put("userNames", entity.getLinkerName());
        pushSupUtil.sendEmail(null, "notice","联系人邀请邮件", content.toString(), params, entity.getInviteUrl(), null);
    }

    /**
     * 向邀请电话发送注册成功短信
     * @param entity
     */
    private void sendApproveSms(LinkerInviteEntity entity) {
        Map<String, String> params = new HashMap<>();
        params.put("path", pushSupUtil.SSO);
        params.put("name", entity.getLinkerName());
        params.put("phone", entity.getLinkPhone());
        pushSupUtil.sendSmsNoAuth(entity.getLinkPhone(), PlanConstant.供应商注册成功短信模板编码, PlanConstant.SIGN_NAME, params);
    }

    /**
     * 向邀请邮箱发送注册成功邮件
     * @param entity
     */
    private void sendApproveEmail(LinkerInviteEntity entity) {
        StringBuilder content = new StringBuilder();
        content.append(entity.getLinkerName());
        content.append("，您好，恭喜您完成联系人注册入库，请点击下方链接");
        String url = pushSupUtil.getLoginUrl();
        content.append(url);
        content.append("，进行登录，登录账号:");
        content.append(entity.getLinkPhone());
        content.append("，首次登录采用短信验证码进行验证");
        JSONObject params = new JSONObject();
        params.put("userEmails", entity.getLinkEmail());
        params.put("userNames", entity.getSupplierName());
        pushSupUtil.sendEmail(null, "notice","联系人注册成功邮件", content.toString(), params, url, null);
    }

    /**
     * 向邀请邮箱发送注册驳回邮件
     * @param entity
     */
    private void sendBackEmail(LinkerInviteEntity entity) {
        StringBuilder content = new StringBuilder();
        content.append("中电四公司已驳回了您办理的联系人入库，请点击下方链接重新注册");
        content.append(entity.getInviteUrl());
        content.append("，该链接请勿外传，如有疑问，请联系:");
        content.append(entity.getInviterName());
        content.append(entity.getInviterPhone());
        JSONObject params = new JSONObject();
        params.put("userEmails", entity.getLinkEmail());
        params.put("userNames", entity.getSupplierName());
        pushSupUtil.sendEmail(null, "notice","联系人注册驳回邮件", content.toString(), params, entity.getInviteUrl(), null);
    }
}
