package com.ejianc.business.zdssupplier.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdssupplier.sub.bean.SupplierBankEntity;
import com.ejianc.business.zdssupplier.sub.mapper.SupplierBankMapper;
import com.ejianc.business.zdssupplier.sub.service.ISupplierBankService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 分包供应商档案-银行信息
 * 
 * @author generator
 * 
 */
@Service("supplierBankService")
public class SupplierBankServiceImpl extends BaseServiceImpl<SupplierBankMapper, SupplierBankEntity> implements ISupplierBankService {

    @Override
    public List<SupplierBankEntity> getAllBySupplierIds(List<Long> supplierIds) {
        QueryWrapper<SupplierBankEntity> query = new QueryWrapper<>();
        query.in("supplier_id", supplierIds);
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.list(query);
    }
}
