package com.ejianc.business.zds.archive.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zds.archive.bean.AdministrativeAreaEntity;
import com.ejianc.business.zds.archive.bean.BankCategoryEntity;
import com.ejianc.business.zds.archive.service.IBankCategoryService;
import com.ejianc.business.zds.archive.utils.ZdsReqUtil;
import com.ejianc.business.zds.archive.vo.BankCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 银行类别实体
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("bankCategory")
public class BankCategoryController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBankCategoryService service;

    private final String BANK_CATEGORY_ERP_REQ_URL = "/cefoc/yql/getBankList";

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BankCategoryVO> queryDetail(Long id) {
    	BankCategoryEntity entity = service.selectById(id);
    	BankCategoryVO vo = BeanMapper.map(entity, BankCategoryVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BankCategoryVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<BankCategoryEntity> page = service.queryPage(param,false);
        IPage<BankCategoryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BankCategoryVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refBankCategoryData", method = RequestMethod.GET)
    @ResponseBody
    public List<Map> refBankCategoryData(@RequestParam(required=false) String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");

        if(StringUtils.isNotBlank(searchText)) {
            param.setSearchText(searchText);
        }

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("sequence", "asc");
        param.getOrderMap().put("code", "asc");

        List<BankCategoryEntity> list = service.queryList(param);

        return BeanMapper.mapList(list, Map.class);
     }

    @PostMapping(value = "/zdsBankCategorySync")
    public CommonResponse<String> zdsBankCategorySync() {
        logger.info("*********************中电四-银行分类信息同步任务 开始*********************");
        Integer pageNum = 0;
        Integer pageSize = Integer.valueOf(ZdsReqUtil.getErpDataBatchSize());
        Map<String, Integer> param = new HashMap<>();
        String reqUrl = ZdsReqUtil.getErpReqHost() + BANK_CATEGORY_ERP_REQ_URL;
        boolean hasNext = true;
        Map<String, String> headers = null;

        try {
            headers = ZdsReqUtil.getErpHeaders();
            param.put("PageSize", pageSize);
            JSONObject reqJson = null;
            JSONArray pageData =null;

            param.put("PageNum", ++pageNum);
            String reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(param),
                    headers, HttpTookit.connTimeout, HttpTookit.readTimeout);

            reqJson = JSONObject.parseObject(reqResp);

            if("ok".equals(reqJson.getString("status"))) {
                pageData = reqJson.getJSONArray("data");
                if(null != pageData && pageData.size() > 0) {
                    logger.info("中电四银行分类同步，处理第{}页, {}条数据", pageNum, pageData.size());
                    handleErpPageData(pageData);
                } else {
                    logger.info("中电四银行分类同步 处理数据完成！！！总共{}页数据！", pageNum);
                }
            } else {
                logger.error("请求中电四获取银行分类结果返回失败：请求地址-{},参数-{},header-{},结果-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp);
            }

        } catch (Exception e) {
            logger.error("获取中电四银行分类信息异常, 请求地址：{}, 请求参数：{}",
                    reqUrl, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat), e);
            return CommonResponse.error("同步中电四银行分类信息异常");
        }

        logger.info("*********************中电四-银行分类信息同步任务 结束*********************");
        return CommonResponse.success("中电四银行分类同步完成！");
    }

    private void handleErpPageData(JSONArray pageData) {
        JSONObject tmp = null;
        BankCategoryEntity tmpEntity = null;
        Map<String, BankCategoryEntity> sourceIdMap = new HashMap<>();
        List<BankCategoryEntity> saveList = new ArrayList<>();

        for(Object obj : pageData) {
            tmp = (JSONObject) obj;
            tmpEntity = new BankCategoryEntity();
            tmpEntity.setName(tmp.getString("Title")); //名称
            tmpEntity.setSourceId(tmp.getString("C_SD_BankInfoOID")); //主键
            tmpEntity.setCode(tmp.getString("Title_ID")); //银行代码
            tmpEntity.setEnabled(StringUtils.isNotBlank(tmp.getString("IsEnable")) ? "true".equals(tmp.getString("IsEnable").toLowerCase()) ? "1" : "0" : null); //停启用
            tmpEntity.setSequence(null != tmp.get("Sort_ID") ? tmp.getInteger("Sort_ID") : 1);
            tmpEntity.setMemo(null != tmp.getString("Memo") ? tmp.getString("Memo") : null);
            tmpEntity.setSubBankCode(tmp.getString("SubBankCode")); //银行码 作为参数查询分行数据

            sourceIdMap.put(tmpEntity.getSourceId(), tmpEntity);
        }

        List<BankCategoryEntity> dbListBySourceId = service.getAllBySourceIds(new ArrayList<>(sourceIdMap.keySet()));
        if(CollectionUtils.isNotEmpty(dbListBySourceId)) {
            //更新列表
            for(BankCategoryEntity dbEntity : dbListBySourceId) {
                tmpEntity = sourceIdMap.get(dbEntity.getSourceId());
                dbEntity.setName(tmpEntity.getName());
                dbEntity.setEnabled(tmpEntity.getEnabled());
                dbEntity.setSequence(tmpEntity.getSequence());
                dbEntity.setMemo(tmpEntity.getMemo());
                dbEntity.setCode(tmpEntity.getCode());
                dbEntity.setSubBankCode(tmpEntity.getSubBankCode());
                saveList.add(dbEntity);

                sourceIdMap.remove(dbEntity.getSourceId());
            }
        }

        if(!sourceIdMap.isEmpty()) {
            saveList.addAll(sourceIdMap.values());
        }

        logger.info("本次保存数据-{}条", saveList.size());
        service.saveOrUpdateBatch(saveList, saveList.size(), false);
    }
}
