package com.ejianc.business.zds.archive.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zds.archive.bean.SubTypeManagerEntity;
import com.ejianc.business.zds.archive.service.ISubTypeManagerService;
import com.ejianc.business.zds.archive.utils.ZdsReqUtil;
import com.ejianc.business.zds.archive.vo.SubTypeManagerVO;
import com.ejianc.business.zdsmaterial.erp.api.IZDSSubTypeApi;
import com.ejianc.business.zdsmaterial.material.vo.SubTypeVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2024/5/9 17:21
 */
@RestController
@RequestMapping(value = "/subTypeManager/")
public class SubTypeManagerController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISubTypeManagerService service;

    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private IZDSSubTypeApi izdsSubTypeApi;

    private final String SUB_TYPE_MANAGER_ERP_REQ_URL = "/cefoc/yql/getGoodTypeListMainPeople";

    @PostMapping(value = "/zdsSubTypeManagerSync")
    public CommonResponse<String> zdsSubTypeManagerSync(@RequestBody JSONObject reqParam) {
        logger.info("*********************中电四-分包类型负责人信息同步任务 开始*********************");
        Integer pageNum = null != reqParam.get("pageNum") ? reqParam.getInteger("pageNum") : 0;
        Integer pageSize = null != reqParam.get("pageSize") ? reqParam.getInteger("pageSize") : Integer.valueOf(ZdsReqUtil.getErpDataBatchSize());
        JSONObject param = new JSONObject();
        String reqUrl = ZdsReqUtil.getErpReqHost() + SUB_TYPE_MANAGER_ERP_REQ_URL;
        boolean hasNext = true;
        Map<String, String> headers = null;

        //请求连续失败次数，连续两次请求失败时 任务终止
        Integer reqErrorTimes = null != reqParam.get("reqErrorTimes") ? reqParam.getInteger("reqErrorTimes") : 0;
        reqParam.remove("reqErrorTimes");

        try {
            headers = ZdsReqUtil.getErpHeaders();
            param.put("PageSize", pageSize);
            JSONObject reqJson = null;
            JSONArray pageData =null;

            param.put("PageNum", ++pageNum);
            String reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(param),
                    headers, HttpTookit.connTimeout, HttpTookit.readTimeout);

            reqJson = JSONObject.parseObject(reqResp);
            reqErrorTimes = 0;

            if("ok".equals(reqJson.getString("status"))) {

                pageData = reqJson.getJSONArray("data");
                if(null != pageData && pageData.size() > 0) {
                    logger.info("中电四分包类型负责人信息同步,请求成功，共{}条数据，当前处理第{}页-{}条数据",reqJson.getString("allCount"), pageNum, pageData.size());
                    int startLine = 0, step = 20, total = pageData.size();
                    while (startLine < pageData.size()) {
                        handleErpPageData(pageData.subList(startLine, startLine+step < total ? startLine+step : total));
                        startLine+=step;
                    }
                } else {
                    logger.info("中电四分包类型负责人信息同步 处理数据完成！！！总共{}页数据！", pageNum);
                }
            } else {
                logger.error("请求中电四获取分包类型负责人信息结果返回失败：请求地址-{},参数-{},header-{},结果-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp);
            }

        } catch (Exception e) {
            logger.error("获取中电四分包类型负责人信息异常, 请求地址：{}, 请求参数：{}", reqUrl, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat), e);

            reqErrorTimes++;
            if(reqErrorTimes >= 2) {
                return CommonResponse.error("同步中电四分包类型负责人信息异常");
            }
            try {
                logger.info("同步中电四分包类型负责人信息异常，1.5s后重试.........,当前已同步{}数据",param.getInteger("PageNum")-1);
                //休息1.5s
                Thread.sleep(5000);
                param.put("pageSize", param.getInteger("PageSize"));
                param.put("pageNum", param.getInteger("PageNum")-1);
                param.put("reqErrorTimes", reqErrorTimes);
                return zdsSubTypeManagerSync(param);
            } catch (Exception e1) {
                logger.error("重启中电四分包类型负责人信息同步接口异常,", e1);
                return CommonResponse.error("同步中电四分包类型负责人信息异常");
            }
        }

        logger.info("*********************中电四-分包类型负责人信息同步任务 结束*********************");
        return CommonResponse.success("中电四分包类型负责人信息同步完成！");

    }

    private void handleErpPageData(List<Object> pageData) {
        JSONObject tmp = null;
        SubTypeManagerEntity tmpEntity = null;
        Map<String, SubTypeManagerEntity> dataMap = new HashMap<>();
        List<SubTypeManagerEntity> saveList = new ArrayList<>();
        Set<String> subTypeSids = new HashSet<>();
        Set<String> empSid = new HashSet<>();
        Set<String> sourceIds = new HashSet<>();
        Map<String, SubTypeVO> subTypeMap = new HashMap<>();
        Map<String, EmployeeVO> employeeMap = new HashMap<>();

        for(Object obj : pageData) {
            tmp = (JSONObject) obj;
            tmpEntity = new SubTypeManagerEntity();
            tmpEntity.setManagerSid(tmp.getString("Title_Sid")); //负责人SID
            tmpEntity.setSubTypeSid(tmp.getString("GoodsType_FK")); //分包类型SID
            tmpEntity.setEnabled("true".equals(tmp.getString("IsEnable")) ? 1 : 0); //停启用：0-停用，1-启用
            tmpEntity.setManagerName(tmp.getString("Title")); //负责人名称
            tmpEntity.setSourceId(tmp.getString("C_SD_GoodsTypeSubBOID")); //ERP主键

            empSid.add(tmpEntity.getManagerSid());
            subTypeSids.add(tmpEntity.getSubTypeSid());
            sourceIds.add(tmpEntity.getSourceId());
            dataMap.put(tmpEntity.getSourceId(), tmpEntity);
        }

        if(CollectionUtils.isNotEmpty(subTypeSids)) {
            CommonResponse<List<SubTypeVO>> subTypeResp = izdsSubTypeApi.getAllBySourceIds(new ArrayList<>(subTypeSids));
            if(!subTypeResp.isSuccess()) {
                logger.error("根据分包类型SID列表-{}获取对应分包类型信息失败，{}", subTypeSids, JSONObject.toJSONString(empSid, SerializerFeature.PrettyFormat));
            } else if(CollectionUtils.isNotEmpty(subTypeResp.getData())) {
                subTypeMap.putAll(subTypeResp.getData().stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item)));
            }
        }

        if(CollectionUtils.isNotEmpty(empSid)) {
            CommonResponse<List<EmployeeVO>> empResp = employeeApi.getAllBySourceIds(new ArrayList<>(empSid));
            if(!empResp.isSuccess()) {
                logger.error("根据人员SID列表-{}获取对应人员信息失败，{}", empSid, JSONObject.toJSONString(empSid, SerializerFeature.PrettyFormat));
            } else if(CollectionUtils.isNotEmpty(empResp.getData())) {
                employeeMap.putAll(empResp.getData().stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item)));
            }
        }

        EmployeeVO tmpEmp = null;
        SubTypeVO tmpSubType = null;

        List<SubTypeManagerEntity> dbList = service.getAllBySourceIds(new ArrayList<>(sourceIds));
        if(CollectionUtils.isNotEmpty(dbList)) {
            for(SubTypeManagerEntity dbEntity : dbList) {
                tmpEntity = dataMap.get(dbEntity.getSourceId());
                dbEntity.setEnabled(tmpEntity.getEnabled());

                tmpEmp = employeeMap.get(tmpEntity.getManagerSid());
                if(null != tmpEmp) {
                    dbEntity.setManagerName(tmpEmp.getName());
                    dbEntity.setManagerCode(tmpEmp.getCode());
                    dbEntity.setManagerId(tmpEmp.getId());
                }
                tmpSubType = subTypeMap.get(tmpEntity.getSubTypeSid());
                if(null != tmpSubType) {
                    dbEntity.setSubTypeId(tmpSubType.getId());
                    dbEntity.setSubTypeName(tmpSubType.getName());
                }

                saveList.add(dbEntity);
                dataMap.remove(dbEntity.getSourceId());
            }
        }

        if(!dataMap.isEmpty()) {
            for(SubTypeManagerEntity newRecord : dataMap.values()) {
                tmpEmp = employeeMap.get(newRecord.getManagerSid());
                if(null != tmpEmp) {
                    newRecord.setManagerName(tmpEmp.getName());
                    newRecord.setManagerCode(tmpEmp.getCode());
                    newRecord.setManagerId(tmpEmp.getId());
                }
                tmpSubType = subTypeMap.get(newRecord.getSubTypeSid());
                if(null != tmpSubType) {
                    newRecord.setSubTypeId(tmpSubType.getId());
                    newRecord.setSubTypeName(tmpSubType.getName());
                }
                saveList.add(newRecord);
            }
        }

        logger.info("本次保存数据-{}条", saveList.size());
        if(CollectionUtils.isNotEmpty(saveList)) {
            service.saveOrUpdateBatch(saveList, saveList.size(), false);
        }
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @PostMapping(value = "/queryList")
    public CommonResponse<IPage<SubTypeManagerVO>> queryList(@RequestBody QueryParam param) {

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("managerName");
        fuzzyFields.add("managerCode");

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<SubTypeManagerEntity> page = service.queryPage(param,false);

        IPage<SubTypeManagerVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubTypeManagerVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
}
