package com.ejianc.business.zdssupplier.common.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdssupplier.common.utils.PushSupUtil;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.mq.consumer.BaseConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * 消息中心基础消息拉取监听类
 */
@Component
public class MessageCommonListener extends BaseConsumer {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private final static String UPLOAD_FILE_QUEUE = "upload_file_queue";

    @Value("${spring.cloud.config.profile}")
    private String profile;

    @Autowired
    private PushSupUtil pushSupUtil;

    @Override
    protected void doConsumeMsg(MqMessage mqMessage) {
        logger.info("消息执行MQ开始");
        try {
            TransferVO vo = JSONObject.parseObject(JSON.toJSONString(mqMessage.getBody()), TransferVO.class);
            pushSupUtil.uploadFileByUrl(vo.getUrl(), vo.getSourceId(), vo.getBillType(), vo.getSourceType(), vo.getAuthority());
        } catch (Exception e) {
            logger.error("监听消息异常: ", e);
        }
    }

    @Override
    protected String[] getQueueNames() {
        return new String[]{UPLOAD_FILE_QUEUE + "_" + profile};
    }
}
