package com.ejianc.business.zdssupplier.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierEntity;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierService;
import com.ejianc.business.zdssupplier.sub.bean.LinkerEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierManagerEntity;
import com.ejianc.business.zdssupplier.sub.service.ILinkerService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierManagerService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.tenant.vo.TenantVO;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;


@Component
public class CoordinationUtil<T> {
    private final Logger logger = LoggerFactory.getLogger(getClass());

    private static final String USER_SUP_ROLE_LIST_URL = "/ejc-idm-web/openapi/api/user/supUserRoleList";
    private static final String USER_URL = "/ejc-oms-web/openapi/enterprise/createOrUpdateUser";
    private static final String TENANT_URL = "/ejc-oms-web/openapi/enterprise/createOrUpdateTenant";
    private static final String ADD_ROLE_URL = "/ejc-idm-web/openapi/api/user/addUserAccRole";
    private static final String REMOVE_ROLE_URL = "/ejc-idm-web/openapi/api/user/removeUserAccRole";

    @Value("${eachLink.host}")
    private String host;

    @Value("${eachLink.appId}")
    private String appId;

    @Value("${eachLink.secret}")
    private String secret;

    @Autowired
    private IProSupplierApi proSupplierApi;

    @Autowired
    private ISystemDataPushService systemDataPushService;

    @Autowired
    private ILinkerService linkerService;

    @Autowired
    private IMatLinkerService matLinkerService;

    @Autowired
    private ISupplierManagerService supplierManagerService;

    @Autowired
    private IMatSupplierService matSupplierService;

    @Autowired
    private ISupplierService supplierService;

    @Autowired
    private PushSupUtil pushSupUtil;

    /**
     * 查询指定手机再供方对应角色信息
     *
     * @param userPhone 用户手机号
     * @param supRoleName 带查询角色名称（可缺省）
     * @param supTenant 供方租户Id（可缺省）
     * @return
     */
    public List<RoleUserRelationVO> getUserSupRoleList(String userPhone, String supRoleName, Long supTenant) {
        logger.info("供方角色信息查询：userPhone-{}, supRoleName-{}, supTenant-{}", userPhone, supRoleName, supTenant);
        if(StringUtils.isBlank(userPhone)) {
            throw new BusinessException("查询用户供方角色信息失败，用户手机号为空！");
        }

        Map<String, String> reqParam = new HashMap<>();
        reqParam.put("userPhone", userPhone);
        reqParam.put("supRoleName", supRoleName);
        reqParam.put("supTenant", null != supTenant ? supTenant.toString() : null);

        CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataWithUniversal(USER_SUP_ROLE_LIST_URL,
                RequestMethod.POST, JSONObject.toJSONString(reqParam), appId, secret, host);

        logger.error("供方角色信息查询结果：{}", JSONObject.toJSONString(syncReqResp));
        if(!syncReqResp.isSuccess()) {
            logger.error("{供方角色信息查询失败，参数：{}, 结果：{}", JSONObject.toJSONString(reqParam), JSONObject.toJSONString(syncReqResp));
            throw new BusinessException(syncReqResp.getMsg());
        }
        CommonResponse<List<RoleUserRelationVO>> respData = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
        return respData.getData();
    }

    /**
     * 联系人生成协同账号
     * @param reqParam
     * @return
     */
    public JSONObject createSupAccount(Map<String, String> reqParam) {
        logger.info("生成协同账户参数reqParam：{}，url:{}", reqParam, USER_URL);

        Long supplierId = Long.valueOf(reqParam.get("supplierId"));
        Long billId = Long.valueOf(reqParam.get("billId"));
        String linkName = reqParam.get("linkName");
        String supplierType = reqParam.get("linkSupType");
        String supplierAccRole = reqParam.get("supplierAccRole");

        //加锁
        int retryTime = 0;
        boolean lockRs = false;
        String lockKeyPrefix = PlanConstant.分包项目经理.equals(supplierAccRole) ?
                PlanConstant.供应商联系人协同加锁键值前缀 : PlanConstant.供应商项目经理协同加锁键值前缀;

        try {
            try {
                lockRs = BillLockUtil.getLock(lockKeyPrefix, billId);
                while (!lockRs && retryTime <= 3) {
                    //获取锁失败，5S秒后重试获取锁， 重试三次
                    logger.info("{}【id-{},name-{},type-{}】生成协同账户获取锁失败，5s后再次尝试获取锁！",supplierAccRole, billId, linkName, supplierAccRole);
                    TimeUnit.SECONDS.sleep(5);
                    lockRs = BillLockUtil.getLock(lockKeyPrefix, billId);
                    retryTime++;
                }
            } catch (Exception e) {
                logger.error("供应商id-{},{}id-{}生成协同账户失败，获取锁失败,",supplierId, supplierAccRole, billId, e);
            }

            if(!lockRs) {
                logger.error("供应商id-{},{}id-{}生成协同账户失败，获取锁失败,", supplierId, supplierAccRole, billId);
                throw new BusinessException(supplierAccRole+"[" + linkName + "]生成协同账户失败，获取锁失败！");
            }

            if(retryTime > 0) {
                String linkerCooFlag = "0";
                Long supTenant = null;
                Long supUserId = null;
                if(PlanConstant.分包项目经理.equals(supplierAccRole)) {
                    SupplierManagerEntity managerEntity = supplierManagerService.selectById(billId);
                    linkerCooFlag = managerEntity.getCoordination();
                    supTenant = managerEntity.getTenant();
                    supUserId = managerEntity.getSupUserId();
                } else {
                    //查询判断当前联系人是否已生成协同账号
                    if(PlanConstant.SUB_SUPPLIER.equals(supplierType)) {
                        //分包联系人
                        LinkerEntity subLinker = linkerService.selectById(billId);
                        linkerCooFlag = subLinker.getCoordination();
                        supTenant = subLinker.getTenant();
                        supUserId = subLinker.getSupUserId();
                    } else {
                        //物资联系人
                        MatLinkerEntity matLinkerEntity = matLinkerService.selectById(billId);
                        linkerCooFlag = matLinkerEntity.getCoordination();
                        supTenant = matLinkerEntity.getTenant();
                        supUserId = matLinkerEntity.getSupUserId();
                    }
                }

                //若已生成协同账号，则返回需要的协同信息
                if(PlanConstant.STRING_YES.equals(linkerCooFlag)) {
                    JSONObject resp = new JSONObject();
                    resp.put("tenantId", supTenant);
                    resp.put("userId", supUserId);
                    return resp;
                }
            }

            CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataWithUniversal(USER_URL,
                    RequestMethod.POST, JSONObject.toJSONString(reqParam), appId, secret, host);
            logger.error("{}生成协同账户请求结果，{}", supplierAccRole, JSONObject.toJSONString(syncReqResp));
            if(!syncReqResp.isSuccess()) {
                logger.error("{}生成协同账户失败，参数：{}, 结果：{}", supplierAccRole, JSONObject.toJSONString(reqParam), JSONObject.toJSONString(syncReqResp));
                throw new BusinessException(syncReqResp.getMsg());
            }
            CommonResponse<JSONObject> resp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
            if (!resp.isSuccess()) {
                logger.error("{}生成协同账户失败，参数：{}, 结果：{}", supplierAccRole, JSONObject.toJSONString(reqParam), JSONObject.toJSONString(resp));
                throw new BusinessException(resp.getMsg());
            }
            return resp.getData();

        } finally {
            if(lockRs) {
                BillLockUtil.releaseLock(lockKeyPrefix, billId);
            }
        }
    }

    /**
     * 向邀请电话发送注册成功短信
     * @param entity
     */
    public void sendApproveSms(JSONObject entity) {
        Map<String, String> params = new HashMap<>();
        params.put("path", pushSupUtil.SSO);
        params.put("name", entity.getString("linkerName"));
        params.put("phone", entity.getString("linkPhone"));
        pushSupUtil.sendSmsNoAuth(entity.getString("linkPhone"), PlanConstant.供应商注册成功短信模板编码, PlanConstant.SIGN_NAME, params);
    }

    /**
     * 向邀请邮箱发送注册成功邮件
     * @param entity
     */
    public void sendApproveEmail(JSONObject entity) {
        StringBuilder content = new StringBuilder();
        content.append(entity.getString("linkerName"));
        content.append("，您好，恭喜您完成联系人注册入库，请点击下方链接");
        String url = pushSupUtil.getLoginUrl();
        content.append(url);
        content.append("，进行登录，登录账号:");
        content.append(entity.getString("linkPhone"));
        content.append("，首次登录采用短信验证码进行验证");
        JSONObject params = new JSONObject();
        params.put("userEmails", entity.getString("linkEmail"));
        params.put("userNames", entity.getString("supplierName"));
        pushSupUtil.sendEmail(null, "notice","联系人注册成功邮件", content.toString(), params, url, null);
    }

    /**
     * 供应商生成协同租户
     * @param reqParam
     * @return
     */
    public TenantVO createSupTenant(Map<String, String> reqParam) {
        logger.info("供应商生成协同租户参数reqParam：{}，url:{}", reqParam, TENANT_URL);

        Long supplierId = Long.valueOf(reqParam.get("supplierId"));
        String supplierName = reqParam.get("supplierName");
        String supplierType = reqParam.get("supplierType");

        //加锁
        int retryTime = 0;
        boolean lockRs = false;

        try {
            try {

                lockRs = BillLockUtil.getLock(PlanConstant.供应商协同加锁键值前缀, supplierId);
                while (!lockRs && retryTime <= 3) {
                    //获取锁失败，5S秒后重试获取锁， 重试三次
                    logger.info("供应商【id-{},name-{},type-{}】生成协同租户获取锁失败，5s后再次尝试获取锁！", supplierId, supplierName, supplierType);
                    TimeUnit.SECONDS.sleep(5);
                    lockRs = BillLockUtil.getLock(PlanConstant.供应商协同加锁键值前缀, supplierId);
                    retryTime++;
                }

            } catch (Exception e) {
                logger.error("供应商id-{},name-{},type-{}生成协同租户失败，获取锁失败,", supplierId, supplierName, supplierType, e);
            }

            if(!lockRs) {
                logger.error("供应商id-{},name-{},type-{}生成协同租户失败，获取锁失败,", supplierId, supplierName, supplierType);
                throw new BusinessException("供应商[" + supplierName + "]生成协同租户失败，获取锁失败！");
            }

            if(retryTime > 0) {
                String cooFlag = "0";
                Long supTenant = null;
                Long enterprise = null;
                if(PlanConstant.SUB_SUPPLIER.equals(supplierType)) {
                    SupplierEntity subSupplier = supplierService.selectById(supplierId);
                    cooFlag = subSupplier.getCoordination();
                    supTenant = subSupplier.getTenant();
                    enterprise = Long.valueOf(subSupplier.getSystemId());
                } else {
                    MatSupplierEntity matSupplier = matSupplierService.selectById(supplierId);
                    cooFlag = matSupplier.getCoordination();
                    supTenant = matSupplier.getTenant();
                    enterprise = Long.valueOf(matSupplier.getSystemId());
                }

                if(PlanConstant.STRING_YES.equals(cooFlag)) {
                    TenantVO tenantVO = new TenantVO();
                    tenantVO.setEnterpriseId(enterprise);
                    tenantVO.setId(supTenant);
                    tenantVO.setName(supplierName);
                    return tenantVO;
                }
            }

            // 设置单据当前系统信息
            CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
            String systemId = null;
            if (!ejcCloudSystemCode.isSuccess()) {
                logger.error("获取当前系统信息失败, {}", JSONObject.toJSONString(ejcCloudSystemCode));
                throw new BusinessException("操作失败，获取当前系统信息失败");
            }
            systemId = ejcCloudSystemCode.getData();
            reqParam.put("systemId", systemId);

            logger.info("生成协同租户参数reqParam：{}，rul:{}", reqParam, TENANT_URL);
            CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataWithUniversal(TENANT_URL,
                    RequestMethod.POST, JSONObject.toJSONString(reqParam), appId, secret, host);
            logger.error("请求结果，{}", JSONObject.toJSONString(syncReqResp));
            if(!syncReqResp.isSuccess()) {
                logger.error("供应商生成协同租户失败，参数：{}, 结果：{}", JSONObject.toJSONString(reqParam), JSONObject.toJSONString(syncReqResp));
            }
            CommonResponse<JSONObject> resp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
            if (!resp.isSuccess()) {
                logger.error("供应商生成协同租户失败，参数：{}, 结果：{}", JSONObject.toJSONString(reqParam), JSONObject.toJSONString(resp));
//            throw new BusinessException("生成供方租户信息失败！");
                throw new BusinessException(resp.getMsg());
            }
            TenantVO vo = JSONObject.parseObject(JSON.toJSONString(resp.getData()), TenantVO.class);
            return vo;

        } finally {
            if(lockRs) {
                BillLockUtil.releaseLock(PlanConstant.供应商协同加锁键值前缀, supplierId);
            }
        }
    }

    /**
     * 用户启用
     * @param params
     * @return
     */
    public String addUserAccRole(JSONObject params) {
        logger.info("启用参数reqParam：{}，rul:{}", params.toJSONString(), ADD_ROLE_URL);
        String supplierId = params.getString("supplierId");
        CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataWithEachLinkSystem(ADD_ROLE_URL,
                RequestMethod.POST, params.toJSONString(), supplierId);
        logger.error("请求结果，{}", JSONObject.toJSONString(syncReqResp));
        if(!syncReqResp.isSuccess()) {
            logger.error("启用失败，参数：{}, 结果：{}", params.toJSONString(), JSONObject.toJSONString(syncReqResp));
        }
        CommonResponse<JSONObject> resp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
        if (!resp.isSuccess()) {
            logger.error("启用失败，参数：{}, 结果：{}", params.toJSONString(), JSONObject.toJSONString(resp));
            throw new BusinessException(resp.getMsg());
        }
        return "操作成功！";
    }

    /**
     * 用户停用
     * @param params
     * @return
     */
    public String removeUserAccRole(JSONObject params) {
        logger.info("停用参数reqParam：{}，rul:{}", params.toJSONString(), REMOVE_ROLE_URL);
        String supplierId = params.getString("supplierId");
        CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataWithEachLinkSystem(REMOVE_ROLE_URL,
                RequestMethod.POST, params.toJSONString(), supplierId);
        logger.error("请求结果，{}", JSONObject.toJSONString(syncReqResp));
        if(!syncReqResp.isSuccess()) {
            logger.error("停用失败，参数：{}, 结果：{}", params.toJSONString(), JSONObject.toJSONString(syncReqResp));
        }
        CommonResponse<JSONObject> resp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
        if (!resp.isSuccess()) {
            logger.error("停用失败，参数：{}, 结果：{}", params.toJSONString(), JSONObject.toJSONString(resp));
            throw new BusinessException(resp.getMsg());
        }
        return "操作成功！";
    }

}
