package com.ejianc.business.zdssupplier.common.utils;

import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

public class ParamUtil {

    /**
     * AND (
     * 	(field = obj1)
     * 	OR (field = obj2)
     * )
     * @param field
     * @param param1
     * @param param2
     * @return
     */
    public static ComplexParam getOrParam(String field, Parameter param1, Parameter param2) {
        ComplexParam complex = new ComplexParam();
        complex.setLogic(ComplexParam.AND);
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.OR);
        c1.getParams().put(field, param1);
        complex.getComplexParams().add(c1);
        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put(field, param2);
        complex.getComplexParams().add(c2);
        return complex;
    }

    /**
     * AND (
     * 	(field = obj1)
     * 	OR (field = obj2)
     * )
     * @param field
     * @param obj1
     * @param obj2
     * @return
     */
    public static ComplexParam getOrParam(String field, Object obj1, Object obj2) {
        ComplexParam complex = new ComplexParam();
        complex.setLogic(ComplexParam.AND);
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.OR);
        c1.getParams().put(field, new Parameter(QueryParam.EQ, obj1));
        complex.getComplexParams().add(c1);
        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put(field, new Parameter(QueryParam.EQ, obj2));
        complex.getComplexParams().add(c2);
        return complex;
    }

    /**
     * AND (
     * 	(field1 = obj1)
     * 	OR (field2 = obj2)
     * )
     * @param field1
     * @param obj1
     * @param obj2
     * @return
     */
    public static ComplexParam getOrParam(String field1, String field2, Object obj1, Object obj2) {
        ComplexParam complex = new ComplexParam();
        complex.setLogic(ComplexParam.AND);
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.OR);
        c1.getParams().put(field1, new Parameter(QueryParam.EQ, obj1));
        complex.getComplexParams().add(c1);
        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put(field2, new Parameter(QueryParam.EQ, obj2));
        complex.getComplexParams().add(c2);
        return complex;
    }
}
