package com.ejianc.business.zdssupplier.material.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerEntity;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerService;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerVO;
import com.ejianc.business.zdssupplier.sub.bean.LinkerEntity;
import com.ejianc.business.zdssupplier.sub.vo.LinkerVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.dozer.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2024/1/30 16:06
 */
@RestController
@RequestMapping(value = "/api/matLinkerApi")
public class MatLinkerApi {

    @Autowired
    private IMatLinkerService service;

    /**
     * 同步准入数据
     *
     * @return
     */
    @PostMapping(value = "/getBySourceIds")
    public CommonResponse<List<MatLinkerVO>> getBySourceIds(@RequestBody List<String> sourceIds) {
        List<MatLinkerVO> vos = service.getBySourceIds(sourceIds);
        return CommonResponse.success("查询成功", vos);
    }
    @GetMapping(value = "/getSupUserIdAndTenant")
    public CommonResponse<MatLinkerVO> getSupUserIdAndTenant(@RequestParam Long supUserId, @RequestParam Long tenantId) {
        QueryWrapper<MatLinkerEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("sup_user_id",supUserId);
        queryWrapper.eq("tenant", tenantId);
        queryWrapper.eq("dr", BaseVO.DR_UNDELETE);
        queryWrapper.eq("date_type", BaseVO.DR_UNDELETE);

        List<MatLinkerEntity> list = service.list(queryWrapper);
        if (null!=list&&list.size()>0){
            MatLinkerEntity matLinker = list.get(0);
            MatLinkerVO matLinkerVO = BeanMapper.map(matLinker, MatLinkerVO.class);
            return CommonResponse.success("查询成功", matLinkerVO);
        }
        return CommonResponse.success("查询成功", null);
    }

    /**
     * 根据联系人供方用户Id，获取联系人信息
     */
    @GetMapping(value = "/getBySupUserId")
    CommonResponse<MatLinkerVO> getBySupUserId(@RequestParam("supUserId") Long supUserId, @RequestParam("supplierId") Long supplierId) {
        MatLinkerVO resp = service.getBySupUserId(supUserId, supplierId);
        return CommonResponse.success(resp);
    }

}
