package com.ejianc.business.zdssupplier.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdssupplier.common.utils.EntityUtil;
import com.ejianc.business.zdssupplier.common.utils.PushSupUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerAccessEntity;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerEntity;
import com.ejianc.business.zdssupplier.material.mapper.MatLinkerAccessMapper;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerAccessService;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerInviteService;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerService;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerAccessVO;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerInviteVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 物资联系人准入
 * 
 * @author generator
 * 
 */
@Service("matLinkerAccessService")
public class MatLinkerAccessServiceImpl extends BaseServiceImpl<MatLinkerAccessMapper, MatLinkerAccessEntity> implements IMatLinkerAccessService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_TYPE = BillTypeEnum.物资联系人准入.getCode();
    private static final String BILL_NAME = BillTypeEnum.物资联系人准入.getName();
    private static final String BILL_CODE = "ZDS_MAT_LINKER_ACCESS";//此处需要根据实际修改
    private static final String SYNC_SUPP_DETAIL_BILL_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/matLinkerAccess/syncDetailBill";

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private PushSupUtil pushSupUtil;

    @Autowired
    private IMatLinkerInviteService inviteService;

    @Autowired
    private IMatLinkerService linkerService;

    @Override
    public MatLinkerAccessVO saveOrUpdate(MatLinkerAccessVO saveOrUpdateVO) {
        MatLinkerAccessEntity entity = BeanMapper.map(saveOrUpdateVO, MatLinkerAccessEntity.class);

        // 校验手机号唯一性
        this.validateUnique(entity, entity.getId());

        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            // 待注册，默认邀请人为当前登录人
            entity.setSourceType(PlanConstant.SOURCE_TYPE_EL.toString());
            entity.setInviterId(InvocationInfoProxy.getUserid());
            entity.setInviterName(sessionManager.getUserContext().getUserName());
        }
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, MatLinkerAccessVO.class);
    }

    @Override
    public Long saveSyncBill(HttpServletRequest request) {
        String transData = request.getParameter("transData");
        MatLinkerAccessEntity saveEntity = JSONObject.parseObject(transData, MatLinkerAccessEntity.class);
        QueryParam param = new QueryParam();
        param.getParams().put("inviteId", new Parameter(QueryParam.EQ, saveEntity.getInviteId()));
        List<MatLinkerAccessEntity> list = super.queryList(param);
        if(CollectionUtils.isNotEmpty(list)){
            throw new BusinessException("该邀请链接已生成准入，不允许重复生成！");
        }

        // 校验手机号唯一性
        this.validateUnique(saveEntity, null);

        Long id = pushSupUtil.saveSyncBill(request, MatLinkerAccessEntity.class, BILL_TYPE, BILL_NAME);
        if(null == id) {
            throw new BusinessException("同步数据异常！");
        }
        MatLinkerAccessEntity entity = super.selectById(id);
        // 生成单据编码
        entity.setCode(EntityUtil.createBillCode(entity, BILL_CODE));
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        // 更新附件主键
        if(entity.getUserType() == 2){
            Long fileId = pushSupUtil.getFileId(Long.valueOf(entity.getId()), BILL_TYPE, PlanConstant.AGENT_SOURCE_TYPE, Long.valueOf(entity.getAgencyFileId()));
            entity.setAgencyFileId(fileId.toString());
            if(null != entity.getCertifyFileId()) {
                Long certifyFileId = pushSupUtil.getFileId(Long.valueOf(entity.getId()), BILL_TYPE, PlanConstant.CERTIFY_SOURCE_TYPE, Long.valueOf(entity.getCertifyFileId()));
                entity.setCertifyFileId(certifyFileId.toString());
            }
        } else {
            Long fileId = pushSupUtil.getFileId(Long.valueOf(entity.getId()), BILL_TYPE, PlanConstant.LEGAL_PERSON_SOURCE_TYPE, Long.valueOf(entity.getLegalPersonFileId()));
            entity.setLegalPersonFileId(fileId.toString());
        }
        super.saveOrUpdate(entity, false);
        // 修改邀请状态并生成流水
        MatLinkerInviteVO inviteVO = new MatLinkerInviteVO();
        inviteVO.setId(entity.getInviteId());
        inviteVO.setStatus(PlanConstant.INVITE_STATUS_AFFIRM);
        inviteVO.setInviterId(entity.getInviterId());
        inviteVO.setInviterName(entity.getInviterName());
        inviteService.updateBillStatus(inviteVO, true);
        return id;
    }

    @Override
    public Boolean validateUnique(MatLinkerAccessEntity linker, Long id) {
        // 供应商准入不校验
        if(linker.getSupplierId() == null){
            return true;
        }
        // 同一供应商下联系人不能重复
        QueryParam param = new QueryParam();
        param.getParams().put("mobileLinkPhone", new Parameter(QueryParam.EQ, linker.getMobileLinkPhone()));
        param.getParams().put("supplierId", new Parameter(QueryParam.EQ, linker.getSupplierId()));
        if(id != null){
            param.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        List<MatLinkerAccessEntity> accessList = super.queryList(param);
        if(CollectionUtils.isNotEmpty(accessList)){
            logger.error("该联系人的手机号{}已生成准入【{}】，不允许重复准入！", linker.getMobileLinkPhone(), accessList.get(0).getId());
            throw new BusinessException("该联系人的手机号已生成准入，不允许重复准入！");
        }
        param.getParams().remove("supplierId");
        param.getParams().put("dateType", new Parameter(QueryParam.EQ, 0));
        param.getParams().put("enableStatus", new Parameter(QueryParam.EQ, 1));
        List<MatLinkerEntity> linkerList = linkerService.queryList(param);
        if(CollectionUtils.isNotEmpty(linkerList)){
            logger.error("该联系人的手机号{}已生成档案【{}】，不允许重复准入！", linker.getMobileLinkPhone(), linkerList.get(0).getId());
            throw new BusinessException("该联系人的手机号已生成档案，不允许重复准入！");
        }
        return true;
    }

    @Override
    public Boolean validateUnique(List<MatLinkerAccessEntity> linkerList) {
        linkerList = linkerList.stream().filter(x->!"del".equals(x.getRowState())).collect(Collectors.toList());
        Integer legalNum = (int) linkerList.stream().filter(x->PlanConstant.INTEGER_YES.equals(x.getUserType())).count();
        if(legalNum > 1){
            throw new BusinessException("联系人类型为法定代表人最多只能有一条！");
        }
        for(MatLinkerAccessEntity linker : linkerList){
            // 校验手机号唯一性
            this.validateUnique(linker, linker.getId());
        }
        return true;
    }

    @Override
    public MatLinkerAccessVO syncDetailBill(Long inviteId) {
        MatLinkerAccessEntity entity = this.getEntityByInviteId(inviteId, null);
        if(null == entity.getId()){
            // 不存在准入，从分供方重新拉取
            Map<String, String> params = new HashMap<>();
            params.put("inviteId", String.valueOf(inviteId));
            CommonResponse<String> response = pushSupUtil.exchangeDataAndFilesWithUniversal(SYNC_SUPP_DETAIL_BILL_SERVER_URL, params);
            if (response.isSuccess()){
                CommonResponse<String> resp = JSONObject.parseObject(response.getData(), CommonResponse.class);
                if (!resp.isSuccess()) {
                    throw new BusinessException(resp.getMsg());
                }
                entity = this.getEntityByInviteId(null, Long.valueOf(resp.getData()));
            }else {
                throw new BusinessException(response.getMsg());
            }
        }
        return BeanMapper.map(entity, MatLinkerAccessVO.class);
    }

    /**
     * 根据邀请链接id查询准入
     * @param inviteId
     * @return
     */
    private MatLinkerAccessEntity getEntityByInviteId(Long inviteId, Long sourceId){
        QueryParam queryParam = new QueryParam();
        if(sourceId != null){
            queryParam.getParams().put("sourceId", new Parameter(QueryParam.EQ, sourceId));
        } else {
            queryParam.getParams().put("inviteId", new Parameter(QueryParam.EQ, inviteId));
        }
        List<MatLinkerAccessEntity> list = super.queryList(queryParam);
        MatLinkerAccessEntity entity = new MatLinkerAccessEntity();
        if(CollectionUtils.isNotEmpty(list)){
            entity = super.selectById(list.get(0).getId());
        }
        return entity;
    }
}
