package com.ejianc.business.zdssupplier.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierAttachesEntity;
import com.ejianc.business.zdssupplier.material.mapper.MatSupplierAttachesMapper;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierAttachesService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 物资供应商档案-附件信息
 * 
 * @author generator
 * 
 */
@Service("matSupplierAttachesService")
public class MatSupplierAttachesServiceImpl extends BaseServiceImpl<MatSupplierAttachesMapper, MatSupplierAttachesEntity> implements IMatSupplierAttachesService {

    @Override
    public List<MatSupplierAttachesEntity> getAllBySupplierIds(List<Long> supplierIds) {
        QueryWrapper<MatSupplierAttachesEntity> query = new QueryWrapper<>();
        query.in("supplier_id", supplierIds);
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.list(query);
    }
}
