package com.ejianc.business.zdssupplier.material.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zds.archive.bean.BankCategoryEntity;
import com.ejianc.business.zds.archive.bean.BankEntity;
import com.ejianc.business.zds.archive.service.IBankCategoryService;
import com.ejianc.business.zds.archive.service.IBankService;
import com.ejianc.business.zdsmaterial.erp.api.IZDSBrandApi;
import com.ejianc.business.zdsmaterial.erp.vo.BrandVO;
import com.ejianc.business.zdsmaterial.material.api.IZDSMatSupManagerApi;
import com.ejianc.business.zdsmaterial.material.api.IZDSMaterialCategoryApi;
import com.ejianc.business.zdsmaterial.material.vo.MatSupplierManagerVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdssupplier.common.utils.DateUtil;
import com.ejianc.business.zdssupplier.common.utils.EntityUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.material.bean.*;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierChangeMaterialInfoService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierChangeService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierService;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierChangeVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierSyncErpParamVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

@Service("matSupplierChange") 
public class MatSupplierChangeBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	private static final String sourceBillType = BillTypeEnum.物资供应商变更.getCode();
	private static final String targetBillType = BillTypeEnum.物资供应商档案.getCode();

	@Autowired
	private IAttachmentApi attachmentApi;

	@Autowired
	private IMatSupplierChangeService service;

	@Autowired
	private IMatSupplierService supplierService;

	@Autowired
	private IZDSMatSupManagerApi izdsMatSupManagerApi;

	@Autowired
	private IMatSupplierChangeMaterialInfoService matSupplierChangeMaterialInfoService;

	@Autowired
	private IUserApi userApi;

	@Autowired
	private SessionManager sessionManager;

	@Autowired
	private IBankService bankService;

	@Autowired
	private IBankCategoryService bankCategoryService;

	@Autowired
	private IZDSMaterialCategoryApi materialCategoryApi;

	@Autowired
	private IZDSBrandApi brandApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		MatSupplierChangeEntity entity = service.selectById(billId);

		JSONArray resp = service.getApprUserList(billId);

		if(resp.size() == 0) {
			return CommonResponse.error("操作失败，联系人所属供应商下供货内容的物资分类未设置审核人信息！");
		}

		Date invokeDate = entity.getInvokeDate();
		if(null == invokeDate || DateUtil.compareDate(DateUtil.addDays(invokeDate, 15), new Date()) < 0){
			return CommonResponse.error("距离上一次调用天眼查时间已超过15天，请更新后操作！");
		}
		// 校验
		this.validate(entity);
		return CommonResponse.success();
	};

	/**
	 * 校验
	 * @param entity
	 */
	private void validate(MatSupplierChangeEntity entity) {
		// 校验统一社会信用代码唯一性
		supplierService.validateUnique(entity.getName(), entity.getSocialCreditCode(), entity.getSupplierId(), "变更");

		// 校验是否有在途单据
		service.validateRunning(entity.getSupplierId(), entity.getId());

		if(CollectionUtils.isEmpty(entity.getBankList())){
			throw new BusinessException("请添加至少一条银行信息！");
		}

		// 校验附件必输性
//		for(MatSupplierChangeAttachesEntity attach : entity.getAttachesList()){
//			if(PlanConstant.subAttachNameMap.containsKey(attach.getFileType()) &&
//					PlanConstant.subAttachNameMap.get(attach.getFileType()) && null == attach.getFileId()){
//				throw new BusinessException(attach.getFileType() + "未上传附件，请上传并保存后提交！");
//			}
//		}
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		MatSupplierChangeEntity entity = service.selectById(billId);
		// 修改变更状态并生成流水
		MatSupplierChangeVO vo = new MatSupplierChangeVO();
		vo.setId(entity.getId());
		vo.setSourceType(entity.getSourceType());
		vo.setStatus(PlanConstant.CHANGE_STATUS_COMMIT);
		service.updateBillStatus(vo);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		MatSupplierChangeEntity entity = service.selectById(billId);
		// 修改变更状态并生成流水
		MatSupplierChangeVO vo = new MatSupplierChangeVO();
		vo.setId(entity.getId());
		vo.setSourceType(entity.getSourceType());
		vo.setStatus(PlanConstant.CHANGE_STATUS_AFFIRM);
		vo.setFlowType(PlanConstant.FLOW_TYPE_APPROVE_BACK);
		service.updateBillStatus(vo);
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		MatSupplierChangeEntity entity = service.selectById(billId);
		// 校验
		this.validate(entity);
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		MatSupplierChangeEntity entity = service.selectById(billId);
//		// 生成历史
//		service.pushToHistory(entity.getSupplierId(), entity.getId());
		// 同步档案
		this.pushToArchive(entity);

		UserContext user = sessionManager.getUserContext();

		//推送ERP
		String msg = supplierService.syncSupplierChangeToErp(new SupplierSyncErpParamVO(entity.getSupplierId(), null,
				PlanConstant.供应商变更同步ERP, billId, true, user.getUserId(), user.getUserName()));
		if(StringUtils.isNotBlank(msg)) {
			throw new BusinessException(msg);
		}

		// 修改变更状态并生成流水
		MatSupplierChangeVO vo = new MatSupplierChangeVO();
		vo.setId(entity.getId());
		vo.setSourceType(entity.getSourceType());
		vo.setStatus(PlanConstant.CHANGE_STATUS_APPROVE);
		service.updateBillStatus(vo);
		return CommonResponse.success();
	}

	/**
	 * 同步档案
	 * @param entity
	 */
	@Transactional(rollbackFor = Exception.class)
	public Boolean pushToArchive(MatSupplierChangeEntity entity) {
		MatSupplierEntity supplier = supplierService.selectById(entity.getSupplierId());
		// 将变更数据同步到档案
		MatSupplierEntity saveEntity = EntityUtil.transformFileds(supplier, entity);
		saveEntity.setSourceType("3");// 来源变更
		// 保留数据
		saveEntity.setCode(supplier.getCode());
		saveEntity.setBillState(supplier.getBillState());
		saveEntity.setThirdSourceId(supplier.getThirdSourceId());
		saveEntity.setTenant(supplier.getTenant());
		saveEntity.setTenantName(supplier.getTenantName());
		saveEntity.setCoordination(supplier.getCoordination());

		if(StringUtil.isNotBlank(supplier.getErpType())) {
			saveEntity.setErpType(supplier.getErpType());
		}
		if(StringUtils.isNotBlank(supplier.getCorpErpName())) {
			saveEntity.setCorpErpName(supplier.getCorpErpName());
		}
		if(StringUtils.isNotBlank(supplier.getErpCreatorSid())) {
			saveEntity.setErpCreatorSid(supplier.getErpCreatorSid());
		}
		if(StringUtils.isNotBlank(supplier.getSysLastUpd())) {
			saveEntity.setSysLastUpd(supplier.getSysLastUpd());
		}
		if(StringUtils.isNotBlank(supplier.getErpRegisterName())) {
			saveEntity.setErpRegisterName(supplier.getErpRegisterName());
		}

		// 来源供方不更新字段，因为供方这些字段没有，会全量覆盖
		if(PlanConstant.SOURCE_TYPE_SUPPLIER.toString().equals(entity.getSourceType())){
			saveEntity.setPoState(supplier.getPoState());
			saveEntity.setRestrictDate(supplier.getRestrictDate());
			saveEntity.setTypeLabel(supplier.getTypeLabel());
			saveEntity.setCompanyCharacter(supplier.getCompanyCharacter());

		}
		saveEntity.setLinkerList(supplier.getLinkerList());

		//银行sid处理
		if(CollectionUtils.isNotEmpty(supplier.getBankList())) {
			Map<Long, MatSupplierBankEntity> bankMap =
					supplier.getBankList().stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
			if(CollectionUtils.isNotEmpty(saveEntity.getBankList())) {

				Map<String, BankEntity> bankNameMap =
						bankService.getAllMapByNames(saveEntity.getBankList().stream().map(item -> item.getOpenBank()).collect(Collectors.toList()));
				Map<String, BankCategoryEntity> bankCategoryNameMap =
						bankCategoryService.getAllMapByNames(saveEntity.getBankList().stream().map(item -> item.getBankName()).collect(Collectors.toList()));

				saveEntity.getBankList().forEach(bank -> {
					if(bankMap.containsKey(bank.getSourceDetailId())) {
						bank.setBankThirdSourceId(bankMap.get(bank.getSourceDetailId()).getBankThirdSourceId());
						bank.setBankSid(bankMap.get(bank.getSourceDetailId()).getBankSid());
						bank.setBankCategorySid(bankMap.get(bank.getSourceDetailId()).getBankCategorySid());
					}
					if(StringUtils.isNotBlank(bank.getOpenBank()) && bankNameMap.containsKey(bank.getOpenBank())) {
						bank.setBankSid(bankNameMap.get(bank.getOpenBank()).getSourceId());
					}
					if(StringUtils.isNotBlank(bank.getBankName()) && bankCategoryNameMap.containsKey(bank.getBankName())) {
						bank.setBankCategorySid(bankCategoryNameMap.get(bank.getBankName()).getSourceId());
					}
				});
			}
		}
		//附件
		if(CollectionUtils.isNotEmpty(supplier.getAttachesList())) {
			Map<Long, MatSupplierAttachesEntity> attachMap =
					supplier.getAttachesList().stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
			if(CollectionUtils.isNotEmpty(saveEntity.getAttachesList())) {
				saveEntity.getAttachesList().forEach(attach -> {
					if(attachMap.containsKey(attach.getSourceDetailId())) {
						attach.setThirdSourceId(attachMap.get(attach.getSourceDetailId()).getThirdSourceId());
					}
				});
			}
		}
		//供货内容
		if(CollectionUtils.isNotEmpty(supplier.getMaterialInfoList())) {
			Map<Long, MatSupplierMaterialInfoEntity> materialMap =
					supplier.getMaterialInfoList().stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
			if(CollectionUtils.isNotEmpty(saveEntity.getMaterialInfoList())) {
				List<Long> brandIds = new ArrayList<>();
				List<Long> materialIds = new ArrayList<>();
				Map<String, BrandVO> brandIdMap = new HashMap<>();
				Map<Long, MaterialCategoryVO> materialCategoryIdMap = new HashMap<>();

				saveEntity.getMaterialInfoList().forEach(material -> {
					if(materialMap.containsKey(material.getSourceDetailId())) {
						material.setInfoThirdSourceId(materialMap.get(material.getSourceDetailId()).getInfoThirdSourceId());
						material.setMaterialSid(materialMap.get(material.getSourceDetailId()).getMaterialSid());
						material.setBrandSid(materialMap.get(material.getSourceDetailId()).getBrandSid());
					}
					if(StringUtils.isNotBlank(material.getBrandId()) && !brandIds.contains(material.getBrandId())) {
						brandIds.add(Long.valueOf(material.getBrandId()));
					}
					if(null != material.getMaterialId() && !materialIds.contains(material.getMaterialId())) {
						materialIds.add(material.getMaterialId());
					}
				});
				if(CollectionUtils.isEmpty(materialIds)) {
					CommonResponse<List<MaterialCategoryVO>> materialResp = materialCategoryApi.getAllByIds(materialIds);
					if(!materialResp.isSuccess() || CollectionUtils.isEmpty(materialResp.getData())) {
						logger.error("根据物资分类id-{}查询物资分类信息失败: {}", JSONObject.toJSONString(brandIds),
								JSONObject.toJSONString(materialResp));
						throw new BusinessException("获取供货内容物资分类信息失败！");
					}
					materialCategoryIdMap.putAll(materialResp.getData().stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
					for(MatSupplierMaterialInfoEntity info : saveEntity.getMaterialInfoList()) {
						if(materialCategoryIdMap.containsKey(info.getMaterialId())) {
							info.setMaterialSid(materialCategoryIdMap.get(info.getMaterialId()).getSourceId());
						}
					}
				}
				if(CollectionUtils.isEmpty(brandIds)) {
					CommonResponse<List<BrandVO>> brandResp = brandApi.getAllByIds(brandIds);
					if(!brandResp.isSuccess() || CollectionUtils.isEmpty(brandResp.getData())) {
						logger.error("根据品牌id-{}查询品牌信息失败: {}", JSONObject.toJSONString(brandIds),
								JSONObject.toJSONString(brandResp));
						throw new BusinessException("获取供货内容品牌信息失败！");
					}
					brandIdMap.putAll(brandResp.getData().stream().collect(Collectors.toMap(item -> item.getId().toString(), item -> item)));
					for(MatSupplierMaterialInfoEntity info : saveEntity.getMaterialInfoList()) {
						if(brandIdMap.containsKey(info.getBrandId())) {
							info.setBrandSid(brandIdMap.get(info.getBrandId()).getSourceId());
						}
					}
				}
			}
		}

		supplierService.saveOrUpdate(saveEntity, false);

		// 附件处理
		attachmentApi.copyFilesFromSourceBillToTargetBill(
				String.valueOf(entity.getId()), sourceBillType, PlanConstant.BILL_SOURCE_TYPE,
				String.valueOf(supplier.getId()), targetBillType, PlanConstant.BILL_SOURCE_TYPE);

		Map<Long, MatSupplierAttachesEntity> attachMap = supplier.getAttachesList().stream().collect(Collectors.toMap(x->null != x.getSourceDetailId() ? x.getSourceDetailId() : x.getId(), x->x));
		for(MatSupplierChangeAttachesEntity source : entity.getAttachesList()){
			if(attachMap.containsKey(source.getId())){
				MatSupplierAttachesEntity target = attachMap.get(source.getId());
				attachmentApi.copyFilesFromSourceBillToTargetBill(
						String.valueOf(source.getId()), sourceBillType, PlanConstant.FILE_SOURCE_TYPE,
						String.valueOf(target.getId()), targetBillType, PlanConstant.FILE_SOURCE_TYPE);
			}
		}
		return true;
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("该单据不允许弃审！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

	@Override
	public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other) {
		JSONArray resp = service.getApprUserList(billId);
		if(resp.size() == 0) {
			return CommonResponse.error("操作失败，供应商下供货内容的物资分类未设置审核人信息！");
		}
		return CommonResponse.success(resp);
	}

}
