package com.ejianc.business.zdssupplier.material.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zds.archive.bean.BankEntity;
import com.ejianc.business.zds.archive.bean.PushErpRecordsEntity;
import com.ejianc.business.zds.archive.service.IBankCategoryService;
import com.ejianc.business.zds.archive.service.IBankService;
import com.ejianc.business.zds.archive.service.IPushErpRecordsService;
import com.ejianc.business.zds.archive.utils.ZdsReqUtil;
import com.ejianc.business.zds.archive.vo.BankCategoryVO;
import com.ejianc.business.zds.archive.vo.BankVO;
import com.ejianc.business.zdsmaterial.erp.api.IZDSBrandApi;
import com.ejianc.business.zdsmaterial.erp.vo.BrandVO;
import com.ejianc.business.zdsmaterial.material.api.IZDSMatSupManagerApi;
import com.ejianc.business.zdsmaterial.material.api.IZDSMaterialCategoryApi;
import com.ejianc.business.zdsmaterial.material.vo.MatSupplierManagerVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdssupplier.common.service.ISupplierSyncErpService;
import com.ejianc.business.zdssupplier.common.utils.CoordinationUtil;
import com.ejianc.business.zdssupplier.common.utils.ParamUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.cons.enums.ErpCompanyTypeEnums;
import com.ejianc.business.zdssupplier.cons.enums.ErpLinkerCardTypeEnum;
import com.ejianc.business.zdssupplier.cons.enums.ErpTaxCreditLevelEnum;
import com.ejianc.business.zdssupplier.material.bean.*;
import com.ejianc.business.zdssupplier.material.mapper.MatSupplierMapper;
import com.ejianc.business.zdssupplier.material.service.*;
import com.ejianc.business.zdssupplier.material.vo.*;
import com.ejianc.business.zdssupplier.sub.bean.SupplierBankEntity;
import com.ejianc.business.zdssupplier.sub.vo.SupSubDelParamVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierSyncErpParamVO;
import com.ejianc.business.zdssupplier.utils.ZDSReqUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IDeptApi;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IPostApi;
import com.ejianc.foundation.orgcenter.vo.DeptVO;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.orgcenter.vo.PostVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.tenant.vo.TenantVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 物资供应商档案
 * 
 * @author generator
 * 
 */
@Service("matSupplierService")
public class MatSupplierServiceImpl extends BaseServiceImpl<MatSupplierMapper, MatSupplierEntity> implements IMatSupplierService, ISupplierSyncErpService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "ZDS_MAT_SUPPLIER";//此处需要根据实际修改

    @Autowired
    private CoordinationUtil coordinationUtil;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IMatLinkerService linkerService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IBankService bankService;

    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IPostApi postApi;

    @Autowired
    private IDeptApi deptApi;

    @Autowired
    private IMatSupplierChangeMaterialInfoService changeMaterialInfoService;

    @Autowired
    private IMatSupplierChangeAttachesService changeAttachesService;

    @Autowired
    private IMatSupplierChangeBankService changeBankService;

    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Autowired
    private IZDSBrandApi brandApi;

    @Autowired
    private IZDSMaterialCategoryApi materialCategoryApi;

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Autowired
    private IBankCategoryService bankCategoryService;

    @Value("${spring.cloud.config.profile}")
    private String profile;

    @Autowired
    private RabbitTemplate rabbitTemplate;

    private final static String ERP_MAT_SUPPLIER_UPDATE_URL = "/cefoc/yql/MESupplierList?OID=";

    @Autowired
    private MatSupplierMapper mapper;

    @Autowired
    private IZDSMatSupManagerApi izdsMatSupManagerApi;

    @Override
    public MatSupplierVO saveOrUpdate(MatSupplierVO saveOrUpdateVO) {
        return saveOrUpdateSupInfo(saveOrUpdateVO, true);
    }


    @Override
    public MatSupplierVO saveOrUpdateSupInfo(MatSupplierVO saveOrUpdateVO, boolean linkerGenerateAccFlag) {
        MatSupplierEntity entity = BeanMapper.map(saveOrUpdateVO, MatSupplierEntity.class);

        // 校验统一社会信用代码唯一性
        this.validateUnique(entity.getName(), entity.getSocialCreditCode(), entity.getId(), "生成");

        // 联系人校验
        linkerService.validateUnique(entity.getLinkerList());

        if(StringUtils.isEmpty(saveOrUpdateVO.getCode()) && (entity.getId() == null || entity.getId() == 0)){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        if(linkerGenerateAccFlag) {
            if(!PlanConstant.STRING_YES.equals(entity.getCoordination())) {
                // 供应商未生成协同租户，则先创建协同租户
                this.createSupTenant(entity);
            }
            for(MatLinkerEntity linker : entity.getLinkerList()){
                if(!PlanConstant.STRING_YES.equals(linker.getCoordination())) {
                    linkerService.createSupAccount(linker, entity.getTenant());
                }
            }
        }
        return BeanMapper.map(entity, MatSupplierVO.class);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void generateLinkerAcc(Long supplierId) {
        MatSupplierEntity entity = super.selectById(supplierId);
        if(!PlanConstant.STRING_YES.equals(entity.getCoordination())) {
            // 供应商未生成协同租户，则先创建协同租户
            this.createSupTenant(entity);
        }
        for(MatLinkerEntity linker : entity.getLinkerList()){
            if(!PlanConstant.STRING_YES.equals(linker.getCoordination())) {
                linkerService.createSupAccount(linker, entity.getTenant());
            }
        }
    }

    @Override
    public List<Long> getSignConSupplierIds(Long projectId) {
        return mapper.getSignConSupplierIds(projectId);
    }

    @Override
    public JSONArray getApprUserList(Long supplierId) {
        JSONArray resp = new JSONArray();
        MatSupplierEntity supplier = super.selectById(supplierId);
        //获取供应商公户信息中的物料分类Id列表
        List<MatSupplierMaterialInfoEntity> msList = supplier.getMaterialInfoList();
        List<Long> categoryIds = msList.stream().filter(item -> null != item.getMaterialId())
                .map(MatSupplierMaterialInfoEntity::getMaterialId).collect(Collectors.toList());

        if(CollectionUtils.isEmpty(msList) || CollectionUtils.isEmpty(categoryIds)) {
            throw new BusinessException("操作失败，供应商下供货内容的物资分类为空，无法获取到对应审核人信息！");
        }

        CommonResponse<List<MatSupplierManagerVO>> settingResp = izdsMatSupManagerApi.getAllByCategoryIds(categoryIds);
        if(!settingResp.isSuccess()) {
            logger.error("根据物料分类ids-{}获取对应审核人信息失败，{}", categoryIds, JSONObject.toJSONString(settingResp, SerializerFeature.PrettyFormat));
            throw new BusinessException("查询供应商审核人信息失败！");
        }
        List<MatSupplierManagerVO> settingList = settingResp.getData();
        if(CollectionUtils.isNotEmpty(settingList)) {
            for(MatSupplierManagerVO m : settingList) {
                JSONObject obj = new JSONObject();
                obj.put("userId", m.getManagerId());
                obj.put("userName", m.getManagerName());
                resp.add(obj);
            }
        }

        return resp;
    }

    @Override
    public CommonResponse<MatSupplierEntity> queryDetailBill(HttpServletRequest request) {
        String transData = StringEscapeUtils.unescapeJava(request.getParameter("transData"));
        JSONObject jsonObject = JSONObject.parseObject(transData, JSONObject.class);
        String tenant = jsonObject.getString("tenant");
        Long id = jsonObject.getLong("id");
        QueryWrapper<MatSupplierEntity> queryWrapper = new QueryWrapper<>();
        if(null != id){
            queryWrapper.eq("id", id);
        } else {
            queryWrapper.eq("tenant",tenant);
        }
        List<MatSupplierEntity> list = super.list(queryWrapper);
        if (list.size() == 0) {
            return CommonResponse.error("未查询到单据！");
        }
        MatSupplierEntity supplierEntity = list.get(0);
        MatSupplierEntity entity =  super.selectById(supplierEntity.getId());
//        MatSupplierVO vo = BeanMapper.map(entity, MatSupplierVO.class);
        return CommonResponse.success("查询详情数据成功！", entity);
    }

    @Override
    public TenantVO createSupTenant(MatSupplierEntity supplier) {
        Map<String, String> reqParam = new HashMap<>();
        reqParam.put("socialCreditCode", supplier.getSocialCreditCode());
        reqParam.put("supplierType", PlanConstant.MAT_SUPPLIER);
        reqParam.put("supplierName", supplier.getName() + "-物资");
        reqParam.put("supplierId", supplier.getId().toString());

        // 供应商生成协同租户
        TenantVO vo = coordinationUtil.createSupTenant(reqParam);

        supplier.setCoordination(PlanConstant.STRING_YES);
        supplier.setTenant(vo.getId());
        supplier.setTenantName(vo.getName());
        supplier.setSystemId(vo.getEnterpriseId().toString());
        super.saveOrUpdate(supplier, false);
        return vo;
    }

    @Override
    public MatSupplierVO getByTenantId(Long supplierTenant) {
        MatSupplierVO resp = null;

        QueryWrapper<MatSupplierEntity> query = new QueryWrapper<>();
        query.eq("tenant", supplierTenant);
        query.eq("dr", BaseVO.DR_UNDELETE);
        MatSupplierEntity e = super.getOne(query);

        if(null != e) {
            resp = BeanMapper.map(e, MatSupplierVO.class);
        }

        return resp;
    }

    @Override
    public List<MatSupplierEntity> getAllByThirdSourceIds(List<String> thirdSourceIds) {
        QueryWrapper<MatSupplierEntity> query = new QueryWrapper<>();
        query.in("third_source_id", thirdSourceIds);
        query.eq("dr", BaseVO.DR_UNDELETE);
        List<MatSupplierEntity> resp = super.list(query);

        return resp;
    }

    @Override
    public Boolean validateUnique(String name, String socialCreditCode, Long id, String operate) {
        QueryParam param = new QueryParam();
        ComplexParam complexParam = ParamUtil.getOrParam("name", "socialCreditCode", name, socialCreditCode);
        param.getComplexParams().add(complexParam);
        if(id != null){
            param.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        List<MatSupplierEntity> supplierList = super.queryList(param);
        if(CollectionUtils.isNotEmpty(supplierList)){
            throw new BusinessException("该供应商的统一社会信用代码已生成档案【" + supplierList.get(0).getCode() + "】，不允许重复" + operate + "！");
        }
        return true;
    }

    @Override
    public String syncSupplierChangeToErp(SupplierSyncErpParamVO syncParam) {
        String pushResult = null;
        logger.info("推送物资供应商-{}至ERP   start*********", JSONObject.toJSONString(syncParam));
        Map<String, String> headers = null;

        PushErpRecordsEntity pushEntity = new PushErpRecordsEntity();
        pushEntity.setBillType(PlanConstant.供应商新增同步ERP.equals(syncParam.getSyncType()) ? BillTypeEnum.物资供应商准入.getCode() :
                PlanConstant.供应商变更同步ERP.equals(syncParam.getSyncType()) ? BillTypeEnum.物资供应商变更.getCode() :
                        PlanConstant.联系人新增同步ERP.equals(syncParam.getSyncType()) ? BillTypeEnum.物资联系人准入.getCode() : BillTypeEnum.物资联系人变更.getCode());
        pushEntity.setPushTypeName(syncParam.getSyncType());
        pushEntity.setOperatorId(syncParam.getOperatorId());
        pushEntity.setOperatorName(syncParam.getOperatorName());
        pushEntity.setPushDate(new Date());

        SupplierSyncParam syncSupParam = new SupplierSyncParam();
        try {
            String syncUrl = PlanConstant.供应商新增同步ERP.equals(syncParam.getSyncType()) ? PlanConstant.物资供应商新增同步ERP地址 : PlanConstant.物资供应商变更同步ERP地址;
            MatSupplierEntity entity =super.selectById(syncParam.getSupplierId());
            syncSupParam.setSupplierId(entity.getId());
            //推送数据地址记录
            pushEntity.setUrl(ZdsReqUtil.getErpReqHost()+ syncUrl);

            JSONObject supJson = null;
            if(!PlanConstant.供应商新增同步ERP.equals(syncParam.getSyncType())) {
                //查询供应商变更前 供应商ERP数据 并记录
                supJson = getSupErpInfo(syncParam.getSupplierId());
                if(null == supJson && !"ok".equals(supJson.get("status"))) {
                    logger.error("中电四 供应商id-{}推送ERP失败, 从ERP接口获取该供应商最新信息失败!", syncParam.getSupplierId());
                    pushResult = "操作失败，从ERP接口获取当前供应商最新信息失败！";
                    pushEntity.setSucFlag(PlanConstant.STRING_NO);
                    pushEntity.setPushResult("供应商【id-"+syncParam.getSupplierId().toString()+"】推送,从ERP接口获取供应商最新信息失败！");

                    //存储推送记录
                    sendMq(SupplierSyncParam.PUSH_ERP_RECORD_QUEUE+"_"+profile, JSONObject.toJSONString(pushEntity));
                    return pushResult;
                }

                //查询成功，记录当前供应商在ERP中最新信息
                pushEntity.setBeforePushSupInfo(supJson.toJSONString());
            }

            List<SupSubDelParamVO> delList = new ArrayList<>();
            //推送ERP供应商数据组装
            JSONArray syncData = transferToErpParam(entity, syncParam, delList, supJson);
            //推送数据记录
            pushEntity.setData(JSONObject.toJSONString(syncData));

            headers = ZdsReqUtil.getErpHeaders();
            String reqResp = HttpTookit.postByJson(ZdsReqUtil.getErpReqHost()+ syncUrl, JSONObject.toJSONString(syncData),
                    headers, ZdsReqUtil.CONN_TIME_OUT, ZdsReqUtil.READ_TIME_OUT);

            logger.info("物资供应商推送ERP：url-{}, 参数：{}，结果：{}", ZdsReqUtil.getErpReqHost()+ syncUrl,
                    JSONObject.toJSONString(syncData, SerializerFeature.PrettyFormat), reqResp);
            JSONObject reqJson = JSONObject.parseObject(reqResp);

            pushEntity.setErpResult(reqJson.toJSONString());

            if("true".equals(reqJson.getString("status"))) {
                logger.info("中电四 物资供应商登记id-{}推送ERP成功!", syncParam.getSupplierId());
                pushEntity.setSucFlag(PlanConstant.STRING_YES);
                pushEntity.setPushResult("供应商【id-"+syncParam.getSupplierId().toString()+"】推送ERP成功！");
                //处理字表删除项
                if(CollectionUtils.isNotEmpty(delList)) {
                    //TODO
                }

            } else {
                logger.error("中电四 物资供应商登记id-{}推送ERP失败!", syncParam.getSupplierId());
                pushEntity.setSucFlag(PlanConstant.STRING_NO);
                pushResult = "操作失败，供应商数据推送ERP处理失败！";
                pushEntity.setPushResult("供应商【id-"+syncParam.getSupplierId().toString()+"】推送,ERP处理失败！");
            }

        } catch (Exception e) {
            logger.error("推送物资供应商id-{}异常，", syncParam.getSupplierId(), e);
            pushEntity.setErpResult("推送异常");
            pushEntity.setSucFlag(PlanConstant.STRING_NO);
            pushResult = "操作失败，供应商推送ERP数据转换失败！";
            pushEntity.setPushResult("供应商【id-"+syncParam.getSupplierId().toString()+"】推送，数据转换失败！");
        }

//        pushErpRecordsService.saveOrUpdate(pushEntity, false);
        syncSupParam.setHandleServiceName("matSupplierService");

        //存储推送记录
        sendMq(SupplierSyncParam.PUSH_ERP_RECORD_QUEUE+"_"+profile, JSONObject.toJSONString(pushEntity));

        //查询ERP供应商信息并更新至EL平台
        if(PlanConstant.STRING_YES.equals(pushEntity.getSucFlag())) {
            sendMq(SupplierSyncParam.ERP_SUPPLIER_UPD_QUEUE+"_"+profile, JSONObject.toJSONString(syncSupParam));
        }

        logger.info("推送物资供应商id-{}至ERP   end*********", syncParam.getSupplierId());
        return pushResult;
    }

    @Override
    public String sendMq(String queueName, String body) {
        MqMessage mqMessage = new MqMessage();
//
        mqMessage.setBody(body);
        rabbitTemplate.convertAndSend(queueName, mqMessage);
        logger.info("MQ队列标识：{}", queueName);
        return "消息发送MQ队列成功！";
    }

    private JSONArray transferToErpParam(MatSupplierEntity entity,
                                         SupplierSyncErpParamVO syncParam,
                                         List<SupSubDelParamVO> delList, JSONObject supErpJson) {
        JSONArray resp = new JSONArray();
        JSONObject data = new JSONObject();
        resp.add(data);

        JSONObject supplierJson = new JSONObject();
        if(null != supErpJson && supErpJson.getJSONArray("MESupplierList").size() > 0) {
            supplierJson = (JSONObject) supErpJson.getJSONArray("MESupplierList").get(0);
        }

        //查询供应商归属部门信息
        String corpSid = entity.getCorpSid();
        if(StringUtils.isBlank(corpSid) && null != entity.getCorpId()) {
            //查询供应商所属部门细心
            CommonResponse<OrgVO> orgResp = orgApi.getOneById(entity.getCorpId());
            if(!orgResp.isSuccess()) {
                logger.error("物资供应商同步ERP失败,查询供应商归属部门id-{}信息失败！", entity.getCorpId(), JSONObject.toJSONString(orgResp));
//                throw new BusinessException("物资供应商同步ERP失败,查询供应商归属部门信息失败！");
            }
            if(null == orgResp.getData()) {
                logger.error("物资供应商同步ERP失败,查询供应商归属部门id-{}信息为空！", entity.getCorpId(), JSONObject.toJSONString(orgResp));
//                throw new BusinessException("物资供应商同步ERP失败,查询供应商归属部门信息为空！");
            } else {
                corpSid = orgResp.getData().getSourceId();
            }
        }

        //查询供应商录入人信息
        EmployeeVO creator = null;
        if(StringUtils.isNotBlank(entity.getErpCreatorSid())) {
            CommonResponse<EmployeeVO> creatorRes = employeeApi.getOneBySourceId(entity.getErpCreatorSid());
            if(!creatorRes.isSuccess()) {
                logger.error("物资供应商同步ERP失败,查询供应商录入人sid-{}信息失败！", JSONObject.toJSONString(entity.getErpCreatorSid()), JSONObject.toJSONString(creatorRes));
//                throw new BusinessException("物资供应商同步ERP失败,查询供应商录入人信息失败！");
            }
            creator = creatorRes.getData();
            if(null == creator) {
                logger.error("物资供应商id-{}同步ERP失败,查询供应商录入人sid-{}信息为空！", entity.getId(), entity.getErpCreatorSid());
//                throw new BusinessException("物资供应商同步ERP失败,查询供应商录入人信息为空！");
            }
        }

//        if(StringUtils.isBlank(corpSid)) {
//            logger.error("物资供应商id-{}同步ERP失败,查询供应商归属部门corpSid信息为空！", entity.getId());
//            throw new BusinessException("物资供应商同步ERP失败,查询供应商归属部门信息为空！");
//        }

        data.put("YQL_SID", StringUtils.isBlank(entity.getThirdSourceId()) ? entity.getId() : entity.getThirdSourceId());//ERP SID
        data.put("CON_EMP_NUM", null != creator ? creator.getCode() : null);//录入人工号
        if(null != creator || StringUtils.isNotBlank(entity.getErpRegisterName())) {
            data.put("Register_Name", null != creator ? creator.getName() : entity.getErpRegisterName());//录入人工号
        }
        data.put("Company_Name", entity.getName()); //供应商名称
//        data.put("C_PS_MESupplierInfoOID", entity.getThirdSourceId());//ERP主键
        data.put("Taxcreditrating", StringUtils.isNotBlank(ErpTaxCreditLevelEnum.getByName(entity.getTaxCreditLevel())) ?
                ErpTaxCreditLevelEnum.getByName(entity.getTaxCreditLevel()) : ""); //纳税等级
        data.put("OwnerDept", StringUtils.isNotBlank(entity.getCorpErpName()) ? entity.getCorpErpName() :
                StringUtils.isNotBlank(entity.getCorpName()) ? entity.getCorpName() : ""); //归属部门
        data.put("OwnerDeptSid", StringUtils.isBlank(corpSid) ? PlanConstant.ERP空值 : corpSid); //归属部门SID
        data.put("CompanyStyle", ErpCompanyTypeEnums.fuzzyMatchByName(entity.getCompanyType().contains("(") ?
                entity.getCompanyType().substring(0, entity.getCompanyType().indexOf("(")) : entity.getCompanyType())); //公司类型
        data.put("Company_LegalPerson", entity.getLegalPerson()); //法人
        data.put("RegistrationCode", entity.getSocialCreditCode()); //统一社会信用代码
        data.put("IsPoSupplier", entity.getPoState()); //是否po供应商
        data.put("RegistrationCapital", handleMnyStr(entity.getRegisteredCapitalStr())); //注册资本
        data.put("Company_Address", entity.getRegisteredAddress()); //注册地址
        data.put("EntryDept", StringUtils.isNotBlank(entity.getType()) ? PlanConstant.ERP_MAT_INFO_TYPE_MAPPING.get(entity.getType()) :
                StringUtils.isNotBlank(entity.getErpType()) ? entity.getErpType() : null); //信息来源
        data.put("ConpanyTypeDescription", entity.getCompanyCharacter()); //类型描述
        data.put("OperatingPeriodStart", null != entity.getBusinessStartDate() ?
                DateFormatUtil.formatDate("yyyy-MM-dd", entity.getBusinessStartDate()) : ""); //经营开始时间
        data.put("OperatingPeriodStartEnd", null != entity.getBusinessEndDate() ?
                DateFormatUtil.formatDate("yyyy-MM-dd", entity.getBusinessEndDate()) : ""); //经营开始时间
        data.put("OperatingRange", entity.getBusinessScope()); //经营范围
        data.put("MainBrands", CollectionUtils.isNotEmpty(entity.getMaterialInfoList()) ?
                entity.getMaterialInfoList().stream().map(MatSupplierMaterialInfoEntity::getBrandName).collect(Collectors.joining(",")) : ""); //主营品牌
        data.put("SupplyArea", entity.getIntentName()); //业务区域
        data.put("CompanyType", entity.getProfessionName()); //产品类型
        data.put("CompanyType_Sid", entity.getProfessionName()); //产品类型SID
        data.put("IsSupportES", entity.getSealState()); //是否电签
        data.put("companyState", entity.getCompanyState()); //公司状态
        data.put("Restricteddate", null != entity.getRestrictDate() ?
                DateFormatUtil.formatDate("yyyy-MM-dd", entity.getRestrictDate()) : ""); //限期
        data.put("IsitaOneTimeUse", entity.getDisposableState()); //是否一次使用
        data.put("ReasonforOneTimeUse", StringUtils.isNotBlank(entity.getDisposableReason()) ? entity.getDisposableReason() : ""); //一次性使用原因
        data.put("TypeLabel", Integer.valueOf(entity.getCompanyCharacter())-1); //企业类型:ERP值域：0-生产商，1-贸易商，2-零售商，3-个体工商户
        data.put("InStorageRemark", StringUtils.isNotBlank(entity.getMemo()) ? entity.getMemo() : ""); //入库说明
        data.put("Memo", entity.getMemo()); //备注
        data.put("Paidincapital", handleMnyStr(entity.getPaidCapitalStr())); //实缴资本
        data.put("regStatus", entity.getBusinessStatus()); //经营状态
        data.put("Ma_id", entity.getCode()); //供应商编码

        //基础信息特殊处理
        supplierInfoBaseFill(data, supplierJson);

        //供应商联系人
        JSONArray linkerArr = new JSONArray();
        data.put("ContactList", linkerArr);
        handleSupLinker(linkerArr, entity.getLinkerList(), syncParam, creator, supplierJson.getJSONArray("ContactList"));

        //供应商银行信息
        JSONArray bankListArr = new JSONArray();
        data.put("BankList", bankListArr);
        handleSupBank(bankListArr, entity.getBankList(),
                syncParam, data.getString("C_PS_MESupplierInfoOID"), entity, delList, supplierJson.getJSONArray("BankList"));

        //供应商附件信息
        JSONArray archiveArr = new JSONArray();
        data.put("ArchiveList", archiveArr);
        handleSupArchive(archiveArr, entity.getAttachesList(), syncParam, data.getString("C_PS_MESupplierInfoOID"), creator, delList);

        //供应商供货信息
        JSONArray materialArr = new JSONArray();
        data.put("MESupplierSubDList", materialArr);
        handleSupMaterial(materialArr, entity.getMaterialInfoList(), syncParam, entity,
                delList, supplierJson.getJSONArray("SupplyList"));

        if(materialArr.size() > 0) {
            data.put("CompanyType", materialArr.stream().map(item -> ((JSONObject)item).getString("CompanyType")).collect(Collectors.joining(","))); //产品类型：字表供货内容 物料分类名称汇总
            data.put("CompanyType_Sid", materialArr.stream().map(item -> ((JSONObject)item).getString("CompanyType_Sid")).collect(Collectors.joining(","))); //产品类型：字表供货内容 物料分类Id汇总
        }

        return resp;
    }

    private void supplierInfoBaseFill(JSONObject data, JSONObject supplierJson) {
        if(StringUtils.isBlank(data.getString("OwnerDept")) && StringUtils.isNotBlank(supplierJson.getString("OwnerDept"))) {
            data.put("OwnerDept", supplierJson.getString("OwnerDept"));
        }
        if(StringUtils.isBlank(data.getString("OwnerDeptSid")) && StringUtils.isNotBlank(supplierJson.getString("OwnerDeptSid"))) {
            data.put("OwnerDeptSid", supplierJson.getString("OwnerDept"));
        }
        if(StringUtils.isBlank(data.getString("MainBrands")) && StringUtils.isNotBlank(supplierJson.getString("MainBrands"))) {
            data.put("MainBrands", supplierJson.getString("MainBrands"));
        }
        if(StringUtils.isBlank(data.getString("CompanyStyle")) && StringUtils.isNotBlank(supplierJson.getString("CompanyStyle"))) {
            data.put("CompanyStyle", supplierJson.getString("CompanyStyle"));
        }
        if(StringUtils.isBlank(data.getString("Taxcreditrating")) && StringUtils.isNotBlank(supplierJson.getString("Taxcreditrating"))) {
            data.put("Taxcreditrating", supplierJson.getString("Taxcreditrating"));
        }
        if(StringUtils.isBlank(data.getString("EntryDept")) && StringUtils.isNotBlank(supplierJson.getString("EntryDept"))) {
            data.put("EntryDept", supplierJson.getString("EntryDept"));
        }
        if(StringUtils.isBlank(data.getString("SupplyArea")) && StringUtils.isNotBlank(supplierJson.getString("SupplyArea"))) {
            data.put("SupplyArea", supplierJson.getString("SupplyArea"));
        }
        if(StringUtils.isBlank(data.getString("TypeLabel")) && StringUtils.isNotBlank(supplierJson.getString("TypeLabel"))) {
            data.put("TypeLabel", supplierJson.getString("TypeLabel"));
        }
    }

    private String handleMnyStr(String mnyStr) {
        if(StringUtils.isBlank(mnyStr)) {
            return "-";
        }
        mnyStr = mnyStr.replaceAll("亿", "00000000");
        mnyStr = mnyStr.replaceAll("千万", "0000000");
        mnyStr = mnyStr.replaceAll("万", "0000");
        mnyStr = mnyStr.replaceAll("千", "000");
        mnyStr = mnyStr.replaceAll("百", "00");
        mnyStr = mnyStr.replaceAll("十", "0");
        mnyStr = mnyStr.replaceAll("人民币", "");
        return mnyStr;
    }

    private void handleSupMaterial(JSONArray materialArr, List<MatSupplierMaterialInfoEntity> materialInfoList,
                                   SupplierSyncErpParamVO syncParam, MatSupplierEntity supplier,
                                   List<SupSubDelParamVO> delList, JSONArray erpMaterialArr) {
        if (PlanConstant.联系人新增同步ERP.equals(syncParam.getSyncType()) || PlanConstant.联系人变更同步ERP.equals(syncParam.getSyncType())) {
            //联系人变更、准入不会调整供应商附件信息，故不做同步
            return;
        } else if (PlanConstant.供应商变更同步ERP.equals(syncParam.getSyncType())) {
            //查询到本次供应商变更删除的项
            List<MatSupplierChangeMaterialInfoVO> changeDelList = changeMaterialInfoService.getDeledRecord(syncParam.getChangeId());
            logger.info("删除项：{}", changeDelList);
//            if(CollectionUtils.isNotEmpty(changeDelList)) {
//                materialInfoList.addAll(BeanMapper.mapList(changeDelList.stream().map(item -> {
//                    item.setId(item.getSourceDetailId());
//                    return item;
//                }).collect(Collectors.toList()), MatSupplierMaterialInfoEntity.class));
//            }
        }
        JSONObject materialJson = null;
        Map<String, JSONObject> erpMaterialMap = new HashMap<>();
        if (null != erpMaterialArr && erpMaterialArr.size() > 0) {
            for (Object obj : erpMaterialArr) {
                materialJson = (JSONObject) obj;
                erpMaterialMap.put(materialJson.getString("C_PS_MESupplierInfo_SubDOID"), materialJson);
            }
        }

        if (CollectionUtils.isNotEmpty(materialInfoList)) {
            Map<Long, BrandVO> brandMap = new HashMap<>();
            Map<String, BrandVO> brandNameMap = new HashMap<>();
            List<Long> brandIds = materialInfoList.stream().flatMap(item -> Stream.of(item.getBrandId().split(","))).map(Long::parseLong).collect(Collectors.toList());
            List<String> brandSids = materialInfoList.stream().filter(item -> StringUtils.isNotBlank(item.getBrandSid())).map(item -> item.getBrandSid()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(brandIds)) {
                CommonResponse<List<BrandVO>> brandResp = brandApi.getAllByIds(brandIds);
                if(!brandResp.isSuccess()) {
                    logger.error("根据品牌ID-{}查询品牌信息失败,{}", JSONObject.toJSONString(brandIds), JSONObject.toJSONString(brandResp, SerializerFeature.PrettyFormat));
                    throw new BusinessException("物资供应商同步ERP失败，查询供货品牌信息失败！");
                }
                if(CollectionUtils.isEmpty(brandResp.getData())) {
                    logger.error("根据品牌ID-{}查询品牌信息为空", JSONObject.toJSONString(brandIds), JSONObject.toJSONString(brandResp, SerializerFeature.PrettyFormat));
//                        throw new BusinessException("物资供应商同步ERP失败，查询供货品牌信息为空！");
                } else {
                    brandMap.putAll(brandResp.getData().stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
                }
            }
            if(CollectionUtils.isNotEmpty(brandSids)) {
                CommonResponse<Map<String, BrandVO>> brandResp = brandApi.getAllMapBySourceIds(brandSids);
                if(!brandResp.isSuccess()) {
                    logger.error("根据品牌SID-{}查询品牌信息失败,{}", JSONObject.toJSONString(brandSids), JSONObject.toJSONString(brandResp, SerializerFeature.PrettyFormat));
                    throw new BusinessException("物资供应商同步ERP失败，查询供货品牌信息失败！");
                }
                if(MapUtils.isEmpty(brandResp.getData())) {
                    logger.error("根据品牌ID-{}查询品牌信息为空", JSONObject.toJSONString(brandIds), JSONObject.toJSONString(brandResp, SerializerFeature.PrettyFormat));
//                        throw new BusinessException("物资供应商同步ERP失败，查询供货品牌信息为空！");
                } else {
                    brandNameMap = brandResp.getData();
                }
            }

            Map<Long, MaterialCategoryVO> categoryMap = new HashMap<>();
            Map<String, MaterialCategoryVO> categorySourceMap = new HashMap<>();
            //查询物资分类信息
            List<Long> categoryIds = materialInfoList.stream().filter(item -> null != item.getMaterialId()).map(item -> item.getMaterialId()).collect(Collectors.toList());
            List<String> categorySid = materialInfoList.stream().filter(item -> StringUtils.isNotBlank(item.getMaterialSid()))
                    .map(item -> item.getMaterialSid()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(categoryIds)) {
                CommonResponse<List<MaterialCategoryVO>> catetgoyResp = materialCategoryApi.getAllByIds(categoryIds);
                if (!catetgoyResp.isSuccess()) {
                    logger.error("根据品牌ID-{}查询物料分类信息失败", brandIds, JSONObject.toJSONString(catetgoyResp, SerializerFeature.PrettyFormat));
                    throw new BusinessException("物资供应商同步ERP失败，查询供货物料分类信息失败！");
                }

                if (CollectionUtils.isEmpty(catetgoyResp.getData())) {
                    logger.error("根据品牌ID-{}查询品物料分类信息为空", JSONObject.toJSONString(categoryIds), JSONObject.toJSONString(catetgoyResp, SerializerFeature.PrettyFormat));
//                throw new BusinessException("物资供应商同步ERP失败，查询供货物料分类信息为空！");
                }
                categoryMap = catetgoyResp.getData().stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
            }
            if(CollectionUtils.isNotEmpty(categorySid)) {
                CommonResponse<List<MaterialCategoryVO>> catetgoyResp = materialCategoryApi.getAllBySourceIdsAndPropertyFlag(categorySid, PlanConstant.INTEGER_YES);
                if (!catetgoyResp.isSuccess()) {
                    logger.error("根据品牌SID-{}查询物料分类信息失败", JSONObject.toJSONString(categorySid),
                            JSONObject.toJSONString(catetgoyResp, SerializerFeature.PrettyFormat));
                    throw new BusinessException("物资供应商同步ERP失败，查询供货物料分类信息失败！");
                }

                if (CollectionUtils.isEmpty(catetgoyResp.getData())) {
                    logger.error("根据品牌SID-{}查询品物料分类信息为空", JSONObject.toJSONString(categorySid),
                            JSONObject.toJSONString(catetgoyResp, SerializerFeature.PrettyFormat));
//                throw new BusinessException("物资供应商同步ERP失败，查询供货物料分类信息为空！");
                }
                categorySourceMap.putAll(catetgoyResp.getData().stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item)));
            }

            Map<Long, String> projectSid = new HashMap<>();
            //查询项目信息
            List<Long> projectIds = materialInfoList.stream().filter(item -> null != item.getAffiliatedProjectId()).map(item -> item.getAffiliatedProjectId()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(projectIds)) {
                CommonResponse<JSONArray> prjResp = projectPoolApi.queryProjectByIds(projectIds);
                if (!prjResp.isSuccess()) {
                    logger.error("根据关联项目ID-{}查询项目信息失败", projectIds, JSONObject.toJSONString(prjResp, SerializerFeature.PrettyFormat));
                    throw new BusinessException("物资供应商同步ERP失败，查询供货内容关联项目信息失败！");
                }
                if (CollectionUtils.isEmpty(prjResp.getData())) {
                    logger.error("根据关联项目ID-{}查询项目信息为空", brandIds, JSONObject.toJSONString(prjResp, SerializerFeature.PrettyFormat));
//                    throw new BusinessException("物资供应商同步ERP失败，查询供货内容关联项目信息为空！");
                }
                projectSid.putAll(prjResp.getData().stream().map(item -> JSONObject.parseObject(JSONObject.toJSONString(item)))
                        .collect(Collectors.toMap(item -> item.getLong("id"), item -> item.getString("sourceId"))));
            }


            MaterialCategoryVO tmpCategory = null;
            String projectSidStr = null;
            for (MatSupplierMaterialInfoEntity material : materialInfoList) {
                logger.info("供货内容项：{}", JSONObject.toJSONString(material, SerializerFeature.PrettyFormat));

                materialJson = new JSONObject();
                tmpCategory = categoryMap.get(material.getMaterialId());
                if (null == tmpCategory) {
                    logger.error("根据物料分类id-{}信息没有匹配到分类信息", brandIds);
//                    throw new BusinessException("物资供应商同步ERP失败，供应商供货物料分类与档案不匹配！");
                }
                if(null == tmpCategory) {
                    tmpCategory = categorySourceMap.get(material.getMaterialSid());
                }
//                List<Long> notExistsBrandIds = Arrays.stream(material.getBrandId().split(",")).filter(item -> !brandMap.containsKey(Long.valueOf(item))).map(Long::parseLong).collect(Collectors.toList());
//                if (CollectionUtils.isNotEmpty(notExistsBrandIds)) {
//                    logger.error("根据品牌ids-{}品牌信息没有匹配到分类信息", JSONObject.toJSONString(notExistsBrandIds), JSONObject.toJSONString(brandResp, SerializerFeature.PrettyFormat));
//                    throw new BusinessException("物资供应商同步ERP失败，供应商供货物料分类与档案不匹配！");
//                }
                if (null != material.getAffiliatedProjectId() && !projectSid.containsKey(material.getAffiliatedProjectId())) {
                    logger.error("物资供应商-{}同步ERP失败，没有匹配的关联项目-{}信息", material.getSupplierId(), material.getAffiliatedProjectId());
//                    throw new BusinessException("物资供应商同步ERP失败，关联项目信息与项目档案不匹配！");
                }
                projectSidStr = projectSid.containsKey(material.getAffiliatedProjectId()) ? projectSid.get(material.getAffiliatedProjectId()) : null;
                if(null != tmpCategory) {
                    materialJson.put("CompanyType", tmpCategory.getName()); //物资类型
                    materialJson.put("CompanyType_Sid", tmpCategory.getSourceId()); //物资类型Sid
                }
                materialJson.put("MainBrands", material.getBrandName()); //品牌
                materialJson.put("MainBrands_Sid", StringUtils.isNotBlank(material.getBrandId()) &&
                        brandMap.containsKey(Long.valueOf(material.getBrandId())) ?
                        brandMap.get(Long.valueOf(material.getBrandId())).getSourceId() :
                        StringUtils.isNotBlank(material.getBrandSid()) ? material.getBrandSid() : null); //品牌Sid
                materialJson.put("PropertyCode", material.getPropertyValue()); //属性
                materialJson.put("PropertyName", PlanConstant.MAT_MATERIAL_PROPERTY.get(material.getPropertyValue())); //属性Name
                materialJson.put("CertificationCode", Integer.valueOf(1).equals(material.getCertification()) ? "0" : "1"); //资质
                materialJson.put("CertificationName", Integer.valueOf(1).equals(material.getCertification()) ? "代理证" : "项目授权"); //资质
                materialJson.put("BeginTime", null != material.getStartTime() ?
                        DateFormatUtil.formatDate("yyyy-MM-dd", material.getStartTime()) : ""); //起始时间
                materialJson.put("EndTime", null != material.getTerminalTime() ?
                        DateFormatUtil.formatDate("yyyy-MM-dd", material.getTerminalTime()) : ""); //终止时间
                materialJson.put("AffiliatedCompany", material.getAffiliatedManufacturer()); //关联厂家
                materialJson.put("AffiliatedProject", material.getAffiliatedProjectName()); //关联项目
                materialJson.put("IsEnable", material.getEnableStatus()); //是否启用
                materialJson.put("AccountingProjectSet_FK", StringUtils.isNotBlank(projectSidStr) ? projectSidStr : ""); //执行项目外键
                materialJson.put("YQL_SID", StringUtils.isBlank(material.getInfoThirdSourceId()) ? material.getId() : material.getInfoThirdSourceId()); //益企联主键
                materialJson.put("Is_Add_Del", PlanConstant.供应商新增同步ERP.equals(syncParam.getSyncType()) ? PlanConstant.信息新增 : BaseVO.DR_DELETED.equals(material.getDr()) ? PlanConstant.信息删除 :
                        null != material.getSourceDetailId() ? PlanConstant.信息修订 : PlanConstant.信息新增); //同步操作状态

                if (erpMaterialMap.containsKey(material.getInfoThirdSourceId())) {
                    boolean pushFlag = fillMaterialInfo(materialJson, erpMaterialMap.get(material.getInfoThirdSourceId()));
                    if(!pushFlag) {
                        continue;
                    }
                }

                materialArr.add(materialJson);
            }
        }
    }

    private boolean fillMaterialInfo(JSONObject materialJson, JSONObject erpMaterialJson) {
        boolean pushFlag = true;
        if(StringUtils.isBlank(materialJson.getString("MainBrands"))) {
            if(StringUtils.equals(materialJson.getString("MainBrands_Sid"), erpMaterialJson.getString("MainBrands_Sid"))) {
                materialJson.put("MainBrands", erpMaterialJson.getString("MainBrands"));
            } else {
                pushFlag= false;
            }

        }
        if(StringUtils.isBlank(materialJson.getString("MainBrands_Sid"))) {
            if(StringUtils.equals(materialJson.getString("MainBrands"), erpMaterialJson.getString("MainBrands"))) {
                materialJson.put("MainBrands_Sid", erpMaterialJson.getString("MainBrands_Sid"));
            } else {
                pushFlag= false;
            }
        }
        if(StringUtils.isBlank(materialJson.getString("CompanyType"))) {
            if(StringUtils.equals(materialJson.getString("CompanyType_Sid"), erpMaterialJson.getString("CompanyType_Sid"))) {
                materialJson.put("CompanyType", erpMaterialJson.getString("CompanyType"));
            } else {
                pushFlag= false;
            }
        }
        if(StringUtils.isBlank(materialJson.getString("CompanyType_Sid"))) {
            if(StringUtils.equals(materialJson.getString("CompanyType"), erpMaterialJson.getString("CompanyType"))) {
                materialJson.put("CompanyType_Sid", erpMaterialJson.getString("CompanyType_Sid"));
            } else {
                pushFlag= false;
            }
        }
        if(StringUtils.isBlank(materialJson.getString("CompanyType_Sid"))) {
            if(StringUtils.equals(materialJson.getString("CompanyType"), erpMaterialJson.getString("CompanyType"))) {
                materialJson.put("CompanyType_Sid", erpMaterialJson.getString("CompanyType_Sid"));
            } else {
                pushFlag= false;
            }
        }
        if(StringUtils.isBlank(materialJson.getString("AffiliatedCompany"))) {
            if(StringUtils.equals(materialJson.getString("PropertyCode"), erpMaterialJson.getString("PropertyCode"))) {
                materialJson.put("PropertyCode", erpMaterialJson.getString("PropertyCode"));
            }
        }
        if(StringUtils.isBlank(materialJson.getString("AffiliatedProject"))) {
            if(StringUtils.equals(materialJson.getString("PropertyCode"), erpMaterialJson.getString("PropertyCode"))) {
                materialJson.put("AffiliatedProject", erpMaterialJson.getString("AffiliatedProject"));
            }
        }
        if(StringUtils.isBlank(materialJson.getString("AccountingProjectSet_FK"))) {
            if(StringUtils.equals(materialJson.getString("PropertyCode"), erpMaterialJson.getString("PropertyCode"))) {
                materialJson.put("AccountingProjectSet_FK", erpMaterialJson.getString("AccountingProjectSet_FK"));
            }
        }

        return pushFlag;
    }

    private void handleSupArchive(JSONArray archiveArr, List<MatSupplierAttachesEntity> attachesList,
                                  SupplierSyncErpParamVO syncParam, String supplierSid,
                                  EmployeeVO creator,
                                  List<SupSubDelParamVO> delList) {
        if(!PlanConstant.供应商新增同步ERP.equals(syncParam.getSyncType())) {
            //联系人变更、准入不会调整供应商附件信息，故不做同步
            return;
        }
//        else if(PlanConstant.供应商变更同步ERP.equals(syncParam.getSyncType())) {
//            //查询到本次供应商变更删除的项
//            List<MatSupplierChangeAttachesVO> changeDelList = changeAttachesService.getDeledRecord(syncParam.getChangeId());
//            logger.info("删除项：{}", changeDelList);
//            if(CollectionUtils.isNotEmpty(changeDelList)) {
//                attachesList.addAll(BeanMapper.mapList(changeDelList.stream().map(item -> {
//                    item.setId(item.getSourceDetailId());
//                    return item;
//                }).collect(Collectors.toList()), MatSupplierAttachesEntity.class));
//            }
//        }

        if(CollectionUtils.isNotEmpty(attachesList)) {
            //查询附件信息
            JSONObject params = new JSONObject();
            List<Long> sourceIds = attachesList.stream().map(MatSupplierAttachesEntity::getFileId).collect(Collectors.toList());
            CommonResponse<List<AttachmentVO>> attachResp = attachmentApi.queryAllByIds(sourceIds);
            Map<Long, AttachmentVO> attachMap = new HashMap<>();
            if(!attachResp.isSuccess()) {
                logger.error("根据id列表-{}查询对应附件信息失败，", JSONObject.toJSONString(sourceIds),
                        JSONObject.toJSONString(attachResp, SerializerFeature.PrettyFormat));
            } else if(CollectionUtils.isNotEmpty(attachResp.getData())) {
                attachMap.putAll(attachResp.getData().stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
            }

            AttachmentVO tmpAttach = null;
            for(MatSupplierAttachesEntity archive : attachesList) {
                JSONObject archiveJson = new JSONObject();
                logger.info("附件项：{}", JSONObject.toJSONString(archive, SerializerFeature.PrettyFormat));
                if(null != archive.getFileId()) {
                    tmpAttach = attachMap.get(archive.getFileId());
//                    archiveJson.put("C_PS_ArchivesOID", archive.getThirdSourceId());//ERP主键
                    archiveJson.put("Attach_Name", archive.getFileName()); //附件名称
                    archiveJson.put("Attach_Extension", archive.getFileName().indexOf(".") > 0 ?
                            archive.getFileName().substring(archive.getFileName().lastIndexOf(".")) :
                            tmpAttach.getFileName().substring(tmpAttach.getFileName().lastIndexOf("."))); //附件名称
                    archiveJson.put("Attach_Type", archive.getFileType()); //附件类型
                    archiveJson.put("AttachBase64", null != tmpAttach ? BASE_HOST + "filepreview/"+tmpAttach.getFilePath() : ""); //附件url
                    archiveJson.put("YQL_SID", StringUtils.isBlank(archive.getThirdSourceId()) ? archive.getId() : archive.getThirdSourceId()); //EL主键
                    archiveJson.put("Is_Add_Del", PlanConstant.供应商新增同步ERP.equals(syncParam.getSyncType()) ?
                            PlanConstant.信息新增 : BaseVO.DR_DELETED.equals(archive.getDr()) ? PlanConstant.信息删除 :
                            null != archive.getThirdSourceId() ? PlanConstant.信息修订 : PlanConstant.信息新增); //同步操作状态
                    archiveJson.put("Main_FK", supplierSid); //供应商SID
                    archiveArr.add(archiveJson);
                } else if(StringUtils.isNotBlank(archive.getThirdSourceId())) {
                    //附件不存在责人为是删除态
//                    archiveJson.put("C_PS_ArchivesOID", archive.getThirdSourceId());//ERP主键
                    archiveJson.put("Attach_Name", archive.getFileName()); //附件名称
                    archiveJson.put("Attach_Extension", archive.getFileName().indexOf(".") > 0 ?
                            archive.getFileName().substring(archive.getFileName().lastIndexOf(".")) : ""); //附件名称
                    archiveJson.put("Attach_Type", archive.getFileType()); //附件类型
                    archiveJson.put("YQL_SID", StringUtils.isNotBlank(archive.getThirdSourceId()) ? archive.getThirdSourceId() : archive.getId()); //EL主键
                    archiveJson.put("Is_Add_Del", PlanConstant.信息删除); //同步操作状态
                    archiveArr.add(archiveJson);
                }
            }
        }
    }

    private void handleSupBank(JSONArray bankListArr, List<MatSupplierBankEntity> bankList, SupplierSyncErpParamVO syncParam,
                               String supplierSid, MatSupplierEntity supplier, List<SupSubDelParamVO> delList,
                               JSONArray erpBankArr) {
        if(PlanConstant.联系人新增同步ERP.equals(syncParam.getSyncType()) || PlanConstant.联系人变更同步ERP.equals(syncParam.getSyncType())) {
            //联系人变更、准入不会调整供应商银行信息，故不做同步
            return;
        } else if(PlanConstant.供应商变更同步ERP.equals(syncParam.getSyncType())) {
            //查询到本次供应商变更删除的项
            List<MatSupplierChangeBankVO> changeDelList = changeBankService.getDeledRecord(syncParam.getChangeId());
            logger.info("删除项：{}", changeDelList);
//            if(CollectionUtils.isNotEmpty(changeDelList)) {
//                bankList.addAll(BeanMapper.mapList(changeDelList.stream().map(item -> {
//                    item.setId(item.getSourceDetailId());
//                    return item;
//                }).collect(Collectors.toList()), MatSupplierBankEntity.class));
//            }
        }
        JSONObject bankJson = null;
        Map<String,JSONObject> erpBankMap = new HashMap<>();
        if(null != erpBankArr && erpBankArr.size() > 0) {
            for(Object obj : erpBankArr) {
                bankJson = (JSONObject) obj;
                erpBankMap.put(bankJson.getString("C_PS_MESupplierInfo_SubBOID"), bankJson);
            }
        }

        List<BankVO> dbBankList= bankService.getAllByIds(bankList.stream().map(MatSupplierBankEntity::getBankId).collect(Collectors.toList()));
        Map<String, BankEntity> bankNameMap = bankService.getAllMapByNames(bankList.stream().map(MatSupplierBankEntity::getOpenBank).collect(Collectors.toList()));
        Map<Long, BankVO> bankMap = new HashMap<>();
        Map<Long, BankCategoryVO> bankCategoryMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(dbBankList)) {
            bankMap.putAll(dbBankList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
            List<BankCategoryVO> bankCategory = bankCategoryService.getAllByIds(dbBankList.stream().map(BankVO::getCategoryId).collect(Collectors.toList()));
            bankCategoryMap.putAll(bankCategory.stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
        }
        BankVO tmpBank = null;
        BankCategoryVO tmpBankCategory = null;

        for(MatSupplierBankEntity bank : bankList) {
            bankJson = new JSONObject();
            tmpBank = bankMap.get(bank.getBankId());
            if(null == tmpBank) {
                tmpBank = bankNameMap.containsKey(bank.getOpenBank()) ? BeanMapper.map(bankNameMap.get(bank.getOpenBank()), BankVO.class) : null;
            }
            if(null == tmpBank) {
                logger.error("供应商id-{}同步ERP失败，不存在主键为：{}的银行信息", bank.getSupplierId(), bank.getBankId());
            } else {
                tmpBankCategory = bankCategoryMap.get(tmpBank.getCategoryId());
            }
            if(null == tmpBankCategory) {
                logger.error("供应商id-{}同步ERP失败，不存在主键为：{}的银行分类信息", bank.getSupplierId(), JSONObject.toJSONString(bank, SerializerFeature.PrettyFormat));
            }

            logger.info("银行项：{}", JSONObject.toJSONString(bank, SerializerFeature.PrettyFormat));
            bankJson.put("YQL_SID", StringUtils.isBlank(bank.getBankThirdSourceId()) ? bank.getId() : bank.getBankThirdSourceId()); //EL主键
            bankJson.put("AccountType", null != bank.getNumberType() ? (bank.getNumberType() - 1) + "" : ""); //账号类型
            bankJson.put("Contact_BankAccount", bank.getBankNumber()); //银行账号
            if(null != tmpBank) {
                bankJson.put("SubBankName", tmpBank.getCategoryName()); //银行分类名称
                bankJson.put("SubBankCode", tmpBank.getSubBankCode()); //银行代码
                bankJson.put("Province", tmpBank.getProvinceName()); //省
                bankJson.put("City", tmpBank.getCityName()); //市
                bankJson.put("Contact_Bank", tmpBank.getName()); //开户行
                bankJson.put("Contact_BankNumber", tmpBank.getCode()); //银行行号
                bankJson.put("BranchSqe", tmpBank.getCode()); //具体支行序号
                bankJson.put("Whlnam", tmpBank.getName()); //网点名称
                bankJson.put("BankInfoOID", tmpBank.getSourceId()); //银行SID
            }
            if(null != tmpBankCategory) {
                bankJson.put("BankType", tmpBankCategory.getCode()); //银行类型
            }
            bankJson.put("Memo", ""); //备注
            bankJson.put("C_PS_SubContractorInfo_FK", supplierSid); //供应商SID
            bankJson.put("Is_Add_Del", PlanConstant.供应商新增同步ERP.equals(syncParam.getSyncType()) ? PlanConstant.信息新增 :
                    BaseVO.DR_DELETED.equals(bank.getDr()) ? PlanConstant.信息删除 : null != bank.getSourceDetailId() ? PlanConstant.信息修订 : PlanConstant.信息新增); //信息同步操作

            if(null == tmpBank && erpBankMap.containsKey(bank.getBankThirdSourceId())) {
                fillBankInfo(bankJson, erpBankMap.get(bank.getBankThirdSourceId()));
            } else {
                //数据不合法跳过
                logger.info("供应商银行信息[{}]不合法，跳过推送ERP", JSONObject.toJSONString(bank));
                continue;
            }

            bankListArr.add(bankJson);
        }
    }

    private void fillBankInfo(JSONObject bankJson, JSONObject erpBank) {
        if(StringUtils.isBlank(bankJson.getString("SubBankName")) && StringUtils.isNotBlank(erpBank.getString("SubBankName"))) {
            bankJson.put("SubBankName", erpBank.getString("SubBankName"));
        }
        if(StringUtils.isBlank(bankJson.getString("SubBankCode")) && StringUtils.isNotBlank(erpBank.getString("SubBankCode"))) {
            bankJson.put("SubBankCode", erpBank.getString("SubBankCode"));
        }
        if(StringUtils.isBlank(bankJson.getString("Province")) && StringUtils.isNotBlank(erpBank.getString("Province"))) {
            bankJson.put("Province", erpBank.getString("Province"));
        }
        if(StringUtils.isBlank(bankJson.getString("City")) && StringUtils.isNotBlank(erpBank.getString("City"))) {
            bankJson.put("City", erpBank.getString("City"));
        }
        if(StringUtils.isBlank(bankJson.getString("Contact_Bank")) && StringUtils.isNotBlank(erpBank.getString("Contact_Bank"))) {
            bankJson.put("Contact_Bank", erpBank.getString("Contact_Bank"));
        }
        if(StringUtils.isBlank(bankJson.getString("Contact_BankNumber")) && StringUtils.isNotBlank(erpBank.getString("Contact_BankNumber"))) {
            bankJson.put("Contact_BankNumber", erpBank.getString("Contact_BankNumber"));
        }
        if(StringUtils.isBlank(bankJson.getString("BranchSqe")) && StringUtils.isNotBlank(erpBank.getString("BranchSqe"))) {
            bankJson.put("BranchSqe", erpBank.getString("BranchSqe"));
        }
        if(StringUtils.isBlank(bankJson.getString("Whlnam")) && StringUtils.isNotBlank(erpBank.getString("Whlnam"))) {
            bankJson.put("Whlnam", erpBank.getString("Whlnam"));
        }
        if(StringUtils.isNotBlank(erpBank.getString("BankInfoOID"))) {
            bankJson.put("BankInfoOID", erpBank.getString("BankInfoOID"));
        }
        if(StringUtils.isBlank(bankJson.getString("BankType")) && StringUtils.isNotBlank(erpBank.getString("BankType"))) {
            bankJson.put("BankType", erpBank.getString("BankType"));
        }
    }

    private void handleSupLinker(JSONArray linkerArr, List<MatLinkerEntity> linkerList,
                                 SupplierSyncErpParamVO syncParam, EmployeeVO curUser,
                                 JSONArray erpLinkerArr) {
        List<MatLinkerEntity> handleData = linkerList;
        if(PlanConstant.供应商变更同步ERP.equals(syncParam.getSyncType())) {
            //供应商变更不调整联系人信息 故不同联系人
            return;
        } else if(PlanConstant.联系人新增同步ERP.equals(syncParam.getSyncType()) || PlanConstant.联系人变更同步ERP.equals(syncParam.getSyncType())) {
            //只同步本次新增/变更的联系人信息
            handleData = handleData.stream().filter(item -> item.getId().equals(syncParam.getLinkerId())).collect(Collectors.toList());
        }
        JSONObject linkerJson = null;
        Map<String, JSONObject> erpLinkerSourceMap = new HashMap<>();
        if(null != erpLinkerArr && erpLinkerArr.size() > 0) {
            for(Object obj : erpLinkerArr) {
                linkerJson = (JSONObject) obj;
                erpLinkerSourceMap.put(linkerJson.getString("subA_oid"), linkerJson);
            }
        }

        if(CollectionUtils.isNotEmpty(handleData)) {
            for(MatLinkerEntity link : handleData) {
                linkerJson = new JSONObject();
                logger.info("联系人项：{}", JSONObject.toJSONString(link, SerializerFeature.PrettyFormat));

                linkerJson.put("YQL_SID", StringUtils.isBlank(link.getThirdSourceId()) ? link.getId() : link.getThirdSourceId());//ERP sid
                linkerJson.put("IDType", ErpLinkerCardTypeEnum.getCodeByElCode(link.getIdCardType()));//证件类型
                linkerJson.put("IDCard", link.getIdCardId());//证件ID
                linkerJson.put("Company_Contact", link.getName());//联系人名称
                //ERP联系人类型:法定代表人为1，授权代理人为2  EL联系人类型：1:法定代表人、2:法定授权人
                linkerJson.put("ContactType", null != link.getUserType() ? link.getUserType() : null);//联系人类型 1法人2授权人
                linkerJson.put("Contact_Mobile", link.getMobileLinkPhone());//联系人手机号
                linkerJson.put("Contact_Telephone", link.getLinkPhone());//联系人固定电话
                linkerJson.put("Contact_Email", link.getElectronicMail());//联系人邮箱
                linkerJson.put("Contact_Address", link.getAddress());//联系人通讯地址
                linkerJson.put("ContactState", null != link.getLinkerStatus() ? link.getLinkerStatus().toString() : null);//联系人任职状态,1:离职，2：在职

                if(erpLinkerSourceMap.containsKey(link.getThirdSourceId())) {
                    fillSupLinkerInfo(linkerJson, erpLinkerSourceMap.get(link.getThirdSourceId()));
                }

                linkerArr.add(linkerJson);
            }
        }
    }

    private void fillSupLinkerInfo(JSONObject linkerJson, JSONObject erpLinkerJson) {
        if(StringUtils.isBlank(linkerJson.getString("ContactState")) && StringUtils.isNotBlank(erpLinkerJson.getString("ContactState"))) {
            linkerJson.put("ContactState", erpLinkerJson.getString("ContactState"));
        }
        if(StringUtils.isBlank(linkerJson.getString("AuthorFlag")) && StringUtils.isNotBlank(erpLinkerJson.getString("AuthorFlag"))) {
            linkerJson.put("AuthorFlag", erpLinkerJson.getString("AuthorFlag"));
        }
        if(StringUtils.isBlank(linkerJson.getString("ServerArea")) && StringUtils.isNotBlank(erpLinkerJson.getString("ServerArea"))) {
            linkerJson.put("ServerArea", erpLinkerJson.getString("ServerArea"));
        }
        if(StringUtils.isBlank(linkerJson.getString("Position")) && StringUtils.isNotBlank(erpLinkerJson.getString("Position"))) {
            linkerJson.put("Position", erpLinkerJson.getString("Position"));
        }
        if(StringUtils.isBlank(linkerJson.getString("Industry")) && StringUtils.isNotBlank(erpLinkerJson.getString("Industry"))) {
            linkerJson.put("Industry", erpLinkerJson.getString("Industry"));
        }
        if(StringUtils.isBlank(linkerJson.getString("lable")) && StringUtils.isNotBlank(erpLinkerJson.getString("lable"))) {
            linkerJson.put("lable", erpLinkerJson.getString("lable"));
        }
        if(StringUtils.isBlank(linkerJson.getString("ContactType")) && StringUtils.isNotBlank(erpLinkerJson.getString("ContactType"))) {
            linkerJson.put("ContactType", erpLinkerJson.getString("ContactType"));
        }
    }

    @Override
    public void syncSupplierErpSid(Long supplierId) {
        SupplierSyncParam syncParam = new SupplierSyncParam();
        syncParam.setHandleServiceName("matSupplierService");
        syncParam.setSupplierId(supplierId);
        syncParam.setDelaySeconds(0);
        syncParam.setRetry(false);
        supplierSync(syncParam);
    }

    @Override
    public JSONObject getSupErpInfo(Long supplierId) {
        logger.info("查询供应商id-{}ERP信息", supplierId);
        MatSupplierEntity supplier = super.selectById(supplierId);
        String reqUrl = ZDSReqUtil.getErpReqHost() + ERP_MAT_SUPPLIER_UPDATE_URL +
                (StringUtils.isBlank(supplier.getThirdSourceId()) ? supplier.getId() : supplier.getThirdSourceId());
        String reqResp = null;
        try {
            Map<String, Object> param = new HashMap<>();
            Map<String, String> headers = ZDSReqUtil.getErpHeaders();
            reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(param), headers,
                    ZDSReqUtil.CONN_TIME_OUT, ZDSReqUtil.READ_TIME_OUT);

            logger.error("请求中电四获取供应商结果返回成功：请求地址-{},参数-{},header-{},结果-{}", reqUrl, JSONObject.toJSONString(param),
                    JSONObject.toJSONString(headers), reqResp);
            return JSONObject.parseObject(reqResp);
        } catch (Exception e) {
            logger.error("查询供应商ERP信息失败", e);
        }

        JSONObject resp = new JSONObject();
        resp.put("erpResult", reqResp);
        resp.put("status", "false");
        return resp;
    }

    @Override
    public boolean supplierSync(SupplierSyncParam supplierSyncParam) {
        try {
            if(null != supplierSyncParam.getDelaySeconds() && supplierSyncParam.getDelaySeconds() > 0) {
                TimeUnit.SECONDS.sleep(supplierSyncParam.getDelaySeconds());
                logger.info("********************更新供应商：id-{}信息，{}s后开始执行********************", supplierSyncParam.getSupplierId(), supplierSyncParam.getDelaySeconds());
            }
        }  catch (InterruptedException e) {
           logger.error("更新供应商：id-{}信息延迟{}秒异常", supplierSyncParam.getSupplierId(), supplierSyncParam.getDelaySeconds(), e);
        }

        logger.info("********************更新供应商：id-{}信息开始********************", supplierSyncParam.getSupplierId());

        MatSupplierEntity supplier = super.selectById(supplierSyncParam.getSupplierId());

        Map<String, Object> param = new HashMap<>();
        String reqUrl = ZDSReqUtil.getErpReqHost() + ERP_MAT_SUPPLIER_UPDATE_URL +
                (null != supplier.getAccessId() ? supplier.getId() : supplier.getThirdSourceId());
        JSONObject reqJson = null;
        JSONArray pageData = null;

        Map<String, String> linkerMap = new HashMap<>();
        Map<String, String> bankMap = new HashMap<>();
        Map<String, String> attachMap = new HashMap<>();
        Map<String, String> materialMap = new HashMap<>();

        SupplierSyncParam syncParam = new SupplierSyncParam();
        syncParam.setSupplierId(supplierSyncParam.getSupplierId());
        syncParam.setHandleServiceName("matSupplierService");
        String queueName = SupplierSyncParam.ERP_SUPPLIER_UPD_QUEUE+"_"+profile;

        try {
            Map<String, String> headers = ZDSReqUtil.getErpHeaders();
            String reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(param), headers,
                    ZDSReqUtil.CONN_TIME_OUT, ZDSReqUtil.READ_TIME_OUT);
            reqJson = JSONObject.parseObject(reqResp);

            if ("ok".equals(reqJson.getString("status"))) {
                logger.error("请求中电四获取物资供应商结果返回成功：请求地址-{},参数-{},header-{},结果-{}", reqUrl,
                        JSONObject.toJSONString(param), JSONObject.toJSONString(headers), JSONObject.toJSONString(reqJson, SerializerFeature.PrettyFormat));

                boolean updateSucFlag = true;
                pageData = reqJson.getJSONArray("MESupplierList");
                if(null == pageData || pageData.size() == 0) {
                    logger.info("同步ERP供应商信息失败，根据供应商SID-{}查询ERP信息为空！");
                    if(!BooleanUtils.isFalse(supplierSyncParam.getRetry())) {
                        sendMq(queueName, JSONObject.toJSONString(supplierSyncParam));
                    }
                    return false;
                }
                JSONObject supplierJson = (JSONObject) pageData.get(0);
                String supplierSid = supplierJson.getString("C_PS_MESupplierInfoOID");
                if(StringUtil.isBlank(supplierSid)) {
                    logger.info("同步ERP供应商信息失败，ERP供应商SID为空:{}",JSONObject.toJSONString(pageData, SerializerFeature.PrettyFormat));
                    if(!BooleanUtils.isFalse(supplierSyncParam.getRetry())) {
                        sendMq(queueName, JSONObject.toJSONString(supplierSyncParam));
                    }
                    return false;
                }
                if(StringUtil.isNotBlank(supplierSid) && StringUtil.isBlank(supplier.getThirdSourceId())) {
                    supplier.setThirdSourceId(supplierSid);
                }

                //供应商联系人
                if(null != reqJson.get("ContactList") && reqJson.getJSONArray("ContactList").size() > 0) {
                    handleLinker(linkerMap, reqJson.getJSONArray("ContactList"));
                }
                if(CollectionUtils.isNotEmpty(supplier.getLinkerList())) {
                    for(MatLinkerEntity linker : supplier.getLinkerList()) {
                        if(StringUtil.isNotBlank(linker.getThirdSourceId())) {
                            continue;
                        }
                        if(linkerMap.containsKey(linker.getId().toString())) {
                            linker.setThirdSourceId(linkerMap.get(linker.getId().toString()));
                            logger.info("更新联系人id-{}， SID-{}",linker.getId(), linker.getThirdSourceId());
                        } else {
                            updateSucFlag = false;
                        }
                    }
                }
                if(!updateSucFlag) {
                    logger.info("供应商：id-{} ERP供应商联系人信息不匹配:{}",supplier.getId(), JSONObject.toJSONString(linkerMap, SerializerFeature.PrettyFormat));
                }

                updateSucFlag = true;
                //供应商附件信息
                if(null != reqJson.get("ArchivesList") && reqJson.getJSONArray("ArchivesList").size() > 0) {
                    handleArchive(attachMap, reqJson.getJSONArray("ArchivesList"));
                }
                if(CollectionUtils.isNotEmpty(supplier.getAttachesList())) {
                    for(MatSupplierAttachesEntity attach : supplier.getAttachesList()) {
                        if(null == attach.getFileId() || StringUtil.isNotBlank(attach.getThirdSourceId())) {
                            continue;
                        }
                        if(attachMap.containsKey(attach.getId().toString())) {
                            attach.setThirdSourceId(attachMap.get(attach.getId().toString()));
                            logger.info("更新附件id-{}， SID-{}",attach.getId(), attach.getThirdSourceId());
                        } else {
                            updateSucFlag = false;
                        }
                    }
                }
                if(!updateSucFlag) {
                    logger.info("供应商：id-{} ERP供应商附件信息不匹配:{}",supplier.getId(), JSONObject.toJSONString(attachMap, SerializerFeature.PrettyFormat));
                }

                updateSucFlag = true;
                //供应商银行信息
                if(null != reqJson.get("BankList") && reqJson.getJSONArray("BankList").size() > 0) {
                    handleBank(bankMap, reqJson.getJSONArray("BankList"));
                }
                if(CollectionUtils.isNotEmpty(supplier.getBankList())) {
                    for(MatSupplierBankEntity bank : supplier.getBankList()) {
                        if(StringUtil.isNotBlank(bank.getBankThirdSourceId())) {
                            continue;
                        }
                        if(bankMap.containsKey(bank.getId().toString())) {
                            bank.setBankThirdSourceId(bankMap.get(bank.getId().toString()));
                            logger.info("更新银行id-{}， SID-{}",bank.getId(), bank.getBankThirdSourceId());
                        } else if(bankMap.containsKey(bank.getBankNumber())) {
                            bank.setBankThirdSourceId(bankMap.get(bank.getBankNumber()));
                            logger.info("更新银行id-{}， SID-{}",bank.getId(), bank.getBankThirdSourceId());
                        } else {
                            updateSucFlag = false;
                            logger.error("*********供应商项银行信息id-{}在ERP中无匹配信息*********", bank.getId());
                        }
                    }
                }
                if(!updateSucFlag) {
                    logger.info("****************供应商：id-{} ERP供应商银行信息不匹配:{}****************",
                            supplier.getId(), JSONObject.toJSONString(bankMap, SerializerFeature.PrettyFormat));
                }

                updateSucFlag = true;
                //供货内容信息
                if(null != reqJson.get("SupplyList") && reqJson.getJSONArray("SupplyList").size() > 0) {
                    handleMaterialInfo(materialMap, reqJson.getJSONArray("SupplyList"));
                }
                if(CollectionUtils.isNotEmpty(supplier.getMaterialInfoList())) {
                    for(MatSupplierMaterialInfoEntity material : supplier.getMaterialInfoList()) {
                        if(StringUtil.isNotBlank(material.getInfoThirdSourceId())) {
                            continue;
                        }
                        if(materialMap.containsKey(material.getId().toString())) {
                            material.setInfoThirdSourceId(materialMap.get(material.getId().toString()));
                            logger.info("更新供货内容id-{}， SID-{}",material.getId(), material.getInfoThirdSourceId());
                        } else {
                            updateSucFlag = false;
                            logger.error("*********供应商供货内容信息id-{}在ERP中无匹配信息*********", material.getId());
                        }
                    }
                }
                if(!updateSucFlag) {
                    logger.info("****************供应商：id-{} ERP供应商供货内容信息不匹配:{}****************",
                            supplier.getId(), JSONObject.toJSONString(materialMap, SerializerFeature.PrettyFormat));
                }

                logger.info("更新供应商id-{}，name-{}ERP SID信息成功", supplier.getId(), supplier.getName());
                super.saveOrUpdate(supplier, false);

            } else {
                logger.error("请求中电四获取物资供应商结果返回失败：请求地址-{},参数-{},header-{},结果-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp);
                if(!BooleanUtils.isFalse(supplierSyncParam.getRetry())) {
                    sendMq(queueName, JSONObject.toJSONString(supplierSyncParam));
                }
            }

        } catch (Exception e) {
            logger.error("获取中电四物资供应商信息异常, 请求地址：{}, 请求参数：{}", reqUrl, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat), e);
            if(!BooleanUtils.isFalse(supplierSyncParam.getRetry())) {
                sendMq(queueName, JSONObject.toJSONString(supplierSyncParam));
            }
        }

        logger.info("********************更新供应商信息结束********************");
        return false;
    }

    private void handleMaterialInfo(Map<String, String> materialMap, JSONArray supplyList) {
        logger.info("本次待处理供应商-供货内容数据:{}条", supplyList.size());
        JSONObject tmpJson = null;
        for(Object obj : supplyList) {
            tmpJson = (JSONObject) obj;
            materialMap.put(StringUtils.isNotBlank(tmpJson.getString("YQL_SID")) ? tmpJson.getString("YQL_SID") :
                            tmpJson.getString("C_PS_MESupplierInfo_SubDOID"),
                    tmpJson.getString("C_PS_MESupplierInfo_SubDOID"));
        }

    }

    private void handleBank(Map<String, String> bankMap, JSONArray bankList) {
        logger.info("本次待处理供应商-银行数据：{}条", bankList.size());
        JSONObject tmpBankJson = null;
        for(Object obj : bankList) {
            tmpBankJson = (JSONObject) obj;
            bankMap.put(StringUtils.isNotBlank(tmpBankJson.getString("YQL_SID")) ? tmpBankJson.getString("YQL_SID") :
                            tmpBankJson.getString("C_PS_MESupplierInfo_SubBOID"),
                    tmpBankJson.getString("C_PS_MESupplierInfo_SubBOID"));
            bankMap.put(tmpBankJson.getString("Contact_BankAccount"), tmpBankJson.getString("C_PS_MESupplierInfo_SubBOID"));
        }
    }

    private void handleArchive(Map<String, String> attachMap, JSONArray archivesList) {
        logger.info("本次待处理供应商-附件数据：{}条", archivesList.size());
        JSONObject tmpAttachJson = null;

        for(Object obj : archivesList) {
            tmpAttachJson = (JSONObject) obj;
            attachMap.put(StringUtils.isNotBlank(tmpAttachJson.getString("YQL_SID")) ? tmpAttachJson.getString("YQL_SID") :
                            tmpAttachJson.getString("C_PS_ArchivesOID"),
                    tmpAttachJson.getString("C_PS_ArchivesOID"));
        }
    }

    private void handleLinker(Map<String, String> linkerMap, JSONArray contactList) {
        logger.info("本次待处理供应商-联系人数据：{}条", contactList.size());
        JSONObject tmpLinkerJson = null;

        for(Object obj : contactList) {
            tmpLinkerJson = (JSONObject) obj;

            linkerMap.put(StringUtils.isNotBlank(tmpLinkerJson.getString("YQL_SID")) ? tmpLinkerJson.getString("YQL_SID") :
                            tmpLinkerJson.getString("subA_oid"),
                    tmpLinkerJson.getString("subA_oid"));
        }
    }
}
