package com.ejianc.business.zdssupplier.sub.controller;

import java.io.Serializable;

import com.ejianc.business.zdssupplier.common.utils.CoordinationUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.sub.bean.SupplierEntity;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.zdssupplier.sub.bean.LinkerEntity;
import com.ejianc.business.zdssupplier.sub.service.ILinkerService;
import com.ejianc.business.zdssupplier.sub.vo.LinkerVO;

/**
 * 分包联系人档案
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("linker")
public class LinkerController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZDS_SUB_LINKER";//此处需要根据实际修改

    @Autowired
    private ILinkerService service;

    @Autowired
    private ISupplierService supplierService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private CoordinationUtil coordinationUtil;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<LinkerVO> saveOrUpdate(@RequestBody LinkerVO saveOrUpdateVO) {
    	LinkerVO vo = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LinkerVO> queryDetail(Long id) {
    	LinkerEntity entity = service.selectById(id);
    	LinkerVO vo = BeanMapper.map(entity, LinkerVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LinkerVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (LinkerVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(LinkerVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<LinkerVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("supplierCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("name");
        fuzzyFields.add("idCardId");
        fuzzyFields.add("mobileLinkPhone");
        fuzzyFields.add("electronicMail");
        fuzzyFields.add("address");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("date_type", new Parameter(QueryParam.EQ, 0));

//        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
//        UserContext userContextCache =sessionManager.getUserContext();
//        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
//        String authOrgIds = userContextCache.getAuthOrgIds();
//        List<OrgVO> orgVOList = null;
//        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
//        }else {//pc端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
//        }
//        //普通组织 id
//        List<Long> commonOrgIds = new ArrayList<>();
//        //项目部 id
//        List<Long> departmentIds = new ArrayList<>();
//        orgVOList.stream().forEach(org -> {
//            if(5 == org.getOrgType()) {
//                //项目部
//                departmentIds.add(org.getId());
//            } else {
//                //普通组织
//                commonOrgIds.add(org.getId());
//            }
//        });
//        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
//        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
//            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
//        }
//        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<LinkerEntity> page = service.queryPage(param,false);
        IPage<LinkerVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), LinkerVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<LinkerVO>> resp = this.queryList(param);
        List<LinkerVO> list = resp.getData().getRecords();
        list.forEach(vo->{
            vo.setIdCardTypeName(PlanConstant.ID_CARD_TYPE.get(vo.getIdCardType()));
            vo.setLinkerMarkName(PlanConstant.LINKER_MARK.get(vo.getLinkerMark()));
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Linker-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refLinkerData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<LinkerVO>> refLinkerData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("date_type", new Parameter(QueryParam.EQ, 0));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("supplierId")) {
                param.getParams().put("supplierId", new Parameter(QueryParam.EQ, String.valueOf(_con.get("supplierId"))));
            }
        }
        param.getOrderMap().put("create_time", QueryParam.DESC);
        IPage<LinkerEntity> page = service.queryPage(param,false);
        IPage<LinkerVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), LinkerVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 供方查询详情
     * @param request
     * @return
     */
    @RequestMapping(value = "/queryDetailBill", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<LinkerVO> queryDetailBill(HttpServletRequest request){
        return service.queryDetailBill(request);
    }

    /**
     * 联系人生成协同账号
     * @param linkerVO
     * @return
     */
    @PostMapping(value = "/accCoordination")
    @ResponseBody
    public CommonResponse<LinkerVO> accCoordination(@RequestBody LinkerVO linkerVO) {
        LinkerEntity linker = service.selectById(linkerVO.getId());
        // 查询分包商是否协同
        SupplierEntity supplier = supplierService.selectById(linker.getSupplierId());
        if(!PlanConstant.STRING_YES.equals(supplier.getCoordination())) {
            // 分包商为生成协同租户，则先创建协同租户
            supplierService.createSupTenant(supplier);
        }
        LinkerVO vo = service.createSupAccount(linker, supplier.getTenant());
        return CommonResponse.success("查询成功", vo);
    }

    /**
     * 更新联系人启用/停用状态
     * @param vo
     * @return
     */
    @PostMapping(value = "/updateEnableStatus")
    @ResponseBody
    public CommonResponse<Boolean> updateEnableStatus(@RequestBody LinkerVO vo) {
        LinkerEntity entity = service.selectById(vo.getId());
        entity.setEnableStatus(vo.getEnableStatus());

        JSONObject params = new JSONObject();
        params.put("userId", entity.getSupUserId());
        params.put("tenantId", entity.getTenant());
        params.put("accRole", PlanConstant.分包联系人);
        params.put("accRoleCheck", true);
        params.put("supplierId", entity.getSupplierId());
        if(1 == vo.getEnableStatus() && "1".equals(entity.getCoordination())){
            coordinationUtil.addUserAccRole(params);// 启用
        } else if(2 == vo.getEnableStatus() && "1".equals(entity.getCoordination())){
            coordinationUtil.removeUserAccRole(params);// 停用
        }
        service.saveOrUpdate(entity, false);
        return CommonResponse.success("更新成功", true);
    }
}
