package com.ejianc.business.zdssupplier.utils.enterprise.dispatch;

import com.ejianc.business.zdssupplier.utils.enterprise.processor.ICompanyCheckProcessor;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author CJ
 * @Description:
 * @date 2024/3/18 14:03
 */
public class CompanyCheckFactory {

    private static final Logger logger = LoggerFactory.getLogger(CompanyCheckFactory.class);

    public CompanyCheckFactory() {
    }
    public static ICompanyCheckProcessor getInstance(String checkType) throws BusinessException {
        ICompanyCheckProcessor processor = ContextUtil.getBean(checkType, ICompanyCheckProcessor.class);
        if(null == processor) {
            logger.error("没有配置与{}对应的企业信息获取实现。请检查企业信息获取实现配置，或者传入的企业信息获取类型有误!", checkType);
            throw new BusinessException("没有配置与"+checkType+"企业信息获取实现。请检查企业信息获取实现配置，或者传入的企业信息获取类型有误");
        }
        return processor;
    }

}
