package com.ejianc.business.zdssupplier.utils.enterprise.dispatch;

import com.ejianc.business.zdssupplier.common.service.ISupplierSyncErpService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author CJ
 * @Description:
 * @date 2024/4/24 15:00
 */
public class SupplierSyncFactory {

    private static final Logger logger = LoggerFactory.getLogger(SupplierSyncFactory.class);

    public SupplierSyncFactory() {
    }
    public static ISupplierSyncErpService getInstance(String handleService) throws BusinessException {
        ISupplierSyncErpService service = ContextUtil.getBean(handleService, ISupplierSyncErpService.class);
        if(null == service) {
            logger.error("没有配置与{}对应的供应商同步实现。请检查供应商同步实现配置，或者传入的供应商同步处理服务有误!", handleService);
            throw new BusinessException("没有配置与"+handleService+"供应商同步实现。请检查供应商同步实现配置，或者传入的供应商同步服务有误");
        }
        return service;
    }

}
