package com.ejianc.business.zdssupplier.utils.enterprise.vo;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2024/3/13 17:15
 */
public class BaseCompanyInfoVO implements Serializable {

    private static final long serialVersionUID = 3298819746534681731L;

    private String name; //企业名称
    private String socialCreditCode; //统一社会信用代码
    private String businessStatus; //企业经营状态
    private String registeredCapitalStr; //注册资本（文本）
    private BigDecimal registeredCapital; //注册资本
    private String paidCapitalStr; //实缴金额（文本）
    private BigDecimal paidCapital; //实缴金额
    private String legalPerson; //法人
    private String businessScope; //经营范围
    private String registeredAddress; // 注册地址
    private String industry; //行业
    private String companyType; //企业类型
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date businessStartDate; //经营起始日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date businessEndDate; // 经营终止日期
    private Integer legalType; //法人类型：1人 2公司
    private String bondName; //股票名

    List certiList = new ArrayList<>();

    public <T extends BaseCertificateVO> List<T> getCertiList() {
        return certiList;
    }

    public <T extends BaseCertificateVO> void setCertiList(List<T> certiList) {
        this.certiList = certiList;
    }

    public String getIndustry() {
        return industry;
    }

    public void setIndustry(String industry) {
        this.industry = industry;
    }

    public String getCompanyType() {
        return companyType;
    }

    public void setCompanyType(String companyType) {
        this.companyType = companyType;
    }

    public Date getBusinessStartDate() {
        return businessStartDate;
    }

    public void setBusinessStartDate(Date businessStartDate) {
        this.businessStartDate = businessStartDate;
    }

    public Date getBusinessEndDate() {
        return businessEndDate;
    }

    public void setBusinessEndDate(Date businessEndDate) {
        this.businessEndDate = businessEndDate;
    }

    public Integer getLegalType() {
        return legalType;
    }

    public void setLegalType(Integer legalType) {
        this.legalType = legalType;
    }

    public String getBondName() {
        return bondName;
    }

    public void setBondName(String bondName) {
        this.bondName = bondName;
    }

    public String getRegisteredAddress() {
        return registeredAddress;
    }

    public void setRegisteredAddress(String registeredAddress) {
        this.registeredAddress = registeredAddress;
    }

    public String getBusinessScope() {
        return businessScope;
    }

    public void setBusinessScope(String businessScope) {
        this.businessScope = businessScope;
    }

    public String getLegalPerson() {
        return legalPerson;
    }

    public void setLegalPerson(String legalPerson) {
        this.legalPerson = legalPerson;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSocialCreditCode() {
        return socialCreditCode;
    }

    public void setSocialCreditCode(String socialCreditCode) {
        this.socialCreditCode = socialCreditCode;
    }

    public String getBusinessStatus() {
        return businessStatus;
    }

    public void setBusinessStatus(String businessStatus) {
        this.businessStatus = businessStatus;
    }

    public String getRegisteredCapitalStr() {
        return registeredCapitalStr;
    }

    public void setRegisteredCapitalStr(String registeredCapitalStr) {
        this.registeredCapitalStr = registeredCapitalStr;
    }

    public BigDecimal getRegisteredCapital() {
        return registeredCapital;
    }

    public void setRegisteredCapital(BigDecimal registeredCapital) {
        this.registeredCapital = registeredCapital;
    }

    public String getPaidCapitalStr() {
        return paidCapitalStr;
    }

    public void setPaidCapitalStr(String paidCapitalStr) {
        this.paidCapitalStr = paidCapitalStr;
    }

    public BigDecimal getPaidCapital() {
        return paidCapital;
    }

    public void setPaidCapital(BigDecimal paidCapital) {
        this.paidCapital = paidCapital;
    }

}
