package com.ejianc.business.zdssupplier.utils.enterprise.vo.tyc;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdssupplier.utils.enterprise.vo.BaseCompanyInfoVO;
import com.ejianc.framework.core.kit.time.DateFormatUtil;

/**
 * @author CJ
 * @Description:
 * @date 2024/3/13 17:13
 */
public class TYCEnterpriseInfoVO extends BaseCompanyInfoVO {

    private static final long serialVersionUID = 4538936802419221186L;

    private String staffNumRange; //人员规模

    public String getStaffNumRange() {
        return staffNumRange;
    }

    public void setStaffNumRange(String staffNumRange) {
        this.staffNumRange = staffNumRange;
    }

    public static void transfer(TYCEnterpriseInfoVO resp, JSONObject dataJson) {
        resp.setName(dataJson.getString("name")); //企业名称
        resp.setStaffNumRange(dataJson.getString("staffNumRange")); //人员规模
        resp.setBondName(dataJson.getString("bondName")); //股票名
        resp.setLegalType(dataJson.getInteger("type")); //法人类型：1人 2公司
        resp.setBusinessStartDate(dataJson.getDate("fromTime"));
        try {
            resp.setBusinessEndDate(null != dataJson.getDate("toTime") ? dataJson.getDate("toTime") : DateFormatUtil.parseDate("yyyy-MM-dd", "2999-12-31"));
        } catch (Exception e) {
            e.printStackTrace();
        }
        resp.setBusinessScope(dataJson.getString("businessScope"));
        resp.setIndustry(dataJson.getString("industry"));
        resp.setLegalPerson(dataJson.getString("legalPersonName"));
        resp.setCompanyType(dataJson.getString("companyOrgType"));
        resp.setPaidCapitalStr(null!=dataJson.getString("actualCapital")?dataJson.getString("actualCapital"):"-");
        resp.setRegisteredCapitalStr(dataJson.getString("regCapital"));
        resp.setRegisteredAddress(dataJson.getString("regLocation"));
        resp.setBusinessStatus(dataJson.getString("regStatus"));
        resp.setSocialCreditCode(dataJson.getString("creditCode"));
    }
}
