/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zds.archive.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zds.archive.bean.AdministrativeAreaEntity;
import com.ejianc.business.zds.archive.service.IAdministrativeAreaService;
import com.ejianc.business.zds.archive.utils.ZdsReqUtil;
import com.ejianc.business.zds.archive.vo.AdministrativeAreaVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"administrativeArea"})
public class AdministrativeAreaController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAdministrativeAreaService service;
    private final String AREA_ERP_REQ_URL = "/cefoc/yql/getAreaList";

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AdministrativeAreaVO> queryDetail(Long id) {
        AdministrativeAreaEntity entity = (AdministrativeAreaEntity)((Object)this.service.selectById(id));
        AdministrativeAreaVO vo = (AdministrativeAreaVO)BeanMapper.map((Object)((Object)entity), AdministrativeAreaVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AdministrativeAreaVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AdministrativeAreaVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/refAdministrativeAreaData"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> refAdministrativeAreaData(@RequestParam(required=false) String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("longCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            param.setSearchText(searchText);
        }
        param.getOrderMap().put("sequence", "asc");
        param.getOrderMap().put("longCode", "asc");
        List list = this.service.queryList(param);
        List resultMapList = BeanMapper.mapList((Iterable)list, Map.class);
        return ResultAsTree.createTreeData((List)resultMapList);
    }

    @PostMapping(value={"/zdsAreaSync"})
    public CommonResponse<String> zdsAreaSync() {
        this.logger.info("*********************\u4e2d\u7535\u56db-\u884c\u653f\u5730\u533a\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u5f00\u59cb*********************");
        Integer pageNum = 0;
        Integer pageSize = Integer.valueOf(ZdsReqUtil.getErpDataBatchSize());
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        String reqUrl = ZdsReqUtil.getErpReqHost() + "/cefoc/yql/getAreaList";
        boolean hasNext = true;
        Map<String, String> headers = null;
        try {
            headers = ZdsReqUtil.getErpHeaders();
            param.put("PageSize", pageSize);
            JSONObject reqJson = null;
            JSONArray pageData = null;
            pageNum = pageNum + 1;
            param.put("PageNum", pageNum);
            String reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString(param), headers, (Integer)10000, (Integer)10000);
            reqJson = JSONObject.parseObject((String)reqResp);
            if ("ok".equals(reqJson.getString("status"))) {
                pageData = reqJson.getJSONArray("data");
                if (null != pageData && pageData.size() > 0) {
                    this.logger.info("\u4e2d\u7535\u56db\u884c\u653f\u5730\u533a\u540c\u6b65\uff0c\u5904\u7406\u7b2c{}\u9875, {}\u6761\u6570\u636e", (Object)pageNum, (Object)pageData.size());
                    this.handleErpPageData(pageData);
                } else {
                    this.logger.info("\u4e2d\u7535\u56db\u884c\u653f\u5730\u533a\u540c\u6b65 \u5904\u7406\u6570\u636e\u5b8c\u6210\uff01\uff01\uff01\u603b\u5171{}\u9875\u6570\u636e\uff01", (Object)pageNum);
                }
            } else {
                this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u884c\u653f\u5730\u533a\u7ed3\u679c\u8fd4\u56de\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp});
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4e2d\u7535\u56db\u884c\u653f\u5730\u533a\u4fe1\u606f\u5f02\u5e38, \u8bf7\u6c42\u5730\u5740\uff1a{}, \u8bf7\u6c42\u53c2\u6570\uff1a{}", new Object[]{reqUrl, JSONObject.toJSONString(param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), e});
            return CommonResponse.error((String)"\u540c\u6b65\u4e2d\u7535\u56db\u884c\u653f\u5730\u533a\u4fe1\u606f\u5f02\u5e38");
        }
        this.logger.info("*********************\u4e2d\u7535\u56db-\u884c\u653f\u5730\u533a\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u7ed3\u675f*********************");
        return CommonResponse.success((String)"\u4e2d\u7535\u56db\u884c\u653f\u5730\u533a\u540c\u6b65\u5b8c\u6210\uff01");
    }

    private void handleErpPageData(JSONArray pageData) {
        JSONObject tmp = null;
        AdministrativeAreaEntity tmpEntity = null;
        Map<Object, Object> sourceIdMap = new HashMap();
        HashMap<String, AdministrativeAreaEntity> dataMap = new HashMap<String, AdministrativeAreaEntity>();
        ArrayList<AdministrativeAreaEntity> saveList = new ArrayList<AdministrativeAreaEntity>();
        HashSet<String> sourceIds = new HashSet<String>();
        for (Object obj : pageData) {
            tmp = (JSONObject)obj;
            tmpEntity = new AdministrativeAreaEntity();
            tmpEntity.setId(IdWorker.getId());
            tmpEntity.setName(tmp.getString("Title"));
            tmpEntity.setSourceId(tmp.getString("C_SD_AreaOID"));
            tmpEntity.setEnabled("True".equals(tmp.getString("IsEnable")) ? "1" : "0");
            tmpEntity.setSequence(null != tmp.get((Object)"Sort_ID") ? tmp.getInteger("Sort_ID") : 1);
            tmpEntity.setMemo(null != tmp.getString("Memo") ? tmp.getString("Memo") : null);
            tmpEntity.setLongCode(tmp.getString("Long_code"));
            tmpEntity.setShortCode(tmp.getString("Short_code"));
            tmpEntity.setCode(tmp.getString("Title_ID"));
            if (StringUtils.isNotBlank((CharSequence)tmp.getString("C_SD_Area_FK")) && !"00000000-0000-0000-0000-000000000000".equals(tmp.getString("C_SD_Area_FK"))) {
                tmpEntity.setSourceParentId(tmp.getString("C_SD_Area_FK"));
                sourceIds.add(tmpEntity.getSourceParentId());
            }
            sourceIds.add(tmpEntity.getSourceId());
            dataMap.put(tmpEntity.getSourceId(), tmpEntity);
        }
        List<AdministrativeAreaEntity> dbListBySourceId = this.service.getAllBySourceIds(new ArrayList<String>(sourceIds));
        if (CollectionUtils.isNotEmpty(dbListBySourceId)) {
            sourceIdMap = dbListBySourceId.stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item));
        }
        AdministrativeAreaEntity saveEntity = null;
        AdministrativeAreaEntity parent = null;
        for (AdministrativeAreaEntity item2 : dataMap.values()) {
            if (sourceIdMap.containsKey(item2.getSourceId())) {
                saveEntity = (AdministrativeAreaEntity)((Object)sourceIdMap.get(item2.getSourceId()));
                saveEntity.setName(item2.getName());
                saveEntity.setEnabled(item2.getEnabled());
                saveEntity.setSequence(item2.getSequence());
                saveEntity.setMemo(item2.getMemo());
                saveEntity.setLongCode(item2.getLongCode());
                saveEntity.setShortCode(item2.getShortCode());
                saveEntity.setCode(item2.getCode());
                saveEntity.setSourceParentId(item2.getSourceParentId());
            } else {
                saveEntity = item2;
            }
            if (StringUtils.isNotBlank((CharSequence)item2.getSourceParentId())) {
                parent = (AdministrativeAreaEntity)((Object)sourceIdMap.get(item2.getSourceParentId()));
                if (null == parent) {
                    parent = (AdministrativeAreaEntity)((Object)dataMap.get(item2.getSourceParentId()));
                }
                if (null == parent) {
                    this.logger.error("\u5730\u533a-{}\uff0c\u7236\u7ea7\u5730\u533asid-{}\u4e0d\u5b58\u5728\uff0c\u4fdd\u5b58\u5931\u8d25", (Object)item2.getName(), (Object)item2.getSourceParentId());
                    continue;
                }
                saveEntity.setParentId(parent.getId());
            }
            saveList.add(saveEntity);
        }
        this.logger.info("\u672c\u6b21\u4fdd\u5b58\u6570\u636e-{}\u6761", (Object)saveList.size());
        this.service.saveOrUpdateBatch(saveList, saveList.size(), false);
    }
}

