/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zds.archive.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zds.archive.bean.BankCategoryEntity;
import com.ejianc.business.zds.archive.service.IBankCategoryService;
import com.ejianc.business.zds.archive.utils.ZdsReqUtil;
import com.ejianc.business.zds.archive.vo.BankCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"bankCategory"})
public class BankCategoryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBankCategoryService service;
    private final String BANK_CATEGORY_ERP_REQ_URL = "/cefoc/yql/getBankList";

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BankCategoryVO> queryDetail(Long id) {
        BankCategoryEntity entity = (BankCategoryEntity)((Object)this.service.selectById(id));
        BankCategoryVO vo = (BankCategoryVO)BeanMapper.map((Object)((Object)entity), BankCategoryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BankCategoryVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BankCategoryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/refBankCategoryData"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map> refBankCategoryData(@RequestParam(required=false) String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            param.setSearchText(searchText);
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("sequence", "asc");
        param.getOrderMap().put("code", "asc");
        List list = this.service.queryList(param);
        return BeanMapper.mapList((Iterable)list, Map.class);
    }

    @PostMapping(value={"/zdsBankCategorySync"})
    public CommonResponse<String> zdsBankCategorySync() {
        this.logger.info("*********************\u4e2d\u7535\u56db-\u94f6\u884c\u5206\u7c7b\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u5f00\u59cb*********************");
        Integer pageNum = 0;
        Integer pageSize = Integer.valueOf(ZdsReqUtil.getErpDataBatchSize());
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        String reqUrl = ZdsReqUtil.getErpReqHost() + "/cefoc/yql/getBankList";
        boolean hasNext = true;
        Map<String, String> headers = null;
        try {
            headers = ZdsReqUtil.getErpHeaders();
            param.put("PageSize", pageSize);
            JSONObject reqJson = null;
            JSONArray pageData = null;
            pageNum = pageNum + 1;
            param.put("PageNum", pageNum);
            String reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString(param), headers, (Integer)10000, (Integer)10000);
            reqJson = JSONObject.parseObject((String)reqResp);
            if ("ok".equals(reqJson.getString("status"))) {
                pageData = reqJson.getJSONArray("data");
                if (null != pageData && pageData.size() > 0) {
                    this.logger.info("\u4e2d\u7535\u56db\u94f6\u884c\u5206\u7c7b\u540c\u6b65\uff0c\u5904\u7406\u7b2c{}\u9875, {}\u6761\u6570\u636e", (Object)pageNum, (Object)pageData.size());
                    this.handleErpPageData(pageData);
                } else {
                    this.logger.info("\u4e2d\u7535\u56db\u94f6\u884c\u5206\u7c7b\u540c\u6b65 \u5904\u7406\u6570\u636e\u5b8c\u6210\uff01\uff01\uff01\u603b\u5171{}\u9875\u6570\u636e\uff01", (Object)pageNum);
                }
            } else {
                this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u94f6\u884c\u5206\u7c7b\u7ed3\u679c\u8fd4\u56de\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp});
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4e2d\u7535\u56db\u94f6\u884c\u5206\u7c7b\u4fe1\u606f\u5f02\u5e38, \u8bf7\u6c42\u5730\u5740\uff1a{}, \u8bf7\u6c42\u53c2\u6570\uff1a{}", new Object[]{reqUrl, JSONObject.toJSONString(param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), e});
            return CommonResponse.error((String)"\u540c\u6b65\u4e2d\u7535\u56db\u94f6\u884c\u5206\u7c7b\u4fe1\u606f\u5f02\u5e38");
        }
        this.logger.info("*********************\u4e2d\u7535\u56db-\u94f6\u884c\u5206\u7c7b\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u7ed3\u675f*********************");
        return CommonResponse.success((String)"\u4e2d\u7535\u56db\u94f6\u884c\u5206\u7c7b\u540c\u6b65\u5b8c\u6210\uff01");
    }

    private void handleErpPageData(JSONArray pageData) {
        JSONObject tmp = null;
        BankCategoryEntity tmpEntity = null;
        HashMap<String, BankCategoryEntity> sourceIdMap = new HashMap<String, BankCategoryEntity>();
        ArrayList<BankCategoryEntity> saveList = new ArrayList<BankCategoryEntity>();
        for (Object obj : pageData) {
            tmp = (JSONObject)obj;
            tmpEntity = new BankCategoryEntity();
            tmpEntity.setName(tmp.getString("Title"));
            tmpEntity.setSourceId(tmp.getString("C_SD_BankInfoOID"));
            tmpEntity.setCode(tmp.getString("Title_ID"));
            tmpEntity.setEnabled(StringUtils.isNotBlank((CharSequence)tmp.getString("IsEnable")) ? ("true".equals(tmp.getString("IsEnable").toLowerCase()) ? "1" : "0") : null);
            tmpEntity.setSequence(null != tmp.get((Object)"Sort_ID") ? tmp.getInteger("Sort_ID") : 1);
            tmpEntity.setMemo(null != tmp.getString("Memo") ? tmp.getString("Memo") : null);
            tmpEntity.setSubBankCode(tmp.getString("SubBankCode"));
            sourceIdMap.put(tmpEntity.getSourceId(), tmpEntity);
        }
        List<BankCategoryEntity> dbListBySourceId = this.service.getAllBySourceIds(new ArrayList<String>(sourceIdMap.keySet()));
        if (CollectionUtils.isNotEmpty(dbListBySourceId)) {
            for (BankCategoryEntity dbEntity : dbListBySourceId) {
                tmpEntity = (BankCategoryEntity)((Object)sourceIdMap.get(dbEntity.getSourceId()));
                dbEntity.setName(tmpEntity.getName());
                dbEntity.setEnabled(tmpEntity.getEnabled());
                dbEntity.setSequence(tmpEntity.getSequence());
                dbEntity.setMemo(tmpEntity.getMemo());
                dbEntity.setCode(tmpEntity.getCode());
                dbEntity.setSubBankCode(tmpEntity.getSubBankCode());
                saveList.add(dbEntity);
                sourceIdMap.remove(dbEntity.getSourceId());
            }
        }
        if (!sourceIdMap.isEmpty()) {
            saveList.addAll(sourceIdMap.values());
        }
        this.logger.info("\u672c\u6b21\u4fdd\u5b58\u6570\u636e-{}\u6761", (Object)saveList.size());
        this.service.saveOrUpdateBatch(saveList, saveList.size(), false);
    }
}

