/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdssupplier.common.utils.CoordinationUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierEntity;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierService;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"matLinker"})
public class MatLinkerController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ZDS_MAT_LINKER";
    @Autowired
    private IMatLinkerService service;
    @Autowired
    private IMatSupplierService supplierService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private CoordinationUtil coordinationUtil;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MatLinkerVO> saveOrUpdate(@RequestBody MatLinkerVO saveOrUpdateVO) {
        MatLinkerVO vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MatLinkerVO> queryDetail(Long id) {
        MatLinkerEntity entity = (MatLinkerEntity)((Object)this.service.selectById(id));
        MatLinkerVO vo = (MatLinkerVO)BeanMapper.map((Object)((Object)entity), MatLinkerVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MatLinkerVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MatLinkerVO matLinkerVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MatLinkerVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("supplierCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("name");
        fuzzyFields.add("idCardId");
        fuzzyFields.add("mobileLinkPhone");
        fuzzyFields.add("electronicMail");
        fuzzyFields.add("address");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("date_type", new Parameter("eq", (Object)0));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MatLinkerVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<MatLinkerVO>> resp = this.queryList(param);
        List list = ((IPage)resp.getData()).getRecords();
        list.forEach(vo -> {
            vo.setIdCardTypeName((String)PlanConstant.ID_CARD_TYPE.get(vo.getIdCardType()));
            vo.setLinkerMarkName((String)PlanConstant.LINKER_MARK.get(vo.getLinkerMark()));
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MatLinker-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMatLinkerData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MatLinkerVO>> refMatLinkerData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("date_type", new Parameter("eq", (Object)0));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).containsKey((Object)"supplierId")) {
            param.getParams().put("supplierId", new Parameter("eq", (Object)String.valueOf(_con.get((Object)"supplierId"))));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MatLinkerVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryDetailBill"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MatLinkerVO> queryDetailBill(HttpServletRequest request) {
        return this.service.queryDetailBill(request);
    }

    @PostMapping(value={"/accCoordination"})
    @ResponseBody
    public CommonResponse<MatLinkerVO> accCoordination(@RequestBody MatLinkerVO linkerVO) {
        MatLinkerEntity linker = (MatLinkerEntity)((Object)this.service.selectById(linkerVO.getId()));
        MatSupplierEntity supplier = (MatSupplierEntity)((Object)this.supplierService.selectById(linker.getSupplierId()));
        if (!"1".equals(supplier.getCoordination())) {
            this.supplierService.createSupTenant(supplier);
        }
        MatLinkerVO vo = this.service.createSupAccount(linker, supplier.getTenant());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)vo);
    }

    @PostMapping(value={"/updateEnableStatus"})
    @ResponseBody
    public CommonResponse<Boolean> updateEnableStatus(@RequestBody MatLinkerVO vo) {
        MatLinkerEntity entity = (MatLinkerEntity)((Object)this.service.selectById(vo.getId()));
        entity.setEnableStatus(vo.getEnableStatus());
        JSONObject params = new JSONObject();
        params.put("userId", (Object)entity.getSupUserId());
        params.put("tenantId", (Object)entity.getTenant());
        params.put("accRole", (Object)"\u7269\u8d44\u8054\u7cfb\u4eba");
        params.put("accRoleCheck", (Object)true);
        params.put("supplierId", (Object)entity.getSupplierId());
        if (1 == vo.getEnableStatus() && "1".equals(entity.getCoordination())) {
            this.coordinationUtil.addUserAccRole(params);
        } else if (2 == vo.getEnableStatus() && "1".equals(entity.getCoordination())) {
            this.coordinationUtil.removeUserAccRole(params);
        }
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f", (Object)true);
    }
}

