/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.material.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.material.api.IZDSMatSupManagerApi;
import com.ejianc.business.zdsmaterial.material.vo.MatSupplierManagerVO;
import com.ejianc.business.zdssupplier.common.utils.EntityUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerAccessEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierMaterialInfoEntity;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerAccessService;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerInviteService;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierService;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerInviteVO;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierSyncErpParamVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="matLinkerAccess")
public class MatLinkerAccessBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String sourceBillType = BillTypeEnum.\u7269\u8d44\u8054\u7cfb\u4eba\u51c6\u5165.getCode();
    private static final String targetBillType = BillTypeEnum.\u7269\u8d44\u8054\u7cfb\u4eba\u6863\u6848.getCode();
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IMatLinkerAccessService service;
    @Autowired
    private IMatLinkerInviteService inviteService;
    @Autowired
    private IMatLinkerService linkerService;
    @Autowired
    private IMatSupplierService supplierService;
    @Autowired
    private IZDSMatSupManagerApi izdsMatSupManagerApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        Integer legalNum;
        MatLinkerAccessEntity entity = (MatLinkerAccessEntity)((Object)this.service.selectById(billId));
        MatSupplierEntity supplier = (MatSupplierEntity)((Object)this.supplierService.selectById(entity.getSupplierId()));
        if (PlanConstant.INTEGER_YES.equals(entity.getUserType()) && (legalNum = Integer.valueOf((int)supplier.getLinkerList().stream().filter(x -> PlanConstant.INTEGER_YES.equals(x.getUserType())).count())) > 0) {
            return CommonResponse.error((String)"\u8054\u7cfb\u4eba\u7c7b\u578b\u4e3a\u6cd5\u5b9a\u4ee3\u8868\u4eba\u6700\u591a\u53ea\u80fd\u6709\u4e00\u6761\uff01");
        }
        this.linkerService.validateUnique(entity.getName(), entity.getMobileLinkPhone());
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        MatLinkerAccessEntity entity = (MatLinkerAccessEntity)((Object)this.service.selectById(billId));
        MatLinkerInviteVO inviteVO = new MatLinkerInviteVO();
        inviteVO.setId(entity.getInviteId());
        inviteVO.setStatus("3");
        this.inviteService.updateBillStatus(inviteVO);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        MatLinkerAccessEntity entity = (MatLinkerAccessEntity)((Object)this.service.selectById(billId));
        MatLinkerInviteVO inviteVO = new MatLinkerInviteVO();
        inviteVO.setId(entity.getInviteId());
        inviteVO.setStatus("2");
        inviteVO.setFlowType("7");
        this.inviteService.updateBillStatus(inviteVO);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        Integer legalNum;
        MatLinkerAccessEntity entity = (MatLinkerAccessEntity)((Object)this.service.selectById(billId));
        MatSupplierEntity supplier = (MatSupplierEntity)((Object)this.supplierService.selectById(entity.getSupplierId()));
        if (PlanConstant.INTEGER_YES.equals(entity.getUserType()) && (legalNum = Integer.valueOf((int)supplier.getLinkerList().stream().filter(x -> PlanConstant.INTEGER_YES.equals(x.getUserType())).count())) > 0) {
            throw new BusinessException("\u8054\u7cfb\u4eba\u7c7b\u578b\u4e3a\u6cd5\u5b9a\u4ee3\u8868\u4eba\u6700\u591a\u53ea\u80fd\u6709\u4e00\u6761\uff01");
        }
        this.linkerService.validateUnique(entity.getName(), entity.getMobileLinkPhone());
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        MatLinkerAccessEntity entity = (MatLinkerAccessEntity)((Object)this.service.selectById(billId));
        Long linkerId = this.pushToArchive(entity);
        String msg = this.supplierService.syncSupplierChangeToErp(new SupplierSyncErpParamVO(entity.getSupplierId(), linkerId, "linkerAdd", billId, true, entity.getInviterId(), entity.getInviterName()));
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            throw new BusinessException(msg);
        }
        try {
            this.linkerService.createSupAccount(linkerId);
        }
        catch (Exception e) {
            this.logger.error("***********\u4f9b\u5e94\u5546id-{}\uff0c\u8054\u7cfb\u4eba\u51c6\u5165\u6210\u529f\uff0c\u63a8\u9001ERP\u6210\u529f\uff0c\u8054\u7cfb\u4ebaid-{}\u751f\u6210\u534f\u540c\u8d26\u53f7\u5931\u8d25\uff01\uff01\uff01", new Object[]{entity.getSupplierId(), linkerId, e});
        }
        MatLinkerInviteVO inviteVO = new MatLinkerInviteVO();
        inviteVO.setId(entity.getInviteId());
        inviteVO.setStatus("6");
        this.inviteService.updateBillStatus(inviteVO);
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public Long pushToArchive(MatLinkerAccessEntity entity) {
        MatLinkerVO save = EntityUtil.clearInvalidEntity(entity, MatLinkerVO.class);
        save.setAccessId(entity.getId());
        save.setLinkerStatus(Integer.valueOf(2));
        save.setEnableStatus(Integer.valueOf(1));
        save.setChangeVersion(Integer.valueOf(0));
        save.setDateType(Integer.valueOf(0));
        MatLinkerVO linker = this.linkerService.saveOrUpdate(save, "false", false);
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(entity.getId()), sourceBillType, "attachMgr", String.valueOf(linker.getId()), targetBillType, "attachMgr");
        String sourceType = entity.getUserType() == 2 ? "agentFile" : "legalPersonFile";
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(entity.getId()), sourceBillType, sourceType, String.valueOf(linker.getId()), targetBillType, sourceType);
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(entity.getId()), sourceBillType, "certify", String.valueOf(linker.getId()), targetBillType, "certify");
        return linker.getId();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u8be5\u5355\u636e\u4e0d\u5141\u8bb8\u5f03\u5ba1\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other) {
        JSONArray resp = new JSONArray();
        MatLinkerAccessEntity entity = (MatLinkerAccessEntity)((Object)this.service.selectById(billId));
        MatSupplierEntity supplier = (MatSupplierEntity)((Object)this.supplierService.selectById(entity.getSupplierId()));
        List<MatSupplierMaterialInfoEntity> msList = supplier.getMaterialInfoList();
        List categoryIds = msList.stream().map(MatSupplierMaterialInfoEntity::getMaterialId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(categoryIds)) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8054\u7cfb\u4eba\u6240\u5c5e\u4f9b\u5e94\u5546\u4e0b\u4f9b\u8d27\u5185\u5bb9\u7684\u7269\u8d44\u5206\u7c7b\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u5bf9\u5e94\u5ba1\u6838\u4eba\u4fe1\u606f\uff01");
        }
        CommonResponse settingResp = this.izdsMatSupManagerApi.getAllByCategoryIds(categoryIds);
        if (!settingResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u7269\u6599\u5206\u7c7bids-{}\u83b7\u53d6\u5bf9\u5e94\u5ba1\u6838\u4eba\u4fe1\u606f\u5931\u8d25\uff0c{}", categoryIds, (Object)JSONObject.toJSONString((Object)settingResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            return CommonResponse.error((String)"\u83b7\u53d6\u4f9b\u5e94\u5546\u5ba1\u6838\u4eba\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List settingList = (List)settingResp.getData();
        if (CollectionUtils.isNotEmpty((Collection)settingList)) {
            for (MatSupplierManagerVO m : settingList) {
                JSONObject obj = new JSONObject();
                obj.put("userId", (Object)m.getManagerId());
                obj.put("userName", (Object)m.getManagerName());
                resp.add((Object)obj);
            }
        }
        if (resp.size() == 0) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8054\u7cfb\u4eba\u6240\u5c5e\u4f9b\u5e94\u5546\u7684\u4f9b\u8d27\u5185\u5bb9\u7684\u7269\u8d44\u5206\u7c7b\u672a\u8bbe\u7f6e\u5ba1\u6838\u4eba\u4fe1\u606f\uff01");
        }
        return CommonResponse.success((Object)resp);
    }
}

