/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdssupplier.common.utils.EntityUtil;
import com.ejianc.business.zdssupplier.common.utils.ParamUtil;
import com.ejianc.business.zdssupplier.common.utils.PushSupUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerAccessEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierAccessAttachesEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierAccessEntity;
import com.ejianc.business.zdssupplier.material.mapper.MatSupplierAccessMapper;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerAccessService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierAccessService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierInviteService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierService;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierAccessVO;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierInviteVO;
import com.ejianc.business.zdssupplier.utils.enterprise.dispatch.CompanyCheckFactory;
import com.ejianc.business.zdssupplier.utils.enterprise.vo.BaseCompanyInfoVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="matSupplierAccessService")
public class MatSupplierAccessServiceImpl
extends BaseServiceImpl<MatSupplierAccessMapper, MatSupplierAccessEntity>
implements IMatSupplierAccessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_TYPE = BillTypeEnum.\u7269\u8d44\u4f9b\u5e94\u5546\u51c6\u5165.getCode();
    private static final String BILL_NAME = BillTypeEnum.\u7269\u8d44\u4f9b\u5e94\u5546\u51c6\u5165.getName();
    private static final String BILL_CODE = "ZDS_MAT_SUPPLIER_ACCESS";
    private static final String SYNC_SUPP_DETAIL_BILL_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/matSupplierAccess/syncDetailBill";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private PushSupUtil pushSupUtil;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMatSupplierInviteService inviteService;
    @Autowired
    private IMatSupplierService supplierService;
    @Autowired
    private IMatLinkerAccessService linkerService;

    @Override
    public MatSupplierAccessVO saveOrUpdate(MatSupplierAccessVO saveOrUpdateVO) {
        MatSupplierAccessEntity entity = (MatSupplierAccessEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MatSupplierAccessEntity.class));
        this.linkerService.validateUnique(entity.getLinkerList());
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCode((String)billCode.getData());
            entity.setSourceType(PlanConstant.SOURCE_TYPE_EL.toString());
            entity.setInviterId(InvocationInfoProxy.getUserid());
            entity.setInviterName(this.sessionManager.getUserContext().getUserName());
        }
        this.updateAttachList(entity);
        super.saveOrUpdate((Object)entity, false);
        return (MatSupplierAccessVO)BeanMapper.map((Object)((Object)entity), MatSupplierAccessVO.class);
    }

    private void updateAttachList(MatSupplierAccessEntity entity) {
        Map nameMap = PlanConstant.matCompanyAttachNameMap;
        if ("1".equals(entity.getCompanyCharacter())) {
            nameMap = PlanConstant.pdCompanyAttachNameMap;
        }
        Map finalNameMap = nameMap;
        List<MatSupplierAccessAttachesEntity> attachList = entity.getAttachesList();
        if (attachList.stream().noneMatch(x -> finalNameMap.keySet().contains(x.getFileType()))) {
            for (String name : nameMap.keySet()) {
                MatSupplierAccessAttachesEntity vo = new MatSupplierAccessAttachesEntity();
                vo.setFileType(name);
                vo.setType("\u4f01\u4e1a");
                vo.setSourceType(PlanConstant.SOURCE_TYPE_SUPPLIER);
                attachList.add(vo);
            }
        } else {
            for (MatSupplierAccessAttachesEntity vo : attachList) {
                if (vo.getFileType().startsWith("\u8d44\u8d28\u7c7b\u8bc1\u4e66\uff08\u6709\u8d44\u8d28\u7684\uff0c\u5fc5\u987b\u4e0a\u4f20\u76d6\u516c\u7ae0\u7248\u8d44\u8d28\u6587\u4ef6\u626b\u63cf\u4ef6\uff09")) {
                    StringBuilder fileType = new StringBuilder();
                    fileType.append("\u8d44\u8d28\u7c7b\u8bc1\u4e66\uff08\u6709\u8d44\u8d28\u7684\uff0c\u5fc5\u987b\u4e0a\u4f20\u76d6\u516c\u7ae0\u7248\u8d44\u8d28\u6587\u4ef6\u626b\u63cf\u4ef6\uff09");
                    if ("1".equals(entity.getCompanyCharacter())) {
                        fileType.append("\u5b89\u73af\u8ba4\u8bc1\u4f53\u7cfb\u3001\u8d28\u91cf\u8ba4\u8bc1\u4f53\u7cfb");
                    }
                    vo.setFileType(fileType.toString());
                }
                if (!vo.getFileType().equals("\u751f\u4ea7\u5546\u51fa\u5177\u7684\u6388\u6743\u6587\u4ef6") || !"1".equals(entity.getCompanyCharacter())) continue;
                vo.setRowState("del");
            }
            if (!"1".equals(entity.getCompanyCharacter()) && attachList.stream().noneMatch(x -> "\u751f\u4ea7\u5546\u51fa\u5177\u7684\u6388\u6743\u6587\u4ef6".equals(x.getFileType()))) {
                MatSupplierAccessAttachesEntity vo = new MatSupplierAccessAttachesEntity();
                vo.setFileType("\u751f\u4ea7\u5546\u51fa\u5177\u7684\u6388\u6743\u6587\u4ef6");
                vo.setType("\u4f01\u4e1a");
                vo.setSourceType(PlanConstant.SOURCE_TYPE_SUPPLIER);
                attachList.add(vo);
            }
        }
    }

    @Override
    public Long saveSyncBill(HttpServletRequest request) {
        Long fileId;
        String transData = request.getParameter("transData");
        MatSupplierAccessEntity saveEntity = (MatSupplierAccessEntity)((Object)JSONObject.parseObject((String)transData, MatSupplierAccessEntity.class));
        QueryParam param = new QueryParam();
        param.getParams().put("inviteId", new Parameter("eq", (Object)saveEntity.getInviteId()));
        List list = super.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u8be5\u9080\u8bf7\u94fe\u63a5\u5df2\u751f\u6210\u51c6\u5165\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210\uff01");
        }
        this.linkerService.validateUnique(saveEntity.getLinkerList());
        Long id = this.pushSupUtil.saveSyncBill(request, MatSupplierAccessEntity.class, BILL_TYPE, BILL_NAME);
        if (null == id) {
            throw new BusinessException("\u540c\u6b65\u6570\u636e\u5f02\u5e38\uff01");
        }
        MatSupplierAccessEntity entity = (MatSupplierAccessEntity)((Object)super.selectById((Serializable)id));
        entity.setCode(EntityUtil.createBillCode(entity, BILL_CODE));
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        List<MatLinkerAccessEntity> likerList = entity.getLinkerList();
        List<MatSupplierAccessAttachesEntity> attachList = entity.getAttachesList();
        for (MatLinkerAccessEntity liker : likerList) {
            fileId = null;
            ArrayList<Long> attachIds = new ArrayList<Long>();
            if (liker.getUserType() == 2) {
                fileId = this.pushSupUtil.uploadFileFormNet(BILL_TYPE, liker.getId(), "agentFile", Long.valueOf(liker.getAgencyFileId()));
                liker.setAgencyFileId(fileId.toString());
                attachIds.add(fileId);
                if (null != liker.getCertifyFileId()) {
                    Long certifyFileId = this.pushSupUtil.uploadFileFormNet(BILL_TYPE, liker.getId(), "certify", Long.valueOf(liker.getCertifyFileId()));
                    liker.setCertifyFileId(certifyFileId.toString());
                    attachIds.add(certifyFileId);
                }
            } else {
                fileId = this.pushSupUtil.uploadFileFormNet(BILL_TYPE, liker.getId(), "legalPersonFile", Long.valueOf(liker.getLegalPersonFileId()));
                liker.setLegalPersonFileId(fileId.toString());
                attachIds.add(fileId);
            }
            liker.setAttachIds(attachIds);
        }
        for (MatSupplierAccessAttachesEntity attach : attachList) {
            fileId = this.pushSupUtil.uploadFileFormNet(BILL_TYPE, attach.getId(), "file", attach.getFileId());
            attach.setFileId(fileId);
            attach.setAttachIds(Collections.singletonList(fileId));
        }
        super.saveOrUpdate((Object)entity, false);
        MatSupplierInviteVO inviteVO = new MatSupplierInviteVO();
        inviteVO.setId(entity.getInviteId());
        inviteVO.setStatus("2");
        inviteVO.setInviterId(entity.getInviterId());
        inviteVO.setInviterName(entity.getInviterName());
        this.inviteService.updateBillStatus(inviteVO, true);
        return id;
    }

    @Override
    public MatSupplierAccessVO TYCDetail(String supplierName, Long id) {
        if (StringUtils.isEmpty((CharSequence)supplierName)) {
            throw new BusinessException("\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BaseCompanyInfoVO company = CompanyCheckFactory.getInstance("TYCProcessor").getCompanyInfo(supplierName, null);
        if (null == company) {
            return new MatSupplierAccessVO();
        }
        MatSupplierAccessEntity entity = null;
        if (id != null) {
            entity = (MatSupplierAccessEntity)((Object)super.selectById((Serializable)id));
        }
        if (entity == null) {
            entity = new MatSupplierAccessEntity();
            entity.setCode(EntityUtil.createBillCode(entity, BILL_CODE));
            entity.setSourceType(PlanConstant.SOURCE_TYPE_EL.toString());
            entity.setInviterId(InvocationInfoProxy.getUserid());
            entity.setInviterName(this.sessionManager.getUserContext().getUserName());
            entity.setCompanyGrade("\u4e34\u65f6");
            entity.setCompanyState("\u6b63\u5e38");
        }
        entity.setName(supplierName);
        entity.setInvokeDate(new Date());
        entity.setSocialCreditCode(company.getSocialCreditCode());
        entity.setBusinessStatus(company.getBusinessStatus());
        entity.setRegisteredCapitalStr(company.getRegisteredCapitalStr());
        entity.setPaidCapitalStr(StringUtils.isNotEmpty((CharSequence)company.getPaidCapitalStr()) ? company.getPaidCapitalStr() : "-");
        entity.setBusinessScope(company.getBusinessScope());
        entity.setLegalPerson(company.getLegalPerson());
        entity.setRegisteredAddress(company.getRegisteredAddress());
        entity.setCompanyType(PushSupUtil.clearBracket(company.getCompanyType()));
        entity.setBusinessStartDate(company.getBusinessStartDate());
        entity.setBusinessEndDate(company.getBusinessEndDate());
        entity.setSourceType(PlanConstant.SOURCE_TYPE_EL.toString());
        if (StringUtils.isEmpty((CharSequence)entity.getCompanyCharacter())) {
            entity.setCompanyCharacter("1");
        }
        Map nameMap = PlanConstant.matCompanyAttachNameMap;
        if ("1".equals(entity.getCompanyCharacter())) {
            nameMap = PlanConstant.pdCompanyAttachNameMap;
        }
        Map finalNameMap = nameMap;
        List<MatSupplierAccessAttachesEntity> attachList = entity.getAttachesList();
        if (attachList.stream().noneMatch(x -> finalNameMap.keySet().contains(x.getFileType()))) {
            for (String name : nameMap.keySet()) {
                MatSupplierAccessAttachesEntity vo = new MatSupplierAccessAttachesEntity();
                vo.setFileType(name);
                vo.setType("\u4f01\u4e1a");
                vo.setSourceType(PlanConstant.SOURCE_TYPE_SUPPLIER);
                attachList.add(vo);
            }
        }
        super.saveOrUpdate((Object)entity, false);
        MatSupplierAccessVO vo = (MatSupplierAccessVO)BeanMapper.map((Object)((Object)entity), MatSupplierAccessVO.class);
        return vo;
    }

    @Override
    public Boolean validateUnique(String name, String socialCreditCode, Long id) {
        List accessList;
        QueryParam param = new QueryParam();
        ComplexParam complexParam = ParamUtil.getOrParam("name", "socialCreditCode", name, socialCreditCode);
        param.getComplexParams().add(complexParam);
        if (id != null) {
            param.getParams().put("id", new Parameter("ne", (Object)id));
        }
        if (CollectionUtils.isNotEmpty((Collection)(accessList = super.queryList(param)))) {
            throw new BusinessException("\u8be5\u4f9b\u5e94\u5546\u7684\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u5df2\u751f\u6210\u51c6\u5165\u3010" + ((MatSupplierAccessEntity)((Object)accessList.get(0))).getCode() + "\u3011\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u51c6\u5165\uff01");
        }
        this.supplierService.validateUnique(name, socialCreditCode, null, "\u51c6\u5165");
        return true;
    }

    @Override
    public MatSupplierAccessVO syncDetailBill(Long inviteId) {
        MatSupplierAccessEntity entity = this.getEntityByInviteId(inviteId, null);
        if (null == entity.getId()) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("inviteId", String.valueOf(inviteId));
            CommonResponse<String> response = this.pushSupUtil.exchangeDataAndFilesWithUniversal(SYNC_SUPP_DETAIL_BILL_SERVER_URL, params);
            if (response.isSuccess()) {
                CommonResponse resp = (CommonResponse)JSONObject.parseObject((String)((String)response.getData()), CommonResponse.class);
                if (!resp.isSuccess()) {
                    throw new BusinessException(resp.getMsg());
                }
                entity = this.getEntityByInviteId(null, Long.valueOf((String)resp.getData()));
            } else {
                throw new BusinessException(response.getMsg());
            }
        }
        return (MatSupplierAccessVO)BeanMapper.map((Object)((Object)entity), MatSupplierAccessVO.class);
    }

    private MatSupplierAccessEntity getEntityByInviteId(Long inviteId, Long sourceId) {
        QueryParam queryParam = new QueryParam();
        if (sourceId != null) {
            queryParam.getParams().put("sourceId", new Parameter("eq", (Object)sourceId));
        } else {
            queryParam.getParams().put("inviteId", new Parameter("eq", (Object)inviteId));
        }
        List list = super.queryList(queryParam);
        MatSupplierAccessEntity entity = new MatSupplierAccessEntity();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            entity = (MatSupplierAccessEntity)((Object)super.selectById((Serializable)((MatSupplierAccessEntity)((Object)list.get(0))).getId()));
        }
        return entity;
    }
}

