/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdssupplier.common.utils.PushSupUtil;
import com.ejianc.business.zdssupplier.cons.enums.SupLinkerEnum;
import com.ejianc.business.zdssupplier.cons.enums.SupStatusEnum;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerChangeEntity;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerEntity;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerChangeService;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerService;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerChangeVO;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerVO;
import com.ejianc.business.zdssupplier.sub.bean.LinkerChangeEntity;
import com.ejianc.business.zdssupplier.sub.bean.LinkerEntity;
import com.ejianc.business.zdssupplier.sub.mapper.LinkerChangeMapper;
import com.ejianc.business.zdssupplier.sub.service.ILinkerChangeService;
import com.ejianc.business.zdssupplier.sub.service.ILinkerService;
import com.ejianc.business.zdssupplier.sub.vo.LinkerChangeVO;
import com.ejianc.business.zdssupplier.sub.vo.LinkerVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="linkerChangeService")
public class LinkerChangeServiceImpl
extends BaseServiceImpl<LinkerChangeMapper, LinkerChangeEntity>
implements ILinkerChangeService {
    private final String OPERATE = "linkerChangeBill";
    private final String FILE_TYPE = "EJCBT202403000017";
    private final String LEGAL_FILE_BILL_TYPE = "legalPersonFile";
    private final String AGENT_FILE_BILL_TYPE = "agentFile";
    private final String BILL_PUSH_PM_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/linkerChange/syncBill";
    private static final String BILL_CODE = "ZDS_SUB_LINKER_CHANGE";
    @Value(value="${file.batchdownflow}")
    private String batchdownflow;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ILinkerService linkerService;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IAttachmentApi attachmentRefApi;
    @Autowired
    private PushSupUtil pushSupUtil;
    @Autowired
    private IMatLinkerService mapService;
    @Autowired
    private IMatLinkerChangeService matLinkerChangeService;

    @Override
    public LinkerChangeVO addConvertById(Long linkerId) {
        LinkerEntity linkerEntity = (LinkerEntity)((Object)this.linkerService.selectById(linkerId));
        if (SupLinkerEnum.\u53d8\u66f4\u4e2d.getCode().equals(linkerEntity.getChangeStatus())) {
            return this.queryDetail(linkerEntity.getChangeId());
        }
        LinkerChangeVO changeVO = (LinkerChangeVO)BeanMapper.map((Object)((Object)linkerEntity), LinkerChangeVO.class);
        changeVO.setChangeVersion(Integer.valueOf(changeVO.getChangeVersion() + 1));
        changeVO.setBillState(null);
        changeVO.setLinkerId(linkerId);
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setId(null);
        changeVO.setSourceType(SupStatusEnum.\u9879\u76ee.getCode());
        changeVO.setBeforeAgencyFileId(linkerEntity.getAgencyFileId());
        changeVO.setAgencyFileId(null);
        changeVO.setAgencyFileName(null);
        changeVO.setBeforeAgencyFileName(linkerEntity.getAgencyFileName());
        changeVO.setBeforeCertifyFileId(linkerEntity.getCertifyFileId());
        changeVO.setBeforeCertifyFileName(linkerEntity.getCertifyFileName());
        changeVO.setCertifyFileId(null);
        changeVO.setCertifyFileName(null);
        changeVO.setBeforePersonFileId(linkerEntity.getLegalPersonFileId());
        changeVO.setBeforePersonFileName(linkerEntity.getLegalPersonFileName());
        changeVO.setLegalPersonFileId(null);
        changeVO.setLegalPersonFileName(null);
        return changeVO;
    }

    @Override
    public LinkerChangeVO queryDetail(Long changeId) {
        LinkerChangeEntity matLinkerChangeEntity = (LinkerChangeEntity)((Object)super.selectById((Serializable)changeId));
        LinkerChangeVO changeVO = (LinkerChangeVO)BeanMapper.map((Object)((Object)matLinkerChangeEntity), LinkerChangeVO.class);
        this.changeField(changeVO);
        return changeVO;
    }

    public void changeField(LinkerChangeVO changeVO) {
        ArrayList<String> changeField = new ArrayList<String>();
        LinkerEntity matLinkerEntity = (LinkerEntity)((Object)this.linkerService.selectById(changeVO.getLinkerId()));
        LinkerChangeVO resultData = (LinkerChangeVO)BeanMapper.map((Object)((Object)matLinkerEntity), LinkerChangeVO.class);
        if (!StringUtils.equals((CharSequence)resultData.getMobileLinkPhone(), (CharSequence)changeVO.getMobileLinkPhone())) {
            changeField.add("mobileLinkPhone");
        }
        if (!StringUtils.equals((CharSequence)resultData.getElectronicMail(), (CharSequence)changeVO.getElectronicMail())) {
            changeField.add("electronicMail");
        }
        if (!StringUtils.equals((CharSequence)resultData.getAddress(), (CharSequence)changeVO.getAddress())) {
            changeField.add("address");
        }
        if (!StringUtils.equals((CharSequence)String.valueOf(resultData.getUserType()), (CharSequence)String.valueOf(changeVO.getUserType()))) {
            changeField.add("userType");
            if (changeVO.getUserType() == 1) {
                changeField.add("legalPersonFile");
            } else {
                changeField.add("agencyFile");
                if (null != resultData.getCertifyFileId()) {
                    changeField.add("certifyFile");
                }
            }
        } else if (changeVO.getUserType() == 1) {
            if (null != changeVO.getLegalPersonFileId()) {
                changeField.add("legalPersonFile");
            }
        } else {
            if (null != changeVO.getAgencyFileId()) {
                changeField.add("agencyFile");
            }
            if (null != changeVO.getCertifyFileId()) {
                changeField.add("certifyFile");
            }
        }
        if (!matLinkerEntity.getName().equals(changeVO.getUserName())) {
            changeField.add("name");
            changeField.add("userName");
            changeField.add("beforeName");
        }
        if (!String.valueOf(changeVO.getLinkerStatus()).equals(changeVO.getLinkerStatus())) {
            changeField.add("linkerStatus");
        }
        changeVO.setChangeField(changeField);
    }

    @Override
    public JSONObject contrast(Long linkerId, Long changeId, String flagType) {
        if ("sub".equals(flagType)) {
            JSONObject js = new JSONObject();
            LinkerChangeVO LinkerChangeVO2 = this.queryDetail(changeId);
            js.put("LinkerChangeVO", (Object)LinkerChangeVO2);
            QueryWrapper queryWrapper = new QueryWrapper();
            if (BillStateEnum.PASSED_STATE.getBillStateCode().equals(LinkerChangeVO2.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(LinkerChangeVO2.getBillState())) {
                queryWrapper.eq((Object)"change_version", (Object)LinkerChangeVO2.getChangeVersion());
                queryWrapper.eq((Object)"main_linker_id", (Object)linkerId);
            } else {
                queryWrapper.eq((Object)"id", (Object)linkerId);
            }
            List list = this.linkerService.list((Wrapper)queryWrapper);
            LinkerEntity supplierEntity = (LinkerEntity)((Object)list.get(0));
            LinkerVO vo = (LinkerVO)BeanMapper.map((Object)((Object)supplierEntity), LinkerVO.class);
            js.put("LinkerVO", (Object)vo);
            return js;
        }
        JSONObject js = new JSONObject();
        MatLinkerChangeEntity matLinkerChangeEntity = (MatLinkerChangeEntity)((Object)this.matLinkerChangeService.selectById(changeId));
        MatLinkerChangeVO matLinkerChangeVO = (MatLinkerChangeVO)BeanMapper.map((Object)((Object)matLinkerChangeEntity), MatLinkerChangeVO.class);
        js.put("LinkerChangeVO", (Object)matLinkerChangeVO);
        QueryWrapper queryWrapper = new QueryWrapper();
        if (BillStateEnum.PASSED_STATE.getBillStateCode().equals(matLinkerChangeVO.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(matLinkerChangeVO.getBillState())) {
            queryWrapper.eq((Object)"change_version", (Object)matLinkerChangeVO.getChangeVersion());
            queryWrapper.eq((Object)"main_linker_id", (Object)linkerId);
        } else {
            queryWrapper.eq((Object)"id", (Object)linkerId);
        }
        List list = this.mapService.list((Wrapper)queryWrapper);
        MatLinkerEntity supplierEntity = (MatLinkerEntity)((Object)list.get(0));
        MatLinkerVO matLinkerVO = (MatLinkerVO)BeanMapper.map((Object)((Object)supplierEntity), MatLinkerVO.class);
        js.put("LinkerVO", (Object)matLinkerVO);
        return js;
    }

    @Override
    public CommonResponse<String> syncBill(HttpServletRequest request) {
        Long fileId;
        long id;
        String transData = request.getParameter("transData");
        String fileListStr = request.getParameter("fileList");
        List fileList = (List)JSONObject.parseObject((String)fileListStr, (TypeReference)new TypeReference<List<AttachmentVO>>(){}, (Feature[])new Feature[0]);
        this.logger.info("\u63a5\u6536\u5230\u6570\u636etransData\uff1a{}\uff0cfileList\uff1a{}", (Object)transData, (Object)fileList);
        if (StringUtils.isBlank((CharSequence)transData)) {
            return CommonResponse.error((String)"\u5355\u636e\u540c\u6b65\u5931\u8d25\uff0c\u5355\u636e\u5185\u5bb9\u4e3a\u7a7a\uff01");
        }
        LinkerChangeEntity entity = (LinkerChangeEntity)((Object)JSONObject.parseObject((String)transData, LinkerChangeEntity.class));
        Long linkerId = entity.getLinkerId();
        boolean b = this.linkerService.linkerChangeStatus(linkerId, id = IdWorker.getId());
        if (b) {
            return CommonResponse.error((String)"\u8be5\u8054\u7cfb\u4eba\u6b63\u5728\u53d8\u66f4\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
        entity.setSourceId(entity.getId());
        entity.setId(id);
        if (Integer.valueOf(1).equals(entity.getUserType())) {
            if (StringUtils.isNotBlank((CharSequence)entity.getLegalPersonFileId())) {
                fileId = this.pushSupUtil.uploadFileFormNet(SupLinkerEnum.\u5206\u5305\u8054\u7cfb\u4eba\u53d8\u66f4\u5355\u636e\u7c7b\u578b.getValue(), entity.getId(), "legalPersonFile", Long.valueOf(entity.getLegalPersonFileId()));
                entity.setLegalPersonFileId(fileId.toString());
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)entity.getAgencyFileId())) {
                fileId = this.pushSupUtil.uploadFileFormNet(SupLinkerEnum.\u5206\u5305\u8054\u7cfb\u4eba\u53d8\u66f4\u5355\u636e\u7c7b\u578b.getValue(), entity.getId(), "agentFile", Long.valueOf(entity.getAgencyFileId()));
                entity.setAgencyFileId(fileId.toString());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getCertifyFileId())) {
                fileId = this.pushSupUtil.uploadFileFormNet(SupLinkerEnum.\u5206\u5305\u8054\u7cfb\u4eba\u53d8\u66f4\u5355\u636e\u7c7b\u578b.getValue(), entity.getId(), "certify", Long.valueOf(entity.getCertifyFileId()));
                entity.setCertifyFileId(fileId.toString());
            }
        }
        LinkerEntity dbLinker = (LinkerEntity)((Object)this.linkerService.selectById(linkerId));
        entity.setBeforeAgencyFileId(dbLinker.getAgencyFileId());
        entity.setBeforeCertifyFileId(dbLinker.getCertifyFileId());
        entity.setBeforePersonFileId(dbLinker.getLegalPersonFileId());
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        entity.setReceiveStatus(SupLinkerEnum.\u521d\u5ba1\u5f85\u786e\u8ba4.getCode());
        entity.setTenantId(InvocationInfoProxy.getTenantid());
        entity.setVersion(null);
        entity.setCreateUserCode(null);
        entity.setUpdateUserCode(null);
        this.logger.info("\u7269\u8d44\u8054\u7cfb\u4eba\u8f6c\u6362\u4fdd\u5b58\u5355\u636e: {}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u5355\u636e\u540c\u6b65\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<LinkerChangeVO> pushStatus(Long id) {
        LinkerChangeEntity entity = (LinkerChangeEntity)((Object)super.selectById((Serializable)id));
        this.linkerService.upLinkerChangeStatus(entity.getLinkerId(), SupLinkerEnum.\u672a\u53d8\u66f4.getCode(), null);
        entity.setReceiveStatus(SupLinkerEnum.\u5df2\u9a73\u56de\u4f9b\u65b9.getCode());
        String s = this.pushBill(entity);
        if (StringUtils.isNotBlank((CharSequence)s)) {
            throw new BusinessException(s);
        }
        super.saveOrUpdate((Object)entity, false);
        LinkerChangeVO vo = (LinkerChangeVO)BeanMapper.map((Object)((Object)entity), LinkerChangeVO.class);
        return CommonResponse.success((String)"\u9a73\u56de\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResponse<LinkerChangeVO> saveOrUpdate(LinkerChangeVO saveOrUpdateVO) {
        LinkerChangeEntity entity = (LinkerChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, LinkerChangeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCode((String)billCode.getData());
            entity.setId(IdWorker.getId());
            boolean b = this.linkerService.linkerChangeStatus(entity.getLinkerId(), entity.getId());
            if (b) {
                return CommonResponse.error((String)"\u5f53\u524d\u8054\u7cfb\u4eba\u6b63\u5728\u53d8\u66f4\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        LinkerChangeVO changeVO = this.queryDetail(entity.getId());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)changeVO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String pushBill(LinkerChangeEntity entity) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = "linkerChangeBill::" + entity.getId().toString() + "::sup";
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"linkerChangeBill", (int)600);
            if (!locked) {
                this.releaseLock(jedis, false, key, "linkerChangeBill");
                String string = "\u7269\u8d44\u8054\u7cfb\u4eba\u53d8\u66f4\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25\uff0c\u52a0\u9501\u5931\u8d25\uff01";
                return string;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("transData", JSONObject.toJSONString((Object)((Object)entity)));
            this.logger.info("\u7269\u8d44\u8054\u7cfb\u4eba\u53d8\u66f4\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0: url-{}, \u7269\u8d44\u8054\u7cfb\u4eba\u53d8\u66f4\uff1a{}", (Object)"/ejc-zdssupbusiness-web/openapi/linkerChange/syncBill", (Object)JSONObject.toJSONString((Object)((Object)entity)));
            CommonResponse writeBackResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-zdssupbusiness-web/openapi/linkerChange/syncBill", params, entity.getSupplierId().toString(), null);
            this.logger.error("\u7269\u8d44\u8054\u7cfb\u4eba\u53d8\u66f4\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u8bf7\u6c42\u7ed3\u679c\uff0c{}", (Object)JSONObject.toJSONString((Object)writeBackResp));
            if (!writeBackResp.isSuccess()) {
                this.releaseLock(jedis, true, key, "linkerChangeBill");
                this.logger.error("\u7269\u8d44\u8054\u7cfb\u4eba\u53d8\u66f4id-{}\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff0c{}", (Object)entity.getId(), (Object)writeBackResp.getMsg());
                String string = "\u7269\u8d44\u8054\u7cfb\u4eba\u53d8\u66f4\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25";
                return string;
            }
            String operateRespStr = (String)writeBackResp.getData();
            CommonResponse operateResp = (CommonResponse)JSONObject.parseObject((String)operateRespStr, CommonResponse.class);
            if (!operateResp.isSuccess()) {
                this.logger.error("\u7269\u8d44\u8054\u7cfb\u4eba\u53d8\u66f4id-{}\u63a8\u9001\u4f9b\u5e94\u94fe\uff0c\u5e73\u53f0\u5904\u7406\u5931\u8d25\uff0c{}", (Object)entity.getId(), (Object)operateResp.getMsg());
                this.releaseLock(jedis, true, key, "linkerChangeBill");
                String string = "\u7269\u8d44\u8054\u7cfb\u4eba\u53d8\u66f4\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25";
                return string;
            }
        }
        catch (Exception e) {
            this.logger.error("\u7269\u8d44\u8054\u7cfb\u4eba\u53d8\u66f4id-{}\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25\uff0c", (Object)entity.getId(), (Object)e);
            msg = "\u64cd\u4f5c\u5931\u8d25\uff0c\u7269\u8d44\u8054\u7cfb\u4eba\u53d8\u66f4\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "linkerChangeBill");
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}

