/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.sub.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zds.archive.bean.SubTypeManagerEntity;
import com.ejianc.business.zds.archive.service.ISubTypeManagerService;
import com.ejianc.business.zdssupplier.common.utils.DateUtil;
import com.ejianc.business.zdssupplier.common.utils.EntityUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.sub.bean.LinkerAccessEntity;
import com.ejianc.business.zdssupplier.sub.bean.LinkerEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierAccessAttachesEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierAccessCertificateEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierAccessEntity;
import com.ejianc.business.zdssupplier.sub.service.ILinkerService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierAccessService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierInviteService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.business.zdssupplier.sub.vo.LinkerVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierAttachesVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierCertificateVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierInviteVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierSyncErpParamVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="supplierAccess")
public class SupplierAccessBpmServiceImpl
implements ICommonBusinessService {
    private static final String sourceBillType = BillTypeEnum.\u5206\u5305\u4f9b\u5e94\u5546\u51c6\u5165.getCode();
    private static final String targetBillType = BillTypeEnum.\u5206\u5305\u4f9b\u5e94\u5546\u6863\u6848.getCode();
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISupplierAccessService service;
    @Autowired
    private ISupplierInviteService inviteService;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private ISubTypeManagerService subTypeManagerService;
    @Autowired
    private ILinkerService linkerService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IEmployeeApi employeeApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5206\u5305\u5546\u51c6\u5165\u63d0\u4ea4\u524d\u6821\u9a8c\uff1aid:{}", (Object)billId);
        SupplierAccessEntity entity = (SupplierAccessEntity)((Object)this.service.selectById(billId));
        Date invokeDate = entity.getInvokeDate();
        if (DateUtil.compareDate(DateUtil.addDays(invokeDate, 15), new Date()) < 0) {
            throw new BusinessException("\u8ddd\u79bb\u4e0a\u4e00\u6b21\u8c03\u7528\u5929\u773c\u67e5\u65f6\u95f4\u5df2\u8d85\u8fc715\u5929\uff0c\u8bf7\u66f4\u65b0\u540e\u64cd\u4f5c\uff01");
        }
        this.getApprUser(billId);
        this.validate(entity);
        return CommonResponse.success();
    }

    private void validate(SupplierAccessEntity entity) {
        this.service.validateUnique(entity.getName(), entity.getSocialCreditCode(), entity.getId());
        if (CollectionUtils.isEmpty(entity.getLinkerList())) {
            throw new BusinessException("\u8bf7\u6dfb\u52a0\u81f3\u5c11\u4e00\u6761\u8054\u7cfb\u4eba\uff01");
        }
        if (CollectionUtils.isEmpty(entity.getBankList())) {
            throw new BusinessException("\u8bf7\u6dfb\u52a0\u81f3\u5c11\u4e00\u6761\u94f6\u884c\u4fe1\u606f\uff01");
        }
        if (CollectionUtil.isEmpty(entity.getManagerList())) {
            throw new BusinessException("\u9879\u76ee\u7ecf\u7406\u5fc5\u987b\u6709\u4e00\u6761!");
        }
        this.linkerService.validateUnique(BeanMapper.mapList(entity.getLinkerList(), LinkerEntity.class));
        for (SupplierAccessAttachesEntity attach : entity.getAttachesList()) {
            if (!PlanConstant.subAttachNameMap.containsKey(attach.getFileType()) || !((Boolean)PlanConstant.subAttachNameMap.get(attach.getFileType())).booleanValue() || null != attach.getFileId()) continue;
            throw new BusinessException(attach.getFileType() + "\u672a\u4e0a\u4f20\u9644\u4ef6\uff0c\u8bf7\u4e0a\u4f20\u5e76\u4fdd\u5b58\u540e\u63d0\u4ea4\uff01");
        }
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        SupplierAccessEntity entity = (SupplierAccessEntity)((Object)this.service.selectById(billId));
        SupplierInviteVO inviteVO = new SupplierInviteVO();
        inviteVO.setId(entity.getInviteId());
        inviteVO.setStatus("3");
        this.inviteService.updateBillStatus(inviteVO);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        SupplierAccessEntity entity = (SupplierAccessEntity)((Object)this.service.selectById(billId));
        SupplierInviteVO inviteVO = new SupplierInviteVO();
        inviteVO.setId(entity.getInviteId());
        inviteVO.setStatus("2");
        inviteVO.setFlowType("7");
        this.inviteService.updateBillStatus(inviteVO);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SupplierAccessEntity entity = (SupplierAccessEntity)((Object)this.service.selectById(billId));
        this.validate(entity);
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SupplierAccessEntity entity = (SupplierAccessEntity)((Object)this.service.selectById(billId));
        Long supplierId = this.pushToArchive(entity);
        String msg = this.supplierService.syncSupplierChangeToErp(new SupplierSyncErpParamVO(supplierId, null, "supAdd", billId, true, entity.getInviterId(), entity.getInviterName()));
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            throw new BusinessException(msg);
        }
        try {
            this.supplierService.initCooInfo(supplierId);
        }
        catch (Exception e) {
            this.logger.error("***********\u5206\u5305\u5546\u51c6\u5165\u6210\u529f\uff0c\u63a8\u9001ERP\u6210\u529f\uff0c\u5206\u5305\u5546id-{}\u751f\u6210\u8054\u7cfb\u4eba\u8d26\u53f7\u5931\u8d25", (Object)supplierId, (Object)e);
        }
        SupplierInviteVO inviteVO = new SupplierInviteVO();
        inviteVO.setId(entity.getInviteId());
        inviteVO.setStatus("6");
        this.inviteService.updateBillStatus(inviteVO);
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public Long pushToArchive(SupplierAccessEntity entity) {
        LinkerVO target;
        CommonResponse empResp;
        SupplierVO save = EntityUtil.clearInvalidEntity(entity, SupplierVO.class);
        save.setAccessId(entity.getId());
        save.setCode(EntityUtil.createBillCode(save, "ZDS_SUB_SUPPLIER"));
        save.getLinkerList().forEach(vo -> {
            vo.setLinkerStatus(Integer.valueOf(0));
            vo.setEnableStatus(Integer.valueOf(1));
            vo.setChangeVersion(Integer.valueOf(0));
            vo.setDateType(Integer.valueOf(0));
            vo.setSupplierCode(save.getCode());
            vo.setSupplierName(save.getName());
            vo.setCode(EntityUtil.createBillCode(vo, "ZDS_SUB_LINKER"));
        });
        save.getManagerList().forEach(vo -> {
            vo.setCoordination("0");
            vo.setSynergyAccountStatus(PlanConstant.INTEGER_NO);
            vo.setProjectManagerStatus(Integer.valueOf(0));
            vo.setEnableStatus(Integer.valueOf(2));
        });
        save.setCompanyGrade("\u4e34\u65f6");
        save.setCompanyState("\u6b63\u5e38");
        save.setErpType((String)PlanConstant.ERP_SUB_INFO_TYPE_MAPPING.get(entity.getType()));
        EmployeeVO creator = null;
        if ("1".equals(entity.getSourceType())) {
            empResp = this.employeeApi.getByEmpmloyeeCode(entity.getCreateUserCode());
            if (!empResp.isSuccess() || null == empResp.getData()) {
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u83b7\u53d6\u4ee3\u6ce8\u518c\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff01");
            }
            creator = (EmployeeVO)empResp.getData();
        } else {
            empResp = this.employeeApi.getById(entity.getInviterId());
            if (!empResp.isSuccess() || null == empResp.getData()) {
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u83b7\u53d6\u4ee3\u6ce8\u518c\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff01");
            }
            creator = (EmployeeVO)empResp.getData();
        }
        save.setErpCreatorSid(creator.getSourceId());
        save.setErpRegisterName(creator.getName());
        if (!(null == creator.getOrgId() || null != entity.getCorpId() && creator.getOrgId().equals(entity.getCorpId()))) {
            entity.setCorpId(creator.getOrgId());
        }
        if (null != entity.getCorpId()) {
            OrgVO corpInfo = null;
            CommonResponse orgResp = this.orgApi.getOneById(entity.getCorpId());
            if (!orgResp.isSuccess()) {
                this.logger.error("\u67e5\u8be2\u5206\u5305\u5546\u5f52\u5c5e\u90e8\u95e8corpId-{}\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25", (Object)entity.getCorpId());
            }
            if (null == (corpInfo = (OrgVO)orgResp.getData())) {
                this.logger.error("\u67e5\u8be2\u5206\u5305\u5546\u5f52\u5c5e\u90e8\u95e8\u4fe1\u606fcorpId-{}\u4e3a\u7a7a\uff01", (Object)entity.getCorpId());
            } else {
                save.setCorpSid(corpInfo.getSourceId());
                save.setCorpName(corpInfo.getName());
                save.setCorpCode(corpInfo.getCode());
            }
        }
        save.setCorpErpName(entity.getCorpName());
        SupplierVO supplier = this.supplierService.saveOrUpdateSupInfo(save, false);
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(entity.getId()), sourceBillType, "attachMgr", String.valueOf(supplier.getId()), targetBillType, "attachMgr");
        Map<Long, LinkerVO> linkerMap = supplier.getLinkerList().stream().collect(Collectors.toMap(x -> x.getSourceDetailId(), x -> x));
        Map<Long, SupplierAttachesVO> attachMap = supplier.getAttachesList().stream().collect(Collectors.toMap(x -> x.getSourceDetailId(), x -> x));
        Map<Long, SupplierCertificateVO> certMap = supplier.getCertificateList().stream().collect(Collectors.toMap(x -> x.getSourceDetailId(), x -> x));
        for (LinkerAccessEntity linkerAccessEntity : entity.getLinkerList()) {
            if (!linkerMap.containsKey(linkerAccessEntity.getId())) continue;
            target = linkerMap.get(linkerAccessEntity.getId());
            String sourceType = linkerAccessEntity.getUserType() == 2 ? "agentFile" : "legalPersonFile";
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(linkerAccessEntity.getId()), sourceBillType, sourceType, String.valueOf(target.getId()), targetBillType, sourceType);
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(linkerAccessEntity.getId()), sourceBillType, "certify", String.valueOf(target.getId()), targetBillType, "certify");
        }
        for (SupplierAccessAttachesEntity supplierAccessAttachesEntity : entity.getAttachesList()) {
            if (!attachMap.containsKey(supplierAccessAttachesEntity.getId())) continue;
            target = attachMap.get(supplierAccessAttachesEntity.getId());
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(supplierAccessAttachesEntity.getId()), sourceBillType, "file", String.valueOf(target.getId()), targetBillType, "file");
        }
        for (SupplierAccessCertificateEntity supplierAccessCertificateEntity : entity.getCertificateList()) {
            if (!certMap.containsKey(supplierAccessCertificateEntity.getId())) continue;
            target = certMap.get(supplierAccessCertificateEntity.getId());
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(supplierAccessCertificateEntity.getId()), sourceBillType, "cert", String.valueOf(target.getId()), targetBillType, "cert");
        }
        return supplier.getId();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u8be5\u5355\u636e\u4e0d\u5141\u8bb8\u5f03\u5ba1\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other) {
        return CommonResponse.success((Object)this.getApprUser(billId));
    }

    private JSONArray getApprUser(Long billId) {
        JSONArray resp = new JSONArray();
        SupplierAccessEntity entity = (SupplierAccessEntity)((Object)this.service.selectById(billId));
        if (StringUtils.isBlank((CharSequence)entity.getProfessionId()) && StringUtils.isBlank((CharSequence)entity.getDepProfessionId())) {
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8be5\u5206\u5305\u5546\u7684\u53d1\u5c55\u4e13\u4e1a\u548c\u4e3b\u5bfc\u4e13\u4e1a\u90fd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u5bf9\u5e94\u5ba1\u6838\u4eba\u4fe1\u606f\uff01");
        }
        List<SubTypeManagerEntity> mangers = this.subTypeManagerService.getAllBySubTypeIds(Arrays.stream(entity.getDepProfessionId().split(",")).map(Long::parseLong).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(mangers)) {
            mangers.stream().forEach(item -> {
                JSONObject obj = new JSONObject();
                obj.put("userId", (Object)item.getManagerId());
                obj.put("userName", (Object)item.getManagerName());
                resp.add((Object)obj);
            });
        }
        if (resp.size() == 0 && CollectionUtils.isNotEmpty(mangers = this.subTypeManagerService.getAllBySubTypeIds(Arrays.stream(entity.getProfessionId().split(",")).map(Long::parseLong).collect(Collectors.toList())))) {
            mangers.stream().forEach(item -> {
                JSONObject obj = new JSONObject();
                obj.put("userId", (Object)item.getManagerId());
                obj.put("userName", (Object)item.getManagerName());
                resp.add((Object)obj);
            });
        }
        if (resp.size() == 0) {
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8be5\u5206\u5305\u5546\u7684\u53d1\u5c55\u4e13\u4e1a\u6216\u4e3b\u5bfc\u4e13\u4e1a\u672a\u8bbe\u7f6e\u5ba1\u6838\u4eba\uff01");
        }
        return resp;
    }
}

