/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdssupplier.common.utils.EntityUtil;
import com.ejianc.business.zdssupplier.common.utils.ParamUtil;
import com.ejianc.business.zdssupplier.common.utils.PushSupUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.sub.bean.LinkerAccessEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierAccessAttachesEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierAccessCertificateEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierAccessEntity;
import com.ejianc.business.zdssupplier.sub.mapper.SupplierAccessMapper;
import com.ejianc.business.zdssupplier.sub.service.ILinkerAccessService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierAccessCertificateService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierAccessService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierInviteService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.business.zdssupplier.sub.vo.SupplierAccessVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierInviteVO;
import com.ejianc.business.zdssupplier.utils.enterprise.dispatch.CompanyCheckFactory;
import com.ejianc.business.zdssupplier.utils.enterprise.vo.BaseCertificateVO;
import com.ejianc.business.zdssupplier.utils.enterprise.vo.BaseCompanyInfoVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="supplierAccessService")
public class SupplierAccessServiceImpl
extends BaseServiceImpl<SupplierAccessMapper, SupplierAccessEntity>
implements ISupplierAccessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_TYPE = BillTypeEnum.\u5206\u5305\u4f9b\u5e94\u5546\u51c6\u5165.getCode();
    private static final String BILL_NAME = BillTypeEnum.\u5206\u5305\u4f9b\u5e94\u5546\u51c6\u5165.getName();
    private static final String BILL_CODE = "ZDS_SUB_SUPPLIER_ACCESS";
    private static final String SYNC_SUPP_DETAIL_BILL_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/supplierAccess/syncDetailBill";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private PushSupUtil pushSupUtil;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISupplierInviteService inviteService;
    @Autowired
    private ISupplierAccessCertificateService certService;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private ILinkerAccessService linkerService;

    @Override
    public SupplierAccessVO saveOrUpdate(SupplierAccessVO saveOrUpdateVO) {
        SupplierAccessEntity entity = (SupplierAccessEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SupplierAccessEntity.class));
        this.linkerService.validateUnique(entity.getLinkerList());
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCode((String)billCode.getData());
            entity.setSourceType(PlanConstant.SOURCE_TYPE_EL.toString());
            entity.setInviterId(InvocationInfoProxy.getUserid());
            entity.setInviterName(this.sessionManager.getUserContext().getUserName());
        }
        super.saveOrUpdate((Object)entity, false);
        return (SupplierAccessVO)BeanMapper.map((Object)((Object)entity), SupplierAccessVO.class);
    }

    @Override
    public Long saveSyncBill(HttpServletRequest request) {
        Long fileId;
        String transData = request.getParameter("transData");
        SupplierAccessEntity saveEntity = (SupplierAccessEntity)((Object)JSONObject.parseObject((String)transData, SupplierAccessEntity.class));
        QueryParam param = new QueryParam();
        param.getParams().put("inviteId", new Parameter("eq", (Object)saveEntity.getInviteId()));
        List list = super.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u8be5\u9080\u8bf7\u94fe\u63a5\u5df2\u751f\u6210\u51c6\u5165\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210\uff01");
        }
        this.linkerService.validateUnique(saveEntity.getLinkerList());
        Long id = this.pushSupUtil.saveSyncBill(request, SupplierAccessEntity.class, BILL_TYPE, BILL_NAME);
        if (null == id) {
            throw new BusinessException("\u540c\u6b65\u6570\u636e\u5f02\u5e38\uff01");
        }
        SupplierAccessEntity entity = (SupplierAccessEntity)((Object)super.selectById((Serializable)id));
        entity.setCode(EntityUtil.createBillCode(entity, BILL_CODE));
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        List<LinkerAccessEntity> likerList = entity.getLinkerList();
        List<SupplierAccessAttachesEntity> attachList = entity.getAttachesList();
        List<SupplierAccessCertificateEntity> certList = entity.getCertificateList();
        for (LinkerAccessEntity liker : likerList) {
            fileId = null;
            ArrayList<Long> attachIds = new ArrayList<Long>();
            if (liker.getUserType() == 2) {
                fileId = this.pushSupUtil.uploadFileFormNet(BILL_TYPE, liker.getId(), "agentFile", Long.valueOf(liker.getAgencyFileId()));
                liker.setAgencyFileId(fileId.toString());
                attachIds.add(fileId);
                Long certifyFileId = this.pushSupUtil.uploadFileFormNet(BILL_TYPE, liker.getId(), "certify", Long.valueOf(liker.getCertifyFileId()));
                liker.setCertifyFileId(certifyFileId.toString());
                attachIds.add(certifyFileId);
            } else {
                fileId = this.pushSupUtil.uploadFileFormNet(BILL_TYPE, liker.getId(), "legalPersonFile", Long.valueOf(liker.getLegalPersonFileId()));
                liker.setLegalPersonFileId(fileId.toString());
                attachIds.add(fileId);
            }
            liker.setAttachIds(attachIds);
        }
        for (SupplierAccessAttachesEntity attach : attachList) {
            fileId = this.pushSupUtil.uploadFileFormNet(BILL_TYPE, attach.getId(), "file", attach.getFileId());
            attach.setFileId(fileId);
            attach.setAttachIds(Collections.singletonList(fileId));
        }
        for (SupplierAccessCertificateEntity cert : certList) {
            fileId = this.pushSupUtil.uploadFileFormNet(BILL_TYPE, cert.getId(), "cert", cert.getCertificateFileId());
            cert.setCertificateFileId(fileId);
            cert.setAttachIds(Collections.singletonList(fileId));
        }
        super.saveOrUpdate((Object)entity, false);
        SupplierInviteVO inviteVO = new SupplierInviteVO();
        inviteVO.setId(entity.getInviteId());
        inviteVO.setStatus("2");
        inviteVO.setInviterId(entity.getInviterId());
        inviteVO.setInviterName(entity.getInviterName());
        this.inviteService.updateBillStatus(inviteVO, true);
        return id;
    }

    @Override
    public SupplierAccessVO TYCDetail(String supplierName, Long id) {
        List<SupplierAccessAttachesEntity> attachList;
        if (StringUtils.isEmpty((CharSequence)supplierName)) {
            throw new BusinessException("\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BaseCompanyInfoVO company = CompanyCheckFactory.getInstance("TYCProcessor").getCompanyInfo(supplierName, null);
        if (null == company) {
            return new SupplierAccessVO();
        }
        SupplierAccessEntity entity = null;
        if (id != null) {
            entity = (SupplierAccessEntity)((Object)super.selectById((Serializable)id));
        }
        if (entity == null) {
            entity = new SupplierAccessEntity();
            entity.setCode(EntityUtil.createBillCode(entity, BILL_CODE));
            entity.setSourceType(PlanConstant.SOURCE_TYPE_EL.toString());
            entity.setInviterId(InvocationInfoProxy.getUserid());
            entity.setInviterName(this.sessionManager.getUserContext().getUserName());
            entity.setCompanyGrade("\u4e34\u65f6");
            entity.setCompanyState("\u6b63\u5e38");
        }
        entity.setName(supplierName);
        entity.setInvokeDate(new Date());
        entity.setSocialCreditCode(company.getSocialCreditCode());
        entity.setBusinessStatus(company.getBusinessStatus());
        entity.setRegisteredCapitalStr(company.getRegisteredCapitalStr());
        entity.setPaidCapitalStr(StringUtils.isNotEmpty((CharSequence)company.getPaidCapitalStr()) ? company.getPaidCapitalStr() : "-");
        entity.setBusinessScope(company.getBusinessScope());
        entity.setLegalPerson(company.getLegalPerson());
        entity.setRegisteredAddress(company.getRegisteredAddress());
        entity.setCompanyType(PushSupUtil.clearBracket(company.getCompanyType()));
        entity.setBusinessStartDate(company.getBusinessStartDate());
        entity.setBusinessEndDate(company.getBusinessEndDate());
        entity.setSourceType(PlanConstant.SOURCE_TYPE_EL.toString());
        List<BaseCertificateVO> certList = company.getCertiList();
        List<SupplierAccessCertificateEntity> addList = this.transferCertList(certList, entity.getId());
        if (CollectionUtils.isNotEmpty(addList)) {
            entity.setCertificateList(addList);
        }
        if ((attachList = entity.getAttachesList()).stream().noneMatch(x -> PlanConstant.subAttachNameMap.keySet().contains(x.getFileType()))) {
            for (String name : PlanConstant.subAttachNameMap.keySet()) {
                SupplierAccessAttachesEntity vo = new SupplierAccessAttachesEntity();
                vo.setFileType(name);
                vo.setSourceType(PlanConstant.SOURCE_TYPE_SUPPLIER);
                attachList.add(vo);
            }
        }
        super.saveOrUpdate((Object)entity, false);
        SupplierAccessVO vo = (SupplierAccessVO)BeanMapper.map((Object)((Object)entity), SupplierAccessVO.class);
        return vo;
    }

    @Override
    public Boolean validateUnique(String name, String socialCreditCode, Long id) {
        List accessList;
        QueryParam param = new QueryParam();
        ComplexParam complexParam = ParamUtil.getOrParam("name", "socialCreditCode", name, socialCreditCode);
        param.getComplexParams().add(complexParam);
        if (id != null) {
            param.getParams().put("id", new Parameter("ne", (Object)id));
        }
        if (CollectionUtils.isNotEmpty((Collection)(accessList = super.queryList(param)))) {
            throw new BusinessException("\u8be5\u4f9b\u5e94\u5546\u7684\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u5df2\u751f\u6210\u51c6\u5165\u3010" + ((SupplierAccessEntity)((Object)accessList.get(0))).getCode() + "\u3011\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u51c6\u5165\uff01");
        }
        this.supplierService.validateUnique(name, socialCreditCode, null, "\u51c6\u5165");
        return true;
    }

    @Override
    public SupplierAccessVO syncDetailBill(Long inviteId) {
        SupplierAccessEntity entity = this.getEntityByInviteId(inviteId, null);
        if (null == entity.getId()) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("inviteId", String.valueOf(inviteId));
            CommonResponse<String> response = this.pushSupUtil.exchangeDataAndFilesWithUniversal(SYNC_SUPP_DETAIL_BILL_SERVER_URL, params);
            if (response.isSuccess()) {
                CommonResponse resp = (CommonResponse)JSONObject.parseObject((String)((String)response.getData()), CommonResponse.class);
                if (!resp.isSuccess()) {
                    throw new BusinessException(resp.getMsg());
                }
                entity = this.getEntityByInviteId(null, Long.valueOf((String)resp.getData()));
            } else {
                throw new BusinessException(response.getMsg());
            }
        }
        return (SupplierAccessVO)BeanMapper.map((Object)((Object)entity), SupplierAccessVO.class);
    }

    private SupplierAccessEntity getEntityByInviteId(Long inviteId, Long sourceId) {
        QueryParam queryParam = new QueryParam();
        if (sourceId != null) {
            queryParam.getParams().put("sourceId", new Parameter("eq", (Object)sourceId));
        } else {
            queryParam.getParams().put("inviteId", new Parameter("eq", (Object)inviteId));
        }
        List list = super.queryList(queryParam);
        SupplierAccessEntity entity = new SupplierAccessEntity();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            entity = (SupplierAccessEntity)((Object)super.selectById((Serializable)((SupplierAccessEntity)((Object)list.get(0))).getId()));
        }
        return entity;
    }

    private List<SupplierAccessCertificateEntity> transferCertList(List<BaseCertificateVO> certList, Long accessId) {
        if (CollectionUtils.isEmpty(certList)) {
            return new ArrayList<SupplierAccessCertificateEntity>();
        }
        Map<Object, Object> certMap = new HashMap();
        if (accessId != null) {
            QueryParam param = new QueryParam();
            param.getParams().put("accessId", new Parameter("eq", (Object)accessId));
            List list = this.certService.queryList(param);
            certMap = list.stream().collect(Collectors.toMap(e -> e.getCertificateTypeName() + "|" + e.getCertificateNumber(), x -> x, (v1, v2) -> v2));
        }
        Map<Object, Object> defMap = new HashMap();
        CommonResponse resp = this.defdocApi.getDefDocByDefId(Long.valueOf(824965747632509009L));
        if (resp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)resp.getData()))) {
            defMap = ((List)resp.getData()).stream().collect(Collectors.toMap(x -> x.getName(), x -> x, (v1, v2) -> v2));
        }
        ArrayList<SupplierAccessCertificateEntity> addList = new ArrayList<SupplierAccessCertificateEntity>();
        for (BaseCertificateVO cert : certList) {
            List<String> names = Arrays.asList(cert.getName().split(","));
            for (String name : names) {
                SupplierAccessCertificateEntity vo = new SupplierAccessCertificateEntity();
                if (certMap.containsKey(name + "|" + cert.getCode())) {
                    vo = (SupplierAccessCertificateEntity)((Object)certMap.get(name + "|" + cert.getCode()));
                }
                vo.setCertificateTypeName(name);
                if (!defMap.containsKey(name)) continue;
                vo.setCertificateTypeId(((DefdocDetailVO)defMap.get(name)).getId());
                vo.setCertificateTypeCode(((DefdocDetailVO)defMap.get(name)).getCode());
                vo.setCertificateNumber(cert.getCode());
                vo.setPeriodOfValidity(cert.getEndDate());
                vo.setSourceType(2);
                addList.add(vo);
            }
        }
        return addList;
    }
}

