/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.utils;

import com.ejianc.framework.core.kit.time.DateFormatUtil;
import java.security.MessageDigest;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ZDSReqUtil {
    private static String ERP_APPID;
    private static String ERP_SECRET;
    private static String ERP_REQ_HOST;
    private static String ERP_DATA_BATCH_SIZE;
    public static final int CONN_TIME_OUT = 120000;
    public static final int READ_TIME_OUT = 120000;

    public static String getErpAppid() {
        return ERP_APPID;
    }

    @Value(value="${erp.appId}")
    public void setErpAppid(String appId) {
        ERP_APPID = appId;
    }

    public static String getErpSecret() {
        return ERP_SECRET;
    }

    @Value(value="${erp.secret}")
    public void setErpSecret(String secret) {
        ERP_SECRET = secret;
    }

    public static String getErpReqHost() {
        return ERP_REQ_HOST;
    }

    @Value(value="${erp.reqHost}")
    public void setErpReqHost(String reqHost) {
        ERP_REQ_HOST = reqHost;
    }

    public static String getErpDataBatchSize() {
        return ERP_DATA_BATCH_SIZE;
    }

    @Value(value="${erp.batchSize:100}")
    public void setErpDataBatchSize(String batchSize) {
        ERP_DATA_BATCH_SIZE = batchSize;
    }

    public static Map<String, String> getErpHeaders() throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        String nowStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date());
        headers.put("appid", ZDSReqUtil.toMD5(ERP_APPID));
        headers.put("ticket", nowStr);
        headers.put("sign", ZDSReqUtil.toMD5(ERP_SECRET + ZDSReqUtil.toMD5(ERP_APPID) + ZDSReqUtil.toMD5(nowStr)));
        return headers;
    }

    public static Map<String, String> getErpHeader(String appId, String secret) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        String nowStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date());
        headers.put("appid", ZDSReqUtil.toMD5(appId));
        headers.put("ticket", nowStr);
        headers.put("sign", ZDSReqUtil.toMD5(secret + ZDSReqUtil.toMD5(appId) + ZDSReqUtil.toMD5(nowStr)));
        return headers;
    }

    public static String toMD5(String plainText) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] hashBytes = digest.digest(plainText.getBytes());
        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString().toLowerCase();
    }

    public static String changeLongToGUID(Long longNum) {
        return new UUID(longNum, longNum >> 64).toString();
    }
}

