package com.ejianc.business.zds.archive.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zds.archive.bean.AdministrativeAreaEntity;
import com.ejianc.business.zds.archive.bean.BankCategoryEntity;
import com.ejianc.business.zds.archive.bean.BankEntity;
import com.ejianc.business.zds.archive.service.IAdministrativeAreaService;
import com.ejianc.business.zds.archive.service.IBankCategoryService;
import com.ejianc.business.zds.archive.service.IBankService;
import com.ejianc.business.zds.archive.utils.ZdsReqUtil;
import com.ejianc.business.zds.archive.vo.BankVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 银行实体
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("bank")
public class BankController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBankService service;

    private final String BANK_ERP_REQ_URL = "/cefoc/yql/get_FP_BRDINList";

    @Autowired
    private IAdministrativeAreaService areaService;

    @Autowired
    private IBankCategoryService bankCategoryService;

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BankVO> queryDetail(Long id) {
    	BankEntity entity = service.selectById(id);
    	BankVO vo = BeanMapper.map(entity, BankVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BankVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<BankEntity> page = service.queryPage(param,false);
        IPage<BankVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BankVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refBankData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BankVO>> refBankData(@RequestParam Integer pageNumber,
                                                     @RequestParam Integer pageSize,
                                                     @RequestParam(required = false) String relyCondition,
                                                     @RequestParam(required = false) String condition,
                                                     @RequestParam(required = false) String searchObject,
                                                     @RequestParam(required = false) String searchText) {
        QueryParam param = new QueryParam();

        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("categoryName");
        param.getFuzzyFields().add("cityName");
        param.getFuzzyFields().add("provinceName");

        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        Long categoryId = null;

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        if (StringUtils.isNotBlank(relyCondition)) {
            categoryId = Long.parseLong(relyCondition.split("=")[1]);
            param.getParams().put("categoryId", new Parameter(QueryParam.EQ, categoryId));
        }

        IPage<BankEntity> page = service.queryPage(param,false);
        IPage<BankVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BankVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @PostMapping(value = "/zdsBankSync")
    public CommonResponse<String> zdsBankSync(@RequestBody JSONObject reqParam) {
        logger.info("*********************中电四-银行信息同步任务 开始*********************");
        Integer pageNum = null != reqParam.get("pageNum") ? reqParam.getInteger("pageNum") : 0;
        Integer pageSize = null != reqParam.get("pageSize") ? reqParam.getInteger("pageSize") : Integer.valueOf(ZdsReqUtil.getErpDataBatchSize());
        JSONObject param = new JSONObject();
        String reqUrl = ZdsReqUtil.getErpReqHost() + BANK_ERP_REQ_URL;
        boolean hasNext = true;
        Map<String, String> headers = null;

        //请求连续失败次数，连续两次请求失败时 任务终止
        Integer reqErrorTimes = null != reqParam.get("reqErrorTimes") ? reqParam.getInteger("reqErrorTimes") : 0;
        reqParam.remove("reqErrorTimes");

        try {
            param.put("PageSize", pageSize);
            JSONObject reqJson = null;
            JSONArray pageData =null;

            while(hasNext) {
                headers = ZdsReqUtil.getErpHeaders();
                param.put("PageNum", ++pageNum);
                String reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(param),
                        headers, HttpTookit.connTimeout, HttpTookit.readTimeout);

                reqJson = JSONObject.parseObject(reqResp);
                reqErrorTimes = 0;

                if("ok".equals(reqJson.getString("status"))) {

                    pageData = reqJson.getJSONArray("data");
                    if(null != pageData && pageData.size() > 0) {
                        logger.info("中电四银行同步,请求成功，共{}条数据，当前处理第{}页-{}条数据",reqJson.getString("allCount"), pageNum, pageData.size());
                        handleErpPageData(pageData);
                    } else {
                        logger.info("中电四银行同步 处理数据完成！！！总共{}页数据！", pageNum);
                        hasNext = false;
                    }
                } else {
                    logger.error("请求中电四获取银行结果返回失败：请求地址-{},参数-{},header-{},结果-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp);
                    hasNext = false;
                }
            }

        } catch (Exception e) {
            logger.error("获取中电四银行信息异常, 请求地址：{}, 请求参数：{}", reqUrl, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat), e);

            reqErrorTimes++;
            if(reqErrorTimes >= 2) {
                return CommonResponse.error("同步中电四银行信息异常");
            }
            try {
                logger.info("同步中电四银行支行异常，1.5s后重试.........,当前已同步{}数据",param.getInteger("PageNum")-1);
                //休息1.5s
                Thread.sleep(5000);
                param.put("pageSize", param.getInteger("PageSize"));
                param.put("pageNum", param.getInteger("PageNum")-1);
                param.put("reqErrorTimes", reqErrorTimes);
                return zdsBankSync(param);
            } catch (Exception e1) {
                logger.error("重启中电四银行支行同步接口异常,", e1);
                return CommonResponse.error("同步中电四银行信息异常");
            }
        }

        logger.info("*********************中电四-银行信息同步任务 结束*********************");
        return CommonResponse.success("中电四银行同步完成！");
    }

    private void handleErpPageData(JSONArray pageData) {
        JSONObject tmp = null;
        BankEntity tmpEntity = null;
        Map<String, BankEntity> dataMap = new HashMap<>();
        List<BankEntity> saveList = new ArrayList<>();
        Map<String, AdministrativeAreaEntity> areasSourceMap = new HashMap<>();
        Map<String, BankCategoryEntity> bankSubCodeMap = new HashMap<>();
        Set<String> subBankCodes = new HashSet<>();
        Set<String> areaSids = new HashSet<>();
        List<BankCategoryEntity> bankCategoryList = null;


        for(Object obj : pageData) {
            tmp = (JSONObject) obj;
            logger.info("当前银行数据：{}", JSONObject.toJSONString(tmp, SerializerFeature.PrettyFormat));
            tmpEntity = new BankEntity();
            tmpEntity.setName(tmp.getString("WHLNAM")); //网点名称
            tmpEntity.setSourceId(tmp.getString("C_FP_BRDINFOOID")); //主键
            tmpEntity.setEnabled("0".equals(tmp.getString("RCDSTS")) ? "1" : "0"); //停启用
            tmpEntity.setSequence(null != tmp.get("Sort_ID") ? tmp.getInteger("Sort_ID") : 1);
            tmpEntity.setMemo(null != tmp.getString("Memo") ? tmp.getString("Memo") : null);
            tmpEntity.setSubBankCode(tmp.getString("BNKNBR")); //银行码 作为参数查询分行数据
            tmpEntity.setCityCode(tmp.getString("CTYCOD"));
            tmpEntity.setCityName(tmp.getString("city"));
            tmpEntity.setProvinceName(tmp.getString("province"));
            tmpEntity.setCitySid(tmp.getString("cityoid"));
            tmpEntity.setProvinceSid(tmp.getString("provinceoid"));
            tmpEntity.setCode(tmp.getString("BRDNBR")); //银行码
            tmpEntity.setBankSeq(tmp.getString("SEQNBR")); //银行码
            if(StringUtils.isNotBlank(tmpEntity.getCitySid())) {
                areaSids.add(tmpEntity.getCitySid());
            }
            if(StringUtils.isNotBlank(tmpEntity.getProvinceSid())) {
                areaSids.add(tmpEntity.getProvinceSid());
            }
            subBankCodes.add(tmpEntity.getSubBankCode());

            dataMap.put(tmpEntity.getSourceId(), tmpEntity);
        }

        if(CollectionUtils.isNotEmpty(areaSids)) {
            List<AdministrativeAreaEntity> areaList = areaService.getAllBySourceIds(new ArrayList<>(areaSids));
            if(CollectionUtils.isEmpty(areaList)) {
                areasSourceMap = areaList.stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item));
            }
        }
        if(CollectionUtils.isNotEmpty(subBankCodes)) {
            bankCategoryList = bankCategoryService.getAllBySubBankCodes(new ArrayList<>(subBankCodes));
        }
        if(CollectionUtils.isNotEmpty(bankCategoryList)) {
            bankSubCodeMap = bankCategoryList.stream().collect(Collectors.toMap(item -> item.getSubBankCode(), item -> item));
        }

        List<BankEntity> dbListBySourceId = service.getAllBySourceIds(new ArrayList<>(dataMap.keySet()));
        if(CollectionUtils.isNotEmpty(dbListBySourceId)) {
            //更新列表
            for(BankEntity dbEntity : dbListBySourceId) {
                tmpEntity = dataMap.get(dbEntity.getSourceId());
                dbEntity.setName(tmpEntity.getName());
                dbEntity.setEnabled(tmpEntity.getEnabled());
                dbEntity.setSequence(tmpEntity.getSequence());
                dbEntity.setMemo(tmpEntity.getMemo());
                dbEntity.setCode(tmpEntity.getCode());
                dbEntity.setSubBankCode(tmpEntity.getSubBankCode());
                dbEntity.setProvinceSid(tmpEntity.getProvinceSid());
                dbEntity.setProvinceCode(tmpEntity.getProvinceCode());
                dbEntity.setProvinceName(tmpEntity.getProvinceName());
                dbEntity.setProvinceId(tmpEntity.getProvinceId());
                dbEntity.setCitySid(tmpEntity.getCitySid());
                dbEntity.setCityId(tmpEntity.getCityId());
                dbEntity.setCityCode(tmpEntity.getCityCode());
                dbEntity.setCityName(tmpEntity.getCityName());
                dbEntity.setBankSeq(tmpEntity.getBankSeq());
                saveList.add(dbEntity);

                dataMap.remove(dbEntity.getSourceId());
            }
        }

        if(!dataMap.isEmpty()) {
            saveList.addAll(dataMap.values());
        }

        AdministrativeAreaEntity city = null;
        AdministrativeAreaEntity province = null;
        BankCategoryEntity bankCategory = null;
        for(BankEntity item : saveList) {
            if(StringUtils.isNotBlank(item.getCitySid()) && areasSourceMap.containsKey(item.getCitySid())) {
                city = areasSourceMap.get(item.getCitySid());
            }
            if(null != city) {
                item.setCityCode(city.getCode());
                item.setCityName(city.getName());
                item.setCityId(city.getId());
            }
            if(StringUtils.isNotBlank(item.getProvinceSid()) && areasSourceMap.containsKey(item.getProvinceSid())) {
                province = areasSourceMap.get(item.getProvinceSid());
            }
            if(null != province) {
                item.setProvinceCode(province.getCode());
                item.setCityName(province.getName());
                item.setCityId(province.getId());
            }
            bankCategory = bankSubCodeMap.get(item.getSubBankCode());
            if(null != bankCategory) {
                item.setCategoryId(bankCategory.getId());
                item.setCategoryName(bankCategory.getName());
            }
        }

        logger.info("本次保存数据-{}条", saveList.size());
        service.saveOrUpdateBatch(saveList, saveList.size(), false);
    }
}
